---
name: i.gravity
description: Bouguer gravity anomaly computation (full slab).
keywords: [ imagery, gravity, Bouguer, Eotvos, Free Air ]
---

# i.gravity

Bouguer gravity anomaly computation (full slab).

=== "Command line"

    **i.gravity**
    **gravity_obs**=*name*
    **elevation**=*name*
    **latitude**=*name*
    **flight_azimuth**=*name*
    **flight_velocity**=*name*
    **slab_density**=*name*
    **terrain_corr**=*name*
    **output**=*name*
    [**--overwrite**]
    [**--verbose**]
    [**--quiet**]
    [**--qq**]
    [**--ui**]

    Example:

    ```sh
    i.gravity gravity_obs=gravity_obs elevation=dem latitude=lat flight_azimuth=flight_azimuth flight_velocity=flight_velocity slab_density=slab_density terrain_corr=terrain_corr output=name
    ```

=== "Python (grass.script)"

    *grass.script.run_command*("***i.gravity***",
        **gravity_obs**=*"gravity_obs"*,
        **elevation**=*"dem"*,
        **latitude**=*"lat"*,
        **flight_azimuth**=*"flight_azimuth"*,
        **flight_velocity**=*"flight_velocity"*,
        **slab_density**=*"slab_density"*,
        **terrain_corr**=*"terrain_corr"*,
        **output**,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    gs.run_command("i.gravity", gravity_obs="gravity_obs", elevation="dem", latitude="lat", flight_azimuth="flight_azimuth", flight_velocity="flight_velocity", slab_density="slab_density", terrain_corr="terrain_corr", output="name")
    ```

=== "Python (grass.tools)"

    *grass.tools.Tools.i_gravity*(**gravity_obs**=*"gravity_obs"*,
        **elevation**=*"dem"*,
        **latitude**=*"lat"*,
        **flight_azimuth**=*"flight_azimuth"*,
        **flight_velocity**=*"flight_velocity"*,
        **slab_density**=*"slab_density"*,
        **terrain_corr**=*"terrain_corr"*,
        **output**,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    tools = Tools()
    tools.i_gravity(gravity_obs="gravity_obs", elevation="dem", latitude="lat", flight_azimuth="flight_azimuth", flight_velocity="flight_velocity", slab_density="slab_density", terrain_corr="terrain_corr", output="name")
    ```

    This grass.tools API is experimental in version 8.5 and expected to be stable in version 8.6.

## Parameters

=== "Command line"

    **gravity_obs**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of the observed gravity map [mGal]  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *gravity_obs*  
    **elevation**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of the elevation map [m]  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *dem*  
    **latitude**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of the latitude map [dd.ddd]  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *lat*  
    **flight_azimuth**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of the flight azimuth map (clockwise from North) [dd.ddd]  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *flight_azimuth*  
    **flight_velocity**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of the flight velocity [kph]  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *flight_velocity*  
    **slab_density**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of the slab density [kg/m3]  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *slab_density*  
    **terrain_corr**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of the terrain correction map []  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *terrain_corr*  
    **output**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of the Bouguer gravity anomaly [mGal]  
    **--overwrite**  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    **--help**  
    &nbsp;&nbsp;&nbsp;&nbsp;Print usage summary  
    **--verbose**  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    **--quiet**  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    **--qq**  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    **--ui**  
    &nbsp;&nbsp;&nbsp;&nbsp;Force launching GUI dialog

=== "Python (grass.script)"

    **gravity_obs** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of the observed gravity map [mGal]  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *gravity_obs*  
    **elevation** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of the elevation map [m]  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *dem*  
    **latitude** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of the latitude map [dd.ddd]  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *lat*  
    **flight_azimuth** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of the flight azimuth map (clockwise from North) [dd.ddd]  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *flight_azimuth*  
    **flight_velocity** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of the flight velocity [kph]  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *flight_velocity*  
    **slab_density** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of the slab density [kg/m3]  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *slab_density*  
    **terrain_corr** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of the terrain correction map []  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *terrain_corr*  
    **output** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of the Bouguer gravity anomaly [mGal]  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, raster, *name*  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

=== "Python (grass.tools)"

    **gravity_obs** : str | np.ndarray, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of the observed gravity map [mGal]  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *gravity_obs*  
    **elevation** : str | np.ndarray, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of the elevation map [m]  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *dem*  
    **latitude** : str | np.ndarray, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of the latitude map [dd.ddd]  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *lat*  
    **flight_azimuth** : str | np.ndarray, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of the flight azimuth map (clockwise from North) [dd.ddd]  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *flight_azimuth*  
    **flight_velocity** : str | np.ndarray, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of the flight velocity [kph]  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *flight_velocity*  
    **slab_density** : str | np.ndarray, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of the slab density [kg/m3]  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *slab_density*  
    **terrain_corr** : str | np.ndarray, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of the terrain correction map []  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *terrain_corr*  
    **output** : str | type(np.ndarray) | type(np.array) | type(gs.array.array), *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of the Bouguer gravity anomaly [mGal]  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, raster, *name*  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

    Returns:

    **result** : grass.tools.support.ToolResult | np.ndarray | tuple[np.ndarray] | None  
    If the tool produces text as standard output, a *ToolResult* object will be returned. Otherwise, `None` will be returned. If an array type (e.g., *np.ndarray*) is used for one of the raster outputs, the result will be an array and will have the shape corresponding to the computational region. If an array type is used for more than one raster output, the result will be a tuple of arrays.

    Raises:

    *grass.tools.ToolError*: When the tool ended with an error.

## DESCRIPTION

*i.gravity* calculates the Bouguer gravity anomaly (after Mussett and
Khan).  
Bouguer anomaly computation require:

- g\_obs=observed gravity
- freeair\_corr=free air correction
- bouguer\_corr=bouguer correction
- terrain\_corr=terrain correction
- latitude\_corr=latitude correction
- eotvos\_corr=eotvos correction

## NOTES

- International Gravity Formula (mGal), lambda=latitude (dd)
- Eotvos correction (mGal), v=velocity (kph), lambda=latitude (dd),
    alpha=direction of travel measured clockwise from North
- Free air Correction (mGal), h=height (m)
- Bouguer Correction (mGal), rho=density of slab (Mg/m3), h=height (m)
-

For more details on the algorithms see \[1\].

## SEE ALSO

*[i.latlon](i.latlon.md)*

## REFERENCES

\[1\] Mussett, A.E. and Khan, M.A, M.A. Looking into the Earth: An
Introduction to Geological Geophysics.

## AUTHOR

Yann Chemin, University of London at Birkbeck, United Kingdom.

## SOURCE CODE

Available at: [i.gravity source code](https://github.com/OSGeo/grass-addons/tree/grass8/src/imagery/i.gravity)
([history](https://github.com/OSGeo/grass-addons/commits/grass8/src/imagery/i.gravity))  
Latest change: Thursday May 29 16:46:38 2025 in commit [1350f28](https://github.com/OSGeo/grass-addons/commit/1350f2846b7aa58a2975a7118d92f5042d8871f3)
