---
name: i.hyper.export.py
description: Export 3D hyperspectral 3D raster map (for now, only available compressed multi-band GeoTIFF)
keywords: [ raster3d, export ]
---

# i.hyper.export.py

Export 3D hyperspectral 3D raster map (for now, only available compressed multi-band GeoTIFF)

=== "Command line"

    **i.hyper.export.py**
    **input**=*name*
    **output**=*name*
    [**--overwrite**]
    [**--verbose**]
    [**--quiet**]
    [**--qq**]
    [**--ui**]

    Example:

    ```sh
    i.hyper.export.py input=name output=name
    ```

=== "Python (grass.script)"

    *grass.script.run_command*("***i.hyper.export.py***",
        **input**,
        **output**,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    gs.run_command("i.hyper.export.py", input="name", output="name")
    ```

=== "Python (grass.tools)"

    *grass.tools.Tools.i_hyper_export_py*(**input**,
        **output**,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    tools = Tools()
    tools.i_hyper_export_py(input="name", output="name")
    ```

    This grass.tools API is experimental in version 8.5 and expected to be stable in version 8.6.

## Parameters

=== "Command line"

    **input**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Input 3D raster map  
    **output**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Output file name  
    **--overwrite**  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    **--help**  
    &nbsp;&nbsp;&nbsp;&nbsp;Print usage summary  
    **--verbose**  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    **--quiet**  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    **--qq**  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    **--ui**  
    &nbsp;&nbsp;&nbsp;&nbsp;Force launching GUI dialog

=== "Python (grass.script)"

    **input** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Input 3D raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster_3d, *name*  
    **output** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Output file name  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, file, *name*  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

=== "Python (grass.tools)"

    **input** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Input 3D raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster_3d, *name*  
    **output** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Output file name  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, file, *name*  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

    Returns:

    **result** : grass.tools.support.ToolResult | None  
    If the tool produces text as standard output, a *ToolResult* object will be returned. Otherwise, `None` will be returned.

    Raises:

    *grass.tools.ToolError*: When the tool ended with an error.

## DESCRIPTION

*i.hyper.export* exports a hyperspectral 3D raster map (`raster_3d`)
from GRASS to an external file. At present, the module supports export
to a **compressed multi-band GeoTIFF** only.

The export process converts the 3D raster map into 2D raster slices
using `r3.to.rast`, creates a temporary imagery group, and writes all
bands into a single multi-band GeoTIFF file with `r.out.gdal`. All
temporary rasters and groups are automatically removed after export.

## FUNCTIONALITY

- Exports the complete hyperspectral 3D raster map as a single
  multi-band GeoTIFF.
- Preserves the spectral band order and spatial alignment of the input
  map.
- Uses **DEFLATE** compression with **PREDICTOR=3** for efficient
  floating-point storage.
- Handles null values as `-9999`.
- Automatically sets the computational region to match the input 3D
  raster map.

## NOTES

- Currently, only multi-band GeoTIFF export is supported.
- All intermediate rasters and imagery groups are temporary and removed
  automatically after export.
- The exported GeoTIFF contains spectral data only; wavelength and other
  metadata remain inside GRASS.
- The output file can be opened in software such as QGIS, ENVI, or
  Python libraries (`rasterio`, `gdal`).

## OPTIONS

- `input` -- Input 3D raster map (required).
- `output` -- Output file name (required). Example:
  `output=prisma_3d.tif`.

## EXAMPLES

::: code

    # Example 1: Export PRISMA 3D raster map to compressed GeoTIFF
    i.hyper.export input=prisma@PERMANENT \
                   output=/data/prisma_3d.tif
:::

## OUTPUT

The output is a **multi-band GeoTIFF** file containing one band per
spectral layer of the 3D raster map. Compression (**DEFLATE** +
**PREDICTOR=3**) ensures compact and precise floating-point storage.
Large files are automatically written as BigTIFF when necessary.

## AUTHORS

Alen Mangafić and Tomaž Žagar, Geodetic Institute of Slovenia

## SOURCE CODE

Available at: [i.hyper.export source code](https://github.com/OSGeo/grass-addons/tree/grass8/imagery/i.hyper/i.hyper.export)
([history](https://github.com/OSGeo/grass-addons/commits/grass8/imagery/i.hyper/i.hyper.export))  
Latest change: Monday Nov 17 15:45:17 2025 in commit [615887d](https://github.com/OSGeo/grass-addons/commit/615887d217deac99a8f08bcf940384863fd47f2b)
