---
name: i.lmf
description: Performs Temporal Local Maximum Fitting of vegetation indices, works also for surface reflectance data.
keywords: [ imagery, LMF, Vegetation Indices, Atmospheric correction, Temporal ]
---

# i.lmf

Performs Temporal Local Maximum Fitting of vegetation indices, works also for surface reflectance data.

=== "Command line"

    **i.lmf**
    **input**=*name* [,*name*,...]
    **ndate**=*integer*
    **output**=*name*
    [**--overwrite**]
    [**--verbose**]
    [**--quiet**]
    [**--qq**]
    [**--ui**]

    Example:

    ```sh
    i.lmf input=name ndate=0 output=name
    ```

=== "Python (grass.script)"

    *grass.script.run_command*("***i.lmf***",
        **input**,
        **ndate**,
        **output**,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    gs.run_command("i.lmf", input="name", ndate=0, output="name")
    ```

=== "Python (grass.tools)"

    *grass.tools.Tools.i_lmf*(**input**,
        **ndate**,
        **output**,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    tools = Tools()
    tools.i_lmf(input="name", ndate=0, output="name")
    ```

    This grass.tools API is experimental in version 8.5 and expected to be stable in version 8.6.

## Parameters

=== "Command line"

    **input**=*name* [,*name*,...] **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Names of input layers  
    **ndate**=*integer* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Number of map layers per year  
    **output**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of the output layer  
    **--overwrite**  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    **--help**  
    &nbsp;&nbsp;&nbsp;&nbsp;Print usage summary  
    **--verbose**  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    **--quiet**  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    **--qq**  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    **--ui**  
    &nbsp;&nbsp;&nbsp;&nbsp;Force launching GUI dialog

=== "Python (grass.script)"

    **input** : str | list[str], *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Names of input layers  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **ndate** : int, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Number of map layers per year  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: Number of map layers per year  
    **output** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of the output layer  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, raster, *name*  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

=== "Python (grass.tools)"

    **input** : str | list[str], *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Names of input layers  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **ndate** : int, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Number of map layers per year  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: Number of map layers per year  
    **output** : str | type(np.ndarray) | type(np.array) | type(gs.array.array), *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of the output layer  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, raster, *name*  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

    Returns:

    **result** : grass.tools.support.ToolResult | np.ndarray | tuple[np.ndarray] | None  
    If the tool produces text as standard output, a *ToolResult* object will be returned. Otherwise, `None` will be returned. If an array type (e.g., *np.ndarray*) is used for one of the raster outputs, the result will be an array and will have the shape corresponding to the computational region. If an array type is used for more than one raster output, the result will be a tuple of arrays.

    Raises:

    *grass.tools.ToolError*: When the tool ended with an error.

## DESCRIPTION

*i.lmf* calculates the Local maximum fitting of a temporal image series,
intially for vegetation indices, it also works for surface reflectance.

This is a first level port, only a fast fitting is done, see TODO.

The number of bands is potentially several years, **nfiles** and
**ndates** are respectively the number of pixels and the number of
pixels in a year.

## NOTES

Original links are found here SAWADA, 2001:
[http://www.affrc.go.jp/ANDES/sawady/index.html](https://web.archive.org/web/20110523233556/http://www.affrc.go.jp/ANDES/sawady/index.html)
NAGATANI et al., 2002:
[http://www.gisdevelopment.net/aars/acrs/2002/pos2/184.pdf](https://web.archive.org/web/20051222023531/http://www.gisdevelopment.net/aars/acrs/2002/pos2/184.pdf)
Yann Chemin and Kiyoshi Honda repaired it and ported it from SGI/OpenMP
to Linux.
[http://www.rsgis.ait.ac.th/\~honda/lmf/lmf.html](https://web.archive.org/web/20070824132301/http://www.rsgis.ait.ac.th/~honda/lmf/lmf.html)

## TODO

Port the full detailed algorithm from Fortran, and vastly
unemcomber/clean it. It will make the algorithm must slower though,
gaining only a marginal fitting strength, for my actual experience with
VIs curves.

## SEE ALSO

*[r.series](https://grass.osgeo.org/grass-stable/manuals/r.series.html)*

## AUTHOR

Yann Chemin, International Rice Research Institute, The Philippines

## SOURCE CODE

Available at: [i.lmf source code](https://github.com/OSGeo/grass-addons/tree/grass8/src/imagery/i.lmf)
([history](https://github.com/OSGeo/grass-addons/commits/grass8/src/imagery/i.lmf))  
Latest change: Thursday Feb 20 13:02:26 2025 in commit [53de819](https://github.com/OSGeo/grass-addons/commit/53de8196a10ba5a8a9121898ce87861d227137e3)
