---
name: i.lswt.py
description: Computes Lake Surface Water Temperatures (inland water bodies) from TOA Brightness Temperatures.
keywords: [ imagery, LSWT, MODIS, AVHRR, AATSR, SEVIRI, IMG ]
---

# i.lswt.py

Computes Lake Surface Water Temperatures (inland water bodies) from TOA Brightness Temperatures.

=== "Command line"

    **i.lswt.py**
    [**-i**]
    **ainput**=*name*
    **binput**=*name*
    **basename**=*basename*
    **satellite**=*string*
    [**--overwrite**]
    [**--verbose**]
    [**--quiet**]
    [**--qq**]
    [**--ui**]

    Example:

    ```sh
    i.lswt.py ainput=name binput=name basename=basename satellite=NOAA07-AVHRR
    ```

=== "Python (grass.script)"

    *grass.script.run_command*("***i.lswt.py***",
        **ainput**,
        **binput**,
        **basename**,
        **satellite**,
        **flags**=*None*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    gs.run_command("i.lswt.py", ainput="name", binput="name", basename="basename", satellite="NOAA07-AVHRR")
    ```

=== "Python (grass.tools)"

    *grass.tools.Tools.i_lswt_py*(**ainput**,
        **binput**,
        **basename**,
        **satellite**,
        **flags**=*None*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    tools = Tools()
    tools.i_lswt_py(ainput="name", binput="name", basename="basename", satellite="NOAA07-AVHRR")
    ```

    This grass.tools API is experimental in version 8.5 and expected to be stable in version 8.6.

## Parameters

=== "Command line"

    **ainput**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Brightness Temperature (10.5 - 11.5 micro m)  
    **binput**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Brightness Temperature (11.5 - 12.5 micro m)  
    **basename**=*basename* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output basename raster map(s)  
    **satellite**=*string* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Satellite name  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *NOAA07-AVHRR, NOAA09-AVHRR, NOAA11-AVHRR, NOAA12-AVHRR, NOAA14-AVHRR, NOAA15-AVHRR, NOAA16-AVHRR, NOAA17-AVHRR, NOAA18-AVHRR, NOAA19-AVHRR, METOPA-AVHRR, ERS1-ATSR1, ERS2-ATSR2, Envisat-AATSR, Terra-MODIS, Aqua-MODIS, GOES8-IMG, GOES9-IMG, GOES10-IMG, GOES11-IMG, GOES12-IMG, GOES13-IMG, MSG1-SEVIRI, MSG2-SEVIRI*  
    &nbsp;&nbsp;&nbsp;&nbsp;**NOAA07-AVHRR**: Use split-window coefficients for NOAA07-AVHRR  
    **-i**  
    &nbsp;&nbsp;&nbsp;&nbsp;Display split-window coefficients and exit  
    **--overwrite**  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    **--help**  
    &nbsp;&nbsp;&nbsp;&nbsp;Print usage summary  
    **--verbose**  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    **--quiet**  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    **--qq**  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    **--ui**  
    &nbsp;&nbsp;&nbsp;&nbsp;Force launching GUI dialog

=== "Python (grass.script)"

    **ainput** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Brightness Temperature (10.5 - 11.5 micro m)  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **binput** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Brightness Temperature (11.5 - 12.5 micro m)  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **basename** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output basename raster map(s)  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, raster, *basename*  
    **satellite** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Satellite name  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *NOAA07-AVHRR, NOAA09-AVHRR, NOAA11-AVHRR, NOAA12-AVHRR, NOAA14-AVHRR, NOAA15-AVHRR, NOAA16-AVHRR, NOAA17-AVHRR, NOAA18-AVHRR, NOAA19-AVHRR, METOPA-AVHRR, ERS1-ATSR1, ERS2-ATSR2, Envisat-AATSR, Terra-MODIS, Aqua-MODIS, GOES8-IMG, GOES9-IMG, GOES10-IMG, GOES11-IMG, GOES12-IMG, GOES13-IMG, MSG1-SEVIRI, MSG2-SEVIRI*  
    &nbsp;&nbsp;&nbsp;&nbsp;**NOAA07-AVHRR**: Use split-window coefficients for NOAA07-AVHRR  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *i*  
    &nbsp;&nbsp;&nbsp;&nbsp;**i**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Display split-window coefficients and exit  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

=== "Python (grass.tools)"

    **ainput** : str | np.ndarray, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Brightness Temperature (10.5 - 11.5 micro m)  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **binput** : str | np.ndarray, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Brightness Temperature (11.5 - 12.5 micro m)  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **basename** : str | type(np.ndarray) | type(np.array) | type(gs.array.array), *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output basename raster map(s)  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, raster, *basename*  
    **satellite** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Satellite name  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *NOAA07-AVHRR, NOAA09-AVHRR, NOAA11-AVHRR, NOAA12-AVHRR, NOAA14-AVHRR, NOAA15-AVHRR, NOAA16-AVHRR, NOAA17-AVHRR, NOAA18-AVHRR, NOAA19-AVHRR, METOPA-AVHRR, ERS1-ATSR1, ERS2-ATSR2, Envisat-AATSR, Terra-MODIS, Aqua-MODIS, GOES8-IMG, GOES9-IMG, GOES10-IMG, GOES11-IMG, GOES12-IMG, GOES13-IMG, MSG1-SEVIRI, MSG2-SEVIRI*  
    &nbsp;&nbsp;&nbsp;&nbsp;**NOAA07-AVHRR**: Use split-window coefficients for NOAA07-AVHRR  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *i*  
    &nbsp;&nbsp;&nbsp;&nbsp;**i**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Display split-window coefficients and exit  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

    Returns:

    **result** : grass.tools.support.ToolResult | np.ndarray | tuple[np.ndarray] | None  
    If the tool produces text as standard output, a *ToolResult* object will be returned. Otherwise, `None` will be returned. If an array type (e.g., *np.ndarray*) is used for one of the raster outputs, the result will be an array and will have the shape corresponding to the computational region. If an array type is used for more than one raster output, the result will be a tuple of arrays.

    Raises:

    *grass.tools.ToolError*: When the tool ended with an error.

## DESCRIPTION

*i.lswt* computes Lake Water Surface Temperature (LSWT) from moderate
resolution polar orbiting satellites with dual thermal channels. Given
the Top Of Atmosphere(TOA) Brightness Temperatures (BT) derived from the
thermal channels of the supported satellites, the module computes
surface temperature. For water surface (lakes/inland water bodies), the
module uses a simplified non-linear split-window algorithm.

## NOTES

The non-linear split window equation used here is:

```text
LSWT = Ti + c1 * (Ti - Tj) + c2 * (Ti - Tj) ^ 2 + c0
```

Where Ti and Tj are Brightness temperatures derived from dual thermal
channels 10.5 - 11.5 micro m and 11.5 - 12.5 micro m respectively. The
split window equation and the coefficients c0,c1,c2 are taken from
Jimenez-Munoz et.al (2008).

## EXAMPLE

```sh
r.mask vect=watermask cats=1 --o
i.lswt in1=NSS.LHRR.NP.D14177.S1312_b4 in2=NSS.LHRR.NP.D14177.S1312_b5 \
  basename=NSS.LHRR.NP.D14177.S1312 satellite=NOAA19-AVHRR
```

## REFERENCES

The satellite specific split-window coefficients are taken from:

- Jimenez-Munoz, J.-C., Sobrino, J.A., 2008. Split-Window Coefficients
    for Land Surface Temperature Retrieval From Low-Resolution Thermal
    Infrared Sensors. IEEE Geoscience and Remote Sensing Letters 5,
    806-809. ([DOI](https://doi.org/10.1109/LGRS.2008.2001636))

A new method to develop continuos time series of LSWT from historical
AVHRR is explained below, uses the same split window technique
implemented here:

- Pareeth, S., Delucchi, L., Metz, M., Rocchini, D., Devasthale, A.,
    Raspaud, M., Adrian, R., Salmaso, N., Neteler, M., 2016. New
    Automated Method to Develop Geometrically Corrected Time Series of
    Brightness Temperatures from Historical AVHRR LAC Data. Remote
    Sensing 8, 169. ([DOI](https://doi.org/10.3390/rs8030169))

## SEE ALSO

*[i.landsat8.swlst](i.landsat8.swlst.md),
[i.emissivity](https://grass.osgeo.org/grass-stable/manuals/i.emissivity.html)*

## AUTHOR

Sajid Pareeth; Fondazione Edmund Mach, Italy

## SOURCE CODE

Available at: [i.lswt source code](https://github.com/OSGeo/grass-addons/tree/grass8/src/imagery/i.lswt)
([history](https://github.com/OSGeo/grass-addons/commits/grass8/src/imagery/i.lswt))  
Latest change: Thursday Mar 20 21:36:57 2025 in commit [7286ecf](https://github.com/OSGeo/grass-addons/commit/7286ecf7af235bfd089fb9b1b82fb383cf95f3fc)
