---
name: i.ortho.corr.py
description: Corrects orthophoto taking part of the adjacent orthophotos using a camera angle map.
keywords: [ imagery, orthorectification ]
---

# i.ortho.corr.py

Corrects orthophoto taking part of the adjacent orthophotos using a camera angle map.

=== "Command line"

    **i.ortho.corr.py**
    **input**=*name*
    [**osuffix**=*ortho*]
    [**csuffix**=*ortho*]
    **tiles**=*name*
    [**field**=*name*]
    [**exclude**=*name*]
    [**output**=*name*]
    [**--verbose**]
    [**--quiet**]
    [**--qq**]
    [**--ui**]

    Example:

    ```sh
    i.ortho.corr.py input=name tiles=name
    ```

=== "Python (grass.script)"

    *grass.script.run_command*("***i.ortho.corr.py***",
        **input**,
        **osuffix**=*None*,
        **csuffix**=*None*,
        **tiles**,
        **field**=*None*,
        **exclude**=*None*,
        **output**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    gs.run_command("i.ortho.corr.py", input="name", tiles="name")
    ```

=== "Python (grass.tools)"

    *grass.tools.Tools.i_ortho_corr_py*(**input**,
        **osuffix**=*None*,
        **csuffix**=*None*,
        **tiles**,
        **field**=*None*,
        **exclude**=*None*,
        **output**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    tools = Tools()
    tools.i_ortho_corr_py(input="name", tiles="name")
    ```

    This grass.tools API is experimental in version 8.5 and expected to be stable in version 8.6.

## Parameters

=== "Command line"

    **input**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input raster map  
    **osuffix**=*ortho*  
    &nbsp;&nbsp;&nbsp;&nbsp;Suffix of ortophoto map, default is .ortho, use None for no suffix  
    **csuffix**=*ortho*  
    &nbsp;&nbsp;&nbsp;&nbsp;Suffix of camera angle map, default is .camera_angle, use None for no suffix  
    **tiles**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input vector tiles map create by a list of orthophoto  
    **field**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of location's field in the input vector tiles map  
    **exclude**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Pattern to use if you want exclude some tiles  
    **output**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of output raster map  
    **--help**  
    &nbsp;&nbsp;&nbsp;&nbsp;Print usage summary  
    **--verbose**  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    **--quiet**  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    **--qq**  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    **--ui**  
    &nbsp;&nbsp;&nbsp;&nbsp;Force launching GUI dialog

=== "Python (grass.script)"

    **input** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: , *name*  
    **osuffix** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Suffix of ortophoto map, default is .ortho, use None for no suffix  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: , *ortho*  
    **csuffix** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Suffix of camera angle map, default is .camera_angle, use None for no suffix  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: , *ortho*  
    **tiles** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input vector tiles map create by a list of orthophoto  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: , *name*  
    **field** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of location's field in the input vector tiles map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: , *name*  
    **exclude** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Pattern to use if you want exclude some tiles  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: , *name*  
    **output** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of output raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: , *name*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

=== "Python (grass.tools)"

    **input** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: , *name*  
    **osuffix** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Suffix of ortophoto map, default is .ortho, use None for no suffix  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: , *ortho*  
    **csuffix** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Suffix of camera angle map, default is .camera_angle, use None for no suffix  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: , *ortho*  
    **tiles** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input vector tiles map create by a list of orthophoto  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: , *name*  
    **field** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of location's field in the input vector tiles map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: , *name*  
    **exclude** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Pattern to use if you want exclude some tiles  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: , *name*  
    **output** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of output raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: , *name*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

    Returns:

    **result** : grass.tools.support.ToolResult | None  
    If the tool produces text as standard output, a *ToolResult* object will be returned. Otherwise, `None` will be returned.

    Raises:

    *grass.tools.ToolError*: When the tool ended with an error.

## DESCRIPTION

*i.ortho.corr* allows to correct orthophotos using the camera angle map
create by *i.ortho.photo*.

It creates a new image by searching further images adjacent to the input
image. The output contains part of near images where the camera angle
value is optimal.

## NOTES

It requires a tile index to be created containing all the images to be
processed (e.g., GDAL's *gdaltindex* can create that):

```sh
gdaltindex tile.shp $GRASSDATA/$LOCATION/$MAPSET/cellhd/*imagery.ortho
```

The *field* option is used for the field's name which contains the path
to the file, the default is *location* that it is used by *gdaltindex*.
The *exclude* option serves to remove some tiles, for example when
having tiles from a different flight, they can be excluded by passing a
string or a regular expression.

## EXAMPLES

Create tile index:

```sh
gdaltindex tile.shp $GRASSDATA/$LOCATION/$MAPSET/cellhd/*imagery.ortho
```

Import tile index inside the mapset

```sh
v.in.ogr dns=tile.shp out=tile_images
```

Start *i.ortho.corr* with the default parameters, the output map's name
will be `image.ortho_corr`. You can use default parameters if you didn't
change the output prefix in i.ortho.photo:

```sh
i.ortho.corr input=image.ortho tiles=tile_images
```

Start *i.ortho.corr* with different parameters

```sh
i.ortho.corr input=image.photo tiles=tile_images osuffix=.photo csuffix=.camera
```

## SEE ALSO

*[i.ortho.photo](https://grass.osgeo.org/grass-stable/manuals/i.ortho.photo.html),
[i.ortho.rectify](i.ortho.rectify.md)*

## AUTHOR

Luca Delucchi, Fondazione E. Mach (Italy)

## SOURCE CODE

Available at: [i.ortho.corr source code](https://github.com/OSGeo/grass-addons/tree/grass8/src/imagery/i.ortho.corr)
([history](https://github.com/OSGeo/grass-addons/commits/grass8/src/imagery/i.ortho.corr))  
Latest change: Thursday Feb 20 13:02:26 2025 in commit [53de819](https://github.com/OSGeo/grass-addons/commit/53de8196a10ba5a8a9121898ce87861d227137e3)
