---
name: i.points.auto
description: Generate ground control points for image group to be rectified.
keywords: [ imagery, ground control points ]
---

# i.points.auto

Generate ground control points for image group to be rectified.

=== "Command line"

    **i.points.auto**
    [**-c**]
    **group**=*name*
    **source_image**=*name*
    **target_image**=*name*
    [**order**=*integer*]
    **npoints**=*integer*
    [**detail**=*string*]
    [**threshold**=*float*]
    [**--verbose**]
    [**--quiet**]
    [**--qq**]
    [**--ui**]

    Example:

    ```sh
    i.points.auto group=name source_image=name target_image=name npoints=0
    ```

=== "Python (grass.script)"

    *grass.script.run_command*("***i.points.auto***",
        **group**,
        **source_image**,
        **target_image**,
        **order**=*1*,
        **npoints**,
        **detail**=*"fine"*,
        **threshold**=*0.0*,
        **flags**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    gs.run_command("i.points.auto", group="name", source_image="name", target_image="name", npoints=0)
    ```

=== "Python (grass.tools)"

    *grass.tools.Tools.i_points_auto*(**group**,
        **source_image**,
        **target_image**,
        **order**=*1*,
        **npoints**,
        **detail**=*"fine"*,
        **threshold**=*0.0*,
        **flags**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    tools = Tools()
    tools.i_points_auto(group="name", source_image="name", target_image="name", npoints=0)
    ```

    This grass.tools API is experimental in version 8.5 and expected to be stable in version 8.6.

## Parameters

=== "Command line"

    **group**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input imagery group  
    **source_image**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input raster map  
    **target_image**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input raster map  
    **order**=*integer*  
    &nbsp;&nbsp;&nbsp;&nbsp;Transformation polynom order (1-3)  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *1, 2, 3*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1*  
    **npoints**=*integer* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Maximum number of points to generate  
    **detail**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;How detailed should the information be to be used.  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *coarse, medium, fine*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *fine*  
    **threshold**=*float*  
    &nbsp;&nbsp;&nbsp;&nbsp;RMS error threshold. Recommended: source image resolution or smaller  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *0.0*  
    **-c**  
    &nbsp;&nbsp;&nbsp;&nbsp;Use current region settings in source location instead of source map extends  
    **--help**  
    &nbsp;&nbsp;&nbsp;&nbsp;Print usage summary  
    **--verbose**  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    **--quiet**  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    **--qq**  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    **--ui**  
    &nbsp;&nbsp;&nbsp;&nbsp;Force launching GUI dialog

=== "Python (grass.script)"

    **group** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input imagery group  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, group, *name*  
    **source_image** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **target_image** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **order** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Transformation polynom order (1-3)  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *1, 2, 3*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1*  
    **npoints** : int, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Maximum number of points to generate  
    **detail** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;How detailed should the information be to be used.  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *coarse, medium, fine*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *fine*  
    **threshold** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;RMS error threshold. Recommended: source image resolution or smaller  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *0.0*  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *c*  
    &nbsp;&nbsp;&nbsp;&nbsp;**c**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Use current region settings in source location instead of source map extends  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

=== "Python (grass.tools)"

    **group** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input imagery group  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, group, *name*  
    **source_image** : str | np.ndarray, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **target_image** : str | np.ndarray, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **order** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Transformation polynom order (1-3)  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *1, 2, 3*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1*  
    **npoints** : int, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Maximum number of points to generate  
    **detail** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;How detailed should the information be to be used.  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *coarse, medium, fine*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *fine*  
    **threshold** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;RMS error threshold. Recommended: source image resolution or smaller  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *0.0*  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *c*  
    &nbsp;&nbsp;&nbsp;&nbsp;**c**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Use current region settings in source location instead of source map extends  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

    Returns:

    **result** : grass.tools.support.ToolResult | None  
    If the tool produces text as standard output, a *ToolResult* object will be returned. Otherwise, `None` will be returned.

    Raises:

    *grass.tools.ToolError*: When the tool ended with an error.

## DESCRIPTION

*i.points.auto* tries to automatically generate a given number of new
ground control points (GCPs) by matching the input map to a target map
through FFT correlation, based on a few existing ground control points,
previously defined by the user, for example through the [Ground Control
Points
Manager](https://grass.osgeo.org/grass-stable/manuals/wxGUI.gcp.html).
The goal of the module is thus to automaticallty increase the number of
control points to enable higher quality geocoding of imagery to a master
image (co-registration).

## NOTES

It is recommended to use maps filtered with the DIVERSITY or STDDEV
filters of the *r.neighbors* module, with a window size of 3x3 or 5x5
pixels. However, the algorithm sometimes works well also with the
original maps. The produced GCPs can then be used on the original
imagery.

The actual number of newly generated ground control points will likely
be less than the given maximum number of ground control points because
each generated point is filtered using its FFT correlation coefficient,
and optionally also by the given RMS threshold.

*i.points.auto* supports the usual transformation orders 1-3 and
requires the corresponding number of previously set ground control
points: 3 for order 1, 6 for order 2, 10 for order 3.

## SEE ALSO

The GRASS 4 *[Image Processing
manual](https://grass.osgeo.org/gdp/imagery/grass4_image_processing.pdf)*

*[i.group](https://grass.osgeo.org/grass-stable/manuals/i.group.html),
[i.rectify](https://grass.osgeo.org/grass-stable/manuals/i.rectify.html),
[i.target](https://grass.osgeo.org/grass-stable/manuals/i.target.html),
[r.neighbors](https://grass.osgeo.org/grass-stable/manuals/r.neighbors.html),
[Ground Control Points
Manager](https://grass.osgeo.org/grass-stable/manuals/wxGUI.gcp.html)*

## REFERENCE

(note that the former module name was **i.coregister**)

- Neteler, M, D. Grasso, I. Michelazzi, L. Miori, S. Merler, and C.
    Furlanello (2005). An integrated toolbox for image registration,
    fusion and classification. International Journal of Geoinformatics,
    1(1):51-61
    ([PDF](https://neteler.org/wp-content/uploads/neteler/papers/neteler2005_IJG_051-061_draft.pdf))

## AUTHORS

Ivan Michelazzi  
Luca Miori  
Markus Metz

## SOURCE CODE

Available at: [i.points.auto source code](https://github.com/OSGeo/grass-addons/tree/grass8/src/imagery/i.points.auto)
([history](https://github.com/OSGeo/grass-addons/commits/grass8/src/imagery/i.points.auto))  
Latest change: Friday Feb 21 10:10:05 2025 in commit [7d78fe3](https://github.com/OSGeo/grass-addons/commit/7d78fe34868674c3b6050ba1924e1c5675d155c9)
