---
name: i.pysptools.unmix.py
description: Extract endmembers from imagery group and perform spectral unmixing using pysptools
keywords: [ imagery, endmember, spectral unmixing ]
---

# i.pysptools.unmix.py

Extract endmembers from imagery group and perform spectral unmixing using pysptools

=== "Command line"

    **i.pysptools.unmix.py**
    [**-n**]
    **input**=*name*
    [**output**=*name*]
    [**prefix**=*string*]
    [**endmembers**=*name*]
    **endmember_n**=*integer*
    [**extraction_method**=*string*]
    [**unmixing_method**=*string*]
    [**maxit**=*integer*]
    [**--overwrite**]
    [**--verbose**]
    [**--quiet**]
    [**--qq**]
    [**--ui**]

    Example:

    ```sh
    i.pysptools.unmix.py input=name output=name endmember_n=0
    ```

=== "Python (grass.script)"

    *grass.script.run_command*("***i.pysptools.unmix.py***",
        **input**,
        **output**=*None*,
        **prefix**=*None*,
        **endmembers**=*None*,
        **endmember_n**,
        **extraction_method**=*"NFINDR"*,
        **unmixing_method**=*"FCLS"*,
        **maxit**=*None*,
        **flags**=*None*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    gs.run_command("i.pysptools.unmix.py", input="name", output="name", endmember_n=0)
    ```

=== "Python (grass.tools)"

    *grass.tools.Tools.i_pysptools_unmix_py*(**input**,
        **output**=*None*,
        **prefix**=*None*,
        **endmembers**=*None*,
        **endmember_n**,
        **extraction_method**=*"NFINDR"*,
        **unmixing_method**=*"FCLS"*,
        **maxit**=*None*,
        **flags**=*None*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    tools = Tools()
    tools.i_pysptools_unmix_py(input="name", output="name", endmember_n=0)
    ```

    This grass.tools API is experimental in version 8.5 and expected to be stable in version 8.6.

## Parameters

=== "Command line"

    **input**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Input imagery group  
    **output**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Text file storing endmember information for i.spec.unmix  
    **prefix**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;Prefix for resulting raster maps  
    **endmembers**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Vector map representing identified endmembers  
    **endmember_n**=*integer* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Number of endmembers to identify  
    **extraction_method**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;Method for endmember extraction  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *FIPPI, PPI, NFINDR*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *NFINDR*  
    **unmixing_method**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;Algorithm for spectral unmixing  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *FCLS, UCLS, NNLS*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *FCLS*  
    **maxit**=*integer*  
    &nbsp;&nbsp;&nbsp;&nbsp;Maximal number of iterations for endmember extraction (default=3\*number of bands)  
    **-n**  
    &nbsp;&nbsp;&nbsp;&nbsp;Do not use Automatic Target Generation Process (ATGP)  
    **--overwrite**  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    **--help**  
    &nbsp;&nbsp;&nbsp;&nbsp;Print usage summary  
    **--verbose**  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    **--quiet**  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    **--qq**  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    **--ui**  
    &nbsp;&nbsp;&nbsp;&nbsp;Force launching GUI dialog

=== "Python (grass.script)"

    **input** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Input imagery group  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, group, *name*  
    **output** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Text file storing endmember information for i.spec.unmix  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, file, *name*  
    **prefix** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Prefix for resulting raster maps  
    **endmembers** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Vector map representing identified endmembers  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, vector, *name*  
    **endmember_n** : int, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Number of endmembers to identify  
    **extraction_method** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Method for endmember extraction  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *FIPPI, PPI, NFINDR*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *NFINDR*  
    **unmixing_method** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Algorithm for spectral unmixing  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *FCLS, UCLS, NNLS*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *FCLS*  
    **maxit** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Maximal number of iterations for endmember extraction (default=3\*number of bands)  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *n*  
    &nbsp;&nbsp;&nbsp;&nbsp;**n**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Do not use Automatic Target Generation Process (ATGP)  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

=== "Python (grass.tools)"

    **input** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Input imagery group  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, group, *name*  
    **output** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Text file storing endmember information for i.spec.unmix  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, file, *name*  
    **prefix** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Prefix for resulting raster maps  
    **endmembers** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Vector map representing identified endmembers  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, vector, *name*  
    **endmember_n** : int, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Number of endmembers to identify  
    **extraction_method** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Method for endmember extraction  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *FIPPI, PPI, NFINDR*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *NFINDR*  
    **unmixing_method** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Algorithm for spectral unmixing  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *FCLS, UCLS, NNLS*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *FCLS*  
    **maxit** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Maximal number of iterations for endmember extraction (default=3\*number of bands)  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *n*  
    &nbsp;&nbsp;&nbsp;&nbsp;**n**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Do not use Automatic Target Generation Process (ATGP)  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

    Returns:

    **result** : grass.tools.support.ToolResult | None  
    If the tool produces text as standard output, a *ToolResult* object will be returned. Otherwise, `None` will be returned.

    Raises:

    *grass.tools.ToolError*: When the tool ended with an error.

## DESCRIPTION

*i.pysptools.unmix* extracts endmembers from imagery group and performs
spectral unmixing using [pysptools](https://pysptools.sourceforge.io/).
The module creates an endmember text file and endmember raster maps.

The module is a wrapper around the **pysptools** Python library, that
integrates its functionality for [Endmember
Extraction](https://pysptools.sourceforge.io/eea.html) and [Spectral
Unmixing](https://pysptools.sourceforge.io/abundance_maps.html) into
GRASS GIS.

It requires that the Python libraries **pysptools** and **scikit-learn**
are installed (see below).

Supported algorithms for [Endmember
Extraction](https://pysptools.sourceforge.io/eea.html) are:

- *NFINDR*: N-FINDR endmembers induction algorithm after Winter
    (1999), that also makes use of an Automatic Target Generation
    Process (ATGP) (Plaza & Chang 2006). (*Default*)
- *FIPPI*: Fast Iterative Pixel Purity Index after Chang (2006)
- *PPI*: Pixel Purity Index

Supported algorithms for [Spectral
Unmixing](https://pysptools.sourceforge.io/abundance_maps.html) are:

- *FCLS*: Fully Constrained Least Squares (FCLS): Estimates endmember
    abundance per pixel with the constraint that values are non-negative
    and sum up to one per pixel (*Default*)
- *UCLS*: Unconstrained Least Squares (UCLS): Estimates endmember
    abundance per pixel in an unconstrained way
- *NNLS*: Non-negative Constrained Least Squares (NNLS): Estimates
    endmember abundance per pixel with the constraint that values are
    non-negative

## NOTES

Number of endmembers to extract (*endmember\_n*) is supposed to be lower
than the number of bands in the imagery group. Only the *PPI* method can
extract more endmembers than there are bands in the imagery group.

## EXAMPLE

Example for the North Carolina sample dataset:

```sh
# Create list of bands excluding thermal bands
bands=`g.list type=raster pattern="lsat7_2002*" exclude="lsat7_2002_6?" separator=','`
echo "$bands"

# Create imagery group
i.group group=lsat_2002 input="$bands"

# set computation region
g.region raster=lsat7_2002_10 -p

# Extract Endmembers and perform spectral unmixing using pysptools
# resulting in an endmember text file and raster maps (here: 5 endmember)
i.pysptools.unmix input=lsat_2002 endmembers=endmembers endmember_n=5 \
  output=spectrum.txt prefix=lsat_spectra --v

# Compare to result from i.spec.unmix addon
i.spec.unmix group=lsat7_2002 matrix=sample/spectrum.dat result=lsat7_2002_unmix \
  error=lsat7_2002_unmix_err iter=lsat7_2002_unmix_iterations
```

## REQUIREMENTS

- python-cvxopt (install through system software management)
- python-matplotlib (install through system software management)
- python-scikit-learn (install through system software management)
- python-scipy (install through system software management)
- [pysptools library](https://pypi.org/project/pysptools)
- [scikit-learn library](https://pypi.org/project/scikit-learn)

## REFERENCES

- Chang, C.-I. 2006: A fast iterative algorithm for implementation of
    pixel purity index. Geoscience and Remote Sensing Letters, IEEE,
    3(1): 63-67.
- Plaza, A. & Chang, C.-I. 2006: Impact of Initialization on Design of
    Endmember Extraction Algorithms. Geoscience and Remote Sensing, IEEE
    Transactions. 44(11): 3397-3407.
- Winter, M. E. 1999: N-FINDR: an algorithm for fast autonomous
    spectral end-member determination in hyperspectral data. Presented
    at the Imaging Spectrometry V, Denver, CO, USA, (3753): 266-275.

## SEE ALSO

*[i.spec.unmix](i.spec.unmix.md)*

## AUTHORS

Stefan Blumentrath, [Norwegian Institute for Nature Research (NINA),
Oslo, Norway](https://www.nina.no)  
Zofie Cimburova, [Norwegian Institute for Nature Research (NINA), Oslo,
Norway](https://www.nina.no)

## SOURCE CODE

Available at: [i.pysptools.unmix source code](https://github.com/OSGeo/grass-addons/tree/grass8/src/imagery/i.pysptools.unmix)
([history](https://github.com/OSGeo/grass-addons/commits/grass8/src/imagery/i.pysptools.unmix))  
Latest change: Friday Feb 21 10:10:05 2025 in commit [7d78fe3](https://github.com/OSGeo/grass-addons/commit/7d78fe34868674c3b6050ba1924e1c5675d155c9)
