---
name: i.signature.list.py
description: Lists signature file of a group/subgroup.
keywords: [ imagery, map management, list, signature, group, search ]
---

# i.signature.list.py

Lists signature file of a group/subgroup.

=== "Command line"

    **i.signature.list.py**
    [**-g**]
    [**group**=*name*]
    [**subgroup**=*name*]
    [**--verbose**]
    [**--quiet**]
    [**--qq**]
    [**--ui**]

    Example:

    ```sh
    i.signature.list.py
    ```

=== "Python (grass.script)"

    *grass.script.parse_command*("***i.signature.list.py***",
        **group**=*None*,
        **subgroup**=*None*,
        **flags**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    gs.parse_command("i.signature.list.py")
    ```

=== "Python (grass.tools)"

    *grass.tools.Tools.i_signature_list_py*(**group**=*None*,
        **subgroup**=*None*,
        **flags**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    tools = Tools()
    tools.i_signature_list_py()
    ```

    This grass.tools API is experimental in version 8.5 and expected to be stable in version 8.6.

## Parameters

=== "Command line"

    **group**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Group used to print signature file  
    **subgroup**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Subroup used to print signature file  
    **-g**  
    &nbsp;&nbsp;&nbsp;&nbsp;Return in shell script style, it require group and subgroup options  
    **--help**  
    &nbsp;&nbsp;&nbsp;&nbsp;Print usage summary  
    **--verbose**  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    **--quiet**  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    **--qq**  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    **--ui**  
    &nbsp;&nbsp;&nbsp;&nbsp;Force launching GUI dialog

=== "Python (grass.script)"

    **group** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Group used to print signature file  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, group, *name*  
    **subgroup** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Subroup used to print signature file  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, subgroup, *name*  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *g*  
    &nbsp;&nbsp;&nbsp;&nbsp;**g**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Return in shell script style, it require group and subgroup options  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

=== "Python (grass.tools)"

    **group** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Group used to print signature file  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, group, *name*  
    **subgroup** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Subroup used to print signature file  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, subgroup, *name*  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *g*  
    &nbsp;&nbsp;&nbsp;&nbsp;**g**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Return in shell script style, it require group and subgroup options  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

    Returns:

    **result** : grass.tools.support.ToolResult | None  
    If the tool produces text as standard output, a *ToolResult* object will be returned. Otherwise, `None` will be returned.

    Raises:

    *grass.tools.ToolError*: When the tool ended with an error.

## DESCRIPTION

*i.signature.list* lists the name(s) of signature file(s) of a group and
subgroup. If the **group** and **subgroup** options are not set the
module will iterate over all available groups and subgroups.

## EXAMPLE

```sh
i.signature.list group=name subgroup=subname
```

## AUTHOR

Luca Delucchi

## SOURCE CODE

Available at: [i.signature.list source code](https://github.com/OSGeo/grass-addons/tree/grass8/src/imagery/i.signature.list)
([history](https://github.com/OSGeo/grass-addons/commits/grass8/src/imagery/i.signature.list))  
Latest change: Thursday Feb 20 13:02:26 2025 in commit [53de819](https://github.com/OSGeo/grass-addons/commit/53de8196a10ba5a8a9121898ce87861d227137e3)
