---
name: i.spec.sam
description: Performs Spectral angle mapping on satellite/aerial images
keywords: [ imagery, spectral angle mapping, parallel ]
---

# i.spec.sam

Performs Spectral angle mapping on satellite/aerial images

=== "Command line"

    **i.spec.sam**
    **group**=*name*
    **input**=*name*
    **result**=*string*
    [**--verbose**]
    [**--quiet**]
    [**--qq**]
    [**--ui**]

    Example:

    ```sh
    i.spec.sam group=name input=name result=string
    ```

=== "Python (grass.script)"

    *grass.script.run_command*("***i.spec.sam***",
        **group**,
        **input**,
        **result**,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    gs.run_command("i.spec.sam", group="name", input="name", result="string")
    ```

=== "Python (grass.tools)"

    *grass.tools.Tools.i_spec_sam*(**group**,
        **input**,
        **result**,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    tools = Tools()
    tools.i_spec_sam(group="name", input="name", result="string")
    ```

    This grass.tools API is experimental in version 8.5 and expected to be stable in version 8.6.

## Parameters

=== "Command line"

    **group**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input imagery group  
    **input**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Matrix file containing spectral signatures  
    **result**=*string* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Raster map prefix to hold spectral angles  
    **--help**  
    &nbsp;&nbsp;&nbsp;&nbsp;Print usage summary  
    **--verbose**  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    **--quiet**  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    **--qq**  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    **--ui**  
    &nbsp;&nbsp;&nbsp;&nbsp;Force launching GUI dialog

=== "Python (grass.script)"

    **group** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input imagery group  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, group, *name*  
    **input** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Matrix file containing spectral signatures  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, file, *name*  
    **result** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Raster map prefix to hold spectral angles  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

=== "Python (grass.tools)"

    **group** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input imagery group  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, group, *name*  
    **input** : str | io.StringIO, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Matrix file containing spectral signatures  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, file, *name*  
    **result** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Raster map prefix to hold spectral angles  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

    Returns:

    **result** : grass.tools.support.ToolResult | None  
    If the tool produces text as standard output, a *ToolResult* object will be returned. Otherwise, `None` will be returned.

    Raises:

    *grass.tools.ToolError*: When the tool ended with an error.

## DESCRIPTION

*i.spec.sam* is used to perform Spectral Angle Mapping.

*Input matrix of signatures* \# Channels: r g b i1 i2 i3 \# Enter
spectra linewise\! \# 1. Sagebrush \# 2. Saltbush \# 3. Soil \# 4. Dry
grass \# Matrix: 4 by 6 row0: 8.87 13.14 11.71 35.85 28.26 10.54 row1:
13.59 20.12 19.61 70.66 34.82 16.35 row2: 28.26 34.82 38.27 40.1 38.27
23.7 row3: 10.54 16.35 23.7 38.98 40.1 38.98

## REFERENCES

- Neteler, M., 1999: Spectral Mixture Analysis von Satellitendaten zur
    Bestimmung von Bodenbedeckungsgraden im Hinblick auf die
    Erosionsmodellierung. M.Sc. thesis, University of Hannover, Germany.
- Neteler, M., D. Grasso, I. Michelazzi, L. Miori, S. Merler, and C.
    Furlanello, 2004. New image processing tools for GRASS. - In Proc.
    Free/Libre and Open Source Software for Geoinformatics: GIS-GRASS
    Users Conference, 12-14 Sep 2004, Bangkok, Thailand.
- Neteler, M., D. Grasso, I. Michelazzi, L. Miori, S. Merler, and C.
    Furlanello, 2005. An integrated toolbox for image registration,
    fusion and classification. International Journal of Geoinformatics,
    1(1), pp. 51-61.
    ([PDF](https://www.grassbook.org/wp-content/uploads/neteler/papers/neteler2005_IJG_051-061_draft.pdf))

## SEE ALSO

[i.spec.unmix](i.spec.unmix.md),

## AUTHORS

Markus Neteler, University of Hannover, 1999  
Updated to GRASS GIS 7: Yann Chemin, 2015

## SOURCE CODE

Available at: [i.spec.sam source code](https://github.com/OSGeo/grass-addons/tree/grass8/src/imagery/i.spec.sam)
([history](https://github.com/OSGeo/grass-addons/commits/grass8/src/imagery/i.spec.sam))  
Latest change: Thursday Mar 20 21:36:57 2025 in commit [7286ecf](https://github.com/OSGeo/grass-addons/commit/7286ecf7af235bfd089fb9b1b82fb383cf95f3fc)
