---
name: i.water
description: Water detection from satellite data derived indices, 1 if found, 0 if not
keywords: [ imagery, water, detection ]
---

# i.water

Water detection from satellite data derived indices, 1 if found, 0 if not

=== "Command line"

    **i.water**
    **ndvi**=*name*
    [**albedo**=*name*]
    [**modref7**=*name*]
    **output**=*name*
    [**--overwrite**]
    [**--verbose**]
    [**--quiet**]
    [**--qq**]
    [**--ui**]

    Example:

    ```sh
    i.water ndvi=name output=name
    ```

=== "Python (grass.script)"

    *grass.script.run_command*("***i.water***",
        **ndvi**,
        **albedo**=*None*,
        **modref7**=*None*,
        **output**,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    gs.run_command("i.water", ndvi="name", output="name")
    ```

=== "Python (grass.tools)"

    *grass.tools.Tools.i_water*(**ndvi**,
        **albedo**=*None*,
        **modref7**=*None*,
        **output**,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    tools = Tools()
    tools.i_water(ndvi="name", output="name")
    ```

    This grass.tools API is experimental in version 8.5 and expected to be stable in version 8.6.

## Parameters

=== "Command line"

    **ndvi**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of the NDVI layer [-]  
    **albedo**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of the Albedo layer [-]  
    **modref7**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of the Modis surface reflectance band 7 layer [-]  
    **output**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of the output water layer [0/1]  
    **--overwrite**  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    **--help**  
    &nbsp;&nbsp;&nbsp;&nbsp;Print usage summary  
    **--verbose**  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    **--quiet**  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    **--qq**  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    **--ui**  
    &nbsp;&nbsp;&nbsp;&nbsp;Force launching GUI dialog

=== "Python (grass.script)"

    **ndvi** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of the NDVI layer [-]  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **albedo** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of the Albedo layer [-]  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **modref7** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of the Modis surface reflectance band 7 layer [-]  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **output** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of the output water layer [0/1]  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, raster, *name*  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

=== "Python (grass.tools)"

    **ndvi** : str | np.ndarray, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of the NDVI layer [-]  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **albedo** : str | np.ndarray, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of the Albedo layer [-]  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **modref7** : str | np.ndarray, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of the Modis surface reflectance band 7 layer [-]  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **output** : str | type(np.ndarray) | type(np.array) | type(gs.array.array), *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of the output water layer [0/1]  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, raster, *name*  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

    Returns:

    **result** : grass.tools.support.ToolResult | np.ndarray | tuple[np.ndarray] | None  
    If the tool produces text as standard output, a *ToolResult* object will be returned. Otherwise, `None` will be returned. If an array type (e.g., *np.ndarray*) is used for one of the raster outputs, the result will be an array and will have the shape corresponding to the computational region. If an array type is used for more than one raster output, the result will be a tuple of arrays.

    Raises:

    *grass.tools.ToolError*: When the tool ended with an error.

## DESCRIPTION

*i.water* calculates a water layer after Xiao et al (2005) and Roy et al
(2005). If input is albedo and ndvi, it will process in generic mode. If
input is ndvi and MODIS Band 7 reflectance, it will process in MODIS
mode.

## NOTES

## REFERENCES

Xiao X., Boles S., Liu J., Zhuang D., Frokling S., Li C., Salas W.,
Moore III B. (2005). Mapping paddy rice agriculture in southern China
using multi-temporal MODIS images. Remote Sensing of Environment
95:480-492. Roy D.P., Jin Y., Lewis P.E., Justice C.O. (2005).
Prototyping a global algorithm for systematic fire-affected area mapping
using MODIS time series data. Remote Sensing of Environment 97:137-162.

## SEE ALSO

*[i.vi](https://grass.osgeo.org/grass-stable/manuals/i.vi.html),
[i.albedo](https://grass.osgeo.org/grass-stable/manuals/i.albedo.html)
[i.wi](i.wi.md)*

## AUTHOR

Yann Chemin, International Rice Research Insitute, The Philippines

## SOURCE CODE

Available at: [i.water source code](https://github.com/OSGeo/grass-addons/tree/grass8/src/imagery/i.water)
([history](https://github.com/OSGeo/grass-addons/commits/grass8/src/imagery/i.water))  
Latest change: Thursday Feb 20 13:02:26 2025 in commit [53de819](https://github.com/OSGeo/grass-addons/commit/53de8196a10ba5a8a9121898ce87861d227137e3)
