---
name: i.wi
description: Calculates different types of water indices.
keywords: [ imagery, water, index, biophysical ]
---

# i.wi

Calculates different types of water indices.

=== "Command line"

    **i.wi**
    **winame**=*type*
    [**blue**=*name*]
    [**green**=*name*]
    [**red**=*name*]
    [**nir**=*name*]
    [**band5**=*name*]
    [**band7**=*name*]
    **output**=*name*
    [**--overwrite**]
    [**--verbose**]
    [**--quiet**]
    [**--qq**]
    [**--ui**]

    Example:

    ```sh
    i.wi winame=lswi output=name
    ```

=== "Python (grass.script)"

    *grass.script.run_command*("***i.wi***",
        **winame**=*"lswi"*,
        **blue**=*None*,
        **green**=*None*,
        **red**=*None*,
        **nir**=*None*,
        **band5**=*None*,
        **band7**=*None*,
        **output**,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    gs.run_command("i.wi", winame="lswi", output="name")
    ```

=== "Python (grass.tools)"

    *grass.tools.Tools.i_wi*(**winame**=*"lswi"*,
        **blue**=*None*,
        **green**=*None*,
        **red**=*None*,
        **nir**=*None*,
        **band5**=*None*,
        **band7**=*None*,
        **output**,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    tools = Tools()
    tools.i_wi(winame="lswi", output="name")
    ```

    This grass.tools API is experimental in version 8.5 and expected to be stable in version 8.6.

## Parameters

=== "Command line"

    **winame**=*type* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Type of water index  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *awei_ns, awei_s, lswi, ndwi_mf, ndwi_x, tcw, wi*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *lswi*  
    &nbsp;&nbsp;&nbsp;&nbsp;**awei_ns**: Automated Water Extraction Index - No Shadow  
    &nbsp;&nbsp;&nbsp;&nbsp;**awei_s**: Automated Water Extraction Index - Shadow  
    &nbsp;&nbsp;&nbsp;&nbsp;**lswi**: Land Soil Water Index  
    &nbsp;&nbsp;&nbsp;&nbsp;**ndwi_mf**: Normalized Difference Water Index - Mc Feeters  
    &nbsp;&nbsp;&nbsp;&nbsp;**ndwi_x**: Normalized Difference Water Index - Xu  
    &nbsp;&nbsp;&nbsp;&nbsp;**tcw**: Tasseled Cap Water  
    &nbsp;&nbsp;&nbsp;&nbsp;**wi**: Water Index  
    **blue**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input blue channel surface reflectance map  
    &nbsp;&nbsp;&nbsp;&nbsp;Range: [0.0;1.0]  
    **green**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input green channel surface reflectance map  
    &nbsp;&nbsp;&nbsp;&nbsp;Range: [0.0;1.0]  
    **red**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input red channel surface reflectance map  
    &nbsp;&nbsp;&nbsp;&nbsp;Range: [0.0;1.0]  
    **nir**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input nir channel surface reflectance map  
    &nbsp;&nbsp;&nbsp;&nbsp;Range: [0.0;1.0]  
    **band5**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input 5th channel surface reflectance map  
    &nbsp;&nbsp;&nbsp;&nbsp;Range: [0.0;1.0]  
    **band7**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input 7th channel surface reflectance map  
    &nbsp;&nbsp;&nbsp;&nbsp;Range: [0.0;1.0]  
    **output**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of the output wi layer  
    **--overwrite**  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    **--help**  
    &nbsp;&nbsp;&nbsp;&nbsp;Print usage summary  
    **--verbose**  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    **--quiet**  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    **--qq**  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    **--ui**  
    &nbsp;&nbsp;&nbsp;&nbsp;Force launching GUI dialog

=== "Python (grass.script)"

    **winame** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Type of water index  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *type*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *awei_ns, awei_s, lswi, ndwi_mf, ndwi_x, tcw, wi*  
    &nbsp;&nbsp;&nbsp;&nbsp;**awei_ns**: Automated Water Extraction Index - No Shadow  
    &nbsp;&nbsp;&nbsp;&nbsp;**awei_s**: Automated Water Extraction Index - Shadow  
    &nbsp;&nbsp;&nbsp;&nbsp;**lswi**: Land Soil Water Index  
    &nbsp;&nbsp;&nbsp;&nbsp;**ndwi_mf**: Normalized Difference Water Index - Mc Feeters  
    &nbsp;&nbsp;&nbsp;&nbsp;**ndwi_x**: Normalized Difference Water Index - Xu  
    &nbsp;&nbsp;&nbsp;&nbsp;**tcw**: Tasseled Cap Water  
    &nbsp;&nbsp;&nbsp;&nbsp;**wi**: Water Index  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *lswi*  
    **blue** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input blue channel surface reflectance map  
    &nbsp;&nbsp;&nbsp;&nbsp;Range: [0.0;1.0]  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **green** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input green channel surface reflectance map  
    &nbsp;&nbsp;&nbsp;&nbsp;Range: [0.0;1.0]  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **red** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input red channel surface reflectance map  
    &nbsp;&nbsp;&nbsp;&nbsp;Range: [0.0;1.0]  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **nir** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input nir channel surface reflectance map  
    &nbsp;&nbsp;&nbsp;&nbsp;Range: [0.0;1.0]  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **band5** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input 5th channel surface reflectance map  
    &nbsp;&nbsp;&nbsp;&nbsp;Range: [0.0;1.0]  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **band7** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input 7th channel surface reflectance map  
    &nbsp;&nbsp;&nbsp;&nbsp;Range: [0.0;1.0]  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **output** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of the output wi layer  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, raster, *name*  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

=== "Python (grass.tools)"

    **winame** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Type of water index  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *type*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *awei_ns, awei_s, lswi, ndwi_mf, ndwi_x, tcw, wi*  
    &nbsp;&nbsp;&nbsp;&nbsp;**awei_ns**: Automated Water Extraction Index - No Shadow  
    &nbsp;&nbsp;&nbsp;&nbsp;**awei_s**: Automated Water Extraction Index - Shadow  
    &nbsp;&nbsp;&nbsp;&nbsp;**lswi**: Land Soil Water Index  
    &nbsp;&nbsp;&nbsp;&nbsp;**ndwi_mf**: Normalized Difference Water Index - Mc Feeters  
    &nbsp;&nbsp;&nbsp;&nbsp;**ndwi_x**: Normalized Difference Water Index - Xu  
    &nbsp;&nbsp;&nbsp;&nbsp;**tcw**: Tasseled Cap Water  
    &nbsp;&nbsp;&nbsp;&nbsp;**wi**: Water Index  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *lswi*  
    **blue** : str | np.ndarray, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input blue channel surface reflectance map  
    &nbsp;&nbsp;&nbsp;&nbsp;Range: [0.0;1.0]  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **green** : str | np.ndarray, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input green channel surface reflectance map  
    &nbsp;&nbsp;&nbsp;&nbsp;Range: [0.0;1.0]  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **red** : str | np.ndarray, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input red channel surface reflectance map  
    &nbsp;&nbsp;&nbsp;&nbsp;Range: [0.0;1.0]  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **nir** : str | np.ndarray, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input nir channel surface reflectance map  
    &nbsp;&nbsp;&nbsp;&nbsp;Range: [0.0;1.0]  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **band5** : str | np.ndarray, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input 5th channel surface reflectance map  
    &nbsp;&nbsp;&nbsp;&nbsp;Range: [0.0;1.0]  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **band7** : str | np.ndarray, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input 7th channel surface reflectance map  
    &nbsp;&nbsp;&nbsp;&nbsp;Range: [0.0;1.0]  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **output** : str | type(np.ndarray) | type(np.array) | type(gs.array.array), *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of the output wi layer  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, raster, *name*  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

    Returns:

    **result** : grass.tools.support.ToolResult | np.ndarray | tuple[np.ndarray] | None  
    If the tool produces text as standard output, a *ToolResult* object will be returned. Otherwise, `None` will be returned. If an array type (e.g., *np.ndarray*) is used for one of the raster outputs, the result will be an array and will have the shape corresponding to the computational region. If an array type is used for more than one raster output, the result will be a tuple of arrays.

    Raises:

    *grass.tools.ToolError*: When the tool ended with an error.

## DESCRIPTION

*i.wi* calculates water indices based on biophysical parameters.

- AWEI: Automated Water Extraction Index (2 versions: no shadow or
    shadow
- LSWI: Land Surface Water Index
- NDWI: Normalized Difference Water Index (2 versions: McFeeters or
    Xu)
- TCW: Tasseled Cap Water
- WI: Water Index

## NOTES

Requirements (as of Landsat 5TM bands)

- awei\_noshadow needs greenchan, nirchan, chan5chan
- awei\_shadow needs bluechan, greenchan, nirchan, chan5chan,
    chan7chan
- ls\_wi needs nirchan, chan7chan
- ndwi\_mcfeeters needs greenchan, nirchan
- ndwi\_xu needs greenchan, chan5chan
- tcw needs bluechan, greenchan, redchan, nirchan, chan5chan,
    chan7chan
- wi needs greenchan, redchan, nirchan, chan5chan, chan7chan

## TODO

Find other water indices and add them.

## REFERENCES

AWEI: Automated Water Extraction Index  
Feyisa, G.L., Meilby, H., Fensholt, R., Proud, S.R. (2014). Automated
Water Extraction Index: A new technique for surface water mapping using
Landsat imagery. Remote Sensing of Environment, 140, 23-35.
<https://doi.org/10.1016/j.rse.2013.08.029>.

LSWI: Land Surface Water Index  
a kind of Normalized Difference Water Index Xiao X., Boles S., Frolking
S., Salas W., Moore B., Li C., et al. (2002) Landscape-scale
characterization of cropland in China using vegetation and Landsat TM
images. International Journal of Remote Sensing, 23:3579-3594.

NDWI McFeeters  
McFeeters, S.K. (1996). The use of the Normalized Difference Water Index
(NDWI) in the delineation of open water features. International Journal
of Remote Sensing, 17, 1425-1432.
<https://doi.org/10.1080/01431169608948714>.

NDWI Xu  
Xu, H. (2006). Modification of normalised difference water index (NDWI)
to enhance open water features in remotely sensed imagery. International
Journal of Remote Sensing, 27, 3025-3033.
<https://doi.org/10.1080/01431160600589179>.

TCW  
Crist, E.P. (1985). A TM tasseled cap equivalent transformation for
reflectance factor data. Remote Sensing of Environment, 17, 301-306.

WI  
Fisher, A., Flood, N., Danaher, T. (2016). Comparing Landsat water index
methods for automated water classification in eastern Australia. Remote
Sensing of Environment, 175, 167-182. ISSN 0034-4257,
<https://doi.org/10.1016/j.rse.2015.12.055>.

## SEE ALSO

*[i.vi](https://grass.osgeo.org/grass-stable/manuals/i.vi.html)*

## AUTHOR

Yann Chemin

## SOURCE CODE

Available at: [i.wi source code](https://github.com/OSGeo/grass-addons/tree/grass8/src/imagery/i.wi)
([history](https://github.com/OSGeo/grass-addons/commits/grass8/src/imagery/i.wi))  
Latest change: Friday Feb 21 12:27:42 2025 in commit [8fce680](https://github.com/OSGeo/grass-addons/commit/8fce680a2170ee81eff27fdf4315079b10a10f83)
