---
name: r.catchment.py
description: Creates a raster buffer of specified area around vector points using cost distances using r.walk.
keywords: [ raster, buffer ]
---

# r.catchment.py

Creates a raster buffer of specified area around vector points using cost distances using r.walk.

=== "Command line"

    **r.catchment.py**
    [**-ikcl**]
    **elevation**=*name*
    [**in_cost**=*name*]
    **start_points**=*name*
    [**friction**=*name*]
    [**walk_coeff**=*float*]
    [**lambda**=*float*]
    [**slope_factor**=*float*]
    **buffer**=*name*
    [**sigma**=*float*]
    **area**=*integer*
    **map_val**=*integer*
    [**name_column**=*name*]
    [**--overwrite**]
    [**--verbose**]
    [**--quiet**]
    [**--qq**]
    [**--ui**]

    Example:

    ```sh
    r.catchment.py elevation=name start_points=name buffer=name area=5000000 map_val=1
    ```

=== "Python (grass.script)"

    *grass.script.run_command*("***r.catchment.py***",
        **elevation**,
        **in_cost**=*None*,
        **start_points**,
        **friction**=*""*,
        **walk_coeff**=*0.72,6.0,1.9998,-1.9998*,
        **lambda**=*1*,
        **slope_factor**=*-0.2125*,
        **buffer**,
        **sigma**=*None*,
        **area**=*5000000*,
        **map_val**=*1*,
        **name_column**=*None*,
        **flags**=*None*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    gs.run_command("r.catchment.py", elevation="name", start_points="name", buffer="name", area=5000000, map_val=1)
    ```

=== "Python (grass.tools)"

    *grass.tools.Tools.r_catchment_py*(**elevation**,
        **in_cost**=*None*,
        **start_points**,
        **friction**=*""*,
        **walk_coeff**=*0.72,6.0,1.9998,-1.9998*,
        **lambda**=*1*,
        **slope_factor**=*-0.2125*,
        **buffer**,
        **sigma**=*None*,
        **area**=*5000000*,
        **map_val**=*1*,
        **name_column**=*None*,
        **flags**=*None*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    tools = Tools()
    tools.r_catchment_py(elevation="name", start_points="name", buffer="name", area=5000000, map_val=1)
    ```

    This grass.tools API is experimental in version 8.5 and expected to be stable in version 8.6.

## Parameters

=== "Command line"

    **elevation**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Input elevation map (DEM)  
    **in_cost**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Input cost map (This will override the input elevation map, if none specified, one will be created from input elevation map with r.walk)  
    **start_points**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input vector map  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input vector site points map  
    **friction**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Optional map of friction costs. If no map selected, default friction=0 making output reflect time costs only  
    **walk_coeff**=*float*  
    &nbsp;&nbsp;&nbsp;&nbsp;Coefficients for walking energy formula parameters a,b,c,d  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *0.72,6.0,1.9998,-1.9998*  
    **lambda**=*float*  
    &nbsp;&nbsp;&nbsp;&nbsp;Lambda value for cost distance calculation (for combining friction costs with walking costs)  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1*  
    **slope_factor**=*float*  
    &nbsp;&nbsp;&nbsp;&nbsp;Slope factor determines travel energy cost per height step  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *-0.2125*  
    **buffer**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Output buffer map name, or name-stem for all buffer maps created with flag -i  
    **sigma**=*float*  
    &nbsp;&nbsp;&nbsp;&nbsp;Slope threshold for mask  
    **area**=*integer* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Area of buffer (Integer value to nearest 100 square map units)  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *5000000*  
    **map_val**=*integer* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Integer value for output catchment area (all other areas will be Null)  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1*  
    **name_column**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Database column for point names (with flag -i)  
    **-i**  
    &nbsp;&nbsp;&nbsp;&nbsp;Iterate through each point in the input starting points vector map to create a series of catchment maps centered at each input point rather than a single map starting at all points. Maps will be named "'buffer'_'name'_'id#'", where 'buffer' is the value entered for option 'buffer', 'name' is the value in "name_column" for each input point and 'id#' is unique running id number. If no value specified in "name_column", cat value will be used in place of 'name'). NOTE: this function is NOT compatible with option "in_cost" or flag "l"  
    **-k**  
    &nbsp;&nbsp;&nbsp;&nbsp;Use knight's move for calculating cost surface (slower but more accurate)  
    **-c**  
    &nbsp;&nbsp;&nbsp;&nbsp;Keep cost surface(s) used to calculate buffers (follows similar naming convention from flag -i if -i is also selected)  
    **-l**  
    &nbsp;&nbsp;&nbsp;&nbsp;Show a list of all cost surface values and the area of the catchment that they delimit  
    **--overwrite**  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    **--help**  
    &nbsp;&nbsp;&nbsp;&nbsp;Print usage summary  
    **--verbose**  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    **--quiet**  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    **--qq**  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    **--ui**  
    &nbsp;&nbsp;&nbsp;&nbsp;Force launching GUI dialog

=== "Python (grass.script)"

    **elevation** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Input elevation map (DEM)  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **in_cost** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Input cost map (This will override the input elevation map, if none specified, one will be created from input elevation map with r.walk)  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **start_points** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input vector map  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input vector site points map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, vector, *name*  
    **friction** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Optional map of friction costs. If no map selected, default friction=0 making output reflect time costs only  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **walk_coeff** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Coefficients for walking energy formula parameters a,b,c,d  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *0.72,6.0,1.9998,-1.9998*  
    **lambda** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Lambda value for cost distance calculation (for combining friction costs with walking costs)  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1*  
    **slope_factor** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Slope factor determines travel energy cost per height step  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *-0.2125*  
    **buffer** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Output buffer map name, or name-stem for all buffer maps created with flag -i  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, raster, *name*  
    **sigma** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Slope threshold for mask  
    **area** : int, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Area of buffer (Integer value to nearest 100 square map units)  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *5000000*  
    **map_val** : int, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Integer value for output catchment area (all other areas will be Null)  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1*  
    **name_column** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Database column for point names (with flag -i)  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, dbcolumn, *name*  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *i*, *k*, *c*, *l*  
    &nbsp;&nbsp;&nbsp;&nbsp;**i**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Iterate through each point in the input starting points vector map to create a series of catchment maps centered at each input point rather than a single map starting at all points. Maps will be named "'buffer'_'name'_'id#'", where 'buffer' is the value entered for option 'buffer', 'name' is the value in "name_column" for each input point and 'id#' is unique running id number. If no value specified in "name_column", cat value will be used in place of 'name'). NOTE: this function is NOT compatible with option "in_cost" or flag "l"  
    &nbsp;&nbsp;&nbsp;&nbsp;**k**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Use knight's move for calculating cost surface (slower but more accurate)  
    &nbsp;&nbsp;&nbsp;&nbsp;**c**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Keep cost surface(s) used to calculate buffers (follows similar naming convention from flag -i if -i is also selected)  
    &nbsp;&nbsp;&nbsp;&nbsp;**l**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Show a list of all cost surface values and the area of the catchment that they delimit  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

=== "Python (grass.tools)"

    **elevation** : str | np.ndarray, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Input elevation map (DEM)  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **in_cost** : str | np.ndarray, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Input cost map (This will override the input elevation map, if none specified, one will be created from input elevation map with r.walk)  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **start_points** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input vector map  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input vector site points map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, vector, *name*  
    **friction** : str | np.ndarray, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Optional map of friction costs. If no map selected, default friction=0 making output reflect time costs only  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **walk_coeff** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Coefficients for walking energy formula parameters a,b,c,d  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *0.72,6.0,1.9998,-1.9998*  
    **lambda** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Lambda value for cost distance calculation (for combining friction costs with walking costs)  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1*  
    **slope_factor** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Slope factor determines travel energy cost per height step  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *-0.2125*  
    **buffer** : str | type(np.ndarray) | type(np.array) | type(gs.array.array), *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Output buffer map name, or name-stem for all buffer maps created with flag -i  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, raster, *name*  
    **sigma** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Slope threshold for mask  
    **area** : int, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Area of buffer (Integer value to nearest 100 square map units)  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *5000000*  
    **map_val** : int, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Integer value for output catchment area (all other areas will be Null)  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1*  
    **name_column** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Database column for point names (with flag -i)  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, dbcolumn, *name*  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *i*, *k*, *c*, *l*  
    &nbsp;&nbsp;&nbsp;&nbsp;**i**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Iterate through each point in the input starting points vector map to create a series of catchment maps centered at each input point rather than a single map starting at all points. Maps will be named "'buffer'_'name'_'id#'", where 'buffer' is the value entered for option 'buffer', 'name' is the value in "name_column" for each input point and 'id#' is unique running id number. If no value specified in "name_column", cat value will be used in place of 'name'). NOTE: this function is NOT compatible with option "in_cost" or flag "l"  
    &nbsp;&nbsp;&nbsp;&nbsp;**k**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Use knight's move for calculating cost surface (slower but more accurate)  
    &nbsp;&nbsp;&nbsp;&nbsp;**c**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Keep cost surface(s) used to calculate buffers (follows similar naming convention from flag -i if -i is also selected)  
    &nbsp;&nbsp;&nbsp;&nbsp;**l**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Show a list of all cost surface values and the area of the catchment that they delimit  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

    Returns:

    **result** : grass.tools.support.ToolResult | np.ndarray | tuple[np.ndarray] | None  
    If the tool produces text as standard output, a *ToolResult* object will be returned. Otherwise, `None` will be returned. If an array type (e.g., *np.ndarray*) is used for one of the raster outputs, the result will be an array and will have the shape corresponding to the computational region. If an array type is used for more than one raster output, the result will be a tuple of arrays.

    Raises:

    *grass.tools.ToolError*: When the tool ended with an error.

## DESCRIPTION

*r.catchment* is a module that facilitates modeling "catchments" around
point locations according to a walking cost function. The module is
particularly aimed at "Site Catchment Analysis" for archaeology, but
could be potentially useful in any number of applications where
delimiting an area based on walking-costs is desirable. Although
defining a catchment based on a threshold in walking-costs (or time) can
be undertaken using *r.walk* or *r.cost* alone, this addon module allows
the user to enter a pre-determined square meterage (option **area**) for
the resultant catchment, which is a different approach. This is useful
for applications where the user wants to make a catchment of a
particular size (e.g., certain number of square meters needed for farmed
fields), and doesn't want to spend time via trial and error
experimenting with different cost radii.

Additionally, this module allows the user to enter a slope threshold
(option **sigma**), which will mask out areas of higher slope. This is
useful for delimiting catchments that are of generally flat land (e.g.,
areas where agriculture are likely).

Optionally, you can iteratively loop through a series of input starting
points, and create catchments for each point. You can also opt to save
the cost map produced by r.walk for each input point. This can be a
useful timesaver for the creation of many cost maps and/or catchment
maps with minimal manual repetition.

Important: The user must run **g.region** first to make sure that the
region boundaries and the resolution match the input elevation map.

### Options and flags

*r.catchment* requires an input elevation map, **elevation** , and an
input vector points map of starting locations, **start\_points**.
**area** is also requited, which is an integer value for the size of the
desired catchment (in the map units of the defined location/region). The
final required parameter is **map\_val** , which is the integer value to
write to the areas defined as part of the catchment in the output map,
**buffer**. The optional value, **sigma** is the slope threshold cut off
value. Slopes above **sigma** will be masked out during the
determination of the catchment configuration. The optional value
**name\_column** is to be used in conjunction with the **-i** flag (see
below). There are three native flags for *r.catchment*. **-c** allows
you to keep the interim cost surface maps made. **-l** allows you to
show a list of the costv alues in that cost map, along with the size of
the catchments they delineate. **-i** enable "iterative" mode. Here, the
module will loop through all the points in the input vector file
**start\_points**, calculating a cost map and catchment map around each
point. If **name\_column** is specified, then each output map will
contain the text value in that column as an prefix. Otherwise, the cat
number for each vector point will be used. All other flags and options
are inherited from *r.walk* (see the
[r.walk](https://grass.osgeo.org/grass-stable/manuals/r.walk.html) help
page for more information on these).

## NOTES

The module will attempt to find the cost radius that defines an area
close to the value of **area**, but em will likely slightly overestimate
the catchment size. The module will display the actual area of the
defined catchment in the Command Output. By default, *r.catchment* will
create a **friction** map of value 0, which, when input into *r.walk*
will yield a cost surface based on walking times only. The user may
optionally create a **friction** map, however, and, if used, r.walk will
consider these costs this as well when determining the cost surface used
to determine the catchment. The input **start\_points** map should be a
vector points map. If the file contains other types of features (areas,
lines, centroids), these will be ignored. If you desire, a start points
map could be manually digitized (with *v.digit*) over topographic or
cultural features, or could be created as a series of random points
(with *r.random* or *v.random*). Unless the **-i** flag is used, in the
case of multiple input points, the routine will attempt to equally
divide the area (**area**) between all input points tod etermine
catchments for each point. The total area of all these catchments will
sum (close) to **area**. If two input points are close, their catchments
may overlap. In this case, the routine will "meld" the two, and the
melded catchment will till be of an area close to **area**. If truly
overlapping catchments are desired, then the routine should be run with
the **-i** flag. This will create completely independent catchments
around each input point.

## EXAMPLES

Delimit a catchment of 5,000,000 square meters around a single start
point, ignoring areas of slope \> 15 degrees:  

```sh
r.catchment elevation=DEM10m start_points=site buffer=test_catchment
sigma=15 area=5000000 map_val=1
```

## SEE ALSO

*[r.walk](https://grass.osgeo.org/grass-stable/manuals/r.walk.html),
[r.cost](https://grass.osgeo.org/grass-stable/manuals/r.cost.html)*

## AUTHOR

Isaac Ullah

Updated for GRASS 8, 02, Feb. 2023.

## SOURCE CODE

Available at: [r.catchment source code](https://github.com/OSGeo/grass-addons/tree/grass8/src/raster/r.catchment)
([history](https://github.com/OSGeo/grass-addons/commits/grass8/src/raster/r.catchment))  
Latest change: Friday Feb 21 12:27:42 2025 in commit [8fce680](https://github.com/OSGeo/grass-addons/commit/8fce680a2170ee81eff27fdf4315079b10a10f83)
