---
name: r.centroids.py
description: Creates vector map of centroids from raster of "clumps".
keywords: [ raster, centroid, clumps, vector, centerpoint ]
---

# r.centroids.py

Creates vector map of centroids from raster of "clumps".

=== "Command line"

    **r.centroids.py**
    **input**=*name*
    **output**=*name*
    [**--overwrite**]
    [**--verbose**]
    [**--quiet**]
    [**--qq**]
    [**--ui**]

    Example:

    ```sh
    r.centroids.py input=name output=name
    ```

=== "Python (grass.script)"

    *grass.script.run_command*("***r.centroids.py***",
        **input**,
        **output**,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    gs.run_command("r.centroids.py", input="name", output="name")
    ```

=== "Python (grass.tools)"

    *grass.tools.Tools.r_centroids_py*(**input**,
        **output**,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    tools = Tools()
    tools.r_centroids_py(input="name", output="name")
    ```

    This grass.tools API is experimental in version 8.5 and expected to be stable in version 8.6.

## Parameters

=== "Command line"

    **input**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Raster map of clumps, clusters of same-valued pixels  
    **output**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output vector map  
    **--overwrite**  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    **--help**  
    &nbsp;&nbsp;&nbsp;&nbsp;Print usage summary  
    **--verbose**  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    **--quiet**  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    **--qq**  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    **--ui**  
    &nbsp;&nbsp;&nbsp;&nbsp;Force launching GUI dialog

=== "Python (grass.script)"

    **input** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Raster map of clumps, clusters of same-valued pixels  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **output** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output vector map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, vector, *name*  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

=== "Python (grass.tools)"

    **input** : str | np.ndarray, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Raster map of clumps, clusters of same-valued pixels  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **output** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output vector map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, vector, *name*  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

    Returns:

    **result** : grass.tools.support.ToolResult | None  
    If the tool produces text as standard output, a *ToolResult* object will be returned. Otherwise, `None` will be returned.

    Raises:

    *grass.tools.ToolError*: When the tool ended with an error.

## DESCRIPTION

*r.centroids* is a wrapper function for
[r.volume](https://grass.osgeo.org/grass-stable/manuals/r.volume.html)
that computes the center point of raster clumps of data (neighboring,
same-valued pixels). The centroids will always fall within the clump so
they may not be the true, mathematical centroid. The centroids will
always fall at the center of a pixel.

*r.centroids* requires an input raster containing clumps of data such as
the output of
[r.clump](https://grass.osgeo.org/grass-stable/manuals/r.clump.html).

## EXAMPLES

Find the centroids of the basins map (North Carolina sample dataset).
First, set computational area.

```sh
g.region raster=basin_50K
```

Then, compute the centroids.

```sh
r.centroids input=basin_50K output=centroids50K
```

[![image-alt](r_centroids_basin_50K.png)](r_centroids_basin_50K.png)

## SEE ALSO

*[r.volume](https://grass.osgeo.org/grass-stable/manuals/r.volume.html)*
*[r.clump](https://grass.osgeo.org/grass-stable/manuals/r.clump.html)*

## AUTHOR

Caitlin Haedrich, *Center for Geospatial Analytics, North Carolina State
University*, January, 2021.

## SOURCE CODE

Available at: [r.centroids source code](https://github.com/OSGeo/grass-addons/tree/grass8/src/raster/r.centroids)
([history](https://github.com/OSGeo/grass-addons/commits/grass8/src/raster/r.centroids))  
Latest change: Thursday Feb 20 13:02:26 2025 in commit [53de819](https://github.com/OSGeo/grass-addons/commit/53de8196a10ba5a8a9121898ce87861d227137e3)
