---
name: r.damflood
description: Estimate the area potentially inundated in case of dam break
keywords: [ raster, dambreak, model ]
---

# r.damflood

Estimate the area potentially inundated in case of dam break

=== "Command line"

    **r.damflood**
    [**-d**]
    [**method**=*string*]
    [**timestep**=*float*]
    **elev**=*string*
    **lake**=*string*
    **dambreak**=*string*
    **manning**=*string*
    **tstop**=*integer*
    [**u**=*string*]
    [**v**=*string*]
    [**deltat**=*integer*]
    [**opt_t**=*float* [,*float*,...]]
    [**h**=*string*]
    [**vel**=*string*]
    [**hmax**=*string*]
    [**vmax**=*string*]
    [**imax**=*string*]
    [**wavefront**=*string*]
    [**--overwrite**]
    [**--verbose**]
    [**--quiet**]
    [**--qq**]
    [**--ui**]

    Example:

    ```sh
    r.damflood elev=string lake=string dambreak=string manning=string tstop=0
    ```

=== "Python (grass.script)"

    *grass.script.run_command*("***r.damflood***",
        **method**=*"dambreak-without_hypotesis"*,
        **timestep**=*0.01*,
        **elev**,
        **lake**,
        **dambreak**,
        **manning**,
        **tstop**,
        **u**=*None*,
        **v**=*None*,
        **deltat**=*None*,
        **opt_t**=*None*,
        **h**=*None*,
        **vel**=*None*,
        **hmax**=*None*,
        **vmax**=*None*,
        **imax**=*None*,
        **wavefront**=*None*,
        **flags**=*None*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    gs.run_command("r.damflood", elev="string", lake="string", dambreak="string", manning="string", tstop=0)
    ```

=== "Python (grass.tools)"

    *grass.tools.Tools.r_damflood*(**method**=*"dambreak-without_hypotesis"*,
        **timestep**=*0.01*,
        **elev**,
        **lake**,
        **dambreak**,
        **manning**,
        **tstop**,
        **u**=*None*,
        **v**=*None*,
        **deltat**=*None*,
        **opt_t**=*None*,
        **h**=*None*,
        **vel**=*None*,
        **hmax**=*None*,
        **vmax**=*None*,
        **imax**=*None*,
        **wavefront**=*None*,
        **flags**=*None*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    tools = Tools()
    tools.r_damflood(elev="string", lake="string", dambreak="string", manning="string", tstop=0)
    ```

    This grass.tools API is experimental in version 8.5 and expected to be stable in version 8.6.

## Parameters

=== "Command line"

    **method**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;Computational method for initial velocity estimation  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *dambreak-without_hypotesis, uniform drop in of lake, small dam breach*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *dambreak-without_hypotesis*  
    **timestep**=*float*  
    &nbsp;&nbsp;&nbsp;&nbsp;Initial computational time step [s] - CFL condition  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *0.01*  
    **elev**=*string* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of elevation raster map (including lake bathymetry and dam)  
    **lake**=*string* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of water depth raster map  
    **dambreak**=*string* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of dam breach width raster map  
    **manning**=*string* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of Manning's roughness coefficient raster map  
    **tstop**=*integer* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Simulation time duration [s]  
    **u**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;Initial velocity along the east direction [m/s]  
    **v**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;Initial velocity along the north direction [m/s]  
    **deltat**=*integer*  
    &nbsp;&nbsp;&nbsp;&nbsp;Time-lag for output generation [s]  
    **opt_t**=*float* [,*float*,...]  
    &nbsp;&nbsp;&nbsp;&nbsp;Additional instants for output map generation [s]  
    **h**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;Prefix for water depth output raster maps  
    **vel**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;Prefix for water velocity output raster maps  
    **hmax**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of output maximum water depth raster map; relative intensity [h\*v] and time map are also generated  
    **vmax**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of output maximum water velocity raster map; relative intensity [h\*v] and time map are also generated  
    **imax**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of output maximum intensity [h\*v] raster map; relative time map are also generated  
    **wavefront**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of output wave front time[s] raster map  
    **-d**  
    &nbsp;&nbsp;&nbsp;&nbsp;Flow direction additional output (aspect visualization)  
    **--overwrite**  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    **--help**  
    &nbsp;&nbsp;&nbsp;&nbsp;Print usage summary  
    **--verbose**  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    **--quiet**  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    **--qq**  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    **--ui**  
    &nbsp;&nbsp;&nbsp;&nbsp;Force launching GUI dialog

=== "Python (grass.script)"

    **method** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Computational method for initial velocity estimation  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *dambreak-without_hypotesis, uniform drop in of lake, small dam breach*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *dambreak-without_hypotesis*  
    **timestep** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Initial computational time step [s] - CFL condition  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *0.01*  
    **elev** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of elevation raster map (including lake bathymetry and dam)  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster  
    **lake** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of water depth raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster  
    **dambreak** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of dam breach width raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster  
    **manning** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of Manning's roughness coefficient raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster  
    **tstop** : int, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Simulation time duration [s]  
    **u** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Initial velocity along the east direction [m/s]  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster  
    **v** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Initial velocity along the north direction [m/s]  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster  
    **deltat** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Time-lag for output generation [s]  
    **opt_t** : float | list[float] | str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Additional instants for output map generation [s]  
    **h** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Prefix for water depth output raster maps  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, raster  
    **vel** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Prefix for water velocity output raster maps  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, raster  
    **hmax** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of output maximum water depth raster map; relative intensity [h\*v] and time map are also generated  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, raster  
    **vmax** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of output maximum water velocity raster map; relative intensity [h\*v] and time map are also generated  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, raster  
    **imax** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of output maximum intensity [h\*v] raster map; relative time map are also generated  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, raster  
    **wavefront** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of output wave front time[s] raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, raster  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *d*  
    &nbsp;&nbsp;&nbsp;&nbsp;**d**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Flow direction additional output (aspect visualization)  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

=== "Python (grass.tools)"

    **method** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Computational method for initial velocity estimation  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *dambreak-without_hypotesis, uniform drop in of lake, small dam breach*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *dambreak-without_hypotesis*  
    **timestep** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Initial computational time step [s] - CFL condition  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *0.01*  
    **elev** : str | np.ndarray, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of elevation raster map (including lake bathymetry and dam)  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster  
    **lake** : str | np.ndarray, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of water depth raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster  
    **dambreak** : str | np.ndarray, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of dam breach width raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster  
    **manning** : str | np.ndarray, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of Manning's roughness coefficient raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster  
    **tstop** : int, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Simulation time duration [s]  
    **u** : str | np.ndarray, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Initial velocity along the east direction [m/s]  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster  
    **v** : str | np.ndarray, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Initial velocity along the north direction [m/s]  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster  
    **deltat** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Time-lag for output generation [s]  
    **opt_t** : float | list[float] | str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Additional instants for output map generation [s]  
    **h** : str | type(np.ndarray) | type(np.array) | type(gs.array.array), *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Prefix for water depth output raster maps  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, raster  
    **vel** : str | type(np.ndarray) | type(np.array) | type(gs.array.array), *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Prefix for water velocity output raster maps  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, raster  
    **hmax** : str | type(np.ndarray) | type(np.array) | type(gs.array.array), *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of output maximum water depth raster map; relative intensity [h\*v] and time map are also generated  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, raster  
    **vmax** : str | type(np.ndarray) | type(np.array) | type(gs.array.array), *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of output maximum water velocity raster map; relative intensity [h\*v] and time map are also generated  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, raster  
    **imax** : str | type(np.ndarray) | type(np.array) | type(gs.array.array), *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of output maximum intensity [h\*v] raster map; relative time map are also generated  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, raster  
    **wavefront** : str | type(np.ndarray) | type(np.array) | type(gs.array.array), *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of output wave front time[s] raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, raster  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *d*  
    &nbsp;&nbsp;&nbsp;&nbsp;**d**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Flow direction additional output (aspect visualization)  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

    Returns:

    **result** : grass.tools.support.ToolResult | np.ndarray | tuple[np.ndarray] | None  
    If the tool produces text as standard output, a *ToolResult* object will be returned. Otherwise, `None` will be returned. If an array type (e.g., *np.ndarray*) is used for one of the raster outputs, the result will be an array and will have the shape corresponding to the computational region. If an array type is used for more than one raster output, the result will be a tuple of arrays.

    Raises:

    *grass.tools.ToolError*: When the tool ended with an error.

## DESCRIPTION

***r.damflood*** - The definition of flooding areas is of considerable
importance for both the risk analysis and the emergency management. This
command, in particular, is an embedded GRASS GIS hydrodynamic 2D model
that allows to obtain flooding area due to a failure of a dam, given the
geometry of the reservoir and of the downstream area, the initial
conditions and the dam breach geometry.  
The numerical model solves the conservative form of the shallow water
equations (SWE) using a finite volume method (FVM); the intercell flux
is computed by the "upwind method and the water-level gradient is
evaluated by weighted average of both upwind and downwind gradient.
Additional details of the specific numerical scheme adopted in the model
are presented in references \[1\].  
The command allows to generate raster time series, of water depth and
flow velocity, with time resolution defined by user. Each time series is
identified by a number of raster maps named with a common prefix as
specified by the user and the time instant which it refers expressed in
seconds from the dam failure, joined by the underscore character (e.g.;
myvel\_125, myvel\_250, myvel\_375, etc.).  
Because this new module has been implemented with the aim to provide an
instrument for risk assessment fully within a GIS environment, it should
be able to provide intensity maps directly applicable in those
analyses.In floods, intensity generally corresponds to the maximum flow
depth, but in the particular case of flash floods, where velocities are
normally high, it is recommended to use as intensity indicator the
maximum between the water depth and the product of water velocity and
water depth. For this reason, with this module, in addition to the water
depth and velocity maps, the user can choose a variety of output raster
maps: maximum water depth, maximum water velocity, and maximum intensity
raster maps.  
In case on high numerical stability problem, the user is warned, and the
simulation is stopped.  
  
***Use***  

***Requested input:***  
The required input are:  
\- a DTM including the lake bathimetry and the dam elevation over the
ground \[elev\],  
\- a map with the initial condition easily obtained with
[r.lake](https://grass.osgeo.org/grass-stable/manuals/r.lake.html)
command \[lake\],  
\- a dam breach width raster map \[dambreak\] which can be obtained
using [r.dam](r.dam.md) grass add-on script,  
\- a Manning's roughness coefficient raster map, easily obtained from a
reclassification of a land use map
([r.reclass](https://grass.osgeo.org/grass-stable/manuals/r.reclass.html))
\[manning\],  
\- the simulation time length expressed in *seconds* \[tstop\].  
  
***Output map and additional output options:***  
First the user can set a specific time lag \[deltat\] expressed in
*seconds*, that is used for the output map (depth and velocity)
generation. and also an additional series of instants
\[opt\_t\],expressed in *seconds* from the beginning of the simulation),
used to generate further water flow depth and velocity maps at desired
precise times.  
The user can choose between one of the following time series raster maps
as output: - flow depth \[h\],  
\- flow velocity \[vel\],  
\- a raster map with maximum water depth \[hmax\], relative flooding
intensity \[i\_hmax\], that is the product of water depth and velocity,
and the relative time of occurence\[t\_hmax\],  
\- a raster map with maximum water velocity \[vmax\], relative flooding
intensity \[i\_vmax\], and the relative time of occurence\[t\_vmax\],  
\- a raster map with maximum flooding intensity \[imax\] and the
relative time of occurence\[t\_imax\].  
\- a raster map with the time of arriving of the Wave-Front
\[wavefront\]  
  
where and the raster maps are coded as "prefix" + "\_" + "elapsed
seconds": e.g. *mydepth\_125*.  
  
*Obviously at least one output map prefix must be specified.*  
The unit of measurements of output raster maps are expresssed using the
*International System* (*S.I.*).  
  
***Options:***  
Using a specific flag, the user can obtain another raster map with flow
directions that can be visualized using a specific display command
([d.rast.arrow](https://grass.osgeo.org/grass-stable/manuals/d.rast.arrow.html))
of the GRASS GIS software.  
  
Actually two different dam failure type are considered by the command:
*(i)* full breach, *(ii)* partial breach.  
![image-alt](./dam_failure.png)  
In case of total istantaeous dam break (configuration *i*), the initial
velocity is computed directly applying the SWE at the first time step;
while in case of partial dam breach (configuration *ii*) the user can
choose between don't use any hypothesis, like in the previous
configuration, or evaluate the initial velocity using the overflow
spillway equation:  
*V = 0.4 * sqrt(2 g h)*  
where *V* is the water flow velocity expressed in m/s, *g* is the
gravitational acceleration expressed in m/s<sup>2</sup> and *h* is the
water depth in correspondence of the dam breach expresssed in meters
(m).  
Optionally the user may modify the initial timestep used for the
numerical solution of the SWE (*default value = 0.01 s*), nevertheless
the timestep \[\], and choose a specific failure tipe corresponding to
different computational method for the initial velocity estimation.  

## AUTHORS

Roberto Marzocchi ([e-mail](mailto:roberto.marzocchi@gter.it)) and
Massimiliano Cannata ([e-mail](mailto:massimiliano.cannata@supsi.ch)).
The GRASS tool was developed by Institute of earth science (IST),
University of applied science of Italian Switzerland (SUPSI), Lugano -
Division of geomatics [web-page](http://istgeo.ist.supsi.ch/site/)  
Actually the debug is assured by:  
\- [Gter srl](https://www.gter.it/) (Genoa, Italy)  
\- [IST -SUPSI](https://sites.supsi.ch/ist_en.html) (Lugano,
Switzerland)  
The numerical model, originally developed by the National Center for
Computational Hydroscience and Engineering of the University of
Mississippi, has been reformulated and modified by the authors
introducing important new features to consider the numerical stability
and the type of dam failure, and currently is written in ANSI C
programming language within GRASS.  
  
## SEE ALSO

*[r.lake](https://grass.osgeo.org/grass-stable/manuals/r.lake.html)*,
*[r.reclass](https://grass.osgeo.org/grass-stable/manuals/r.reclass.html)*,
*[d.rast.arrow](https://grass.osgeo.org/grass-stable/manuals/d.rast.arrow.html)*,
*[r.inund.fluv](r.inund.fluv.md)*.  
Details of the numerical model are presented in references.  

## REFERENCES

\[1\] Cannata M. & Marzocchi R. (2012). Two-dimensional dam break
flooding simulation: a GIS embedded approach. - Natural Hazards
61(3):1143-1159  
\[2\]
[Pdf](http://gfoss2009.crs4.it/en/system/files/marzocchi_cannata_licensed.pdf)
presentation of the work at the "X Meeting degli Utenti Italiani di
GRASS - GFOSS" (It) [web-page](http://gfoss2009.crs4.it/en/node/61)  
\[3\] Pdf presentation of the work at the FOSS4G 2009 (En) -
[web-page](http://2009.foss4g.org/researchpapers/#researchpaper_10)  
\[4\] Pdf presentation of the work at the Geoitalia 2011 conference
(En)-
[document](https://dl.dropbox.com/u/3019930/marzocchi_cannata_geoitalia2011.pdf)  

*Last changed: $27 februar 2013 09:40:00 CET $*

## SOURCE CODE

Available at: [r.damflood source code](https://github.com/OSGeo/grass-addons/tree/grass8/src/raster/r.damflood)
([history](https://github.com/OSGeo/grass-addons/commits/grass8/src/raster/r.damflood))  
Latest change: Thursday May 29 11:23:19 2025 in commit [701c59b](https://github.com/OSGeo/grass-addons/commit/701c59b932c6a12e06ba3a4135cab5955cd9047a)
