---
name: r.droka.py
description: Calculates run-out distance of a falling rock mass
keywords: [ rock mass, rockfall ]
---

# r.droka.py

Calculates run-out distance of a falling rock mass

=== "Command line"

    **r.droka.py**
    **dem**=*string*
    **start**=*string*
    **ang**=*float*
    **red**=*float*
    **m**=*float*
    **num**=*integer*
    **prefix**=*name*
    [**n**=*integer*]
    [**--overwrite**]
    [**--verbose**]
    [**--quiet**]
    [**--qq**]
    [**--ui**]

    Example:

    ```sh
    r.droka.py dem=string start=string ang=0.0 red=0.9 m=0.0 num=0 prefix=name
    ```

=== "Python (grass.script)"

    *grass.script.run_command*("***r.droka.py***",
        **dem**,
        **start**,
        **ang**,
        **red**=*0.9*,
        **m**,
        **num**,
        **prefix**,
        **n**=*None*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    gs.run_command("r.droka.py", dem="string", start="string", ang=0.0, red=0.9, m=0.0, num=0, prefix="name")
    ```

=== "Python (grass.tools)"

    *grass.tools.Tools.r_droka_py*(**dem**,
        **start**,
        **ang**,
        **red**=*0.9*,
        **m**,
        **num**,
        **prefix**,
        **n**=*None*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    tools = Tools()
    tools.r_droka_py(dem="string", start="string", ang=0.0, red=0.9, m=0.0, num=0, prefix="name")
    ```

    This grass.tools API is experimental in version 8.5 and expected to be stable in version 8.6.

## Parameters

=== "Command line"

    **dem**=*string* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Digital Elevation Model  
    **start**=*string* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of starting points map  
    **ang**=*float* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Shadow angle  
    **red**=*float* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Reduction value  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *0-1*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *0.9*  
    **m**=*float* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Value of rock mass (kg)  
    **num**=*integer* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Number of boulders (&gt;=1)  
    **prefix**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Prefix for output raster maps  
    **n**=*integer*  
    &nbsp;&nbsp;&nbsp;&nbsp;Buffer distance (meters)  
    **--overwrite**  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    **--help**  
    &nbsp;&nbsp;&nbsp;&nbsp;Print usage summary  
    **--verbose**  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    **--quiet**  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    **--qq**  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    **--ui**  
    &nbsp;&nbsp;&nbsp;&nbsp;Force launching GUI dialog

=== "Python (grass.script)"

    **dem** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Digital Elevation Model  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster  
    **start** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of starting points map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, vector  
    **ang** : float, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Shadow angle  
    **red** : float, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Reduction value  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *0-1*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *0.9*  
    **m** : float, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Value of rock mass (kg)  
    **num** : int, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Number of boulders (&gt;=1)  
    **prefix** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Prefix for output raster maps  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, raster, *name*  
    **n** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Buffer distance (meters)  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

=== "Python (grass.tools)"

    **dem** : str | np.ndarray, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Digital Elevation Model  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster  
    **start** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of starting points map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, vector  
    **ang** : float, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Shadow angle  
    **red** : float, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Reduction value  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *0-1*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *0.9*  
    **m** : float, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Value of rock mass (kg)  
    **num** : int, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Number of boulders (&gt;=1)  
    **prefix** : str | type(np.ndarray) | type(np.array) | type(gs.array.array), *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Prefix for output raster maps  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, raster, *name*  
    **n** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Buffer distance (meters)  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

    Returns:

    **result** : grass.tools.support.ToolResult | np.ndarray | tuple[np.ndarray] | None  
    If the tool produces text as standard output, a *ToolResult* object will be returned. Otherwise, `None` will be returned. If an array type (e.g., *np.ndarray*) is used for one of the raster outputs, the result will be an array and will have the shape corresponding to the computational region. If an array type is used for more than one raster output, the result will be a tuple of arrays.

    Raises:

    *grass.tools.ToolError*: When the tool ended with an error.

## DESCRIPTION

The intersection between the topographic profile and the line starting
from the point of detachment with a certain angle to the horizontal line
defines the point of maximum propagation (Evans and Hungr, 1993;
Jaboyedoff and Labiouse, 2003). The angle of inclination and the line of
propagation are defined as zenith angle and shadow zone. This script
defines rockfall zones from a digital elevation model (DEM) and vector
layer containing starting point or points.

![image-alt](r_droka_img.png)

***Energy line used for the cone method from the top or the bottom of a
cliff (shadow angle), according to various authors (Image from
Jaboyedoff and Labiouse, 2003)***

## INPUT

**Digital Elevation Model**:
Name of elevation raster map.

**Starting points**:
Name of vector map containing rockfall source area. It can be one point or more.

**Shadow angle**:
Angle of inclination that defines the propagation zone.
It's calculated from a horizontal plane starting from a source point:
highest values determine a lowest propagation.

**Reduction value**:
Reduction multiplicator for velocity. Default value is 0.9.

**Number of boulders**:
For each starting point can be generated other random points used in the computations.
By default points are located in a radius from the starting point equal to:
(cell size * number of boulders)/2. Insert 1 for use only the original
starting point or points. Note that a high number of boulders can make
excessively long the calculation times.

**Rock mass**:
Value of rock mass (Kg)

**Output prefix**:
Name of prefix used for output raster maps

**Buffer distance**:
This value defines the radius for randomly generating boulders starting from
starting point. It's in the option dialog window.

## OUTPUT

**r.droka generates 5 raster maps and a vector map.** The names of all
output maps start with the prefix defined by the parameter prefix
followed by the name of map

- *prefix*\_propagation: raster map representing the area of
    propagation. If are used multiple source points, each pixel shows
    the percentage of passage (%)
- *prefix*\_vel\_max: maximum rock-fall translational velocities
    (m/sec)
- *prefix*\_vel\_med: medium rock-fall translational velocities
    (m/sec)
- *prefix*\_vel\_max: medium kinetic energy (kJ)
- *prefix*\_en\_max: maximum kinetic energy (kJ)
- *prefix*\_starting: vector map of starting points

## REFERENCES

FILIPELLO A., GIULIANI A., MANDRONE G. (2010) - Rock Slopes Failure
Susceptibility Analysis: From Remote Sensing Measurements to Geographic
Information System Raster Modules. American Journal of Environmental
Sciences 6 (6): 489-494, 2010 ISSN 1553-345X 2010 Science Publications.

JABOYEDOFF M., LABIOUSE V. (2003) - Preliminary assessment of rockfall
hazard based on GIS Data. Proceeding of the 10th ISRM Congress, South
African Inst. Min. Met., Johannesburg, pp: 575-578

EVANS, S.G., HUNGR O. (1993). The assessment of rock fall hazard at the
base of the talus slope. Can. Geotech. J., 30: 620-636. DOI:
10.1139/t93-054

## SEE ALSO

## AUTHORS

Andrea Filipello, University of Turin, Italy

Daniele Strigaro, University of Milan, Italy

## SOURCE CODE

Available at: [r.droka source code](https://github.com/OSGeo/grass-addons/tree/grass8/src/raster/r.droka)
([history](https://github.com/OSGeo/grass-addons/commits/grass8/src/raster/r.droka))  
Latest change: Thursday Mar 20 21:35:59 2025 in commit [f270357](https://github.com/OSGeo/grass-addons/commit/f270357f0ee5a6a465fc12b118ca6694cd6c7f9d)
