---
name: r.external.out
description: Redirects raster output to file utilizing GDAL library rather than storing in GRASS raster format.
keywords: [ raster, export, output, external ]
---

# r.external.out

Redirects raster output to file utilizing GDAL library rather than storing in GRASS raster format.

=== "Command line"

    **r.external.out**
    [**-frp**]
    **directory**=*path*
    [**extension**=*string*]
    **format**=*string*
    [**options**=*string* [,*string*,...]]
    [**--verbose**]
    [**--quiet**]
    [**--qq**]
    [**--ui**]

    Example:

    ```sh
    r.external.out directory=path format=VRT
    ```

=== "Python (grass.script)"

    *grass.script.run_command*("***r.external.out***",
        **directory**,
        **extension**=*None*,
        **format**,
        **options**=*None*,
        **flags**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    gs.run_command("r.external.out", directory="path", format="VRT")
    ```

=== "Python (grass.tools)"

    *grass.tools.Tools.r_external_out*(**directory**,
        **extension**=*None*,
        **format**,
        **options**=*None*,
        **flags**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    tools = Tools()
    tools.r_external_out(directory="path", format="VRT")
    ```

    This grass.tools API is experimental in version 8.5 and expected to be stable in version 8.6.

## Parameters

=== "Command line"

    **directory**=*path* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of output directory  
    **extension**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;Extension for output files  
    **format**=*string* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Format of output files  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *VRT, GTiff, COG, NITF, HFA, ELAS, AAIGrid, DTED, PNG, JPEG, MEM, GIF, XPM, BMP, PCIDSK, PCRaster, ILWIS, SGI, SRTMHGT, Leveller, Terragen, netCDF, HDF4Image, ISIS3, ISIS2, PDS4, VICAR, ERS, JP2OpenJPEG, FIT, GRIB, RMF, WMS, RST, GSAG, GSBG, GS7BG, R, KMLSUPEROVERLAY, WEBP, PDF, Rasterlite, MBTiles, CALS, WMTS, MRF, PNM, PAux, MFF, MFF2, BT, LAN, LCP, GTX, NTv2, CTable2, KRO, ROI_PAC, RRASTER, BYN, USGSDEM, NWT_GRD, ADRG, BLX, PostGISRaster, SAGA, XYZ, HF2, ZMap, SIGDEM, JPEGXL, GPKG, OpenFileGDB, NGW, ENVI, EHdr, ISCE, Zarr*  
    **options**=*string* [,*string*,...]  
    &nbsp;&nbsp;&nbsp;&nbsp;Creation options  
    **-f**  
    &nbsp;&nbsp;&nbsp;&nbsp;List supported formats and exit  
    **-r**  
    &nbsp;&nbsp;&nbsp;&nbsp;Cease using GDAL and revert to native output  
    **-p**  
    &nbsp;&nbsp;&nbsp;&nbsp;Print current status  
    **--help**  
    &nbsp;&nbsp;&nbsp;&nbsp;Print usage summary  
    **--verbose**  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    **--quiet**  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    **--qq**  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    **--ui**  
    &nbsp;&nbsp;&nbsp;&nbsp;Force launching GUI dialog

=== "Python (grass.script)"

    **directory** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of output directory  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *path*  
    **extension** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Extension for output files  
    **format** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Format of output files  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *VRT, GTiff, COG, NITF, HFA, ELAS, AAIGrid, DTED, PNG, JPEG, MEM, GIF, XPM, BMP, PCIDSK, PCRaster, ILWIS, SGI, SRTMHGT, Leveller, Terragen, netCDF, HDF4Image, ISIS3, ISIS2, PDS4, VICAR, ERS, JP2OpenJPEG, FIT, GRIB, RMF, WMS, RST, GSAG, GSBG, GS7BG, R, KMLSUPEROVERLAY, WEBP, PDF, Rasterlite, MBTiles, CALS, WMTS, MRF, PNM, PAux, MFF, MFF2, BT, LAN, LCP, GTX, NTv2, CTable2, KRO, ROI_PAC, RRASTER, BYN, USGSDEM, NWT_GRD, ADRG, BLX, PostGISRaster, SAGA, XYZ, HF2, ZMap, SIGDEM, JPEGXL, GPKG, OpenFileGDB, NGW, ENVI, EHdr, ISCE, Zarr*  
    **options** : str | list[str], *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Creation options  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *f*, *r*, *p*  
    &nbsp;&nbsp;&nbsp;&nbsp;**f**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;List supported formats and exit  
    &nbsp;&nbsp;&nbsp;&nbsp;**r**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Cease using GDAL and revert to native output  
    &nbsp;&nbsp;&nbsp;&nbsp;**p**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Print current status  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

=== "Python (grass.tools)"

    **directory** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of output directory  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *path*  
    **extension** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Extension for output files  
    **format** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Format of output files  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *VRT, GTiff, COG, NITF, HFA, ELAS, AAIGrid, DTED, PNG, JPEG, MEM, GIF, XPM, BMP, PCIDSK, PCRaster, ILWIS, SGI, SRTMHGT, Leveller, Terragen, netCDF, HDF4Image, ISIS3, ISIS2, PDS4, VICAR, ERS, JP2OpenJPEG, FIT, GRIB, RMF, WMS, RST, GSAG, GSBG, GS7BG, R, KMLSUPEROVERLAY, WEBP, PDF, Rasterlite, MBTiles, CALS, WMTS, MRF, PNM, PAux, MFF, MFF2, BT, LAN, LCP, GTX, NTv2, CTable2, KRO, ROI_PAC, RRASTER, BYN, USGSDEM, NWT_GRD, ADRG, BLX, PostGISRaster, SAGA, XYZ, HF2, ZMap, SIGDEM, JPEGXL, GPKG, OpenFileGDB, NGW, ENVI, EHdr, ISCE, Zarr*  
    **options** : str | list[str], *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Creation options  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *f*, *r*, *p*  
    &nbsp;&nbsp;&nbsp;&nbsp;**f**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;List supported formats and exit  
    &nbsp;&nbsp;&nbsp;&nbsp;**r**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Cease using GDAL and revert to native output  
    &nbsp;&nbsp;&nbsp;&nbsp;**p**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Print current status  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

    Returns:

    **result** : grass.tools.support.ToolResult | None  
    If the tool produces text as standard output, a *ToolResult* object will be returned. Otherwise, `None` will be returned.

    Raises:

    *grass.tools.ToolError*: When the tool ended with an error.

## DESCRIPTION

*r.external.out* instructs GRASS to write subsequently generated
raster maps as data files (e.g. GeoTIFF) using GDAL instead of storing
them in GRASS raster format in the current mapset.

Any new raster map is immediately written out through GDAL as a file.

## NOTES

A relative directory path (parameter *directory*) is interpreted
relative to the current mapset directory, not the current directory
where the command was launched. An unspecified or empty directory (which
will occur if the user passes a simple filename for *output*) results in
the output file being placed in the "gdal/" subdirectory of the current
mapset directory.

## EXAMPLES

### Storing results from raster data analysis directly as GeoTIFF

The module *r.external.out* is used to write out processing results
directly in GeoTIFF format (any GDAL supported format can be used here):

```sh
# define output directory for files resulting from GRASS calculation(s)
# and target format:
mkdir $HOME/gisoutput/
# hint: the create options are not mandatory
r.external.out directory=$HOME/gisoutput/ format="GTiff" option="BIGTIFF=YES,COMPRESS=DEFLATE"
# prepare sample analysis
g.region raster=elevation -p

# perform GRASS calculation (here: filter by height, write > 120m, NULL otherwise)
# this will store the output map directly as GeoTIFF, so we use .tif extension:
r.mapcalc "elev_filt.tif = if(elevation > 120.0, elevation, null() )"

# ...the "elev_filt.tif" is immediately written.

# cease GDAL output connection and turn back to write out GRASS raster files:
r.external.out -r

# verify resulting file
gdalinfo $HOME/gisoutput/elev_filt.tif
```

### Complete workflow using only external geodata while processing in GRASS

The module *r.external.out* can be used along with *r.external* to
process external geodata in GRASS while writing out the results directly
in GeoTIFF:

```sh
# register GeoTIFF file to be used in current mapset:
r.external input=terra_lst1km20030314.LST_Day.tif output=modis_celsius

# define output directory for files resulting from GRASS calculation:
r.external.out directory=$HOME/gisoutput/ format="GTiff"

# perform GRASS calculation (here: extract pixels > 20 deg C)
# this stores the output map directly as GeoTIFF:
r.mapcalc "warm.tif = if(modis_celsius > 20.0, modis_celsius, null() )"

# cease GDAL output connection and turn back to write GRASS raster files:
r.external.out -r

# now use the resulting file elsewhere
gdalinfo $HOME/gisoutput/warm.tif
```

## REFERENCES

GDAL Pages: [https://gdal.org/](https://gdal.org)  

## SEE ALSO

*[r.in.gdal](r.in.gdal.md), [r.out.gdal](r.out.gdal.md),
[r.external](r.external.md)*

## AUTHOR

Glynn Clements

## SOURCE CODE

Available at: [r.external.out source code](https://github.com/OSGeo/grass/tree/main/raster/r.external.out)
([history](https://github.com/OSGeo/grass/commits/main/raster/r.external.out))  
Latest change: Thursday Dec 04 09:43:11 2025 in commit [8b4d7c3](https://github.com/OSGeo/grass/commit/8b4d7c3e310ec3122a5e870e724c50bd716f9513)
