---
name: r.futures.potential.py
description: Module for computing development potential as input to r.futures.pga
keywords: [ raster, statistics ]
---

# r.futures.potential.py

Module for computing development potential as input to r.futures.pga

=== "Command line"

    **r.futures.potential.py**
    [**-d**]
    **input**=*name*
    **output**=*name*
    [**separator**=*character*]
    **columns**=*name* [,*name*,...]
    **developed_column**=*name*
    **subregions_column**=*name*
    [**random_column**=*string*]
    [**fixed_columns**=*string* [,*string*,...]]
    [**min_variables**=*integer*]
    [**max_variables**=*integer*]
    **nprocs**=*integer*
    [**dredge_output**=*name*]
    [**--overwrite**]
    [**--verbose**]
    [**--quiet**]
    [**--qq**]
    [**--ui**]

    Example:

    ```sh
    r.futures.potential.py input=name output=name columns=name developed_column=name subregions_column=name nprocs=1
    ```

=== "Python (grass.script)"

    *grass.script.run_command*("***r.futures.potential.py***",
        **input**,
        **output**,
        **separator**=*"comma"*,
        **columns**,
        **developed_column**,
        **subregions_column**,
        **random_column**=*None*,
        **fixed_columns**=*None*,
        **min_variables**=*1*,
        **max_variables**=*None*,
        **nprocs**=*1*,
        **dredge_output**=*None*,
        **flags**=*None*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    gs.run_command("r.futures.potential.py", input="name", output="name", columns="name", developed_column="name", subregions_column="name", nprocs=1)
    ```

=== "Python (grass.tools)"

    *grass.tools.Tools.r_futures_potential_py*(**input**,
        **output**,
        **separator**=*"comma"*,
        **columns**,
        **developed_column**,
        **subregions_column**,
        **random_column**=*None*,
        **fixed_columns**=*None*,
        **min_variables**=*1*,
        **max_variables**=*None*,
        **nprocs**=*1*,
        **dredge_output**=*None*,
        **flags**=*None*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    tools = Tools()
    tools.r_futures_potential_py(input="name", output="name", columns="name", developed_column="name", subregions_column="name", nprocs=1)
    ```

    This grass.tools API is experimental in version 8.5 and expected to be stable in version 8.6.

## Parameters

=== "Command line"

    **input**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input vector map  
    &nbsp;&nbsp;&nbsp;&nbsp;Or data source for direct OGR access  
    **output**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Output Potential file  
    **separator**=*character*  
    &nbsp;&nbsp;&nbsp;&nbsp;Separator used in output file  
    &nbsp;&nbsp;&nbsp;&nbsp;Special characters: pipe, comma, space, tab, newline  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *comma*  
    **columns**=*name* [,*name*,...] **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Names of attribute columns representing sampled predictors  
    **developed_column**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of attribute column representing development  
    **subregions_column**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of attribute column representing subregions  
    **random_column**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;Random effect predictor  
    **fixed_columns**=*string* [,*string*,...]  
    &nbsp;&nbsp;&nbsp;&nbsp;Predictor columns that will be used for all models when dredging  
    **min_variables**=*integer*  
    &nbsp;&nbsp;&nbsp;&nbsp;Minimum number of predictors considered  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *1-20*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1*  
    **max_variables**=*integer*  
    &nbsp;&nbsp;&nbsp;&nbsp;Maximum number of predictors considered  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *1-20*  
    **nprocs**=*integer* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Number of parallel processes for dredging  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *1-50*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1*  
    **dredge_output**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Output CSV file summarizing all models  
    **-d**  
    &nbsp;&nbsp;&nbsp;&nbsp;Use dredge function to find best model  
    **--overwrite**  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    **--help**  
    &nbsp;&nbsp;&nbsp;&nbsp;Print usage summary  
    **--verbose**  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    **--quiet**  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    **--qq**  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    **--ui**  
    &nbsp;&nbsp;&nbsp;&nbsp;Force launching GUI dialog

=== "Python (grass.script)"

    **input** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input vector map  
    &nbsp;&nbsp;&nbsp;&nbsp;Or data source for direct OGR access  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, vector, *name*  
    **output** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Output Potential file  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, file, *name*  
    **separator** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Separator used in output file  
    &nbsp;&nbsp;&nbsp;&nbsp;Special characters: pipe, comma, space, tab, newline  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, separator, *character*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *comma*  
    **columns** : str | list[str], *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Names of attribute columns representing sampled predictors  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, dbcolumn, *name*  
    **developed_column** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of attribute column representing development  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, dbcolumn, *name*  
    **subregions_column** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of attribute column representing subregions  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, dbcolumn, *name*  
    **random_column** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Random effect predictor  
    **fixed_columns** : str | list[str], *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Predictor columns that will be used for all models when dredging  
    **min_variables** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Minimum number of predictors considered  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *1-20*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1*  
    **max_variables** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Maximum number of predictors considered  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *1-20*  
    **nprocs** : int, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Number of parallel processes for dredging  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *1-50*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1*  
    **dredge_output** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Output CSV file summarizing all models  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, file, *name*  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *d*  
    &nbsp;&nbsp;&nbsp;&nbsp;**d**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Use dredge function to find best model  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

=== "Python (grass.tools)"

    **input** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input vector map  
    &nbsp;&nbsp;&nbsp;&nbsp;Or data source for direct OGR access  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, vector, *name*  
    **output** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Output Potential file  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, file, *name*  
    **separator** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Separator used in output file  
    &nbsp;&nbsp;&nbsp;&nbsp;Special characters: pipe, comma, space, tab, newline  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, separator, *character*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *comma*  
    **columns** : str | list[str], *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Names of attribute columns representing sampled predictors  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, dbcolumn, *name*  
    **developed_column** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of attribute column representing development  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, dbcolumn, *name*  
    **subregions_column** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of attribute column representing subregions  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, dbcolumn, *name*  
    **random_column** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Random effect predictor  
    **fixed_columns** : str | list[str], *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Predictor columns that will be used for all models when dredging  
    **min_variables** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Minimum number of predictors considered  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *1-20*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1*  
    **max_variables** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Maximum number of predictors considered  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *1-20*  
    **nprocs** : int, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Number of parallel processes for dredging  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *1-50*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1*  
    **dredge_output** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Output CSV file summarizing all models  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, file, *name*  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *d*  
    &nbsp;&nbsp;&nbsp;&nbsp;**d**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Use dredge function to find best model  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

    Returns:

    **result** : grass.tools.support.ToolResult | None  
    If the tool produces text as standard output, a *ToolResult* object will be returned. Otherwise, `None` will be returned.

    Raises:

    *grass.tools.ToolError*: When the tool ended with an error.

## DESCRIPTION

Module *r.futures.potential* implements POTENTIAL submodel as a part of
[FUTURES](r.futures.md) land change model. POTENTIAL is implemented
using a set of coefficients that relate a selection of site suitability
factors to the probability of a place becoming developed. This is
implemented using the parameter table in combination with maps of those
site suitability factors (mapped predictors). The coefficients are
obtained by conducting multilevel logistic regression in R with package
[lme4](https://cran.r-project.org/web/packages/lme4/index.html) where
the coefficients may vary by subregions. The best model is selected
automatically using `dredge` function from package
[MuMIn](https://cran.r-project.org/web/packages/MuMIn/index.html) (which
has numerous caveats).

Module *r.futures.potential* can run it two modes. Without the **-d**
flag, it uses all the given predictors to construct the model. With
**-d** flag, it evaluates all the different combinations of predictors
and picks the best one based on AIC.

### Format

The format of the output file is a CSV file (use option **separator** to
change default separator comma). The header contains the names of the
predictor maps and the first column contains the identifiers of the
subregions. The order of columns is important, the second column
represents intercept, the third development pressure and then the
predictors. Therefore the development pressure column must be specified
as the first column in option **columns**.

```csv
ID,Intercept,devpressure_0_5,slope,road_dens_perc,forest_smooth_perc,...
37037,-1.873,12.595,-0.0758,0.0907,-0.0223,...
37063,-2.039,12.595,-0.0758,0.0907,-0.0223,...
37069,-1.795,12.595,-0.0758,0.0907,-0.0223,...
37077,-1.264,12.595,-0.0758,0.0907,-0.0223,...
37085,-1.925,12.595,-0.0758,0.0907,-0.0223,...
...
```

## NOTES

Note that this module is designed to automate the FUTURES workflow by
brute-force selection of model, which has numerous caveats.

In case there is only one subregion, R function *glm* is used instead of
*glmer*.

## EXAMPLES

## SEE ALSO

[FUTURES](r.futures.md), *[r.futures.pga](r.futures.pga.md)*,
*[r.futures.devpressure](r.futures.devpressure.md)*,
*[r.futures.potsurface](r.futures.potsurface.md)*,
*[r.futures.demand](r.futures.demand.md)*,
*[r.futures.calib](r.futures.calib.md)*,
*[r.sample.category](r.sample.category.md)*

## REFERENCES

- Meentemeyer, R. K., Tang, W., Dorning, M. A., Vogler, J. B.,
    Cunniffe, N. J., & Shoemaker, D. A. (2013). [FUTURES: Multilevel
    Simulations of Emerging Urban-Rural Landscape Structure Using a
    Stochastic Patch-Growing
    Algorithm](https://doi.org/10.1080/00045608.2012.707591). Annals of
    the Association of American Geographers, 103(4), 785-807. DOI:
    10.1080/00045608.2012.707591
- Dorning, M. A., Koch, J., Shoemaker, D. A., & Meentemeyer, R. K.
    (2015). [Simulating urbanization scenarios reveals tradeoffs between
    conservation planning
    strategies](https://doi.org/10.1016/j.landurbplan.2014.11.011).
    Landscape and Urban Planning, 136, 28-39. DOI:
    10.1016/j.landurbplan.2014.11.011
- Petrasova, A., Petras, V., Van Berkel, D., Harmon, B. A., Mitasova,
    H., & Meentemeyer, R. K. (2016). [Open Source Approach to Urban
    Growth
    Simulation](https://isprs-archives.copernicus.org/articles/XLI-B7/953/2016/isprs-archives-XLI-B7-953-2016.pdf).
    Int. Arch. Photogramm. Remote Sens. Spatial Inf. Sci., XLI-B7,
    953-959. DOI: 10.5194/isprsarchives-XLI-B7-953-2016

## AUTHOR

Anna Petrasova, [NCSU GeoForAll](https://geospatial.ncsu.edu/geoforall/)

## SOURCE CODE

Available at: [r.futures.potential source code](https://github.com/OSGeo/grass-addons/tree/grass8/raster/r.futures/r.futures.potential)
([history](https://github.com/OSGeo/grass-addons/commits/grass8/raster/r.futures/r.futures.potential))  
Latest change: Thursday Mar 20 21:36:57 2025 in commit [7286ecf](https://github.com/OSGeo/grass-addons/commit/7286ecf7af235bfd089fb9b1b82fb383cf95f3fc)
