---
name: r.green.biomassfor
description: Toolset for computing the energy potential of biomass from the forestry residues, considering different limits and constraints
keywords: [raster, biomass, forestry]
---

# Toolset for Computing the Energy Potential of Biomass

## DESCRIPTION

The *r.green.biomassfor* suite computes the energy potential of biomass
from the forestry residues, considering different limits and constraints
(e.g. legal, technical, economic).

The *r.green.biomassfor* suite consists of the following different
parts:  
  
- [r.green.biomassfor](r.green.biomassfor.md) - computes the energy
    potential of biomass from the forestry residues, considering
    different limits and constraints (e.g. legal, technical, economic).
- [r.green.biomassfor.theoretical](r.green.biomassfor.theoretical.md)
  - Estimates potential bioenergy depending on forest increment,
    forest management and forest treatment
- [r.green.biomassfor.legal](r.green.biomassfor.legal.md) - Estimates
    potential bioenergy depending on forest increment, forest management
    and forest treatment
- [r.green.biomassfor.technical](r.green.biomassfor.technical.md) -
    Estimates the quantity of woody biomass obtained from a forest
    surface where extraction is possible given a particular level of
    mechanisation
- [r.green.biomassfor.financial](r.green.biomassfor.financial.md) -
    Estimates bioenergy that can be collected to supply heating plants
    or biomass logistic centres and that is associated with a positive
    net revenue for the entire production process
- [r.green.biomassfor.recommended](r.green.biomassfor.recommended.md)
  - Estimates potential bioenergy according to environmental
    restriction
- [r.green.biomassfor.impact](r.green.biomassfor.impact.md) -
    Calculates impact and multifunctionality values

## REFERENCES

- Garegnani, G., Geri, F., Zambelli, P., Grilli, G., Sacchelli, S.,
    Paletto, A., Curetti, G., Ciolli, M., Vettorato, D. (2015). A new
    open source DSS for assessment and planning of renewable energy: r.
    green. Proceedings of FOSS4G Europe, Como, 14-17.
    ([PDF](https://www.academia.edu/download/42063487/A_new_open_source_DSS_for_assessment_and20160204-20913-vxe2wt.pdf))
- Garegnani, G., Zambelli, P., Geri, F., Gros, J., D'Alonzo, V.,
    Grilli, G., Sacchelli, S., Balest, J. Curetti, G., Paletto, A.,
    Ciolli, M., Vettorato, D. (2015): Evaluation of renewable energy
    potential in Pilot Areas: a Decision Support System.
    ([PDF](https://web.archive.org/web/20220419152012/https://www.recharge-green.eu/wp-content/uploads/2015/02/Poster_r-green_v4.pdf))

## SEE ALSO

*[r.green](r.green.md) - overview page*

## AUTHORS

Francesco Geri, Pietro Zambelli, Sandro Sacchelli, Marco Ciolli

## SOURCE CODE

Available at: [r.green.biomassfor source code](https://github.com/OSGeo/grass-addons/tree/grass8/raster/r.green/r.green.biomassfor)
([history](https://github.com/OSGeo/grass-addons/commits/grass8/raster/r.green/r.green.biomassfor))  
Latest change: Friday Mar 07 09:19:19 2025 in commit [88416e6](https://github.com/OSGeo/grass-addons/commit/88416e63e1d8497b436b84ae6bd356d3f97789a6)
