---
name: r.green.gshp.theoretical.py
description: Calculate the Ground Source Heat Pump potential
keywords: [ raster, geothermal, renewable energy ]
---

# r.green.gshp.theoretical.py

Calculate the Ground Source Heat Pump potential

=== "Command line"

    **r.green.gshp.theoretical.py**
    [**-d**]
    **ground_conductivity**=*name*
    [**heating_season_raster**=*name*]
    [**heating_season_value**=*double*]
    [**power_value**=*double*]
    [**ground_capacity_raster**=*name*]
    [**ground_capacity_value**=*double*]
    [**ground_temp_raster**=*name*]
    [**ground_temp_value**=*double*]
    [**borehole_radius**=*double*]
    [**borehole_resistence**=*double*]
    [**borehole_length**=*double*]
    [**pipe_radius**=*double*]
    [**number_pipes**=*integer*]
    [**grout_conductivity**=*double*]
    [**fluid_limit_temperature**=*double*]
    [**lifetime**=*integer*]
    **power**=*name*
    **energy**=*name*
    [**length**=*name*]
    [**--overwrite**]
    [**--verbose**]
    [**--quiet**]
    [**--qq**]
    [**--ui**]

    Example:

    ```sh
    r.green.gshp.theoretical.py ground_conductivity=name power=name energy=name
    ```

=== "Python (grass.script)"

    *grass.script.run_command*("***r.green.gshp.theoretical.py***",
        **ground_conductivity**,
        **heating_season_raster**=*None*,
        **heating_season_value**=*180.*,
        **power_value**=*nan*,
        **ground_capacity_raster**=*None*,
        **ground_capacity_value**=*2.5*,
        **ground_temp_raster**=*None*,
        **ground_temp_value**=*10.*,
        **borehole_radius**=*0.075*,
        **borehole_resistence**=*nan*,
        **borehole_length**=*100*,
        **pipe_radius**=*0.016*,
        **number_pipes**=*4*,
        **grout_conductivity**=*2*,
        **fluid_limit_temperature**=*-2*,
        **lifetime**=*50*,
        **power**,
        **energy**,
        **length**=*None*,
        **flags**=*None*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    gs.run_command("r.green.gshp.theoretical.py", ground_conductivity="name", power="name", energy="name")
    ```

=== "Python (grass.tools)"

    *grass.tools.Tools.r_green_gshp_theoretical_py*(**ground_conductivity**,
        **heating_season_raster**=*None*,
        **heating_season_value**=*180.*,
        **power_value**=*nan*,
        **ground_capacity_raster**=*None*,
        **ground_capacity_value**=*2.5*,
        **ground_temp_raster**=*None*,
        **ground_temp_value**=*10.*,
        **borehole_radius**=*0.075*,
        **borehole_resistence**=*nan*,
        **borehole_length**=*100*,
        **pipe_radius**=*0.016*,
        **number_pipes**=*4*,
        **grout_conductivity**=*2*,
        **fluid_limit_temperature**=*-2*,
        **lifetime**=*50*,
        **power**,
        **energy**,
        **length**=*None*,
        **flags**=*None*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    tools = Tools()
    tools.r_green_gshp_theoretical_py(ground_conductivity="name", power="name", energy="name")
    ```

    This grass.tools API is experimental in version 8.5 and expected to be stable in version 8.6.

## Parameters

=== "Command line"

    **ground_conductivity**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Raster with depth-averaged ground thermal conductivity lambda [W m-1 K-1]  
    **heating_season_raster**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Raster with the Heating Season [0-365] days  
    **heating_season_value**=*double*  
    &nbsp;&nbsp;&nbsp;&nbsp;Heating Season [0-365] days  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *0-365*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *180.*  
    **power_value**=*double*  
    &nbsp;&nbsp;&nbsp;&nbsp;Power value in kW  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *nan*  
    **ground_capacity_raster**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Raster with depth-averaged ground thermal capacity rho_c [MJ m-3 K-1]  
    **ground_capacity_value**=*double*  
    &nbsp;&nbsp;&nbsp;&nbsp;Value with depth-averaged ground thermal capacity rho_c [MJ m-3 K-1]  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *2.5*  
    **ground_temp_raster**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Raster with the initial ground temperature T0 [degrees C]  
    **ground_temp_value**=*double*  
    &nbsp;&nbsp;&nbsp;&nbsp;Value with the initial ground temperature T0 [degrees C]  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *10.*  
    **borehole_radius**=*double*  
    &nbsp;&nbsp;&nbsp;&nbsp;Borehole radius [m]  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *0.075*  
    **borehole_resistence**=*double*  
    &nbsp;&nbsp;&nbsp;&nbsp;Borehole thermal resistance [m K W-1]  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *nan*  
    **borehole_length**=*double*  
    &nbsp;&nbsp;&nbsp;&nbsp;Borehole length [m]  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *100*  
    **pipe_radius**=*double*  
    &nbsp;&nbsp;&nbsp;&nbsp;Pipe radius [m]  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *0.016*  
    **number_pipes**=*integer*  
    &nbsp;&nbsp;&nbsp;&nbsp;Number of pipes in the borehole  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *4*  
    **grout_conductivity**=*double*  
    &nbsp;&nbsp;&nbsp;&nbsp;Thermal conductivity of the borehole filling (geothermal grout) [W m-1 K-1]  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *2*  
    **fluid_limit_temperature**=*double*  
    &nbsp;&nbsp;&nbsp;&nbsp;Minimum or maximum fluid temperature [degrees C]  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *-2*  
    **lifetime**=*integer*  
    &nbsp;&nbsp;&nbsp;&nbsp;Simulated lifetime of the plant [years]  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *50*  
    **power**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of output raster map with the geothermal power potential [W]  
    **energy**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of output raster map with the geothermal energy potential [MWh]  
    **length**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of output raster map with the geothermal length of the BHE [m]  
    **-d**  
    &nbsp;&nbsp;&nbsp;&nbsp;Debug with intermediate maps  
    **--overwrite**  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    **--help**  
    &nbsp;&nbsp;&nbsp;&nbsp;Print usage summary  
    **--verbose**  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    **--quiet**  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    **--qq**  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    **--ui**  
    &nbsp;&nbsp;&nbsp;&nbsp;Force launching GUI dialog

=== "Python (grass.script)"

    **ground_conductivity** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Raster with depth-averaged ground thermal conductivity lambda [W m-1 K-1]  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **heating_season_raster** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Raster with the Heating Season [0-365] days  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **heating_season_value** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Heating Season [0-365] days  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *double*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *0-365*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *180.*  
    **power_value** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Power value in kW  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *double*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *nan*  
    **ground_capacity_raster** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Raster with depth-averaged ground thermal capacity rho_c [MJ m-3 K-1]  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **ground_capacity_value** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Value with depth-averaged ground thermal capacity rho_c [MJ m-3 K-1]  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *double*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *2.5*  
    **ground_temp_raster** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Raster with the initial ground temperature T0 [degrees C]  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **ground_temp_value** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Value with the initial ground temperature T0 [degrees C]  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *double*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *10.*  
    **borehole_radius** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Borehole radius [m]  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *double*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *0.075*  
    **borehole_resistence** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Borehole thermal resistance [m K W-1]  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *double*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *nan*  
    **borehole_length** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Borehole length [m]  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *double*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *100*  
    **pipe_radius** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Pipe radius [m]  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *double*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *0.016*  
    **number_pipes** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Number of pipes in the borehole  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *integer*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *4*  
    **grout_conductivity** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Thermal conductivity of the borehole filling (geothermal grout) [W m-1 K-1]  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *double*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *2*  
    **fluid_limit_temperature** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Minimum or maximum fluid temperature [degrees C]  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *double*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *-2*  
    **lifetime** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Simulated lifetime of the plant [years]  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *integer*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *50*  
    **power** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of output raster map with the geothermal power potential [W]  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, raster, *name*  
    **energy** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of output raster map with the geothermal energy potential [MWh]  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, raster, *name*  
    **length** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of output raster map with the geothermal length of the BHE [m]  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, raster, *name*  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *d*  
    &nbsp;&nbsp;&nbsp;&nbsp;**d**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Debug with intermediate maps  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

=== "Python (grass.tools)"

    **ground_conductivity** : str | np.ndarray, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Raster with depth-averaged ground thermal conductivity lambda [W m-1 K-1]  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **heating_season_raster** : str | np.ndarray, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Raster with the Heating Season [0-365] days  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **heating_season_value** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Heating Season [0-365] days  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *double*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *0-365*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *180.*  
    **power_value** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Power value in kW  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *double*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *nan*  
    **ground_capacity_raster** : str | np.ndarray, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Raster with depth-averaged ground thermal capacity rho_c [MJ m-3 K-1]  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **ground_capacity_value** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Value with depth-averaged ground thermal capacity rho_c [MJ m-3 K-1]  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *double*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *2.5*  
    **ground_temp_raster** : str | np.ndarray, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Raster with the initial ground temperature T0 [degrees C]  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **ground_temp_value** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Value with the initial ground temperature T0 [degrees C]  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *double*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *10.*  
    **borehole_radius** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Borehole radius [m]  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *double*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *0.075*  
    **borehole_resistence** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Borehole thermal resistance [m K W-1]  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *double*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *nan*  
    **borehole_length** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Borehole length [m]  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *double*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *100*  
    **pipe_radius** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Pipe radius [m]  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *double*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *0.016*  
    **number_pipes** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Number of pipes in the borehole  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *integer*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *4*  
    **grout_conductivity** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Thermal conductivity of the borehole filling (geothermal grout) [W m-1 K-1]  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *double*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *2*  
    **fluid_limit_temperature** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Minimum or maximum fluid temperature [degrees C]  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *double*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *-2*  
    **lifetime** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Simulated lifetime of the plant [years]  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *integer*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *50*  
    **power** : str | type(np.ndarray) | type(np.array) | type(gs.array.array), *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of output raster map with the geothermal power potential [W]  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, raster, *name*  
    **energy** : str | type(np.ndarray) | type(np.array) | type(gs.array.array), *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of output raster map with the geothermal energy potential [MWh]  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, raster, *name*  
    **length** : str | type(np.ndarray) | type(np.array) | type(gs.array.array), *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of output raster map with the geothermal length of the BHE [m]  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, raster, *name*  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *d*  
    &nbsp;&nbsp;&nbsp;&nbsp;**d**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Debug with intermediate maps  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

    Returns:

    **result** : grass.tools.support.ToolResult | np.ndarray | tuple[np.ndarray] | None  
    If the tool produces text as standard output, a *ToolResult* object will be returned. Otherwise, `None` will be returned. If an array type (e.g., *np.ndarray*) is used for one of the raster outputs, the result will be an array and will have the shape corresponding to the computational region. If an array type is used for more than one raster output, the result will be a tuple of arrays.

    Raises:

    *grass.tools.ToolError*: When the tool ended with an error.

## DESCRIPTION

*r.green.gshp.theoretical* assess the shallow geothermal potential
defined as the thermal power exchanged by a Borehole Heat Exchanger of a
certain depth. This potential depends on the thermal properties of the
ground and the plant features. This module returns two output raster
maps with the the energy potential (MWh/year) and the power potential
(W). In this module the output is the theoretical maximum energy that
can be converted in the ideal case without considering the financial and
spatial constraints.

## NOTES

The required inputs are the the thermal conductivity. If not specific
values are indicated, reference values have been assumed for the ground
features and the plant.  
  
## EXPLANATION

*r.green.gshp.theoretical* calculates the potential of shallow
geothermal energy by means of and empirical relationship proposed by
Casasso et al. (2016) as:

*P<sub>gshp</sub>=8\*(T<sub>0</sub> - T<sub>lim</sub>) λ L
t'<sub>c</sub>/(-0.619 t'<sub>c</sub> log(u'<sub>s</sub>)-0.455
t'<sub>c</sub>-1.619+4 π R<sub>b</sub>)*  

where

T<sub>0</sub> is the undisturbed ground temperature (°C),  
T<sub>lim</sub> the threshold temperature of the heat carrier fluid
setting to 2°C,  
λ is the the thermal conductivity of the ground (W/(mK)),  
L the borehole length (m),  
t'<sub>c</sub> is is the operating time ratio ,  
u'<sub>s</sub> is a parameter depending on the simulaion time and
the borehole radius ,  
R<sub>b</sub> is the thermal resistance (K/W)

## EXAMPLES

This example is based on the case-study of the EUSALP region, located in
Europe and covering part of Italian, Slovenian, Austrian, German, Swiss
and France territories. The data can be downloades at the following
repositories [EUSALP
dataset](https://gitlab.inf.unibz.it/URS/GRETA/eusalp-shallow-geothermal-energy).

```sh
r.green.gshp.theoretical \
    ground_conductivity=conductivity \
    heating_season_raster=season_heating \
    ground_temp_raster=ground_temperature \
    ground_capacity_value=2.3 \
    power=gpot_power \
    energy=gpot_energy \
```

## REFERENCES

Alessandro Casasso, Rajandrea Sethi, 2016,  
"G.POT: A quantitative method for the assessment and mapping of the
shallow geothermal potential"  
Energy 106, p 765 --  
<https://doi.org/10.1016/j.energy.2016.03.091>  

## SEE ALSO

*[r.green.hydro.technical](r.green.md),
[r.green.hydro.technical](r.green.gshp.technical.md)*

## AUTHORS

Pietro Zambelli (Eurac Research, Bolzano, Italy), Tested by and manual
written by Giulia Garegnani

## SOURCE CODE

Available at: [r.green.gshp.theoretical source code](https://github.com/OSGeo/grass-addons/tree/grass8/r.green/r.green.gshp/r.green.gshp.theoretical)
([history](https://github.com/OSGeo/grass-addons/commits/grass8/r.green/r.green.gshp/r.green.gshp.theoretical))  
Latest change: Saturday Oct 18 14:02:41 2025 in commit [5cb968f](https://github.com/OSGeo/grass-addons/commit/5cb968f55a99751846ac9af8070831e07b9710e5)
