---
name: r.green.hydro.discharge.py
description: Calculate average natural discharge and minimum flow following regional law an
keywords: [ raster, hydropower, renewable energy ]
---

# r.green.hydro.discharge.py

Calculate average natural discharge and minimum flow following regional law an

=== "Command line"

    **r.green.hydro.discharge.py**
    [**-dfp**]
    [**q_spec**=*name*]
    **q_river**=*name*
    [**k_b**=*name*]
    [**k_n**=*name*]
    [**rain**=*name*]
    [**k_matrix**=*name*]
    [**m_matrix**=*name*]
    [**a_matrix**=*name*]
    [**mfd**=*name*]
    [**a_river**=*name*]
    **elevation**=*name*
    [**river**=*name*]
    [**lakes**=*name*]
    **streams**=*name*
    [**corr_fact**=*name*]
    [**env_area**=*name*]
    **threshold**=*float*
    [**--overwrite**]
    [**--verbose**]
    [**--quiet**]
    [**--qq**]
    [**--ui**]

    Example:

    ```sh
    r.green.hydro.discharge.py q_river=name elevation=name streams=name threshold=100000
    ```

=== "Python (grass.script)"

    *grass.script.run_command*("***r.green.hydro.discharge.py***",
        **q_spec**=*None*,
        **q_river**,
        **k_b**=*None*,
        **k_n**=*None*,
        **rain**=*None*,
        **k_matrix**=*None*,
        **m_matrix**=*None*,
        **a_matrix**=*None*,
        **mfd**=*None*,
        **a_river**=*None*,
        **elevation**,
        **river**=*None*,
        **lakes**=*None*,
        **streams**,
        **corr_fact**=*None*,
        **env_area**=*None*,
        **threshold**=*100000*,
        **flags**=*None*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    gs.run_command("r.green.hydro.discharge.py", q_river="name", elevation="name", streams="name", threshold=100000)
    ```

=== "Python (grass.tools)"

    *grass.tools.Tools.r_green_hydro_discharge_py*(**q_spec**=*None*,
        **q_river**,
        **k_b**=*None*,
        **k_n**=*None*,
        **rain**=*None*,
        **k_matrix**=*None*,
        **m_matrix**=*None*,
        **a_matrix**=*None*,
        **mfd**=*None*,
        **a_river**=*None*,
        **elevation**,
        **river**=*None*,
        **lakes**=*None*,
        **streams**,
        **corr_fact**=*None*,
        **env_area**=*None*,
        **threshold**=*100000*,
        **flags**=*None*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    tools = Tools()
    tools.r_green_hydro_discharge_py(q_river="name", elevation="name", streams="name", threshold=100000)
    ```

    This grass.tools API is experimental in version 8.5 and expected to be stable in version 8.6.

## Parameters

=== "Command line"

    **q_spec**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of the specific discharge [l/s/km2]  
    **q_river**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of raster map with the discharge along river [m3/s]  
    **k_b**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of raster map with kb parameter  
    **k_n**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of raster map with kn parameter  
    **rain**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of the specific with rain [mm]  
    **k_matrix**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of k area map with k parameter  
    **m_matrix**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of M area map with M parameter  
    **a_matrix**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of A area map with A parameter  
    **mfd**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of raster map with minimum flow along the river [m3/s]  
    **a_river**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of raster map with area of the basin along the river [m2]  
    **elevation**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input elevation raster map  
    **river**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of river network  
    &nbsp;&nbsp;&nbsp;&nbsp;Or data source for direct OGR access  
    **lakes**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of lakes network  
    &nbsp;&nbsp;&nbsp;&nbsp;Or data source for direct OGR access  
    **streams**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of the new stream network  
    **corr_fact**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of corrective factors area map for environmental flow  
    **env_area**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of area with environmental restriction  
    **threshold**=*float* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Minimum size of exterior watershed basin  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *100000*  
    **-d**  
    &nbsp;&nbsp;&nbsp;&nbsp;Debug with intermediate maps  
    **-f**  
    &nbsp;&nbsp;&nbsp;&nbsp;compute the discharge in the river with q_spec=flow map  
    **-p**  
    &nbsp;&nbsp;&nbsp;&nbsp;compute the discharge in the river with q_spec computed as see manual  
    **--overwrite**  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    **--help**  
    &nbsp;&nbsp;&nbsp;&nbsp;Print usage summary  
    **--verbose**  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    **--quiet**  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    **--qq**  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    **--ui**  
    &nbsp;&nbsp;&nbsp;&nbsp;Force launching GUI dialog

=== "Python (grass.script)"

    **q_spec** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of the specific discharge [l/s/km2]  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **q_river** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of raster map with the discharge along river [m3/s]  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, raster, *name*  
    **k_b** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of raster map with kb parameter  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **k_n** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of raster map with kn parameter  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **rain** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of the specific with rain [mm]  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **k_matrix** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of k area map with k parameter  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **m_matrix** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of M area map with M parameter  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **a_matrix** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of A area map with A parameter  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **mfd** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of raster map with minimum flow along the river [m3/s]  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, raster, *name*  
    **a_river** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of raster map with area of the basin along the river [m2]  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, raster, *name*  
    **elevation** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input elevation raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **river** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of river network  
    &nbsp;&nbsp;&nbsp;&nbsp;Or data source for direct OGR access  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, vector, *name*  
    **lakes** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of lakes network  
    &nbsp;&nbsp;&nbsp;&nbsp;Or data source for direct OGR access  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, vector, *name*  
    **streams** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of the new stream network  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, vector, *name*  
    **corr_fact** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of corrective factors area map for environmental flow  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **env_area** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of area with environmental restriction  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **threshold** : float, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Minimum size of exterior watershed basin  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *100000*  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *d*, *f*, *p*  
    &nbsp;&nbsp;&nbsp;&nbsp;**d**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Debug with intermediate maps  
    &nbsp;&nbsp;&nbsp;&nbsp;**f**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;compute the discharge in the river with q_spec=flow map  
    &nbsp;&nbsp;&nbsp;&nbsp;**p**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;compute the discharge in the river with q_spec computed as see manual  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

=== "Python (grass.tools)"

    **q_spec** : str | np.ndarray, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of the specific discharge [l/s/km2]  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **q_river** : str | type(np.ndarray) | type(np.array) | type(gs.array.array), *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of raster map with the discharge along river [m3/s]  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, raster, *name*  
    **k_b** : str | np.ndarray, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of raster map with kb parameter  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **k_n** : str | np.ndarray, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of raster map with kn parameter  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **rain** : str | np.ndarray, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of the specific with rain [mm]  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **k_matrix** : str | np.ndarray, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of k area map with k parameter  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **m_matrix** : str | np.ndarray, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of M area map with M parameter  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **a_matrix** : str | np.ndarray, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of A area map with A parameter  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **mfd** : str | type(np.ndarray) | type(np.array) | type(gs.array.array), *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of raster map with minimum flow along the river [m3/s]  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, raster, *name*  
    **a_river** : str | type(np.ndarray) | type(np.array) | type(gs.array.array), *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of raster map with area of the basin along the river [m2]  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, raster, *name*  
    **elevation** : str | np.ndarray, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input elevation raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **river** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of river network  
    &nbsp;&nbsp;&nbsp;&nbsp;Or data source for direct OGR access  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, vector, *name*  
    **lakes** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of lakes network  
    &nbsp;&nbsp;&nbsp;&nbsp;Or data source for direct OGR access  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, vector, *name*  
    **streams** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of the new stream network  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, vector, *name*  
    **corr_fact** : str | np.ndarray, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of corrective factors area map for environmental flow  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **env_area** : str | np.ndarray, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of area with environmental restriction  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **threshold** : float, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Minimum size of exterior watershed basin  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *100000*  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *d*, *f*, *p*  
    &nbsp;&nbsp;&nbsp;&nbsp;**d**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Debug with intermediate maps  
    &nbsp;&nbsp;&nbsp;&nbsp;**f**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;compute the discharge in the river with q_spec=flow map  
    &nbsp;&nbsp;&nbsp;&nbsp;**p**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;compute the discharge in the river with q_spec computed as see manual  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

    Returns:

    **result** : grass.tools.support.ToolResult | np.ndarray | tuple[np.ndarray] | None  
    If the tool produces text as standard output, a *ToolResult* object will be returned. Otherwise, `None` will be returned. If an array type (e.g., *np.ndarray*) is used for one of the raster outputs, the result will be an array and will have the shape corresponding to the computational region. If an array type is used for more than one raster output, the result will be a tuple of arrays.

    Raises:

    *grass.tools.ToolError*: When the tool ended with an error.

## DESCRIPTION

*r.green.hydro.discharge* calculates the average natural discharge and
the minimum flow discharge according to regional laws.

## NOTES

The natural discharge is the discharge of the streams which doesn't
consider the existing power plants and the other structures exploiting
the water of the river.  
The Minimal Flow Discharge (MFD) is the amount of water which has to
remain in the river to preserve the ecosystems. The legislation differs
in each region. The MFD can be considered as a percentage of the current
discharge, which is the discharge of the river considering the
structures exploiting the water. The current discharge is often
considered as the mean annual discharge.  
  
However, a percentage of the current discharge cannot define precisely
the MFD and each region has a different method to define it. For the
moment, this module only considers the legislation applied on Piave
basin in the Veneto region. New tabs with the legislation of other
regions could be added.  
  
The module computes two raster maps : the natural discharge and the MFD.
On Piave basin, the natural discharge can be computed thanks to the
input raster map with the values of specific discharge, and the MFD is
calculated thanks to this formula :  
  
Q<sub>MFD</sub> = ( K<sub>b</sub> + K<sub>n</sub> ) \* 177 \*
S<sup>0.85</sup> \* Q<sub>spec</sub> \* 10<sup>-6</sup>  

where K<sub>b</sub> is the biological criticality index,  
K<sub>n</sub> is the naturalistic criticality index,  
S is the catchment area, in km<sup>2</sup>,  
Q<sub>spec</sub> is the specific flow-rate per unit area of the
catchment, in l/(s.km<sup>2</sup>)  

K<sub>b</sub> is typically within the range of 1-1.6; higher values are
chosen for a river whose aquatic ecosystem is considered to be of a
particular environmental value.  
K<sub>n</sub> is typically within the range of 0-0.6; higher values of
such index are used for basins having a particular naturalistic value,
for instance national parks.  
The values of K<sub>b</sub> and K<sub>n</sub> are imposed by the Piave
River Catchment Authority (PRCA). They have different values depending
on homogeneous segments which can be found in a table made by the PRCA.
Also the values of Q<sub>spec</sub> depend on the area and are available
in such a table.  
  
Thanks to three raster maps respectively with the values of
K<sub>b</sub>, K<sub>n</sub> and Q<sub>spec</sub>, and also the
elevation raster map and the streams vector map, the module creates the
two raster maps with the values of MFD and average natural discharge.

## EXAMPLE

This example is based on the case-study of Mis valley in Belluno
province, Veneto, Italy.  
  
Here is the map of the Mis valley with colored areas to define the
K<sub>n</sub>, K<sub>b</sub> and Q<sub>spec</sub> values.

![image-alt](r.green.hydro.discharge_input.png)  
Picture which gathers the input raster maps with K<sub>n</sub>,
K<sub>b</sub> and Q<sub>spec</sub> values

According to the legislation for the Piave basin explained above, the
legal values for the Mis valley are :  
K<sub>n</sub> = 0.4 in the whole region (yellow and red zones)  
K<sub>b</sub> = 1.4 in the yellow zone and 1.6 in the red zone  
Q<sub>spec</sub> = 44 l/(s.km<sup>2</sup>) in the yellow zone and 43
l/(s.km<sup>2</sup>) elsewhere (red and white zones)  
  
These values are put in three different raster maps : q\_spec, k\_b and
k\_n.  
Here is the code used to create the raster maps with the MFD and the
natural discharge. The basins are considered with a threshold of 10000
m.  
  
```sh
r.green.hydro.discharge q_spec=q_spec output_q_river=discharge k_b=k_b k_n=k_n output_mfd=mfd elevation=elevation output_streams=streams threshold=100000
```

The following picture gathers the two output raster maps mfd and
discharge which look like each other (yellow background with colored
points following the river and containing the values of discharge). For
a better understanding, the following picture also shows the border of
the Mis valley and the streams.  
  
![image-alt](r.green.hydro.discharge_output.png)  
Picture which gathers the output raster maps with valued of MFD and
natural discharge, also showing the vector maps with the borders and
streams of Mis valley

The white point is queried in GRASS to know the values of MFD and
natural discharge. The following picture shows these values in
m<sup>3</sup>/s.  
  
![image-alt](r.green.hydro.discharge_output_table.png)  
Values of MFD and natural discharge (in m<sup>3</sup>/s) at the white
point

## SEE ALSO

*[r.green.hydro.delplants](r.green.hydro.delplants.md)  
[r.green.hydro.theoretical](r.green.hydro.theoretical.md)  
[r.green.hydro.optimal](r.green.hydro.optimal.md)  
[r.green.hydro.recommended](r.green.hydro.recommended.md)  
[r.green.hydro.structure](r.green.hydro.structure.md)  
[r.green.hydro.technical](r.green.hydro.technical.md)  
[r.green.hydro.financial](r.green.hydro.financial.md)*

## REFERENCE

*Allegato alla delibera n. 4/2004 del Comitato Istituzionale del 3 marzo
2004  
Piano stralcio per la gestione delle risorse idriche del bacino del
Piave - Misure di Salvaguardia*  
from Autorità di bacino dei fiumi Isonzo, Tagliamento, Livenza, Piave,
Brenta-Bacchiglione

## AUTHORS

Giulia Garegnani (Eurac Research, Bolzano, Italy), Sara Biscaini
(University of Trento, Italy), manual written by Julie Gros.

## SOURCE CODE

Available at: [r.green.hydro.discharge source code](https://github.com/OSGeo/grass-addons/tree/grass8/r.green/r.green.hydro/r.green.hydro.discharge)
([history](https://github.com/OSGeo/grass-addons/commits/grass8/r.green/r.green.hydro/r.green.hydro.discharge))  
Latest change: Friday Feb 21 12:27:42 2025 in commit [8fce680](https://github.com/OSGeo/grass-addons/commit/8fce680a2170ee81eff27fdf4315079b10a10f83)
