---
name: r.in.ahn.py
description: Imports dtm, dsm, chm or laz from the AHN (Actueel Hoogtebestand Nederland (AHN), versions 2–6.
keywords: [ dem, raster, import ]
---

# r.in.ahn.py

Imports dtm, dsm, chm or laz from the AHN (Actueel Hoogtebestand Nederland (AHN), versions 2–6.

=== "Command line"

    **r.in.ahn.py**
    [**-g**]
    **product**=*string*
    **version**=*string*
    **resolution**=*float*
    [**output**=*name*]
    [**directory**=*name*]
    [**laz_files**=*name*]
    [**memory**=*memory in MB*]
    [**nprocs**=*integer*]
    [**max_inputs**=*integer*]
    [**--overwrite**]
    [**--verbose**]
    [**--quiet**]
    [**--qq**]
    [**--ui**]

    Example:

    ```sh
    r.in.ahn.py product=dtm version=4 resolution=0.5
    ```

=== "Python (grass.script)"

    *grass.script.run_command*("***r.in.ahn.py***",
        **product**,
        **version**=*"4"*,
        **resolution**=*0.5*,
        **output**=*None*,
        **directory**=*None*,
        **laz_files**=*None*,
        **memory**=*300*,
        **nprocs**=*0*,
        **max_inputs**=*250*,
        **flags**=*None*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    gs.run_command("r.in.ahn.py", product="dtm", version="4", resolution=0.5)
    ```

=== "Python (grass.tools)"

    *grass.tools.Tools.r_in_ahn_py*(**product**,
        **version**=*"4"*,
        **resolution**=*0.5*,
        **output**=*None*,
        **directory**=*None*,
        **laz_files**=*None*,
        **memory**=*300*,
        **nprocs**=*0*,
        **max_inputs**=*250*,
        **flags**=*None*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    tools = Tools()
    tools.r_in_ahn_py(product="dtm", version="4", resolution=0.5)
    ```

    This grass.tools API is experimental in version 8.5 and expected to be stable in version 8.6.

## Parameters

=== "Command line"

    **product**=*string* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Product  
    &nbsp;&nbsp;&nbsp;&nbsp;Choose which product to download (dtm, dsm or chm)  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *dtm, dsm, chm, laz*  
    **version**=*string* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;AHN version  
    &nbsp;&nbsp;&nbsp;&nbsp;AHN version to download  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *2, 3, 4, 5, 6*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *4*  
    **resolution**=*float* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Resolution  
    &nbsp;&nbsp;&nbsp;&nbsp;Resolution in meters (0.5 or 5)  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *0.5, 5*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *0.5*  
    **output**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output raster map  
    **directory**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Output directory for LAZ data  
    &nbsp;&nbsp;&nbsp;&nbsp;Output directory to which the LAZ data is downloaded (default = working directory)  
    **laz_files**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;CSV file with list of downloaded LAZ files  
    &nbsp;&nbsp;&nbsp;&nbsp;Save the path + names of the downloaded LAZ files to a file  
    **memory**=*memory in MB*  
    &nbsp;&nbsp;&nbsp;&nbsp;Maximum memory to be used (in MB)  
    &nbsp;&nbsp;&nbsp;&nbsp;Cache size for raster rows  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *300*  
    **nprocs**=*integer*  
    &nbsp;&nbsp;&nbsp;&nbsp;Number of threads for parallel computing  
    &nbsp;&nbsp;&nbsp;&nbsp;0: use OpenMP default; &gt;0: use nprocs; &lt;0: use MAX-nprocs  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *0*  
    **max_inputs**=*integer*  
    &nbsp;&nbsp;&nbsp;&nbsp;Maximum number of rasters passed to a single r.patch call  
    &nbsp;&nbsp;&nbsp;&nbsp;Larger values reduce number of intermediate batches but may exceed OS command length limits  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *250*  
    **-g**  
    &nbsp;&nbsp;&nbsp;&nbsp;Set to original computational region  
    &nbsp;&nbsp;&nbsp;&nbsp;After downloading and importing, set the region back to the original computation region.  
    **--overwrite**  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    **--help**  
    &nbsp;&nbsp;&nbsp;&nbsp;Print usage summary  
    **--verbose**  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    **--quiet**  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    **--qq**  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    **--ui**  
    &nbsp;&nbsp;&nbsp;&nbsp;Force launching GUI dialog

=== "Python (grass.script)"

    **product** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Product  
    &nbsp;&nbsp;&nbsp;&nbsp;Choose which product to download (dtm, dsm or chm)  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *dtm, dsm, chm, laz*  
    **version** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;AHN version  
    &nbsp;&nbsp;&nbsp;&nbsp;AHN version to download  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *2, 3, 4, 5, 6*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *4*  
    **resolution** : float, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Resolution  
    &nbsp;&nbsp;&nbsp;&nbsp;Resolution in meters (0.5 or 5)  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *0.5, 5*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *0.5*  
    **output** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, raster, *name*  
    **directory** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Output directory for LAZ data  
    &nbsp;&nbsp;&nbsp;&nbsp;Output directory to which the LAZ data is downloaded (default = working directory)  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, dir, *name*  
    **laz_files** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;CSV file with list of downloaded LAZ files  
    &nbsp;&nbsp;&nbsp;&nbsp;Save the path + names of the downloaded LAZ files to a file  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, file, *name*  
    **memory** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Maximum memory to be used (in MB)  
    &nbsp;&nbsp;&nbsp;&nbsp;Cache size for raster rows  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *memory in MB*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *300*  
    **nprocs** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Number of threads for parallel computing  
    &nbsp;&nbsp;&nbsp;&nbsp;0: use OpenMP default; &gt;0: use nprocs; &lt;0: use MAX-nprocs  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *0*  
    **max_inputs** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Maximum number of rasters passed to a single r.patch call  
    &nbsp;&nbsp;&nbsp;&nbsp;Larger values reduce number of intermediate batches but may exceed OS command length limits  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *250*  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *g*  
    &nbsp;&nbsp;&nbsp;&nbsp;**g**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Set to original computational region  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;After downloading and importing, set the region back to the original computation region.  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

=== "Python (grass.tools)"

    **product** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Product  
    &nbsp;&nbsp;&nbsp;&nbsp;Choose which product to download (dtm, dsm or chm)  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *dtm, dsm, chm, laz*  
    **version** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;AHN version  
    &nbsp;&nbsp;&nbsp;&nbsp;AHN version to download  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *2, 3, 4, 5, 6*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *4*  
    **resolution** : float, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Resolution  
    &nbsp;&nbsp;&nbsp;&nbsp;Resolution in meters (0.5 or 5)  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *0.5, 5*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *0.5*  
    **output** : str | type(np.ndarray) | type(np.array) | type(gs.array.array), *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, raster, *name*  
    **directory** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Output directory for LAZ data  
    &nbsp;&nbsp;&nbsp;&nbsp;Output directory to which the LAZ data is downloaded (default = working directory)  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, dir, *name*  
    **laz_files** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;CSV file with list of downloaded LAZ files  
    &nbsp;&nbsp;&nbsp;&nbsp;Save the path + names of the downloaded LAZ files to a file  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, file, *name*  
    **memory** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Maximum memory to be used (in MB)  
    &nbsp;&nbsp;&nbsp;&nbsp;Cache size for raster rows  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *memory in MB*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *300*  
    **nprocs** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Number of threads for parallel computing  
    &nbsp;&nbsp;&nbsp;&nbsp;0: use OpenMP default; &gt;0: use nprocs; &lt;0: use MAX-nprocs  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *0*  
    **max_inputs** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Maximum number of rasters passed to a single r.patch call  
    &nbsp;&nbsp;&nbsp;&nbsp;Larger values reduce number of intermediate batches but may exceed OS command length limits  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *250*  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *g*  
    &nbsp;&nbsp;&nbsp;&nbsp;**g**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Set to original computational region  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;After downloading and importing, set the region back to the original computation region.  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

    Returns:

    **result** : grass.tools.support.ToolResult | np.ndarray | tuple[np.ndarray] | None  
    If the tool produces text as standard output, a *ToolResult* object will be returned. Otherwise, `None` will be returned. If an array type (e.g., *np.ndarray*) is used for one of the raster outputs, the result will be an array and will have the shape corresponding to the computational region. If an array type is used for more than one raster output, the result will be a tuple of arrays.

    Raises:

    *grass.tools.ToolError*: When the tool ended with an error.

## DESCRIPTION

*r.in.ahn* imports elevation data from the Actueel Hoogtebestand Nederland (AHN).
AHN is the national digital elevation model of the Netherlands and provides
both a digital terrain model (DTM) and a digital surface model (DSM) at
resolutions of 0.5 m and 5 m. In addition, the original LAZ point data is
available for download. The dataset is available in multiple versions
(AHN2 through AHN6), each corresponding to a different acquisition period and
processing specification. An overview of these versions is provided on the
[AHN](https://www.ahn.nl) website.

The user specifies the AHN version, the product (*dtm*, *dsm*, *chm*), and the
desired resolution. When chm is selected, the module first downloads and
imports both the DTM and DSM and then computes the canopy height model (CHM) as
the difference between DSM and DTM. In this case, all three layers are retained
and written to the mapset using the user-defined output name with the suffixes
*_dtm*, *_dsm*, and *_chm*.

The module determines which 1 × 1 km tiles intersect the current computational
region, downloads the required tiles, imports them into the GRASS mapset and
combines them in one layer. During this process, the computational region is
(temporarily) adjusted so that the imported raster aligns with the native AHN
grid and uses the selected resolution. The resulting raster always covers the
original region (or the portion overlapping the AHN extent). When the **-g** flag
is used, the original computational region is restored after the import is
completed.

In addition to the three raster products, users may also download the LiDAR
point cloud tiles by selecting the laz product option. This retrieves the 1 × 1
km LAZ files and stores them in a user-specified directory; if no directory is
provided, the files are saved in the current working directory. Optionally, the
module can write the file paths and filenames of the downloaded tiles to a CSV
file for later reference. Unlike the raster products, LAZ tiles are not
imported into GRASS automatically. Users may import the point data afterwards
using standard GRASS tools such as *v.in.pdal* for vector point clouds or
*r.in.pdal* for generating raster products directly from the LAZ files.

## NOTE

This module can only be used in a location based on the Amersfoort / RD New
coordinate reference system (EPSG:28992). Running it in a location with a
different CRS will result in an error.

The computational region is modified during import to ensure that the resulting
raster aligns with the AHN grid and matches the chosen resolution (0.5 m or 5
m). If the **-g** flag is provided, the region is reset to its original extent
after the import.

All AHN versions are provided as 1 × 1 km tiles. Earlier datasets (AHN2–AHN5),
originally published as larger map sheets (5 × 6.25 km), have been reprocessed
as 1 × 1 km tiles following the AHN6 specification. In the 0.5 m DTM, cell
values represent an unweighted average of ground-level points; in the 0.5 m
DSM, cell values represent the highest point. The earlier versions retain the
original differences related to high-voltage structures: AHN4 DSM excludes
high-voltage power lines but includes pylons, while AHN2 and AHN3 DSM include
both lines and pylons. See the documentation on the [AHN
dataroom](https://www.ahn.nl/dataroom)

The module downloads tiles directly from the AHN object-storage service. The
earlier WCS-based download method and the option to retrieve complete map
sheets are no longer supported.

If a MASK is present, it is preserved, although, consistent with GRASS
behavior, it does not alter the imported DTM or DSM. However, when computing
the CHM, the MASK is applied to the DSM–DTM calculation, and the resulting CHM
will contain NULL values outside the MASKed area.

Versions 5 and 6 do not cover the whole of the Netherlands yet. Check the
[AHN website](https://www.ahn.nl/) for information about which parts are covered.

## EXAMPLES

### Example 1

Import the DTM for Fort Crèvecoeur, an fortress where the river *Old
Dieze* flows into the *Maas* river.

```sh
# Set the region for Fort Crèvecoeur
g.region n=416562 s=415957 w=145900 e=147003 res=0.5

# Download the DSM
r.in.ahn product=dtm output=dtm_crevecoeur resolution=0.5 version=4
```

![image-alt](r.in.ahn example)](r_in_ahn_01.png)
*Figure: DTM map of Fort Crèvecoeur*

### Example 2

Import the DSM version 5 with a resolution of 5 meter. Set the **-g** flag to
keep the current computation region after importing the requested data. Note,
the imported data will still have the resolution of, and will be aligned to,
the original AHN data.

```sh
# Download the DSM
r.in.ahn -g product=dsm output=dsm_crevecoeur resolution=5 version=5
```

[![image-alt](r.in.ahn example)](r_in_ahn_02.png)
*Figure: DSM map of Fort Crèvecoeur*

### Example 3

Import the CHM based on version 4 of DTM and DSM with a resolution of 0.5 meter.

```sh
r.in.ahn product=chm output=chm_crevecoeur resolution=0.5 version=4
```

[![image-alt](r.in.ahn example)](r_in_ahn_03.png)
*Figure: CHM map of Fort Crèvecoeur*

## REFERENCES

See the [AHN](https://www.ahn.nl) webpage for more information about the AHN
data (in Dutch).

## SEE ALSO

*[r.in.srtm](https://grass.osgeo.org/grass-stable/manuals/r.in.srtm.html),
[r.in.nasadem](https://grass.osgeo.org/grass-stable/manuals/r.in.nasadem.html),
[r.in.pdal](https://grass.osgeo.org/grass-stable/manuals/r.in.pdal.html),
[v.in.pdal](https://grass.osgeo.org/grass-stable/manuals/v.in.pdal.html)*

## AUTHOR

Paulo van Breugel | [HAS green academy](https://has.nl), University of
Applied Sciences | [Climate-robust Landscapes research
group](https://www.has.nl/en/research/professorships/climate-robust-landscapes-professorship/)
| [Innovative Bio-Monitoring research
group](https://www.has.nl/en/research/professorships/innovative-bio-monitoring-professorship/)
| Contact: [Ecodiv.earth](https://ecodiv.earth)

## SOURCE CODE

Available at: [r.in.ahn source code](https://github.com/OSGeo/grass-addons/tree/grass8/src/raster/r.in.ahn)
([history](https://github.com/OSGeo/grass-addons/commits/grass8/src/raster/r.in.ahn))  
Latest change: Tuesday Dec 09 16:59:20 2025 in commit [4a42015](https://github.com/OSGeo/grass-addons/commit/4a42015b818dff133263746949c4d3268ebd428d)
