---
name: r.mcda.promethee
description: Multicirtieria decision analysis based on PROMETHEE method
keywords: [ raster, MCDA ]
---

# r.mcda.promethee

Multicirtieria decision analysis based on PROMETHEE method

=== "Command line"

    **r.mcda.promethee**
    **criteria**=*string* [,*string*,...]
    **weight**=*float* [,*float*,...]
    **positiveflow**=*string*
    **negativeflow**=*string*
    [**--overwrite**]
    [**--verbose**]
    [**--quiet**]
    [**--qq**]
    [**--ui**]

    Example:

    ```sh
    r.mcda.promethee criteria=string weight=0.0 positiveflow=positiveflow negativeflow=negativeflow
    ```

=== "Python (grass.script)"

    *grass.script.run_command*("***r.mcda.promethee***",
        **criteria**,
        **weight**,
        **positiveflow**=*"positiveflow"*,
        **negativeflow**=*"negativeflow"*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    gs.run_command("r.mcda.promethee", criteria="string", weight=0.0, positiveflow="positiveflow", negativeflow="negativeflow")
    ```

=== "Python (grass.tools)"

    *grass.tools.Tools.r_mcda_promethee*(**criteria**,
        **weight**,
        **positiveflow**=*"positiveflow"*,
        **negativeflow**=*"negativeflow"*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    tools = Tools()
    tools.r_mcda_promethee(criteria="string", weight=0.0, positiveflow="positiveflow", negativeflow="negativeflow")
    ```

    This grass.tools API is experimental in version 8.5 and expected to be stable in version 8.6.

## Parameters

=== "Command line"

    **criteria**=*string* [,*string*,...] **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Input geographics criteria in information system  
    **weight**=*float* [,*float*,...] **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Criteria weight(s) (w1,w2,..,wn)  
    **positiveflow**=*string* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;positive flow output map  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *positiveflow*  
    **negativeflow**=*string* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;negative flow output map  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *negativeflow*  
    **--overwrite**  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    **--help**  
    &nbsp;&nbsp;&nbsp;&nbsp;Print usage summary  
    **--verbose**  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    **--quiet**  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    **--qq**  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    **--ui**  
    &nbsp;&nbsp;&nbsp;&nbsp;Force launching GUI dialog

=== "Python (grass.script)"

    **criteria** : str | list[str], *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Input geographics criteria in information system  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster  
    **weight** : float | list[float] | str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Criteria weight(s) (w1,w2,..,wn)  
    **positiveflow** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;positive flow output map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, raster  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *positiveflow*  
    **negativeflow** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;negative flow output map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, raster  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *negativeflow*  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

=== "Python (grass.tools)"

    **criteria** : str | list[str], *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Input geographics criteria in information system  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster  
    **weight** : float | list[float] | str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Criteria weight(s) (w1,w2,..,wn)  
    **positiveflow** : str | type(np.ndarray) | type(np.array) | type(gs.array.array), *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;positive flow output map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, raster  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *positiveflow*  
    **negativeflow** : str | type(np.ndarray) | type(np.array) | type(gs.array.array), *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;negative flow output map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, raster  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *negativeflow*  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

    Returns:

    **result** : grass.tools.support.ToolResult | np.ndarray | tuple[np.ndarray] | None  
    If the tool produces text as standard output, a *ToolResult* object will be returned. Otherwise, `None` will be returned. If an array type (e.g., *np.ndarray*) is used for one of the raster outputs, the result will be an array and will have the shape corresponding to the computational region. If an array type is used for more than one raster output, the result will be a tuple of arrays.

    Raises:

    *grass.tools.ToolError*: When the tool ended with an error.

## DESCRIPTION

*r.mcda.promethee* is the implementation of the a multicriteria decision
analysis based on PROMETHEE algorithm (J.P. Brans and P. Vincke (1985).
"A preference ranking organisation method:The PROMETHEE method for
MCDM". Management Science) in GRASS GIS environment. It is one of the
available tools in the r.mcda suite. It requires as an input the list of
raster representing the criteria to be assessed in the multicriteria
evaluation and the vector of weights to be assigned. Every single cell
of the GRASS region is considered as one of the possible alternatives to
evaluate and it is described with the value assumed for the same cell by
the raster used as criteria. There are three output files. One
represents the spatial distribution of the concordance index, the other
one of the discordance index. The optimal solution is the one presenting
the maximum concordance value and the minimum discordance value at the
same time.

## NOTES

The module does not standardize the raster-criteria. Therefore, they
must be prepared before by using, for example, r.mapcalc. The weights
vector is always normalized so that the sum of the weights is 1.

## CITE AS

Massei, G., Rocchi, L., Paolotti, L., Greco, S., & Boggia, Decision
Support Systems for environmental management: A case study on wastewater
from agriculture, Journal of Environmental Management, Volume 146, 15
December 2014, Pages 491-504, ISSN 0301-4797

## REFERENCE

J.P. Brans and P. Vincke (1985). "A preference ranking organisation
method:The PROMETHEE method for MCDM". Management Science.

GRASS Development Team (2015)

## SEE ALSO

[*r.mcda.ahp*](r.mcda.ahp.html),
[*r.mcda.electre*](r.mcda.electre.html),
[*r.mcda.roughet*](r.mcda.roughet.html),
[*r.mapcalc*](https://grass.osgeo.org/grass-stable/manuals/r.mapcalc.html)

## AUTHORS

Antonio Boggia - Gianluca Massei  
Department of Economics and Appraisal - University of Perugia - Italy

## SOURCE CODE

Available at: [r.mcda.promethee source code](https://github.com/OSGeo/grass-addons/tree/grass8/src/raster/r.mcda.promethee)
([history](https://github.com/OSGeo/grass-addons/commits/grass8/src/raster/r.mcda.promethee))  
Latest change: Thursday Feb 20 20:36:19 2025 in commit [158e314](https://github.com/OSGeo/grass-addons/commit/158e314c788f983e3a448ec1b1ba3f226b5ca3e9)
