---
name: r.mcda.topsis.py
description: Generates a MCDA map based on TOPSIS algorthm.
keywords: [ raster, Multi Criteria Decision Analysis (MCDA) ]
---

# r.mcda.topsis.py

Generates a MCDA map based on TOPSIS algorthm.

=== "Command line"

    **r.mcda.topsis.py**
    **criteria**=*name* [,*name*,...]
    **preferences**=*character*
    **weights**=*float* [,*float*,...]
    **topsismap**=*string*
    [**--verbose**]
    [**--quiet**]
    [**--qq**]
    [**--ui**]

    Example:

    ```sh
    r.mcda.topsis.py criteria=name preferences=character weights=0.0 topsismap=string
    ```

=== "Python (grass.script)"

    *grass.script.run_command*("***r.mcda.topsis.py***",
        **criteria**,
        **preferences**,
        **weights**,
        **topsismap**,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    gs.run_command("r.mcda.topsis.py", criteria="name", preferences="character", weights=0.0, topsismap="string")
    ```

=== "Python (grass.tools)"

    *grass.tools.Tools.r_mcda_topsis_py*(**criteria**,
        **preferences**,
        **weights**,
        **topsismap**,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    tools = Tools()
    tools.r_mcda_topsis_py(criteria="name", preferences="character", weights=0.0, topsismap="string")
    ```

    This grass.tools API is experimental in version 8.5 and expected to be stable in version 8.6.

## Parameters

=== "Command line"

    **criteria**=*name* [,*name*,...] **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of criteria raster maps  
    **preferences**=*character* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;preference (gain,cost)  
    **weights**=*float* [,*float*,...] **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;weights (w1,w2,...,wn)  
    **topsismap**=*string* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Ranked raster map  
    **--help**  
    &nbsp;&nbsp;&nbsp;&nbsp;Print usage summary  
    **--verbose**  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    **--quiet**  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    **--qq**  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    **--ui**  
    &nbsp;&nbsp;&nbsp;&nbsp;Force launching GUI dialog

=== "Python (grass.script)"

    **criteria** : str | list[str], *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of criteria raster maps  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **preferences** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;preference (gain,cost)  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *character*  
    **weights** : float | list[float] | str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;weights (w1,w2,...,wn)  
    **topsismap** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Ranked raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

=== "Python (grass.tools)"

    **criteria** : str | list[str], *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of criteria raster maps  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **preferences** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;preference (gain,cost)  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *character*  
    **weights** : float | list[float] | str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;weights (w1,w2,...,wn)  
    **topsismap** : str | type(np.ndarray) | type(np.array) | type(gs.array.array), *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Ranked raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

    Returns:

    **result** : grass.tools.support.ToolResult | np.ndarray | tuple[np.ndarray] | None  
    If the tool produces text as standard output, a *ToolResult* object will be returned. Otherwise, `None` will be returned. If an array type (e.g., *np.ndarray*) is used for one of the raster outputs, the result will be an array and will have the shape corresponding to the computational region. If an array type is used for more than one raster output, the result will be a tuple of arrays.

    Raises:

    *grass.tools.ToolError*: When the tool ended with an error.

## DESCRIPTION

*r.mcda.topsis* implements the ideal point algorithms based on TOPSIS
model and returns a raster map shown the ranking geospatial
alternatives. The user has to provide the weight values and preference
(gain or cost) directly

## NOTES

For bug please contact Gianluca Massei (g\_mass@libero.it)

## REFERENCE

1. Hwang C. L. and Yoon K. Multiple Objective Decision Making Methods
    and Applications, A State-of-the-Art Survey.Springer - Verlag ,
    1981.

## SEE ALSO

*[r.mcda.input](r.mcda.input.md), [r.mcda.electre](r.mcda.electre.md), [r.mcda.roughset](r.mcda.roughset.md), [r.mcda.output](r.mcda.output.md)*

## AUTHORS

Antonio Boggia - Gianluca Massei  
Department of Economics and Appraisal - University of Perugia - Italy

## SOURCE CODE

Available at: [r.mcda.topsis source code](https://github.com/OSGeo/grass-addons/tree/grass8/src/raster/r.mcda.topsis)
([history](https://github.com/OSGeo/grass-addons/commits/grass8/src/raster/r.mcda.topsis))  
Latest change: Thursday Feb 20 20:36:19 2025 in commit [158e314](https://github.com/OSGeo/grass-addons/commit/158e314c788f983e3a448ec1b1ba3f226b5ca3e9)
