---
name: r.northerness.easterness.py
description: Calculation of northerness, easterness and the interaction between northerness and slope
keywords: [ raster, terrain, aspect, slope, sun ]
---

# r.northerness.easterness.py

Calculation of northerness, easterness and the interaction between northerness and slope

=== "Command line"

    **r.northerness.easterness.py**
    **elevation**=*name*
    [**--verbose**]
    [**--quiet**]
    [**--qq**]
    [**--ui**]

    Example:

    ```sh
    r.northerness.easterness.py elevation=name
    ```

=== "Python (grass.script)"

    *grass.script.run_command*("***r.northerness.easterness.py***",
        **elevation**,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    gs.run_command("r.northerness.easterness.py", elevation="name")
    ```

=== "Python (grass.tools)"

    *grass.tools.Tools.r_northerness_easterness_py*(**elevation**,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    tools = Tools()
    tools.r_northerness_easterness_py(elevation="name")
    ```

    This grass.tools API is experimental in version 8.5 and expected to be stable in version 8.6.

## Parameters

=== "Command line"

    **elevation**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of elevation raster map  
    **--help**  
    &nbsp;&nbsp;&nbsp;&nbsp;Print usage summary  
    **--verbose**  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    **--quiet**  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    **--qq**  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    **--ui**  
    &nbsp;&nbsp;&nbsp;&nbsp;Force launching GUI dialog

=== "Python (grass.script)"

    **elevation** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of elevation raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

=== "Python (grass.tools)"

    **elevation** : str | np.ndarray, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of elevation raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

    Returns:

    **result** : grass.tools.support.ToolResult | None  
    If the tool produces text as standard output, a *ToolResult* object will be returned. Otherwise, `None` will be returned.

    Raises:

    *grass.tools.ToolError*: When the tool ended with an error.

## DESCRIPTION

*r.northerness.easterness* calculates northerness, easterness and the
interaction between northerness and slope (northerness\*slope). The user
must specify the input **elevation raster** map.

## NOTES

As aspect is a circular land-surface parameter, in ecology a sine or
cosine transformation is often used to obtain a continuous gradient,
stressing the north-south or east-west gradient (northness or eastness).

The GRASS GIS default aspect angles (cartesian) are converted to compass
angles.

Calculated raster maps are:

- northerness: *cos(aspect)*
- easterness: *sin(aspect)*
- interaction between northerness and slope: *northerness\*slope*

The color of these raster maps are set to *grey*.

## EXAMPLE

```sh
  # align region to DEM and habitat vector
  g.region -a raster=DEM align=DEM

  # run r.northerness.easterness
  r.northerness.easterness elevation=DEM
 
```

## REFERENCES

Olaya, V. 2009. Basic Land-Surface Parameters. In: Hengl, T. & Reuter,
H.I. (eds.) 2009. Geomorphometry. Concepts, Software, Applications.
Developments in Soil Science, Volume 33. Elsevier.

## SEE ALSO

*[r.mapcalc](https://grass.osgeo.org/grass-stable/manuals/r.mapcalc.html),
[r.slope.aspect](https://grass.osgeo.org/grass-stable/manuals/r.slope.aspect.html)*

## AUTHOR

Helmut Kudrnovsky

## SOURCE CODE

Available at: [r.northerness.easterness source code](https://github.com/OSGeo/grass-addons/tree/grass8/src/raster/r.northerness.easterness)
([history](https://github.com/OSGeo/grass-addons/commits/grass8/src/raster/r.northerness.easterness))  
Latest change: Friday Feb 21 10:10:05 2025 in commit [7d78fe3](https://github.com/OSGeo/grass-addons/commit/7d78fe34868674c3b6050ba1924e1c5675d155c9)
