---
name: r.pi.energy.pr
description: Individual-based dispersal model for connectivity analysis (energy based) using iterative patch removal.
keywords: [ raster, landscape structure analysis, connectivity analysis ]
---

# r.pi.energy.pr

Individual-based dispersal model for connectivity analysis (energy based) using iterative patch removal.

=== "Command line"

    **r.pi.energy.pr**
    [**-abrp**]
    **input**=*name*
    [**costmap**=*string*]
    [**suitability**=*string*]
    **output**=*name*
    **keyval**=*integer*
    **step_length**=*integer*
    [**perception**=*integer*]
    [**multiplicator**=*float*]
    **n**=*integer*
    **energy**=*float*
    **percent**=*float*
    **stats**=*string* [,*string*,...]
    [**out_freq**=*integer*]
    [**seed**=*integer*]
    [**title**=*"phrase"*]
    [**--overwrite**]
    [**--verbose**]
    [**--quiet**]
    [**--qq**]
    [**--ui**]

    Example:

    ```sh
    r.pi.energy.pr input=name output=name keyval=0 step_length=0 n=0 energy=0.0 percent=0.0 stats=average
    ```

=== "Python (grass.script)"

    *grass.script.run_command*("***r.pi.energy.pr***",
        **input**,
        **costmap**=*None*,
        **suitability**=*None*,
        **output**,
        **keyval**,
        **step_length**,
        **perception**=*None*,
        **multiplicator**=*None*,
        **n**,
        **energy**,
        **percent**,
        **stats**,
        **out_freq**=*None*,
        **seed**=*None*,
        **title**=*None*,
        **flags**=*None*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    gs.run_command("r.pi.energy.pr", input="name", output="name", keyval=0, step_length=0, n=0, energy=0.0, percent=0.0, stats="average")
    ```

=== "Python (grass.tools)"

    *grass.tools.Tools.r_pi_energy_pr*(**input**,
        **costmap**=*None*,
        **suitability**=*None*,
        **output**,
        **keyval**,
        **step_length**,
        **perception**=*None*,
        **multiplicator**=*None*,
        **n**,
        **energy**,
        **percent**,
        **stats**,
        **out_freq**=*None*,
        **seed**=*None*,
        **title**=*None*,
        **flags**=*None*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    tools = Tools()
    tools.r_pi_energy_pr(input="name", output="name", keyval=0, step_length=0, n=0, energy=0.0, percent=0.0, stats="average")
    ```

    This grass.tools API is experimental in version 8.5 and expected to be stable in version 8.6.

## Parameters

=== "Command line"

    **input**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input raster map  
    **costmap**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of the costmap  
    **suitability**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of the suitability raster with values from 0-100  
    **output**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output raster map  
    **keyval**=*integer* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Category value of the patches  
    **step_length**=*integer* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Length of a single step measured in pixels  
    **perception**=*integer*  
    &nbsp;&nbsp;&nbsp;&nbsp;Perception range  
    **multiplicator**=*float*  
    &nbsp;&nbsp;&nbsp;&nbsp;Attractivity of patches [1-inf]  
    **n**=*integer* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Number of individuals  
    **energy**=*float* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Initial energy of the individuals  
    **percent**=*float* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Percentage of finished individuals desired before simulation ends  
    **stats**=*string* [,*string*,...] **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Statistical method to perform on the pathlengths of the individuals  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *average, variance, standard deviation, median, min, max*  
    **out_freq**=*integer*  
    &nbsp;&nbsp;&nbsp;&nbsp;Output an intermediate state of simulation each [out_freq] steps  
    **seed**=*integer*  
    &nbsp;&nbsp;&nbsp;&nbsp;Seed for random number generator  
    **title**=*"phrase"*  
    &nbsp;&nbsp;&nbsp;&nbsp;Title for resultant raster map  
    **-a**  
    &nbsp;&nbsp;&nbsp;&nbsp;Set for 8 cell-neighbors. 4 cell-neighbors are default  
    **-b**  
    &nbsp;&nbsp;&nbsp;&nbsp;Set if individuals should be set back after leaving area  
    **-r**  
    &nbsp;&nbsp;&nbsp;&nbsp;Set to remove individuals which start in the deleted patch  
    **-p**  
    &nbsp;&nbsp;&nbsp;&nbsp;Set to output values as percentual of the value from the reference run  
    **--overwrite**  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    **--help**  
    &nbsp;&nbsp;&nbsp;&nbsp;Print usage summary  
    **--verbose**  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    **--quiet**  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    **--qq**  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    **--ui**  
    &nbsp;&nbsp;&nbsp;&nbsp;Force launching GUI dialog

=== "Python (grass.script)"

    **input** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **costmap** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of the costmap  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster  
    **suitability** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of the suitability raster with values from 0-100  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster  
    **output** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, raster, *name*  
    **keyval** : int, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Category value of the patches  
    **step_length** : int, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Length of a single step measured in pixels  
    **perception** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Perception range  
    **multiplicator** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Attractivity of patches [1-inf]  
    **n** : int, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Number of individuals  
    **energy** : float, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Initial energy of the individuals  
    **percent** : float, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Percentage of finished individuals desired before simulation ends  
    **stats** : str | list[str], *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Statistical method to perform on the pathlengths of the individuals  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *average, variance, standard deviation, median, min, max*  
    **out_freq** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Output an intermediate state of simulation each [out_freq] steps  
    **seed** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Seed for random number generator  
    **title** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Title for resultant raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *"phrase"*  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *a*, *b*, *r*, *p*  
    &nbsp;&nbsp;&nbsp;&nbsp;**a**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Set for 8 cell-neighbors. 4 cell-neighbors are default  
    &nbsp;&nbsp;&nbsp;&nbsp;**b**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Set if individuals should be set back after leaving area  
    &nbsp;&nbsp;&nbsp;&nbsp;**r**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Set to remove individuals which start in the deleted patch  
    &nbsp;&nbsp;&nbsp;&nbsp;**p**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Set to output values as percentual of the value from the reference run  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

=== "Python (grass.tools)"

    **input** : str | np.ndarray, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **costmap** : str | np.ndarray, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of the costmap  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster  
    **suitability** : str | np.ndarray, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of the suitability raster with values from 0-100  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster  
    **output** : str | type(np.ndarray) | type(np.array) | type(gs.array.array), *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, raster, *name*  
    **keyval** : int, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Category value of the patches  
    **step_length** : int, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Length of a single step measured in pixels  
    **perception** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Perception range  
    **multiplicator** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Attractivity of patches [1-inf]  
    **n** : int, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Number of individuals  
    **energy** : float, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Initial energy of the individuals  
    **percent** : float, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Percentage of finished individuals desired before simulation ends  
    **stats** : str | list[str], *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Statistical method to perform on the pathlengths of the individuals  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *average, variance, standard deviation, median, min, max*  
    **out_freq** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Output an intermediate state of simulation each [out_freq] steps  
    **seed** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Seed for random number generator  
    **title** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Title for resultant raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *"phrase"*  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *a*, *b*, *r*, *p*  
    &nbsp;&nbsp;&nbsp;&nbsp;**a**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Set for 8 cell-neighbors. 4 cell-neighbors are default  
    &nbsp;&nbsp;&nbsp;&nbsp;**b**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Set if individuals should be set back after leaving area  
    &nbsp;&nbsp;&nbsp;&nbsp;**r**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Set to remove individuals which start in the deleted patch  
    &nbsp;&nbsp;&nbsp;&nbsp;**p**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Set to output values as percentual of the value from the reference run  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

    Returns:

    **result** : grass.tools.support.ToolResult | np.ndarray | tuple[np.ndarray] | None  
    If the tool produces text as standard output, a *ToolResult* object will be returned. Otherwise, `None` will be returned. If an array type (e.g., *np.ndarray*) is used for one of the raster outputs, the result will be an array and will have the shape corresponding to the computational region. If an array type is used for more than one raster output, the result will be a tuple of arrays.

    Raises:

    *grass.tools.ToolError*: When the tool ended with an error.

## DESCRIPTION

This function is based on *r.pi.energy* but adds the functionality of
iterative patch removal for testing of patch relevance to maintain the
landscape connectivity integrity. Isolation or connectivity of singular
patches of a defined landcover class are analysed using individual-based
dispersal models. This functions uses a maximum amount of energy for
each individuals dispersing through the landscape which is deminished by
a fricition or cost map. Unlike the related function *r.pi.energy* does
this function allows individuals to stay or move within a patch until
the energy is depleted.

## NOTES

Amount of successful immigrants or emigrants are not taken individual
into account which emigrated from and immigrated into the same patch
(pseudo immigration).

The suitability matrix impacts the step direction, while the costmap
relates to the depletion of assigned energy.

## EXAMPLE

An example for the North Carolina sample dataset: The amount (average)
and variance with or without the respective patch of successful
emigrants (\*\_emi), immigrants (\*\_imi), the percentage of immigrants
per patch (\*\_imi\_percent), the amount of lost indivuals (\*\_lost),
the amount of migrants (\*\_mig), successful (\*\_mig\_succ) and
unsuccessful migrants (\_mig\_unsucc) can be retrieved using this
command:

```sh
r.pi.energy.pr input=landclass96 output=energyiter1 keyval=5 n=1000 step_length=5 energy=10 percent=80 stats=average,variance
```

introducing costs for movement results in different immigration counts:

```sh
r.mapcalc "cost_raster = if(landclass96==5,1,if(landclass96 == 1, 10, if (landclass96==3,2, if(landclass96==4,1,if(landclass96==6,100)))))"
r.pi.energy.pr input=landclass96 output=energy1 keyval=5 n=1000 step_length=5 energy=10 percent=80 stats=average costmap=cost_raster
```

introducing a suitability for the movement:

```sh
# the suitability for the next step selection is defined as:
# class 5 and 3 (forest and grassland) have a high suitability,
# while shrubland (class 4) only a moderate and water and developed
# areas (class 6 and 1) have a very low suitability:

r.mapcalc "suit_raster = if(landclass96==5,100,if(landclass96 == 3, 100, if (landclass96==1,1, if(landclass96==6,1,if(landclass96==4,50)))))"
r.pi.energy.pr input=landclass96 output=energyiter3 keyval=5 n=1000 step_length=5 energy=10 percent=80 suitability=suit_raster stats=average,variance
```

further settings can be changed and information retrieved: setting the
perception range to 10 pixel:

```sh
r.pi.energy.pr input=landclass96 output=energyiter keyval=5 n=1000 step_length=5 energy=10 percent=80 perception=10 stats=average
```

increasing the attraction to move towards patches to 10:

```sh
r.pi.energy input=landclass96 output=energyiter keyval=5 n=1000 step_length=5 energy=10 percent=80 stats=average multiplicator=10
```

output of each movement location for a defined step frequency. Here
every 10th step is provided as output raster:

```sh
r.pi.energy input=landclass96 output=energyiter keyval=5 n=1000 step_length=5 energy=10 percent=80 stats=average out_freq=10
```

## SEE ALSO

*[r.pi.energy](r.pi.energy.md), [r.pi.searchtime](r.pi.searchtime.md),
[r.pi](r.pi.md)*

## AUTHORS

Programming: Elshad Shirinov  
Scientific concept: Dr. Martin Wegmann  
Department of Remote Sensing  
Remote Sensing and Biodiversity Unit  
University of Wuerzburg, Germany

Port to GRASS GIS 7: Markus Metz

## SOURCE CODE

Available at: [r.pi.energy.pr source code](https://github.com/OSGeo/grass-addons/tree/grass8/raster/r.pi/r.pi.energy.pr)
([history](https://github.com/OSGeo/grass-addons/commits/grass8/raster/r.pi/r.pi.energy.pr))  
Latest change: Thursday Feb 20 13:02:26 2025 in commit [53de819](https://github.com/OSGeo/grass-addons/commit/53de8196a10ba5a8a9121898ce87861d227137e3)
