---
name: r.pi.graph
description: Graph Theory for connectivity analysis.
keywords: [ raster, landscape structure analysis, connectivity analysis ]
---

# r.pi.graph

Graph Theory for connectivity analysis.

=== "Command line"

    **r.pi.graph**
    [**-a**]
    **input**=*name*
    **output**=*string*
    **keyval**=*integer*
    **distance**=*float*
    **neighborhood**=*string*
    **index**=*string*
    [**--overwrite**]
    [**--verbose**]
    [**--quiet**]
    [**--qq**]
    [**--ui**]

    Example:

    ```sh
    r.pi.graph input=name output=string keyval=0 distance=0.0 neighborhood=nearest_neighbor index=connectance_index
    ```

=== "Python (grass.script)"

    *grass.script.run_command*("***r.pi.graph***",
        **input**,
        **output**,
        **keyval**,
        **distance**,
        **neighborhood**,
        **index**,
        **flags**=*None*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    gs.run_command("r.pi.graph", input="name", output="string", keyval=0, distance=0.0, neighborhood="nearest_neighbor", index="connectance_index")
    ```

=== "Python (grass.tools)"

    *grass.tools.Tools.r_pi_graph*(**input**,
        **output**,
        **keyval**,
        **distance**,
        **neighborhood**,
        **index**,
        **flags**=*None*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    tools = Tools()
    tools.r_pi_graph(input="name", output="string", keyval=0, distance=0.0, neighborhood="nearest_neighbor", index="connectance_index")
    ```

    This grass.tools API is experimental in version 8.5 and expected to be stable in version 8.6.

## Parameters

=== "Command line"

    **input**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input raster map  
    **output**=*string* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of the new raster file  
    **keyval**=*integer* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Key value  
    **distance**=*float* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Bounding distance [0 for maximum distance]  
    **neighborhood**=*string* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Neighborhood definition  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *nearest_neighbor, relative_neighbor, gabriel, spanning_tree*  
    **index**=*string* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Cluster index  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *connectance_index, gyration_radius, cohesion_index, percent_patches, percent_area, number_patches, number_links, mean_patch_size, largest_patch_size, largest_patch_diameter, graph_diameter*  
    **-a**  
    &nbsp;&nbsp;&nbsp;&nbsp;Set for 8 cell-neighbors. 4 cell-neighbors are default  
    **--overwrite**  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    **--help**  
    &nbsp;&nbsp;&nbsp;&nbsp;Print usage summary  
    **--verbose**  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    **--quiet**  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    **--qq**  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    **--ui**  
    &nbsp;&nbsp;&nbsp;&nbsp;Force launching GUI dialog

=== "Python (grass.script)"

    **input** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **output** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of the new raster file  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, raster  
    **keyval** : int, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Key value  
    **distance** : float, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Bounding distance [0 for maximum distance]  
    **neighborhood** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Neighborhood definition  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *nearest_neighbor, relative_neighbor, gabriel, spanning_tree*  
    **index** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Cluster index  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *connectance_index, gyration_radius, cohesion_index, percent_patches, percent_area, number_patches, number_links, mean_patch_size, largest_patch_size, largest_patch_diameter, graph_diameter*  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *a*  
    &nbsp;&nbsp;&nbsp;&nbsp;**a**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Set for 8 cell-neighbors. 4 cell-neighbors are default  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

=== "Python (grass.tools)"

    **input** : str | np.ndarray, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **output** : str | type(np.ndarray) | type(np.array) | type(gs.array.array), *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of the new raster file  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, raster  
    **keyval** : int, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Key value  
    **distance** : float, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Bounding distance [0 for maximum distance]  
    **neighborhood** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Neighborhood definition  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *nearest_neighbor, relative_neighbor, gabriel, spanning_tree*  
    **index** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Cluster index  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *connectance_index, gyration_radius, cohesion_index, percent_patches, percent_area, number_patches, number_links, mean_patch_size, largest_patch_size, largest_patch_diameter, graph_diameter*  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *a*  
    &nbsp;&nbsp;&nbsp;&nbsp;**a**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Set for 8 cell-neighbors. 4 cell-neighbors are default  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

    Returns:

    **result** : grass.tools.support.ToolResult | np.ndarray | tuple[np.ndarray] | None  
    If the tool produces text as standard output, a *ToolResult* object will be returned. Otherwise, `None` will be returned. If an array type (e.g., *np.ndarray*) is used for one of the raster outputs, the result will be an array and will have the shape corresponding to the computational region. If an array type is used for more than one raster output, the result will be a tuple of arrays.

    Raises:

    *grass.tools.ToolError*: When the tool ended with an error.

## DESCRIPTION

Graph Theory for connectivity analysis.

## NOTES

...

## EXAMPLE

An example for the North Carolina sample dataset using class 5 (forest):
Computing a graph of all patches (4 neighbourhood rule) using a maximum
distance of 10 pixel, the Gabriel method and as resulting index the
*largest patch diameter*:

```sh
r.pi.graph input=landclass96 output=landclass96_graph keyval=5 distance=10 neighborhood=gabriel index=largest_patch_diameter
```

the results are 2 files:  
landclass96\_graph: the information of the index are provided (here a
range of 3-589 of patch diameter)  
landclass96\_graph\_clusters: the generated cluster IDs are provided
(here 16 clusters are identified), doing it with a distance of 5 pixel
is resulting in a total of 66 clusters.

## SEE ALSO

*[r.pi.corearea](r.pi.corearea.md), [r.pi.corr.mw](r.pi.corr.mw.md),
[r.pi.csr.mw](r.pi.csr.mw.md), [r.pi.export](r.pi.export.md),
[r.pi.graph.dec](r.pi.graph.dec.md), [r.pi.graph.pr](r.pi.graph.pr.md),
[r.pi.graph.red](r.pi.graph.red.md), [r.pi.grow](r.pi.grow.md),
[r.pi.import](r.pi.import.md), [r.pi.index](r.pi.index.md),
[r.pi.lm](r.pi.lm.md), [r.pi.odc](r.pi.odc.md),
[r.pi.prob.mw](r.pi.prob.mw.md), [r.pi.rectangle](r.pi.rectangle.md),
[r.pi](r.pi.md)*

## AUTHORS

Programming: Elshad Shirinov  
Scientific concept: Dr. Martin Wegmann  
Department of Remote Sensing  
Remote Sensing and Biodiversity Unit  
University of Wuerzburg, Germany

Port to GRASS GIS 7: Markus Metz

## SOURCE CODE

Available at: [r.pi.graph source code](https://github.com/OSGeo/grass-addons/tree/grass8/raster/r.pi/r.pi.graph)
([history](https://github.com/OSGeo/grass-addons/commits/grass8/raster/r.pi/r.pi.graph))  
Latest change: Thursday Feb 20 13:02:26 2025 in commit [53de819](https://github.com/OSGeo/grass-addons/commit/53de8196a10ba5a8a9121898ce87861d227137e3)
