---
name: r.pi.nlm.stats
description: Neutral Landscape Generator - index statistics
keywords: [ raster, landscape structure analysis, neutral landscapes ]
---

# r.pi.nlm.stats

Neutral Landscape Generator - index statistics

=== "Command line"

    **r.pi.nlm.stats**
    [**-a**]
    [**input1**=*name*]
    **output**=*string*
    [**keyval**=*integer*]
    [**nullval**=*integer* [,*integer*,...]]
    [**landcover**=*float*]
    [**sharpness**=*float*]
    **n**=*integer*
    **method**=*string* [,*string*,...]
    **statmethod**=*string* [,*string*,...]
    [**seed**=*integer*]
    [**title**=*"phrase"*]
    [**--verbose**]
    [**--quiet**]
    [**--qq**]
    [**--ui**]

    Example:

    ```sh
    r.pi.nlm.stats output=string n=0 method=distance statmethod=average
    ```

=== "Python (grass.script)"

    *grass.script.run_command*("***r.pi.nlm.stats***",
        **input1**=*None*,
        **output**,
        **keyval**=*None*,
        **nullval**=*None*,
        **landcover**=*None*,
        **sharpness**=*None*,
        **n**,
        **method**,
        **statmethod**,
        **seed**=*None*,
        **title**=*None*,
        **flags**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    gs.run_command("r.pi.nlm.stats", output="string", n=0, method="distance", statmethod="average")
    ```

=== "Python (grass.tools)"

    *grass.tools.Tools.r_pi_nlm_stats*(**input1**=*None*,
        **output**,
        **keyval**=*None*,
        **nullval**=*None*,
        **landcover**=*None*,
        **sharpness**=*None*,
        **n**,
        **method**,
        **statmethod**,
        **seed**=*None*,
        **title**=*None*,
        **flags**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    tools = Tools()
    tools.r_pi_nlm_stats(output="string", n=0, method="distance", statmethod="average")
    ```

    This grass.tools API is experimental in version 8.5 and expected to be stable in version 8.6.

## Parameters

=== "Command line"

    **input1**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input raster map  
    **output**=*string* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output ASCII-file (use out=- for stdout)  
    **keyval**=*integer*  
    &nbsp;&nbsp;&nbsp;&nbsp;Value of a category from the input file to measure desired landcover  
    **nullval**=*integer* [,*integer*,...]  
    &nbsp;&nbsp;&nbsp;&nbsp;Values marking areas from the input file, which are to be NULL in the resulting map  
    **landcover**=*float*  
    &nbsp;&nbsp;&nbsp;&nbsp;Landcover in percent  
    **sharpness**=*float*  
    &nbsp;&nbsp;&nbsp;&nbsp;Small values produce smooth structures, great values produce sharp, edgy structures - Range [0-1]  
    **n**=*integer* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Number of maps to generate  
    **method**=*string* [,*string*,...] **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Operation to perform on fragments  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *distance, area, perimeter, shapeindex, fractal*  
    **statmethod**=*string* [,*string*,...] **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Statistical method to perform on the values  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *average, mode, median, variance, min, max*  
    **seed**=*integer*  
    &nbsp;&nbsp;&nbsp;&nbsp;Seed for random number generator  
    **title**=*"phrase"*  
    &nbsp;&nbsp;&nbsp;&nbsp;Title for resultant raster map  
    **-a**  
    &nbsp;&nbsp;&nbsp;&nbsp;Set for 8 cell-neighbors. 4 cell-neighbors are default  
    **--help**  
    &nbsp;&nbsp;&nbsp;&nbsp;Print usage summary  
    **--verbose**  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    **--quiet**  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    **--qq**  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    **--ui**  
    &nbsp;&nbsp;&nbsp;&nbsp;Force launching GUI dialog

=== "Python (grass.script)"

    **input1** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **output** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output ASCII-file (use out=- for stdout)  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output  
    **keyval** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Value of a category from the input file to measure desired landcover  
    **nullval** : int | list[int] | str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Values marking areas from the input file, which are to be NULL in the resulting map  
    **landcover** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Landcover in percent  
    **sharpness** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Small values produce smooth structures, great values produce sharp, edgy structures - Range [0-1]  
    **n** : int, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Number of maps to generate  
    **method** : str | list[str], *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Operation to perform on fragments  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *distance, area, perimeter, shapeindex, fractal*  
    **statmethod** : str | list[str], *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Statistical method to perform on the values  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *average, mode, median, variance, min, max*  
    **seed** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Seed for random number generator  
    **title** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Title for resultant raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *"phrase"*  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *a*  
    &nbsp;&nbsp;&nbsp;&nbsp;**a**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Set for 8 cell-neighbors. 4 cell-neighbors are default  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

=== "Python (grass.tools)"

    **input1** : str | np.ndarray, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **output** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output ASCII-file (use out=- for stdout)  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output  
    **keyval** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Value of a category from the input file to measure desired landcover  
    **nullval** : int | list[int] | str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Values marking areas from the input file, which are to be NULL in the resulting map  
    **landcover** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Landcover in percent  
    **sharpness** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Small values produce smooth structures, great values produce sharp, edgy structures - Range [0-1]  
    **n** : int, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Number of maps to generate  
    **method** : str | list[str], *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Operation to perform on fragments  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *distance, area, perimeter, shapeindex, fractal*  
    **statmethod** : str | list[str], *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Statistical method to perform on the values  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *average, mode, median, variance, min, max*  
    **seed** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Seed for random number generator  
    **title** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Title for resultant raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *"phrase"*  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *a*  
    &nbsp;&nbsp;&nbsp;&nbsp;**a**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Set for 8 cell-neighbors. 4 cell-neighbors are default  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

    Returns:

    **result** : grass.tools.support.ToolResult | None  
    If the tool produces text as standard output, a *ToolResult* object will be returned. Otherwise, `None` will be returned.

    Raises:

    *grass.tools.ToolError*: When the tool ended with an error.

## DESCRIPTION

Neutral Landscape Generator - index statistics

## NOTES

...

## EXAMPLE

An example for the North Carolina sample dataset:

```sh
g.region -d
...
```

## SEE ALSO

*[r.pi.nlm](r.pi.nlm.md), [r.pi](r.pi.md)*

## AUTHORS

Programming: Elshad Shirinov  
Scientific concept: Dr. Martin Wegmann  
Department of Remote Sensing  
Remote Sensing and Biodiversity Unit  
University of Wuerzburg, Germany

Port to GRASS GIS 7: Markus Metz

## SOURCE CODE

Available at: [r.pi.nlm.stats source code](https://github.com/OSGeo/grass-addons/tree/grass8/raster/r.pi/r.pi.nlm.stats)
([history](https://github.com/OSGeo/grass-addons/commits/grass8/raster/r.pi/r.pi.nlm.stats))  
Latest change: Thursday Feb 20 13:02:26 2025 in commit [53de819](https://github.com/OSGeo/grass-addons/commit/53de8196a10ba5a8a9121898ce87861d227137e3)
