---
name: r.pi.prox
description: Calculates correlation of two raster maps by calculating correlation function of two corresponding rectangular areas for each raster point and writing the result into a new raster map.
keywords: [ raster, landscape structure analysis, proximity analysis ]
---

# r.pi.prox

Calculates correlation of two raster maps by calculating correlation function of two corresponding rectangular areas for each raster point and writing the result into a new raster map.

=== "Command line"

    **r.pi.prox**
    [**-a**]
    **input**=*name*
    **output**=*name*
    **keyval**=*integer*
    **method**=*string*
    [**min**=*integer*]
    [**max**=*integer*]
    [**title**=*"phrase"*]
    [**--overwrite**]
    [**--verbose**]
    [**--quiet**]
    [**--qq**]
    [**--ui**]

    Example:

    ```sh
    r.pi.prox input=name output=name keyval=0 method=proximity index
    ```

=== "Python (grass.script)"

    *grass.script.run_command*("***r.pi.prox***",
        **input**,
        **output**,
        **keyval**,
        **method**,
        **min**=*None*,
        **max**=*None*,
        **title**=*None*,
        **flags**=*None*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    gs.run_command("r.pi.prox", input="name", output="name", keyval=0, method="proximity index")
    ```

=== "Python (grass.tools)"

    *grass.tools.Tools.r_pi_prox*(**input**,
        **output**,
        **keyval**,
        **method**,
        **min**=*None*,
        **max**=*None*,
        **title**=*None*,
        **flags**=*None*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    tools = Tools()
    tools.r_pi_prox(input="name", output="name", keyval=0, method="proximity index")
    ```

    This grass.tools API is experimental in version 8.5 and expected to be stable in version 8.6.

## Parameters

=== "Command line"

    **input**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input raster map  
    **output**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output raster map  
    **keyval**=*integer* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Key value  
    **method**=*string* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Operation to perform on fragments  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *proximity index, modified proximity index, neighborhood index*  
    **min**=*integer*  
    &nbsp;&nbsp;&nbsp;&nbsp;Minimum range for the operation measured by pixels, default 0  
    **max**=*integer*  
    &nbsp;&nbsp;&nbsp;&nbsp;Maximum Range for the operation measured by pixels, default copmlete map  
    **title**=*"phrase"*  
    &nbsp;&nbsp;&nbsp;&nbsp;Title for resultant raster map  
    **-a**  
    &nbsp;&nbsp;&nbsp;&nbsp;Set for 8 cell-neighbors. 4 cell-neighbors are default  
    **--overwrite**  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    **--help**  
    &nbsp;&nbsp;&nbsp;&nbsp;Print usage summary  
    **--verbose**  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    **--quiet**  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    **--qq**  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    **--ui**  
    &nbsp;&nbsp;&nbsp;&nbsp;Force launching GUI dialog

=== "Python (grass.script)"

    **input** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **output** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, raster, *name*  
    **keyval** : int, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Key value  
    **method** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Operation to perform on fragments  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *proximity index, modified proximity index, neighborhood index*  
    **min** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Minimum range for the operation measured by pixels, default 0  
    **max** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Maximum Range for the operation measured by pixels, default copmlete map  
    **title** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Title for resultant raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *"phrase"*  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *a*  
    &nbsp;&nbsp;&nbsp;&nbsp;**a**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Set for 8 cell-neighbors. 4 cell-neighbors are default  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

=== "Python (grass.tools)"

    **input** : str | np.ndarray, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **output** : str | type(np.ndarray) | type(np.array) | type(gs.array.array), *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, raster, *name*  
    **keyval** : int, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Key value  
    **method** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Operation to perform on fragments  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *proximity index, modified proximity index, neighborhood index*  
    **min** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Minimum range for the operation measured by pixels, default 0  
    **max** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Maximum Range for the operation measured by pixels, default copmlete map  
    **title** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Title for resultant raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *"phrase"*  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *a*  
    &nbsp;&nbsp;&nbsp;&nbsp;**a**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Set for 8 cell-neighbors. 4 cell-neighbors are default  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

    Returns:

    **result** : grass.tools.support.ToolResult | np.ndarray | tuple[np.ndarray] | None  
    If the tool produces text as standard output, a *ToolResult* object will be returned. Otherwise, `None` will be returned. If an array type (e.g., *np.ndarray*) is used for one of the raster outputs, the result will be an array and will have the shape corresponding to the computational region. If an array type is used for more than one raster output, the result will be a tuple of arrays.

    Raises:

    *grass.tools.ToolError*: When the tool ended with an error.

## DESCRIPTION

Calculates different proximity indices using defined buffer areas.

## NOTES

...

## EXAMPLE

An example for the North Carolina sample dataset:

```sh
g.region -d
...
```

## SEE ALSO

*[pi.index](r.pi.index.md), [r.pi.neigh](r.pi.neigh.md),
[r.pi](r.pi.md)*

## AUTHORS

Programming: Elshad Shirinov  
Scientific concept: Dr. Martin Wegmann  
Department of Remote Sensing  
Remote Sensing and Biodiversity Unit  
University of Wuerzburg, Germany

Port to GRASS GIS 7: Markus Metz

## SOURCE CODE

Available at: [r.pi.prox source code](https://github.com/OSGeo/grass-addons/tree/grass8/raster/r.pi/r.pi.prox)
([history](https://github.com/OSGeo/grass-addons/commits/grass8/raster/r.pi/r.pi.prox))  
Latest change: Sunday Oct 05 18:32:57 2025 in commit [fc9ae68](https://github.com/OSGeo/grass-addons/commit/fc9ae6835e9e88967d0ece26ac89b2c78d91e8db)
