---
name: r.prominence
description: Calculates Llobera's prominence index
keywords: [  ]
---

# r.prominence

Calculates Llobera's prominence index

=== "Command line"

    **r.prominence**
    [**-algrq**]
    **input**=*name*
    **output**=*name*
    **radius**=*integer*
    [**--verbose**]
    [**--quiet**]
    [**--qq**]
    [**--ui**]

    Example:

    ```sh
    r.prominence input=name output=name radius=0
    ```

=== "Python (grass.script)"

    *grass.script.parse_command*("***r.prominence***",
        **input**,
        **output**,
        **radius**,
        **flags**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    gs.parse_command("r.prominence", input="name", output="name", radius=0)
    ```

=== "Python (grass.tools)"

    *grass.tools.Tools.r_prominence*(**input**,
        **output**,
        **radius**,
        **flags**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    tools = Tools()
    tools.r_prominence(input="name", output="name", radius=0)
    ```

    This grass.tools API is experimental in version 8.5 and expected to be stable in version 8.6.

## Parameters

=== "Command line"

    **input**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;FP raster map for which to calculate index  
    **output**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;FP raster to store output  
    **radius**=*integer* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Radius of neighbourhood in map cells  
    **-a**  
    &nbsp;&nbsp;&nbsp;&nbsp;Calculate absolute differences  
    **-l**  
    &nbsp;&nbsp;&nbsp;&nbsp;Local data normalisation  
    **-g**  
    &nbsp;&nbsp;&nbsp;&nbsp;Global data normalisation  
    **-r**  
    &nbsp;&nbsp;&nbsp;&nbsp;Use quadratic neighbourhood  
    **-q**  
    &nbsp;&nbsp;&nbsp;&nbsp;Disable on-screen progress display  
    **--help**  
    &nbsp;&nbsp;&nbsp;&nbsp;Print usage summary  
    **--verbose**  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    **--quiet**  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    **--qq**  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    **--ui**  
    &nbsp;&nbsp;&nbsp;&nbsp;Force launching GUI dialog

=== "Python (grass.script)"

    **input** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;FP raster map for which to calculate index  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, , *name*  
    **output** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;FP raster to store output  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: radius, *name*  
    **radius** : int, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Radius of neighbourhood in map cells  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *a*, *l*, *g*, *r*, *q*  
    &nbsp;&nbsp;&nbsp;&nbsp;**a**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Calculate absolute differences  
    &nbsp;&nbsp;&nbsp;&nbsp;**l**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Local data normalisation  
    &nbsp;&nbsp;&nbsp;&nbsp;**g**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Global data normalisation  
    &nbsp;&nbsp;&nbsp;&nbsp;**r**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Use quadratic neighbourhood  
    &nbsp;&nbsp;&nbsp;&nbsp;**q**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Disable on-screen progress display  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

=== "Python (grass.tools)"

    **input** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;FP raster map for which to calculate index  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, , *name*  
    **output** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;FP raster to store output  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: radius, *name*  
    **radius** : int, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Radius of neighbourhood in map cells  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *a*, *l*, *g*, *r*, *q*  
    &nbsp;&nbsp;&nbsp;&nbsp;**a**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Calculate absolute differences  
    &nbsp;&nbsp;&nbsp;&nbsp;**l**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Local data normalisation  
    &nbsp;&nbsp;&nbsp;&nbsp;**g**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Global data normalisation  
    &nbsp;&nbsp;&nbsp;&nbsp;**r**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Use quadratic neighbourhood  
    &nbsp;&nbsp;&nbsp;&nbsp;**q**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Disable on-screen progress display  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

    Returns:

    **result** : grass.tools.support.ToolResult | None  
    If the tool produces text as standard output, a *ToolResult* object will be returned. Otherwise, `None` will be returned.

    Raises:

    *grass.tools.ToolError*: When the tool ended with an error.

## DESCRIPTION

*r.prominence* calculates the average difference between a central cell
and its neighbors. It approximated the terrain 'ruggedness' by looking
at average differences in elev\_lid792\_1m within a given neighborhood
The *radius* is specified in number of map rows/columns.

## EXAMPLE

North Carolina sample region:

```sh
g.region raster=elev_lid792_1m

# get region rows/columns
g.region -g

# calculate prominence (radius of 50 map rows)
r.prominence input=elev_lid792_1m output=prominence radius=50

# visualize over shaded DEM
r.relief input=elev_lid792_1m output=elev_lid792_1m_shaded

d.mon wx0
d.shade shade=elev_lid792_1m_shaded color=prominence
```

## AUTHOR

Benjamin Ducke (benjamin.ducke - oxfordarch.co.uk)  
Update to GRASS GIS 7: Markus Neteler -
[mundialis](https://www.mundialis.de/)

## SOURCE CODE

Available at: [r.prominence source code](https://github.com/OSGeo/grass-addons/tree/grass8/src/raster/r.prominence)
([history](https://github.com/OSGeo/grass-addons/commits/grass8/src/raster/r.prominence))  
Latest change: Thursday Feb 20 13:02:26 2025 in commit [53de819](https://github.com/OSGeo/grass-addons/commit/53de8196a10ba5a8a9121898ce87861d227137e3)
