---
name: r.quantile.ref
description: Determines quantile for input value from reference raster map layers.
keywords: [ raster, aggregation, series, statistics, quantile ]
---

# r.quantile.ref

Determines quantile for input value from reference raster map layers.

=== "Command line"

    **r.quantile.ref**
    [**-z**]
    **input**=*name*
    [**reference**=*name* [,*name*,...]]
    [**file**=*name*]
    **output**=*name*
    [**range**=*lo,hi*]
    [**--overwrite**]
    [**--verbose**]
    [**--quiet**]
    [**--qq**]
    [**--ui**]

    Example:

    ```sh
    r.quantile.ref input=name output=name
    ```

=== "Python (grass.script)"

    *grass.script.run_command*("***r.quantile.ref***",
        **input**,
        **reference**=*None*,
        **file**=*None*,
        **output**,
        **range**=*None*,
        **flags**=*None*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    gs.run_command("r.quantile.ref", input="name", output="name")
    ```

=== "Python (grass.tools)"

    *grass.tools.Tools.r_quantile_ref*(**input**,
        **reference**=*None*,
        **file**=*None*,
        **output**,
        **range**=*None*,
        **flags**=*None*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    tools = Tools()
    tools.r_quantile_ref(input="name", output="name")
    ```

    This grass.tools API is experimental in version 8.5 and expected to be stable in version 8.6.

## Parameters

=== "Command line"

    **input**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input raster map  
    **reference**=*name* [,*name*,...]  
    &nbsp;&nbsp;&nbsp;&nbsp;List ofreference raster maps  
    **file**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Input file with one reference raster map name per line  
    **output**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output raster map  
    **range**=*lo,hi*  
    &nbsp;&nbsp;&nbsp;&nbsp;Ignore values outside this range  
    **-z**  
    &nbsp;&nbsp;&nbsp;&nbsp;Do not keep files open  
    **--overwrite**  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    **--help**  
    &nbsp;&nbsp;&nbsp;&nbsp;Print usage summary  
    **--verbose**  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    **--quiet**  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    **--qq**  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    **--ui**  
    &nbsp;&nbsp;&nbsp;&nbsp;Force launching GUI dialog

=== "Python (grass.script)"

    **input** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **reference** : str | list[str], *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;List ofreference raster maps  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **file** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Input file with one reference raster map name per line  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, file, *name*  
    **output** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, raster, *name*  
    **range** : tuple[float, float] | list[float] | str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Ignore values outside this range  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *lo,hi*  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *z*  
    &nbsp;&nbsp;&nbsp;&nbsp;**z**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Do not keep files open  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

=== "Python (grass.tools)"

    **input** : str | np.ndarray, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **reference** : str | list[str], *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;List ofreference raster maps  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **file** : str | io.StringIO, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Input file with one reference raster map name per line  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, file, *name*  
    **output** : str | type(np.ndarray) | type(np.array) | type(gs.array.array), *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, raster, *name*  
    **range** : tuple[float, float] | list[float] | str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Ignore values outside this range  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *lo,hi*  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *z*  
    &nbsp;&nbsp;&nbsp;&nbsp;**z**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Do not keep files open  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

    Returns:

    **result** : grass.tools.support.ToolResult | np.ndarray | tuple[np.ndarray] | None  
    If the tool produces text as standard output, a *ToolResult* object will be returned. Otherwise, `None` will be returned. If an array type (e.g., *np.ndarray*) is used for one of the raster outputs, the result will be an array and will have the shape corresponding to the computational region. If an array type is used for more than one raster output, the result will be a tuple of arrays.

    Raises:

    *grass.tools.ToolError*: When the tool ended with an error.

## DESCRIPTION

*r.quantile.ref* computes for each pixel the quantile ranking of the
input value against the reference maps: values of 0, 0.5 and 1.0
respectively indicate that the input value corresponds with the minimum,
median or maximum of the reference values. A value of -1 is assigned if
the input value is smaller than the minimum and a value of 2 is assigned
if the input value is larger than the maximum.

*r.quantile.ref* can be regarded as the inverse of *r.series
method=quantile*: while *r.series* calculates the value for a given
quantile, *r.quantile.ref* calculates the quantile for a given value.
This is useful to compare e.g. current environmental conditions to a
time series of historical environmental conditions.

## EXAMPLE

Create some reference rasters:

```sh
r.mapcalc "ref1 = 1"
r.mapcalc "ref2 = 2"
r.mapcalc "ref3 = 3"
r.mapcalc "ref4 = 5"
r.mapcalc "ref5 = 5"
r.mapcalc "ref6 = 5"
```

Create a test raster with cell value 4.5:

```sh
r.mapcalc "test = 4.5"
```

Get the quantile of the test raster for the reference maps:

```sh
r.quantile.ref input=test reference=ref1,ref2,ref3,ref4,ref5,ref6 output=test_quant
```

The quantile corresponding to the value 4.5 is 0.55. Create a test
raster with cell value 5:

```sh
r.mapcalc "test = 5"
```

Get the quantile of the test raster for the reference maps:

```sh
r.quantile.ref input=test reference=ref1,ref2,ref3,ref4,ref5,ref6 output=test_quant
```

The quantile corresponding to the value 5 is 0.8.

## SEE ALSO

*[r.quantile](https://grass.osgeo.org/grass-stable/manuals/r.quantile.html),
[r.series](https://grass.osgeo.org/grass-stable/manuals/r.series.html)*

## AUTHOR

Markus Metz

## SOURCE CODE

Available at: [r.quantile.ref source code](https://github.com/OSGeo/grass-addons/tree/grass8/src/raster/r.quantile.ref)
([history](https://github.com/OSGeo/grass-addons/commits/grass8/src/raster/r.quantile.ref))  
Latest change: Thursday Feb 20 13:02:26 2025 in commit [53de819](https://github.com/OSGeo/grass-addons/commit/53de8196a10ba5a8a9121898ce87861d227137e3)
