---
name: r.recode.attr.py
description: Recode raster based on the values in one or more columns in a csv file.
keywords: [ raster, recode ]
---

# r.recode.attr.py

Recode raster based on the values in one or more columns in a csv file.

=== "Command line"

    **r.recode.attr.py**
    [**-a**]
    **input**=*name*
    **output**=*name*
    **rules**=*name*
    [**separator**=*character*]
    [**--verbose**]
    [**--quiet**]
    [**--qq**]
    [**--ui**]

    Example:

    ```sh
    r.recode.attr.py input=name output=name rules=name
    ```

=== "Python (grass.script)"

    *grass.script.run_command*("***r.recode.attr.py***",
        **input**,
        **output**,
        **rules**,
        **separator**=*"pipe"*,
        **flags**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    gs.run_command("r.recode.attr.py", input="name", output="name", rules="name")
    ```

=== "Python (grass.tools)"

    *grass.tools.Tools.r_recode_attr_py*(**input**,
        **output**,
        **rules**,
        **separator**=*"pipe"*,
        **flags**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    tools = Tools()
    tools.r_recode_attr_py(input="name", output="name", rules="name")
    ```

    This grass.tools API is experimental in version 8.5 and expected to be stable in version 8.6.

## Parameters

=== "Command line"

    **input**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Input map  
    **output**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;name(s) output layer(s)  
    **rules**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Full path to rules file  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input file  
    **separator**=*character*  
    &nbsp;&nbsp;&nbsp;&nbsp;Field separator  
    &nbsp;&nbsp;&nbsp;&nbsp;Special characters: pipe, comma, space, tab, newline  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *pipe*  
    **-a**  
    &nbsp;&nbsp;&nbsp;&nbsp;Align the current region to the input raster map  
    **--help**  
    &nbsp;&nbsp;&nbsp;&nbsp;Print usage summary  
    **--verbose**  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    **--quiet**  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    **--qq**  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    **--ui**  
    &nbsp;&nbsp;&nbsp;&nbsp;Force launching GUI dialog

=== "Python (grass.script)"

    **input** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Input map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **output** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;name(s) output layer(s)  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **rules** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Full path to rules file  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input file  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, file, *name*  
    **separator** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Field separator  
    &nbsp;&nbsp;&nbsp;&nbsp;Special characters: pipe, comma, space, tab, newline  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, separator, *character*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *pipe*  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *a*  
    &nbsp;&nbsp;&nbsp;&nbsp;**a**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Align the current region to the input raster map  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

=== "Python (grass.tools)"

    **input** : str | np.ndarray, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Input map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **output** : str | np.ndarray, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;name(s) output layer(s)  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **rules** : str | io.StringIO, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Full path to rules file  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input file  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, file, *name*  
    **separator** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Field separator  
    &nbsp;&nbsp;&nbsp;&nbsp;Special characters: pipe, comma, space, tab, newline  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, separator, *character*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *pipe*  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *a*  
    &nbsp;&nbsp;&nbsp;&nbsp;**a**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Align the current region to the input raster map  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

    Returns:

    **result** : grass.tools.support.ToolResult | None  
    If the tool produces text as standard output, a *ToolResult* object will be returned. Otherwise, `None` will be returned.

    Raises:

    *grass.tools.ToolError*: When the tool ended with an error.

## DESCRIPTION

The *r.recode.attr* plugin let you reclass/recode a raster layer based
on values specified in a csv table.The module requires the first row of
the CSV file to contain column headers. The table must include at least
two columns: The first column corresponds to the raster values (or a
subset of them). The remaining columns contain the reclassification
values, which can be either integers or floating-point numbers.

For each column in the csv file (except the first one) new raster map
will be created, replacing the raster values corresponding to the first
column with those in the second (3rd, 4th, etc) column.

Users can define custom names for the output map(s). If only one output
name is provided and the CSV file contains more than two columns, the
module will automatically generate output names by appending the column
names to the provided base name.

## EXAMPLES

The example uses the basic North Caroline dataset. You can download it
from ([https://grass.osgeo.org/download/data/](https://grass.osgeo.org/download/data/)).
Alternatively,
you can install in directly from within GRASS using the "Download sample
project" option in the Data panel. Inspect the categories of the
*landuse* raster layer.

```sh
r.category map=landuse@PERMANENT
```

Based on the categories of the *landuse* layer, create a CSV file
*reclass.csv*. This table assigns a friction value and a suitability
value to each attribute.

```sh
cat <<EOL > reclass.csv
rasterID,friction,suitability
1,0.9,0
2,0.7,0.2
3,0.6,0.4
4,0.2,0.5
5,0.1,0.9
6,1,0
7,0.8,0
EOL
```

Use the *r.recode.attr* addon to generate two new raster layers, one for
friction and another for suitability. Specify a base name for the output
maps. Ensure that the **separator** matches the delimiter used in your
CSV file.

```sh
r.recode.attr input=landuse output=map rules=reclass.csv separator=comma
```

Note that the names of the two maps are constructed based on the
provided base name 'map' + name of the name of the column. Create for
both layers created above a color table.

```sh
r.colors map=map_friction color=oranges
r.colors map=map_suitability color=greens
```

The original land use map and the derived friction and suitability maps
are shown in the figure below.

[![image-alt](r_recode_attr_01.png)](r_recode_attr_01.png)  
*Figure 1: The A) friction and B) suitability maps, based on scores
assigned to each land use category of the landuse map.*

## SEE ALSO

*[r.reclass](https://grass.osgeo.org/grass-stable/manuals/r.reclass.html),
[r.recode](https://grass.osgeo.org/grass-stable/manuals/r.recode.html)*

## AUTHOR

Paulo van Breugel, <https://ecodiv.earth>, HAS green academy University
of Applied Sciences, [Innovative Biomonitoring research
group](https://www.has.nl/en/research/professorships/innovative-bio-monitoring-professorship/),
[Climate-robust Landscapes research
group](https://www.has.nl/en/research/professorships/climate-robust-landscapes-professorship/)

## SOURCE CODE

Available at: [r.recode.attr source code](https://github.com/OSGeo/grass-addons/tree/grass8/src/raster/r.recode.attr)
([history](https://github.com/OSGeo/grass-addons/commits/grass8/src/raster/r.recode.attr))  
Latest change: Thursday May 29 11:23:19 2025 in commit [701c59b](https://github.com/OSGeo/grass-addons/commit/701c59b932c6a12e06ba3a4135cab5955cd9047a)
