---
name: r.recode
description: Recodes categorical raster maps.
keywords: [ raster, recode categories, reclassification ]
---

# r.recode

Recodes categorical raster maps.

=== "Command line"

    **r.recode**
    [**-ad**]
    **input**=*name*
    **output**=*name*
    **rules**=*name*
    [**title**=*string*]
    [**--overwrite**]
    [**--verbose**]
    [**--quiet**]
    [**--qq**]
    [**--ui**]

    Example:

    ```sh
    r.recode input=name output=name rules=name
    ```

=== "Python (grass.script)"

    *grass.script.run_command*("***r.recode***",
        **input**,
        **output**,
        **rules**,
        **title**=*None*,
        **flags**=*None*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    gs.run_command("r.recode", input="name", output="name", rules="name")
    ```

=== "Python (grass.tools)"

    *grass.tools.Tools.r_recode*(**input**,
        **output**,
        **rules**,
        **title**=*None*,
        **flags**=*None*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    tools = Tools()
    tools.r_recode(input="name", output="name", rules="name")
    ```

    This grass.tools API is experimental in version 8.5 and expected to be stable in version 8.6.

## Parameters

=== "Command line"

    **input**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of raster map to be recoded  
    **output**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output raster map  
    **rules**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;File containing recode rules  
    &nbsp;&nbsp;&nbsp;&nbsp;'-' for standard input  
    **title**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;Title for output raster map  
    **-a**  
    &nbsp;&nbsp;&nbsp;&nbsp;Align the current region to the input raster map  
    **-d**  
    &nbsp;&nbsp;&nbsp;&nbsp;Force output to 'double' raster map type (DCELL)  
    **--overwrite**  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    **--help**  
    &nbsp;&nbsp;&nbsp;&nbsp;Print usage summary  
    **--verbose**  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    **--quiet**  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    **--qq**  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    **--ui**  
    &nbsp;&nbsp;&nbsp;&nbsp;Force launching GUI dialog

=== "Python (grass.script)"

    **input** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of raster map to be recoded  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **output** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, raster, *name*  
    **rules** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;File containing recode rules  
    &nbsp;&nbsp;&nbsp;&nbsp;'-' for standard input  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, file, *name*  
    **title** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Title for output raster map  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *a*, *d*  
    &nbsp;&nbsp;&nbsp;&nbsp;**a**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Align the current region to the input raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;**d**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Force output to 'double' raster map type (DCELL)  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

=== "Python (grass.tools)"

    **input** : str | np.ndarray, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of raster map to be recoded  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **output** : str | type(np.ndarray) | type(np.array) | type(gs.array.array), *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, raster, *name*  
    **rules** : str | io.StringIO, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;File containing recode rules  
    &nbsp;&nbsp;&nbsp;&nbsp;'-' for standard input  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, file, *name*  
    **title** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Title for output raster map  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *a*, *d*  
    &nbsp;&nbsp;&nbsp;&nbsp;**a**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Align the current region to the input raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;**d**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Force output to 'double' raster map type (DCELL)  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

    Returns:

    **result** : grass.tools.support.ToolResult | np.ndarray | tuple[np.ndarray] | None  
    If the tool produces text as standard output, a *ToolResult* object will be returned. Otherwise, `None` will be returned. If an array type (e.g., *np.ndarray*) is used for one of the raster outputs, the result will be an array and will have the shape corresponding to the computational region. If an array type is used for more than one raster output, the result will be a tuple of arrays.

    Raises:

    *grass.tools.ToolError*: When the tool ended with an error.

## DESCRIPTION

*r.recode* creates an output raster map by recoding input raster map
based on recode **rules**. A **title** for the output raster map may be
(optionally) specified by the user.

The recode rules can be read from standard input (i.e., from the
keyboard, redirected from a file, or piped through another program) by
entering **rules=-**.

Rules are defined in one of these formats:

```sh
old_low:old_high:new_low:new_high
old_low:old_high:new_val  (i.e. new_high == new_low)
*:old_val:new_val         (interval [inf, old_val])
old_val:*:new_val         (interval [old_val, inf])
```

*r.recode* is loosely based on *[r.reclass](r.reclass.md)* and uses the
GRASS Reclass Library to convert the rasters. It has routines for
converting to every possible combination of raster (eg. CELL to DCELL,
DCELL to FCELL, etc). Standard floating point raster precision is float
(FCELL), with **-d** double precision (DCELL) will be written.

There are four basic routines that it accepts:

1. old-low to old-high is reclassed to new-low to new high , where the
    user provides all four values. The program figures on the fly what
    type of raster should be created.
2. old-low to old-high is reclassed to a single new value. Anything
    outside the range is null.
3. \* to old-high will reclass everything less than old-high to a
    single new value.
4. old-low to \* will reclass everything greater than old-low to a
    single new value.

These four sets of arguments can be given on the command line, or piped
via stdin or a file. More than one set of arguments is accepted.

## EXAMPLES

### Map type conversion

To simply convert a raster between formats (eg. int to float) the user
would use the first argument. For example

```sh
10:1500:0.1:15.0
```

would convert an input raster map with range between 10 and 1500 to a
float raster raster with range between 0.1 and 15.0.

### Value replacement

*r.recode* can be used to replace existing cell values by others. The
formatting is as described above. In following example the values 1, 2
and 3 are replaced by 1.1, 7.5 resp. 0.4:

```sh
r.recode input=oldmap output=newmap rules=- << EOF
1:1:1.1:1.1
2:2:7.5:7.5
3:3:0.4:0.4
EOF
```

## SEE ALSO

*[r.reclass](r.reclass.md)*

## AUTHOR

CERL

## SOURCE CODE

Available at: [r.recode source code](https://github.com/OSGeo/grass/tree/main/raster/r.recode)
([history](https://github.com/OSGeo/grass/commits/main/raster/r.recode))  
Latest change: Thursday May 08 20:58:05 2025 in commit [4144ba8](https://github.com/OSGeo/grass/commit/4144ba81fa125e1549fc52e1cf5feb4fa004be8b)
