---
name: r.slopeunits.optimize.py
description: Optimize inputs for slope units
keywords: [ raster, elevation, slopeunits ]
---

# r.slopeunits.optimize.py

Optimize inputs for slope units

=== "Command line"

    **r.slopeunits.optimize.py**
    [**-s**]
    **demmap**=*name*
    [**plainsmap**=*name*]
    **basin**=*name*
    **slumap**=*name*
    [**slumapclean**=*name*]
    **thresh**=*float*
    **rf**=*integer*
    **maxiteration**=*integer*
    **cleansize**=*float*
    **cvmin**=*min,max*
    **areamin**=*min,max*
    **epsilonx**=*float*
    **epsilony**=*float*
    **outdir**=*name*
    [**convergence**=*integer*]
    [**--overwrite**]
    [**--verbose**]
    [**--quiet**]
    [**--qq**]
    [**--ui**]

    Example:

    ```sh
    r.slopeunits.optimize.py demmap=name basin=name slumap=su_tmp thresh=0.0 rf=0 maxiteration=0 cleansize=25000 cvmin=0.05,0.25 areamin=50000.0,200000.0 epsilonx=0.01 epsilony=50000 outdir=outdir
    ```

=== "Python (grass.script)"

    *grass.script.run_command*("***r.slopeunits.optimize.py***",
        **demmap**,
        **plainsmap**=*None*,
        **basin**,
        **slumap**=*"su_tmp"*,
        **slumapclean**=*"su_tmp_cl"*,
        **thresh**,
        **rf**,
        **maxiteration**,
        **cleansize**=*25000*,
        **cvmin**=*"0.05,0.25"*,
        **areamin**=*"50000.0,200000.0"*,
        **epsilonx**=*0.01*,
        **epsilony**=*50000*,
        **outdir**=*"outdir"*,
        **convergence**=*5*,
        **flags**=*None*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    gs.run_command("r.slopeunits.optimize.py", demmap="name", basin="name", slumap="su_tmp", thresh=0.0, rf=0, maxiteration=0, cleansize=25000, cvmin=0.05,0.25, areamin=50000.0,200000.0, epsilonx=0.01, epsilony=50000, outdir="outdir")
    ```

=== "Python (grass.tools)"

    *grass.tools.Tools.r_slopeunits_optimize_py*(**demmap**,
        **plainsmap**=*None*,
        **basin**,
        **slumap**=*"su_tmp"*,
        **slumapclean**=*"su_tmp_cl"*,
        **thresh**,
        **rf**,
        **maxiteration**,
        **cleansize**=*25000*,
        **cvmin**=*"0.05,0.25"*,
        **areamin**=*"50000.0,200000.0"*,
        **epsilonx**=*0.01*,
        **epsilony**=*50000*,
        **outdir**=*"outdir"*,
        **convergence**=*5*,
        **flags**=*None*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    tools = Tools()
    tools.r_slopeunits_optimize_py(demmap="name", basin="name", slumap="su_tmp", thresh=0.0, rf=0, maxiteration=0, cleansize=25000, cvmin=0.05,0.25, areamin=50000.0,200000.0, epsilonx=0.01, epsilony=50000, outdir="outdir")
    ```

    This grass.tools API is experimental in version 8.5 and expected to be stable in version 8.6.

## Parameters

=== "Command line"

    **demmap**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Input digital elevation model  
    **plainsmap**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Input raster map of alluvial plains  
    **basin**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input vector map  
    &nbsp;&nbsp;&nbsp;&nbsp;Input basin passed to r.slopeunits.metrics  
    **slumap**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Slope Units layer (the main output of r.slopeunits.create)  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *su_tmp*  
    **slumapclean**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Slope Units layer, cleaned (the main output of r.slopeunits.clean)  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *su_tmp_cl*  
    **thresh**=*float* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Initial threshold (m^2)  
    **rf**=*integer* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Factor used to iterativelly reduce initial threshold  
    **maxiteration**=*integer* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;maximum number of iteration to do before stopped  
    **cleansize**=*float* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Slope Units size to be removed  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *25000*  
    **cvmin**=*min,max* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Start search with these initial minimum and maximum values of the circular variance (0.0-1.0) below which the slope unit is not further segmented  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *0.05,0.25*  
    **areamin**=*min,max* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Start search with these initial minimum and maximum values of the area (m^2) below which the slope unit is not further segmented  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *50000.0,200000.0*  
    **epsilonx**=*float* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Stop loop when difference of cvmin limits is lesser than this value  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *0.01*  
    **epsilony**=*float* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Stop loop when difference of areamin limits is lesser than this value  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *50000*  
    **outdir**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Output directory for intermediate results for all cvmin and areamin values and final results. Default folder "outdir" in current working directory.  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *outdir*  
    **convergence**=*integer*  
    &nbsp;&nbsp;&nbsp;&nbsp;Convergence factor for MFD in r.watershed (1-10)  
    &nbsp;&nbsp;&nbsp;&nbsp;1 = most diverging flow, 10 = most converging flow. Recommended: 5  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *5*  
    **-s**  
    &nbsp;&nbsp;&nbsp;&nbsp;SFD (D8) flow in r.watershed (default is MFD)  
    &nbsp;&nbsp;&nbsp;&nbsp;SFD: single flow direction, MFD: multiple flow direction  
    **--overwrite**  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    **--help**  
    &nbsp;&nbsp;&nbsp;&nbsp;Print usage summary  
    **--verbose**  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    **--quiet**  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    **--qq**  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    **--ui**  
    &nbsp;&nbsp;&nbsp;&nbsp;Force launching GUI dialog

=== "Python (grass.script)"

    **demmap** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Input digital elevation model  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **plainsmap** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Input raster map of alluvial plains  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **basin** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input vector map  
    &nbsp;&nbsp;&nbsp;&nbsp;Input basin passed to r.slopeunits.metrics  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, vector, *name*  
    **slumap** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Slope Units layer (the main output of r.slopeunits.create)  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, raster, *name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *su_tmp*  
    **slumapclean** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Slope Units layer, cleaned (the main output of r.slopeunits.clean)  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, raster, *name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *su_tmp_cl*  
    **thresh** : float, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Initial threshold (m^2)  
    **rf** : int, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Factor used to iterativelly reduce initial threshold  
    **maxiteration** : int, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;maximum number of iteration to do before stopped  
    **cleansize** : float, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Slope Units size to be removed  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *25000*  
    **cvmin** : tuple[float, float] | list[float] | str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Start search with these initial minimum and maximum values of the circular variance (0.0-1.0) below which the slope unit is not further segmented  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *min,max*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *0.05,0.25*  
    **areamin** : tuple[float, float] | list[float] | str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Start search with these initial minimum and maximum values of the area (m^2) below which the slope unit is not further segmented  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *min,max*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *50000.0,200000.0*  
    **epsilonx** : float, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Stop loop when difference of cvmin limits is lesser than this value  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *0.01*  
    **epsilony** : float, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Stop loop when difference of areamin limits is lesser than this value  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *50000*  
    **outdir** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Output directory for intermediate results for all cvmin and areamin values and final results. Default folder "outdir" in current working directory.  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, dir, *name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *outdir*  
    **convergence** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Convergence factor for MFD in r.watershed (1-10)  
    &nbsp;&nbsp;&nbsp;&nbsp;1 = most diverging flow, 10 = most converging flow. Recommended: 5  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *5*  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *s*  
    &nbsp;&nbsp;&nbsp;&nbsp;**s**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;SFD (D8) flow in r.watershed (default is MFD)  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;SFD: single flow direction, MFD: multiple flow direction  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

=== "Python (grass.tools)"

    **demmap** : str | np.ndarray, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Input digital elevation model  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **plainsmap** : str | np.ndarray, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Input raster map of alluvial plains  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **basin** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input vector map  
    &nbsp;&nbsp;&nbsp;&nbsp;Input basin passed to r.slopeunits.metrics  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, vector, *name*  
    **slumap** : str | type(np.ndarray) | type(np.array) | type(gs.array.array), *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Slope Units layer (the main output of r.slopeunits.create)  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, raster, *name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *su_tmp*  
    **slumapclean** : str | type(np.ndarray) | type(np.array) | type(gs.array.array), *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Slope Units layer, cleaned (the main output of r.slopeunits.clean)  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, raster, *name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *su_tmp_cl*  
    **thresh** : float, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Initial threshold (m^2)  
    **rf** : int, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Factor used to iterativelly reduce initial threshold  
    **maxiteration** : int, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;maximum number of iteration to do before stopped  
    **cleansize** : float, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Slope Units size to be removed  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *25000*  
    **cvmin** : tuple[float, float] | list[float] | str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Start search with these initial minimum and maximum values of the circular variance (0.0-1.0) below which the slope unit is not further segmented  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *min,max*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *0.05,0.25*  
    **areamin** : tuple[float, float] | list[float] | str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Start search with these initial minimum and maximum values of the area (m^2) below which the slope unit is not further segmented  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *min,max*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *50000.0,200000.0*  
    **epsilonx** : float, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Stop loop when difference of cvmin limits is lesser than this value  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *0.01*  
    **epsilony** : float, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Stop loop when difference of areamin limits is lesser than this value  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *50000*  
    **outdir** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Output directory for intermediate results for all cvmin and areamin values and final results. Default folder "outdir" in current working directory.  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, dir, *name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *outdir*  
    **convergence** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Convergence factor for MFD in r.watershed (1-10)  
    &nbsp;&nbsp;&nbsp;&nbsp;1 = most diverging flow, 10 = most converging flow. Recommended: 5  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *5*  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *s*  
    &nbsp;&nbsp;&nbsp;&nbsp;**s**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;SFD (D8) flow in r.watershed (default is MFD)  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;SFD: single flow direction, MFD: multiple flow direction  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

    Returns:

    **result** : grass.tools.support.ToolResult | np.ndarray | tuple[np.ndarray] | None  
    If the tool produces text as standard output, a *ToolResult* object will be returned. Otherwise, `None` will be returned. If an array type (e.g., *np.ndarray*) is used for one of the raster outputs, the result will be an array and will have the shape corresponding to the computational region. If an array type is used for more than one raster output, the result will be a tuple of arrays.

    Raises:

    *grass.tools.ToolError*: When the tool ended with an error.

## DESCRIPTION

*r.slopeunits.optimize* determines optimal input values for slope units:

- "areamin" - Minimum area (m^2) below which the slope unit is not
  further segmented
- "cvmin" - Minimum value of the circular variance (0.0-1.0) below which
  the slope unit is not further segmented

It calls *r.slopeunits.create*, *r.slopeunits.clean*, and
*r.slopeunits.metrics* iteratively. Output is a file `opt.txt` with
optimal values in either specified folder or in folder `output/`" in the
current working directory. Also files `calcd.dat` and `current.txt` are
created with all determined and examined values and the four latest
examined values (combination of
`areamin`` and ``cvmin`` minimum and maximum) and ``center``, respectively.`

## EXAMPLE

```sh
r.slopeunits.optimize \
    basin=basin_chk \
    demmap=dem_italia_isolegrandi@su_test \
    plainsmap=flat \
    thresh=250000 \
    rf=2 \
    maxiteration=50 \
    cleansize=25000
```

## REFERENCES

- Alvioli, M., Marchesini, I., Reichenbach, P., Rossi, M., Ardizzone,
  F., Fiorucci, F., and Guzzetti, F. (2016): Automatic delineation of
  geomorphological slope units with r.slopeunits v1.0 and their
  optimization for landslide susceptibility modeling, Geosci. Model
  Dev., 9, 3975-3991.
  DOI:[10.5194/gmd-9-3975-2016](https://doi.org/10.5194/gmd-9-3975-2016)
- Alvioli, M., Guzzetti, F., & Marchesini, I. (2020): Parameter-free
  delineation of slope units and terrain subdivision of Italy.
  Geomorphology, 358, 107124.
  DOI:[10.1016/j.geomorph.2020.107124](https://doi.org/10.1016/j.geomorph.2020.107124)

## SEE ALSO

*[r.slopeunits.create](r.slopeunits.create.md),
[r.slopeunits.clean](r.slopeunits.clean.md),
[r.slopeunits.metrics](r.slopeunits.metrics.md)*

## AUTHORS

Main authors: Ivan Marchesini, Massimiliano Alvioli, CNR-IRPI  
Carmen Tawalika (translation to python, refactoring),
[mundialis](https://www.mundialis.de/)

## SOURCE CODE

Available at: [r.slopeunits.optimize source code](https://github.com/OSGeo/grass-addons/tree/grass8/raster/r.slopeunits/r.slopeunits.optimize)
([history](https://github.com/OSGeo/grass-addons/commits/grass8/raster/r.slopeunits/r.slopeunits.optimize))  
Latest change: Wednesday May 07 16:16:50 2025 in commit [8af96b6](https://github.com/OSGeo/grass-addons/commit/8af96b6c1138b2b992213db3bfb2242a3e482331)
