---
name: r.soils.texture
description: Define soil texture from sand and clay grid.
keywords: [ raster, soil, texture ]
---

# r.soils.texture

Define soil texture from sand and clay grid.

=== "Command line"

    **r.soils.texture**
    **sand**=*name*
    **clay**=*name*
    **scheme**=*name*
    **output**=*name*
    [**--overwrite**]
    [**--verbose**]
    [**--quiet**]
    [**--qq**]
    [**--ui**]

    Example:

    ```sh
    r.soils.texture sand=name clay=name scheme=name output=name
    ```

=== "Python (grass.script)"

    *grass.script.run_command*("***r.soils.texture***",
        **sand**,
        **clay**,
        **scheme**,
        **output**,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    gs.run_command("r.soils.texture", sand="name", clay="name", scheme="name", output="name")
    ```

=== "Python (grass.tools)"

    *grass.tools.Tools.r_soils_texture*(**sand**,
        **clay**,
        **scheme**,
        **output**,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    tools = Tools()
    tools.r_soils_texture(sand="name", clay="name", scheme="name", output="name")
    ```

    This grass.tools API is experimental in version 8.5 and expected to be stable in version 8.6.

## Parameters

=== "Command line"

    **sand**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input sand map [0-100]  
    **clay**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input clay map [0-100]  
    **scheme**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Text file with texture scheme  
    **output**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output raster map  
    **--overwrite**  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    **--help**  
    &nbsp;&nbsp;&nbsp;&nbsp;Print usage summary  
    **--verbose**  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    **--quiet**  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    **--qq**  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    **--ui**  
    &nbsp;&nbsp;&nbsp;&nbsp;Force launching GUI dialog

=== "Python (grass.script)"

    **sand** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input sand map [0-100]  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **clay** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input clay map [0-100]  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **scheme** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Text file with texture scheme  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, file, *name*  
    **output** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, raster, *name*  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

=== "Python (grass.tools)"

    **sand** : str | np.ndarray, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input sand map [0-100]  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **clay** : str | np.ndarray, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input clay map [0-100]  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **scheme** : str | io.StringIO, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Text file with texture scheme  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, file, *name*  
    **output** : str | type(np.ndarray) | type(np.array) | type(gs.array.array), *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, raster, *name*  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

    Returns:

    **result** : grass.tools.support.ToolResult | np.ndarray | tuple[np.ndarray] | None  
    If the tool produces text as standard output, a *ToolResult* object will be returned. Otherwise, `None` will be returned. If an array type (e.g., *np.ndarray*) is used for one of the raster outputs, the result will be an array and will have the shape corresponding to the computational region. If an array type is used for more than one raster output, the result will be a tuple of arrays.

    Raises:

    *grass.tools.ToolError*: When the tool ended with an error.

## DESCRIPTION

*r.soils.texture* define soils texture from sand and clay distribution
grid and a texture scheme definition.  
Sand and clay grid are simple grid theme; scheme file is text ASCII file
with \*.dat extention like USDA.dat, FAO.dat and nternational.dat
supplied with source code module in scheme directory. You can download
\*.dat files from the [GRASS GIS addons
repository](https://github.com/OSGeo/grass-addons/tree/grass8/src/raster/r.soils.texture/scheme)

## SEE ALSO  

*[GRASS 8 Programmer's Manual](https://grass.osgeo.org/programming8/)*

## REFERENCES

Bourke P., 1987 Determining if a point lies on the interior of a
polygon. Downloaded printed

Neteler M. and H. Mitasova 2004 Open Source GIS: A GRASS GIS Approach -
Kluwer Academic Publisher/Springer, Boston, -Second edition ISBN:
1-4020-8064-6

Sanesi G., 2000 - Elementi di pedologia - Edagricole, Bologna

Texture AutoLookup (TAL) ver 4.2, 2002

Van Rossum G. - 2005 - Manuale di riferimento di python - Ed. Italiana,
Fred L. Drake, Jr., editor

WATTON J. D., 1997 - Comparing C, Fortran, Lisp, java, python, perl,
scheme (guile), and tcl using a floating point numerical test - point
inside polygon. Applied mathematics and computer technology center alcoa
technical center. Distribution documents.

## AUTHOR

Gianluca Massei (g\_massa@libero.it)

## SOURCE CODE

Available at: [r.soils.texture source code](https://github.com/OSGeo/grass-addons/tree/grass8/src/raster/r.soils.texture)
([history](https://github.com/OSGeo/grass-addons/commits/grass8/src/raster/r.soils.texture))  
Latest change: Thursday Feb 20 13:02:26 2025 in commit [53de819](https://github.com/OSGeo/grass-addons/commit/53de8196a10ba5a8a9121898ce87861d227137e3)
