---
name: r.stream.slope
description: Calculates local parameters for slope subsystem.
keywords: [ raster, hydrology, stream network, stream local parameters ]
---

# r.stream.slope

Calculates local parameters for slope subsystem.

=== "Command line"

    **r.stream.slope**
    **direction**=*name*
    **elevation**=*name*
    [**difference**=*name*]
    [**gradient**=*name*]
    [**maxcurv**=*name*]
    [**mincurv**=*name*]
    [**--overwrite**]
    [**--verbose**]
    [**--quiet**]
    [**--qq**]
    [**--ui**]

    Example:

    ```sh
    r.stream.slope direction=name elevation=name
    ```

=== "Python (grass.script)"

    *grass.script.run_command*("***r.stream.slope***",
        **direction**,
        **elevation**,
        **difference**=*None*,
        **gradient**=*None*,
        **maxcurv**=*None*,
        **mincurv**=*None*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    gs.run_command("r.stream.slope", direction="name", elevation="name")
    ```

=== "Python (grass.tools)"

    *grass.tools.Tools.r_stream_slope*(**direction**,
        **elevation**,
        **difference**=*None*,
        **gradient**=*None*,
        **maxcurv**=*None*,
        **mincurv**=*None*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    tools = Tools()
    tools.r_stream_slope(direction="name", elevation="name")
    ```

    This grass.tools API is experimental in version 8.5 and expected to be stable in version 8.6.

## Parameters

=== "Command line"

    **direction**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input raster map with flow direction  
    **elevation**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input elevation raster map  
    **difference**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output local downstream elevation difference raster map  
    **gradient**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output local downstream gradient raster map  
    **maxcurv**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output local downstream maximum curvature raster map  
    **mincurv**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output local downstream minimum curvature raster map  
    **--overwrite**  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    **--help**  
    &nbsp;&nbsp;&nbsp;&nbsp;Print usage summary  
    **--verbose**  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    **--quiet**  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    **--qq**  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    **--ui**  
    &nbsp;&nbsp;&nbsp;&nbsp;Force launching GUI dialog

=== "Python (grass.script)"

    **direction** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input raster map with flow direction  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **elevation** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input elevation raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **difference** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output local downstream elevation difference raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, raster, *name*  
    **gradient** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output local downstream gradient raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, raster, *name*  
    **maxcurv** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output local downstream maximum curvature raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, raster, *name*  
    **mincurv** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output local downstream minimum curvature raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, raster, *name*  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

=== "Python (grass.tools)"

    **direction** : str | np.ndarray, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input raster map with flow direction  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **elevation** : str | np.ndarray, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input elevation raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **difference** : str | type(np.ndarray) | type(np.array) | type(gs.array.array), *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output local downstream elevation difference raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, raster, *name*  
    **gradient** : str | type(np.ndarray) | type(np.array) | type(gs.array.array), *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output local downstream gradient raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, raster, *name*  
    **maxcurv** : str | type(np.ndarray) | type(np.array) | type(gs.array.array), *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output local downstream maximum curvature raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, raster, *name*  
    **mincurv** : str | type(np.ndarray) | type(np.array) | type(gs.array.array), *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output local downstream minimum curvature raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, raster, *name*  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

    Returns:

    **result** : grass.tools.support.ToolResult | np.ndarray | tuple[np.ndarray] | None  
    If the tool produces text as standard output, a *ToolResult* object will be returned. Otherwise, `None` will be returned. If an array type (e.g., *np.ndarray*) is used for one of the raster outputs, the result will be an array and will have the shape corresponding to the computational region. If an array type is used for more than one raster output, the result will be a tuple of arrays.

    Raises:

    *grass.tools.ToolError*: When the tool ended with an error.

## DESCRIPTION

*r.stream.slope* calculates local downstream elevation change and local
downstream minimum and maximum curvature.

## OPTIONS

- *direction*  
    Flow direction: name of input direction map produced by
    *r.watershed* or *r.stream.extract*. If r.stream.extract output map
    is used, it only has non-NULL values in places where streams occur.
    NULL (nodata) cells are ignored, zero and negative values are valid
    direction data if they vary from -8 to 8 (CCW from East in steps of
    45 degrees). Direction map shall be of type CELL values. Region
    resolution and map resolution must be the same.
- *elevation*  
    Elevation: name of input elevation map or any other map we want to
    calculate. Map can be of type CELL, FCELL or DCELL. It is not
    restricted to resolution of region settings like *direction*.
- *difference*  
    Output downstream elevation difference: difference between elevation
    of current cell and downstream cell. Shall always be positive.
    Negative values show, that current cell is pit or depression cell.
    Module is prepared to be used with elevation but can be also used to
    calculate local difference of any feature along watercourses in
    slope subsystem. In that way elevation map must be replaced by map
    we want to calculate. If we use different map than elevation, rest
    of parameters have no sense to calculate
- *gradient*  
    Output downstream gradient: Downstream elevation difference divided
    by distance.
- *maxcurv*  
    Output maximum linear curvature along watercourse. Calculated along
    watercourse between highest upstream cell, current cell and
    downstream cell (there can be only one or no downstream cell but
    more than on upstream)
- *mincurv*  
    Output minimum linear curvature along watercourse. Calculated along
    watercourse between lowest upstream cell, current cell and
    downstream cell (there can be only one or no downstream cell but
    more than on upstream)

## EXAMPLE

```sh
g.region -p -a raster=elevation
r.watershed elevation=elevation threshold=10000 drainage=dirs stream=streams
r.stream.slope dir=dirs elevation=elevation difference=downstream_elev_difference \
  gradient=downstream_gradient maxcurv=downstream_maxcurv mincurv=downstream_mincurv
```

## SEE ALSO

*[r.mapcalc](https://grass.osgeo.org/grass-stable/manuals/r.mapcalc.html),
[r.stream.channel](r.stream.channel.md),
[r.stream.distance](r.stream.distance.md),
[r.stream.extract](https://grass.osgeo.org/grass-stable/manuals/r.stream.extract.html),
[r.stream.order](r.stream.order.md),
[r.stream.segment](r.stream.segment.md),
[r.stream.snap](r.stream.snap.md), [r.stream.stats](r.stream.stats.md),
[r.watershed](https://grass.osgeo.org/grass-stable/manuals/r.watershed.html)*

See also [r.streams.\*
modules](https://grasswiki.osgeo.org/wiki/R.stream.*_modules) wiki page.

## AUTHOR

Jarek Jasiewicz, Adam Mickiewicz University, Geoecology and
Geoinformation Institute.

## SOURCE CODE

Available at: [r.stream.slope source code](https://github.com/OSGeo/grass-addons/tree/grass8/src/raster/r.stream.slope)
([history](https://github.com/OSGeo/grass-addons/commits/grass8/src/raster/r.stream.slope))  
Latest change: Friday Feb 21 10:10:05 2025 in commit [7d78fe3](https://github.com/OSGeo/grass-addons/commit/7d78fe34868674c3b6050ba1924e1c5675d155c9)
