---
name: r.threshold.py
description: Find optimal threshold for stream extraction
keywords: [ raster, hydrology, threshold ]
---

# r.threshold.py

Find optimal threshold for stream extraction

=== "Command line"

    **r.threshold.py**
    [**-g**]
    **acc**=*acc*
    [**--verbose**]
    [**--quiet**]
    [**--qq**]
    [**--ui**]

    Example:

    ```sh
    r.threshold.py acc=acc
    ```

=== "Python (grass.script)"

    *grass.script.parse_command*("***r.threshold.py***",
        **acc**,
        **flags**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    gs.parse_command("r.threshold.py", acc="acc")
    ```

=== "Python (grass.tools)"

    *grass.tools.Tools.r_threshold_py*(**acc**,
        **flags**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    tools = Tools()
    tools.r_threshold_py(acc="acc")
    ```

    This grass.tools API is experimental in version 8.5 and expected to be stable in version 8.6.

## Parameters

=== "Command line"

    **acc**=*acc* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of accumulation raster map  
    **-g**  
    &nbsp;&nbsp;&nbsp;&nbsp;Print the threshold value in shell script style  
    **--help**  
    &nbsp;&nbsp;&nbsp;&nbsp;Print usage summary  
    **--verbose**  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    **--quiet**  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    **--qq**  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    **--ui**  
    &nbsp;&nbsp;&nbsp;&nbsp;Force launching GUI dialog

=== "Python (grass.script)"

    **acc** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of accumulation raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *acc*  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *g*  
    &nbsp;&nbsp;&nbsp;&nbsp;**g**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Print the threshold value in shell script style  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

=== "Python (grass.tools)"

    **acc** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of accumulation raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *acc*  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *g*  
    &nbsp;&nbsp;&nbsp;&nbsp;**g**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Print the threshold value in shell script style  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

    Returns:

    **result** : grass.tools.support.ToolResult | None  
    If the tool produces text as standard output, a *ToolResult* object will be returned. Otherwise, `None` will be returned.

    Raises:

    *grass.tools.ToolError*: When the tool ended with an error.

## DESCRIPTION

*r.threshold* finds optimal threshold for stream extraction.

## NOTES

The module finds a first tentative value of upslope area to be used as
input to extract the river network using *r.stream.extract* or
*r.watershed*. Real streams depend on many factors, such as rainfall,
infiltration rate, geology, climate etc. i.e. the same topography in
different parts of the world yields different real stream networks. This
approach provides a best guess about what makes sense when looking only
at the DEM.

## EXAMPLE

```sh
r.threshold acc=accumulation_map
```

## SEE ALSO

*[r.stream.extract](https://grass.osgeo.org/grass-stable/manuals/r.stream.extract.html),
[r.watershed](https://grass.osgeo.org/grass-stable/manuals/r.watershed.html)*

## AUTHOR

Margherita Di Leo (dileomargherita AT gmail DOT com)

## SOURCE CODE

Available at: [r.threshold source code](https://github.com/OSGeo/grass-addons/tree/grass8/src/raster/r.threshold)
([history](https://github.com/OSGeo/grass-addons/commits/grass8/src/raster/r.threshold))  
Latest change: Thursday Feb 20 13:02:26 2025 in commit [53de819](https://github.com/OSGeo/grass-addons/commit/53de8196a10ba5a8a9121898ce87861d227137e3)
