---
name: r.to.vect.lines.py
description: Convert raster rows to vector lines.
keywords: [ raster, conversion, wiggles ]
---

# r.to.vect.lines.py

Convert raster rows to vector lines.

=== "Command line"

    **r.to.vect.lines.py**
    [**-v**]
    **input**=*name*
    **output**=*name*
    [**skip**=*integer*]
    [**--overwrite**]
    [**--verbose**]
    [**--quiet**]
    [**--qq**]
    [**--ui**]

    Example:

    ```sh
    r.to.vect.lines.py input=name output=name
    ```

=== "Python (grass.script)"

    *grass.script.run_command*("***r.to.vect.lines.py***",
        **input**,
        **output**,
        **skip**=*10*,
        **flags**=*None*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    gs.run_command("r.to.vect.lines.py", input="name", output="name")
    ```

=== "Python (grass.tools)"

    *grass.tools.Tools.r_to_vect_lines_py*(**input**,
        **output**,
        **skip**=*10*,
        **flags**=*None*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    tools = Tools()
    tools.r_to_vect_lines_py(input="name", output="name")
    ```

    This grass.tools API is experimental in version 8.5 and expected to be stable in version 8.6.

## Parameters

=== "Command line"

    **input**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input raster map  
    **output**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output vector map  
    **skip**=*integer*  
    &nbsp;&nbsp;&nbsp;&nbsp;Sample every Nth grid row  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *1-100000*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *10*  
    **-v**  
    &nbsp;&nbsp;&nbsp;&nbsp;Sample vertically (default is to sample horizontally)  
    **--overwrite**  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    **--help**  
    &nbsp;&nbsp;&nbsp;&nbsp;Print usage summary  
    **--verbose**  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    **--quiet**  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    **--qq**  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    **--ui**  
    &nbsp;&nbsp;&nbsp;&nbsp;Force launching GUI dialog

=== "Python (grass.script)"

    **input** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **output** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output vector map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, vector, *name*  
    **skip** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Sample every Nth grid row  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *1-100000*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *10*  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *v*  
    &nbsp;&nbsp;&nbsp;&nbsp;**v**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Sample vertically (default is to sample horizontally)  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

=== "Python (grass.tools)"

    **input** : str | np.ndarray, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **output** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output vector map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, vector, *name*  
    **skip** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Sample every Nth grid row  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *1-100000*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *10*  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *v*  
    &nbsp;&nbsp;&nbsp;&nbsp;**v**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Sample vertically (default is to sample horizontally)  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

    Returns:

    **result** : grass.tools.support.ToolResult | None  
    If the tool produces text as standard output, a *ToolResult* object will be returned. Otherwise, `None` will be returned.

    Raises:

    *grass.tools.ToolError*: When the tool ended with an error.

## NOTES

Extracts rows from a raster map as 3D vector lines.

Reads a raster map, writes to a vector map.

Doesn't check if output map already exists. (fixme)

The category given to the line refers to the row number. (starting with
category 0\!)

Nulls within a row are skipped, so holes will be filled by a straight
line. (fixme) Nulls at the ends of lines are not included in the output
line.

Nulls are not handled very well and may sneak through as very negative
numbers. (fixme)

## EXAMPLE

Display a wiggle plot in NVIZ:  
(Spearfish dataset)

```sh
g.region raster=elevation.dem
r.to.vect.lines.py in=elevation.dem out=wiggle_lines
eval `v.info -g wiggle_lines`
r.mapcalc "floor = $bottom"
nviz elev=floor vector=wiggle_lines

# alternative
m.nviz.image elevation_map=floor vline=wiggle_lines resolution_fine=1 \
  zexag=20 out=wiggle.png perspective=5
```

![image-alt](r_to_vect_lines_example.png)

## SEE ALSO

*[r.to.vect](https://grass.osgeo.org/grass-stable/manuals/r.to.vect.html),
[v.in.lines](https://grass.osgeo.org/grass-stable/manuals/v.in.lines.html)*

## AUTHOR

Hamish Bowman  
*Dept. of Geology  
University of Otago  
Dunedin, New Zealand*

## SOURCE CODE

Available at: [r.to.vect.lines source code](https://github.com/OSGeo/grass-addons/tree/grass8/src/raster/r.to.vect.lines)
([history](https://github.com/OSGeo/grass-addons/commits/grass8/src/raster/r.to.vect.lines))  
Latest change: Thursday Feb 20 13:02:26 2025 in commit [53de819](https://github.com/OSGeo/grass-addons/commit/53de8196a10ba5a8a9121898ce87861d227137e3)
