---
name: r.traveltime
description: Estimation of travel times/isochrones. Computes the travel time of surface runoff to an outlet
keywords: [ raster, hydrology ]
---

# r.traveltime

Estimation of travel times/isochrones.

Computes the travel time of surface runoff to an outlet

=== "Command line"

    **r.traveltime**
    [**-q**]
    **dir**=*name*
    **accu**=*name*
    **dtm**=*name*
    **manningsn**=*name*
    **out_x**=*string*
    **out_y**=*string*
    **threshold**=*string*
    **b**=*string*
    **nchannel**=*string*
    **dis**=*string*
    [**slopemin**=*string*]
    **out**=*name*
    [**--overwrite**]
    [**--verbose**]
    [**--quiet**]
    [**--qq**]
    [**--ui**]

    Example:

    ```sh
    r.traveltime dir=name accu=name dtm=name manningsn=name out_x=string out_y=string threshold=string b=string nchannel=string dis=string out=name
    ```

=== "Python (grass.script)"

    *grass.script.run_command*("***r.traveltime***",
        **dir**,
        **accu**,
        **dtm**,
        **manningsn**,
        **out_x**,
        **out_y**,
        **threshold**,
        **b**,
        **nchannel**,
        **dis**,
        **slopemin**=*None*,
        **out**,
        **flags**=*None*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    gs.run_command("r.traveltime", dir="name", accu="name", dtm="name", manningsn="name", out_x="string", out_y="string", threshold="string", b="string", nchannel="string", dis="string", out="name")
    ```

=== "Python (grass.tools)"

    *grass.tools.Tools.r_traveltime*(**dir**,
        **accu**,
        **dtm**,
        **manningsn**,
        **out_x**,
        **out_y**,
        **threshold**,
        **b**,
        **nchannel**,
        **dis**,
        **slopemin**=*None*,
        **out**,
        **flags**=*None*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    tools = Tools()
    tools.r_traveltime(dir="name", accu="name", dtm="name", manningsn="name", out_x="string", out_y="string", threshold="string", b="string", nchannel="string", dis="string", out="name")
    ```

    This grass.tools API is experimental in version 8.5 and expected to be stable in version 8.6.

## Parameters

=== "Command line"

    **dir**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Flow direction map (e.g. derived by r.watershed)  
    **accu**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Flow accumulation map (e.g. derived by r.watershed)  
    **dtm**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Depressionless, filled terrain model (e.g. derived by r.fill.dir)  
    **manningsn**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Map with Manning's n value for surface roughness  
    **out_x**=*string* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;x coordinate of basin outlet  
    **out_y**=*string* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;y coordinate of basin outlet  
    **threshold**=*string* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Minimum number of cells (threshold) that classify cell as channel  
    **b**=*string* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Channel width  
    **nchannel**=*string* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Channel roughness (Manning's n)  
    **dis**=*string* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Specific discharge [l/s/km\*\*2]  
    **slopemin**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;Minimum slope for flat areas [m/m]  
    **out**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Output travel time map [seconds]  
    **-q**  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet  
    **--overwrite**  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    **--help**  
    &nbsp;&nbsp;&nbsp;&nbsp;Print usage summary  
    **--verbose**  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    **--quiet**  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    **--qq**  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    **--ui**  
    &nbsp;&nbsp;&nbsp;&nbsp;Force launching GUI dialog

=== "Python (grass.script)"

    **dir** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Flow direction map (e.g. derived by r.watershed)  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **accu** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Flow accumulation map (e.g. derived by r.watershed)  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **dtm** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Depressionless, filled terrain model (e.g. derived by r.fill.dir)  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **manningsn** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Map with Manning's n value for surface roughness  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **out_x** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;x coordinate of basin outlet  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster  
    **out_y** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;y coordinate of basin outlet  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster  
    **threshold** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Minimum number of cells (threshold) that classify cell as channel  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster  
    **b** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Channel width  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster  
    **nchannel** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Channel roughness (Manning's n)  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster  
    **dis** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Specific discharge [l/s/km\*\*2]  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster  
    **slopemin** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Minimum slope for flat areas [m/m]  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster  
    **out** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Output travel time map [seconds]  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, raster, *name*  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *q*  
    &nbsp;&nbsp;&nbsp;&nbsp;**q**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Quiet  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

=== "Python (grass.tools)"

    **dir** : str | np.ndarray, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Flow direction map (e.g. derived by r.watershed)  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **accu** : str | np.ndarray, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Flow accumulation map (e.g. derived by r.watershed)  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **dtm** : str | np.ndarray, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Depressionless, filled terrain model (e.g. derived by r.fill.dir)  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **manningsn** : str | np.ndarray, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Map with Manning's n value for surface roughness  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **out_x** : str | np.ndarray, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;x coordinate of basin outlet  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster  
    **out_y** : str | np.ndarray, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;y coordinate of basin outlet  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster  
    **threshold** : str | np.ndarray, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Minimum number of cells (threshold) that classify cell as channel  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster  
    **b** : str | np.ndarray, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Channel width  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster  
    **nchannel** : str | np.ndarray, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Channel roughness (Manning's n)  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster  
    **dis** : str | np.ndarray, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Specific discharge [l/s/km\*\*2]  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster  
    **slopemin** : str | np.ndarray, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Minimum slope for flat areas [m/m]  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster  
    **out** : str | type(np.ndarray) | type(np.array) | type(gs.array.array), *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Output travel time map [seconds]  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, raster, *name*  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *q*  
    &nbsp;&nbsp;&nbsp;&nbsp;**q**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Quiet  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

    Returns:

    **result** : grass.tools.support.ToolResult | np.ndarray | tuple[np.ndarray] | None  
    If the tool produces text as standard output, a *ToolResult* object will be returned. Otherwise, `None` will be returned. If an array type (e.g., *np.ndarray*) is used for one of the raster outputs, the result will be an array and will have the shape corresponding to the computational region. If an array type is used for more than one raster output, the result will be a tuple of arrays.

    Raises:

    *grass.tools.ToolError*: When the tool ended with an error.

## DESCRIPTION

*r.traveltime* computes the travel time of surface runoff to an outlet.
The program starts at the basin outlet and calculates the travel time
for each raster cell recursively. A drainage area related threshold
considers either surface runoff or channel runoff. Travel times are
derived by assuming kinematic wave approximation.  
In order to derive channel flow velocities, an equilibrium discharge for
each cell is calculated (Q=Area\*specific discharge).  
The results can be used to derive a time-area function. This might be
useful for precipitation-runoff calculations (estimation of flood
predictions) with a lumped hydrological model (user-specified unit
hydrograph).

## REMARKS

The program ist restricted to SI units (meters). The algorithm is
recursive. Maybe it will not work with extensive datasets. It is assumed
that the minimum slope is 0.001. For smaller gradients the program uses
this value.  
Please not that the flow accumulation map must be defined as single
direction. Multiple flow directions are not supported. Thus, the "SFD
(D8) flow" option has to be set if, e.g., the r.watershed module is used
to generate the input files (parameter s). The flow accumulation map
should include positive values only (-a of r.watershed). Flow direction
definitions are in accordance to the r.fill.dir program using the
"agnps" format option.

## KNOWN ISSUES

The program does not work correctly if Manning's roughness grid is
defined as double (float expected). To define a simple uniform roughness
distribution try: r.mapcalc 'roughness = 0.1f'

## EXAMPLE

*This example uses the North Carolina sample dataset.*

```sh
g.region raster=elevation
r.mapcalc "n = 0.1f"
r.fill.dir input=elevation output=fill direction=flowdir format=agnps
r.fill.dir input=fill output=fill2 direction=flowdir2 format=agnps
r.watershed -a -s elevation=fill2 accumulation=accu
r.traveltime --overwrite dir=flowdir2 accu=accu dtm=fill2 manningsn=n \
    out_x=634613 out_y=217014 threshold=250 b=3 nchannel=0.03 slopemin=0.01 \
    dis=900 out=ttime
r.colors ttime colors=blues
```

![image-alt](r_traveltime.png)  

## SEE ALSO

*[r.watershed](https://grass.osgeo.org/grass-stable/manuals/r.watershed.html),
[r.fill.dir](https://grass.osgeo.org/grass-stable/manuals/r.fill.dir.html)*  
<https://jesbergwetter.twoday.net/stories/4845555/>

## REFERENCES

- Kilgore, J. L. (1997): *Development and evaluation of a GIS-based
    spatially distributed unit hydrograph model*, master thesis,
    Virginia Polytechnic Institute and State University.
- Melesse, A. M., Graham, W. D. (2004): *Storm runoff predicition
    based on a spatially distributed travel time method utilizing remote
    sensing and GIS*, Journal of the American Water Resources
    Association, 8, 863-879.
- Muzik, I. (1996): *Flood modelling with GIS-derived distributed unit
    hydrographs*, Hydrological Processes, 10, 1401-1409.

## AUTHOR

Kristian Foerster

## SOURCE CODE

Available at: [r.traveltime source code](https://github.com/OSGeo/grass-addons/tree/grass8/src/raster/r.traveltime)
([history](https://github.com/OSGeo/grass-addons/commits/grass8/src/raster/r.traveltime))  
Latest change: Friday Feb 21 10:10:05 2025 in commit [7d78fe3](https://github.com/OSGeo/grass-addons/commit/7d78fe34868674c3b6050ba1924e1c5675d155c9)
