---
name: r.viewshed.cva.py
description: Undertakes a "cumulative viewshed analysis" using a vector points map as input "viewing" locations, using r.viewshed to calculate the individual viewsheds.
keywords: [ raster, viewshed, line of sight, LOS ]
---

# r.viewshed.cva.py

Undertakes a "cumulative viewshed analysis" using a vector points map as input "viewing" locations, using r.viewshed to calculate the individual viewsheds.

=== "Command line"

    **r.viewshed.cva.py**
    [**-kcrbe**]
    **input**=*name*
    **vector**=*name*
    **output**=*name*
    [**observer_elevation**=*float*]
    [**target_elevation**=*float*]
    [**max_distance**=*float*]
    [**memory**=*integer*]
    [**refraction_coeff**=*float*]
    [**name_column**=*name*]
    [**--overwrite**]
    [**--verbose**]
    [**--quiet**]
    [**--qq**]
    [**--ui**]

    Example:

    ```sh
    r.viewshed.cva.py input=name vector=name output=name
    ```

=== "Python (grass.script)"

    *grass.script.run_command*("***r.viewshed.cva.py***",
        **input**,
        **vector**,
        **output**,
        **observer_elevation**=*1.75*,
        **target_elevation**=*1.75*,
        **max_distance**=*-1*,
        **memory**=*500*,
        **refraction_coeff**=*0.14286*,
        **name_column**=*None*,
        **flags**=*None*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    gs.run_command("r.viewshed.cva.py", input="name", vector="name", output="name")
    ```

=== "Python (grass.tools)"

    *grass.tools.Tools.r_viewshed_cva_py*(**input**,
        **vector**,
        **output**,
        **observer_elevation**=*1.75*,
        **target_elevation**=*1.75*,
        **max_distance**=*-1*,
        **memory**=*500*,
        **refraction_coeff**=*0.14286*,
        **name_column**=*None*,
        **flags**=*None*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    tools = Tools()
    tools.r_viewshed_cva_py(input="name", vector="name", output="name")
    ```

    This grass.tools API is experimental in version 8.5 and expected to be stable in version 8.6.

## Parameters

=== "Command line"

    **input**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Input elevation map (DEM)  
    **vector**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input vector map  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input vector points map containg the set of points for this analysis.  
    **output**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Output cumulative viewshed raster  
    **observer_elevation**=*float*  
    &nbsp;&nbsp;&nbsp;&nbsp;Height of observation points off the ground  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1.75*  
    **target_elevation**=*float*  
    &nbsp;&nbsp;&nbsp;&nbsp;Height of target areas off the ground  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1.75*  
    **max_distance**=*float*  
    &nbsp;&nbsp;&nbsp;&nbsp;Maximum visibility radius. By default infinity (-1)  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *-1*  
    **memory**=*integer*  
    &nbsp;&nbsp;&nbsp;&nbsp;Amount of memory to use (in MB)  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *500*  
    **refraction_coeff**=*float*  
    &nbsp;&nbsp;&nbsp;&nbsp;Refraction coefficient (with flag -r)  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *0.0-1.0*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *0.14286*  
    **name_column**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Database column for point names (with flag -k)  
    **-k**  
    &nbsp;&nbsp;&nbsp;&nbsp;Keep all interim viewshed maps produced by the routine (maps will be named "vshed_'name'_uniquenumber", where 'name' is the value in "name_column" for each input point. If no value specified in "name_column", cat value will be used instead)  
    **-c**  
    &nbsp;&nbsp;&nbsp;&nbsp;Consider the curvature of the earth (current ellipsoid)  
    **-r**  
    &nbsp;&nbsp;&nbsp;&nbsp;Consider the effect of atmospheric refraction  
    **-b**  
    &nbsp;&nbsp;&nbsp;&nbsp;Output format is {0 (invisible) 1 (visible)}  
    **-e**  
    &nbsp;&nbsp;&nbsp;&nbsp;Output format is invisible = NULL, else current elev - viewpoint_elev  
    **--overwrite**  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    **--help**  
    &nbsp;&nbsp;&nbsp;&nbsp;Print usage summary  
    **--verbose**  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    **--quiet**  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    **--qq**  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    **--ui**  
    &nbsp;&nbsp;&nbsp;&nbsp;Force launching GUI dialog

=== "Python (grass.script)"

    **input** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Input elevation map (DEM)  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **vector** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input vector map  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input vector points map containg the set of points for this analysis.  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, vector, *name*  
    **output** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Output cumulative viewshed raster  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, raster, *name*  
    **observer_elevation** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Height of observation points off the ground  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1.75*  
    **target_elevation** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Height of target areas off the ground  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1.75*  
    **max_distance** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Maximum visibility radius. By default infinity (-1)  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *-1*  
    **memory** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Amount of memory to use (in MB)  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *500*  
    **refraction_coeff** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Refraction coefficient (with flag -r)  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *0.0-1.0*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *0.14286*  
    **name_column** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Database column for point names (with flag -k)  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, dbcolumn, *name*  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *k*, *c*, *r*, *b*, *e*  
    &nbsp;&nbsp;&nbsp;&nbsp;**k**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Keep all interim viewshed maps produced by the routine (maps will be named "vshed_'name'_uniquenumber", where 'name' is the value in "name_column" for each input point. If no value specified in "name_column", cat value will be used instead)  
    &nbsp;&nbsp;&nbsp;&nbsp;**c**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Consider the curvature of the earth (current ellipsoid)  
    &nbsp;&nbsp;&nbsp;&nbsp;**r**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Consider the effect of atmospheric refraction  
    &nbsp;&nbsp;&nbsp;&nbsp;**b**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Output format is {0 (invisible) 1 (visible)}  
    &nbsp;&nbsp;&nbsp;&nbsp;**e**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Output format is invisible = NULL, else current elev - viewpoint_elev  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

=== "Python (grass.tools)"

    **input** : str | np.ndarray, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Input elevation map (DEM)  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **vector** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input vector map  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input vector points map containg the set of points for this analysis.  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, vector, *name*  
    **output** : str | type(np.ndarray) | type(np.array) | type(gs.array.array), *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Output cumulative viewshed raster  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, raster, *name*  
    **observer_elevation** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Height of observation points off the ground  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1.75*  
    **target_elevation** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Height of target areas off the ground  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1.75*  
    **max_distance** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Maximum visibility radius. By default infinity (-1)  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *-1*  
    **memory** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Amount of memory to use (in MB)  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *500*  
    **refraction_coeff** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Refraction coefficient (with flag -r)  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *0.0-1.0*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *0.14286*  
    **name_column** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Database column for point names (with flag -k)  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, dbcolumn, *name*  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *k*, *c*, *r*, *b*, *e*  
    &nbsp;&nbsp;&nbsp;&nbsp;**k**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Keep all interim viewshed maps produced by the routine (maps will be named "vshed_'name'_uniquenumber", where 'name' is the value in "name_column" for each input point. If no value specified in "name_column", cat value will be used instead)  
    &nbsp;&nbsp;&nbsp;&nbsp;**c**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Consider the curvature of the earth (current ellipsoid)  
    &nbsp;&nbsp;&nbsp;&nbsp;**r**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Consider the effect of atmospheric refraction  
    &nbsp;&nbsp;&nbsp;&nbsp;**b**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Output format is {0 (invisible) 1 (visible)}  
    &nbsp;&nbsp;&nbsp;&nbsp;**e**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Output format is invisible = NULL, else current elev - viewpoint_elev  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

    Returns:

    **result** : grass.tools.support.ToolResult | np.ndarray | tuple[np.ndarray] | None  
    If the tool produces text as standard output, a *ToolResult* object will be returned. Otherwise, `None` will be returned. If an array type (e.g., *np.ndarray*) is used for one of the raster outputs, the result will be an array and will have the shape corresponding to the computational region. If an array type is used for more than one raster output, the result will be a tuple of arrays.

    Raises:

    *grass.tools.ToolError*: When the tool ended with an error.

## DESCRIPTION

*r.viewshed.cva* is a module that allows for the construction of
"Cumulative Viewshed", or "visualscape" maps from a series of input
points stored in a vector points map. The routine is a python wrapper
script that iterative loops through each input point, calculating a
viewshed map, and then creates an output map that is coded by the number
of input locations that can "see" each cell. *r.viewshed.cva* uses the
GRASS GIS module *r.viewshed* for the viewshed analysis. *r.viewshed* is
very fast, thus allowing for a cumulative viewshed analysis to run in a
reasonable amount of time. The final cumulative viewshed map is computed
using the "count" method of *r.series*, rather than with mapcalc, as it
better handles the null values in the individual constituent viewshed
maps (and allows for interim viewshed maps to be coded in any way).

### Options and flags

*r.viewshed.cva* requires an input elevation map, **input**, and an
input vector points map, **vector**. There is currently only one native
flag for *r.viewshed.cva*, **-k**, which allows you to keep the interim
viewshed maps made for each input point. Optionally, option
**name\_column** can be used with **-k** to specify the suffix of the
kept viewshed maps by a particular column in the input vector points'
database. If no value is specified for **name\_column**, then the cat
value will be used.

All other flags and options are inherited from *r.viewshed* (see the
*[r.viewshed](https://grass.osgeo.org/grass-stable/manuals/r.viewshed.html)*
help page for more information on these).

## NOTES

The input vector points map can be manually digitized (with *v.digit*)
over topographic or cultural features, or can be created as a series of
random points (with *r.random* or *v.random*). Note that using the flag
-k allows you to keep any interim viewshed maps created during the
analysis, and these resultant viewshed maps will be named according to
the cat number of the original input points. This is also useful for
simple creating a large number of individual viewsheds from points in a
vector file.

An automated summit extraction can be done with **r.geomorphon**.

## EXAMPLES

Undertake a cumulative viewshed analysis from a digitized vector points
map of prominent peaks in a region (North Carolina sample dataset):  

```sh
g.region raster=elevation -p
# use v.digit to digitize points or e.g. the r.geomorphon addon for summits
r.viewshed.cva input=elevation output=peaks_CVA_map \
  vector=prominent_peaks_points name_column=cat \
  observer_elevation=1.75 target_elevation=0
```

Undertake a cumulative viewshed analysis from a 10% sample of landscape
locations in a region:  

```sh
g.region raster=elevation -p
r.random input=elevation n=10% vector=rand_points_10p
r.viewshed.cva input=elevation output=peaks_CVA_map \
  vector=rand_points_10p name_column=cat \
  observer_elevation=1.75 target_elevation=0
```

## SEE ALSO

*[r.geomorphon](https://grass.osgeo.org/grass-stable/manuals/r.geomorphon.html),
[r.viewshed](https://grass.osgeo.org/grass-stable/manuals/r.viewshed.html)*

## AUTHOR

Isaac Ullah

## SOURCE CODE

Available at: [r.viewshed.cva source code](https://github.com/OSGeo/grass-addons/tree/grass8/src/raster/r.viewshed.cva)
([history](https://github.com/OSGeo/grass-addons/commits/grass8/src/raster/r.viewshed.cva))  
Latest change: Wednesday Feb 26 13:08:15 2025 in commit [40dada2](https://github.com/OSGeo/grass-addons/commit/40dada2f2d1e7f2af128c5b5a3e74a0da5019f1c)
