---
name: r.vol.dem
description: Creates a 3D raster model (voxels) from a series of raster DEMs
keywords: [ raster, volume, conversion ]
---

# r.vol.dem

Creates a 3D raster model (voxels) from a series of raster DEMs

=== "Command line"

    **r.vol.dem**
    [**-cfgpqsvz**]
    **input**=*name* [,*name*,...]
    **output**=*name*
    [**labels**=*float*]
    [**colors**=*string*]
    [**errormap**=*name*]
    [**algorithm**=*string*]
    [**--overwrite**]
    [**--verbose**]
    [**--quiet**]
    [**--qq**]
    [**--ui**]

    Example:

    ```sh
    r.vol.dem input=name output=name
    ```

=== "Python (grass.script)"

    *grass.script.run_command*("***r.vol.dem***",
        **input**,
        **output**,
        **labels**=*None*,
        **colors**=*None*,
        **errormap**=*None*,
        **algorithm**=*"up"*,
        **flags**=*None*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    gs.run_command("r.vol.dem", input="name", output="name")
    ```

=== "Python (grass.tools)"

    *grass.tools.Tools.r_vol_dem*(**input**,
        **output**,
        **labels**=*None*,
        **colors**=*None*,
        **errormap**=*None*,
        **algorithm**=*"up"*,
        **flags**=*None*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    tools = Tools()
    tools.r_vol_dem(input="name", output="name")
    ```

    This grass.tools API is experimental in version 8.5 and expected to be stable in version 8.6.

## Parameters

=== "Command line"

    **input**=*name* [,*name*,...] **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Input DEMs (at least 2) in raster format. Bottom DEM first  
    **output**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output 3D raster map  
    **labels**=*float*  
    &nbsp;&nbsp;&nbsp;&nbsp;List of label values, one for each 3D layer  
    **colors**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;List of RRR:GGG:BBB color triplets, one for each layer  
    **errormap**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Raster map to represent topology errors in input DEMs  
    **algorithm**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;3D flood fill algorithm to use  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *up, down*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *up*  
    **-c**  
    &nbsp;&nbsp;&nbsp;&nbsp;Calculate 3D cell counts for each layer.  
    **-f**  
    &nbsp;&nbsp;&nbsp;&nbsp;Fill through NULL value areas in DEMs  
    **-g**  
    &nbsp;&nbsp;&nbsp;&nbsp;Export voxel model as vector points  
    **-p**  
    &nbsp;&nbsp;&nbsp;&nbsp;Export VTK point data instead of cell data  
    **-q**  
    &nbsp;&nbsp;&nbsp;&nbsp;Disable on-screen progress display  
    **-s**  
    &nbsp;&nbsp;&nbsp;&nbsp;Skip topology error checking  
    **-v**  
    &nbsp;&nbsp;&nbsp;&nbsp;Generate a .vtk file for visualisation with e.g. paraview  
    **-z**  
    &nbsp;&nbsp;&nbsp;&nbsp;Fit active region's Z range to input DEMs  
    **--overwrite**  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    **--help**  
    &nbsp;&nbsp;&nbsp;&nbsp;Print usage summary  
    **--verbose**  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    **--quiet**  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    **--qq**  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    **--ui**  
    &nbsp;&nbsp;&nbsp;&nbsp;Force launching GUI dialog

=== "Python (grass.script)"

    **input** : str | list[str], *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Input DEMs (at least 2) in raster format. Bottom DEM first  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **output** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output 3D raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, raster_3d, *name*  
    **labels** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;List of label values, one for each 3D layer  
    **colors** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;List of RRR:GGG:BBB color triplets, one for each layer  
    **errormap** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Raster map to represent topology errors in input DEMs  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, raster, *name*  
    **algorithm** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;3D flood fill algorithm to use  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *up, down*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *up*  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *c*, *f*, *g*, *p*, *q*, *s*, *v*, *z*  
    &nbsp;&nbsp;&nbsp;&nbsp;**c**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Calculate 3D cell counts for each layer.  
    &nbsp;&nbsp;&nbsp;&nbsp;**f**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Fill through NULL value areas in DEMs  
    &nbsp;&nbsp;&nbsp;&nbsp;**g**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Export voxel model as vector points  
    &nbsp;&nbsp;&nbsp;&nbsp;**p**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Export VTK point data instead of cell data  
    &nbsp;&nbsp;&nbsp;&nbsp;**q**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Disable on-screen progress display  
    &nbsp;&nbsp;&nbsp;&nbsp;**s**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Skip topology error checking  
    &nbsp;&nbsp;&nbsp;&nbsp;**v**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Generate a .vtk file for visualisation with e.g. paraview  
    &nbsp;&nbsp;&nbsp;&nbsp;**z**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Fit active region's Z range to input DEMs  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

=== "Python (grass.tools)"

    **input** : str | list[str], *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Input DEMs (at least 2) in raster format. Bottom DEM first  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **output** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output 3D raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, raster_3d, *name*  
    **labels** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;List of label values, one for each 3D layer  
    **colors** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;List of RRR:GGG:BBB color triplets, one for each layer  
    **errormap** : str | type(np.ndarray) | type(np.array) | type(gs.array.array), *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Raster map to represent topology errors in input DEMs  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, raster, *name*  
    **algorithm** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;3D flood fill algorithm to use  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *up, down*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *up*  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *c*, *f*, *g*, *p*, *q*, *s*, *v*, *z*  
    &nbsp;&nbsp;&nbsp;&nbsp;**c**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Calculate 3D cell counts for each layer.  
    &nbsp;&nbsp;&nbsp;&nbsp;**f**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Fill through NULL value areas in DEMs  
    &nbsp;&nbsp;&nbsp;&nbsp;**g**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Export voxel model as vector points  
    &nbsp;&nbsp;&nbsp;&nbsp;**p**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Export VTK point data instead of cell data  
    &nbsp;&nbsp;&nbsp;&nbsp;**q**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Disable on-screen progress display  
    &nbsp;&nbsp;&nbsp;&nbsp;**s**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Skip topology error checking  
    &nbsp;&nbsp;&nbsp;&nbsp;**v**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Generate a .vtk file for visualisation with e.g. paraview  
    &nbsp;&nbsp;&nbsp;&nbsp;**z**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Fit active region's Z range to input DEMs  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

    Returns:

    **result** : grass.tools.support.ToolResult | np.ndarray | tuple[np.ndarray] | None  
    If the tool produces text as standard output, a *ToolResult* object will be returned. Otherwise, `None` will be returned. If an array type (e.g., *np.ndarray*) is used for one of the raster outputs, the result will be an array and will have the shape corresponding to the computational region. If an array type is used for more than one raster output, the result will be a tuple of arrays.

    Raises:

    *grass.tools.ToolError*: When the tool ended with an error.

## DESCRIPTION

*r.vol.dem* interpolates a voxel model from a series of DEMs by flood
filling the voxel space in between. The module is able to calculate
voxel maps between at least two DEMs. The algorithm is based on a
so-called "Flood-filling" algorithm. Since a date, label or category
number of an e.g., archaeological stratum represents always the value
for the entire stratum it would be more suitable to fill the entire 3D
unit with this single value.

The input bottom and top DEMs represent each the bottom and top border
for the "voxeled" stratum, in this case the implicit structure. Before
running the *r.vol.dem* module, one needs to adjust the
three-dimensional extent of the 3D interpolation which works as an
analytical mask in the GRASS GIS module *g.region*. This procedure
adjusts additionally the voxel's size which influences the 3D resolution
of the entire stratum. Furthermore, it is possible to adjust the height
and width of the voxel in order to obtain a cube or cuboid voxel shape.
In general, the smaller the voxel's size the higher the resolution, the
more precise 3D units.

## NOTES

The input data for the 3D interpolation which requires at least two
raster DEMs. They have to be entered in a certain rank, with the lowest,
according to elevation, DEM first.

The list of label values is one for each 3D layer (labels=value): Since
one can enter an infinite number of DEMs it is possible adjust certain
labels for each 3D layer. If they are not specified, labelling starts
with layer 0. The numbers are given always upwards disregarding the
algorithm direction.

The *errormap* raster map is to represent topology errors in input DEMs.
This option does not yet create a real map but gives the coordinates
where intersections of DEMs occur.

The *algorithm* parameter is used to select the 3D flood fill algorithm
to use. The user can chose between an up or down filling direction. The
default adjustment is the upwards algorithm. The results can become very
different according to the shape and extension of the DEMs.

The *-c* flag calculates 3D cell counts for each layer: This option
counts the number of voxels for each 3D layer label. Unfortunately, this
count is not stored in the *r3.info* information. Thus, if one needs
this information afterwards, one has to repeat the whole calculation.

The *-f* flag fills through NULL value areas in DEMs: Null value areas
are areas which lie outside a 3D layer defined by two successive DEMs in
the input command. In the case, where a 3D layer is limited not only
from one unit surface, e.g. on top, this flag allows a further 3D
interpolation until the next DEM or the region's margin.

![image-alt](r_vol_dem_layerdown.jpg)  
Layer down NULL filling behaviour of *r.vol.dem*

![image-alt](r_vol_dem_layerup.jpg)  
Layer up NULL filling behaviour of *r.vol.dem*

The *-g* flag exports voxel model as vector points: This option creates
a vector point for each interpolated voxel. This became necessary
because of the lack of suitable representation in the visualisation
module nivz in GRASS GIS 6. Nevertheless, the points can be represented
virtually as cubes in nviz which gives an idea of the voxel layer.
Unfortunately, there is still an error in the module using this flag
(state 01.06.2006) that can be corrected by the following procedure: The
module *r.vol.dem* creates a temporary txt-file in the HOME directory.
Opening this file one will find a line which starts with "\#
v.in.ascii". This line needs to be copied without the \#-sign and
executed in the GRASS bash shell.

The *-p* flag exports VTK point data instead of cell data: This option
reflects the fact that the visualisation program ParaView which treats
cell data and point data differently in comparison to the program GRASS
GIS. Hence, if one wants to visualise GRASS voxel in ParaView, this flag
is recommended. The VTK floating point precision is 1/1000 of the
current GRASS location's map unit.

The *-q* flag disables on-screen progress display: This option does not
yet work.

The *-s* flag skips topology error checking: The module checks the input
DEMs for intersection before running the algorithm. If such an unwanted
intersection is found, the algorithm creates an errormap (see *errormap*
option) and stops the entire 3D interpolation process. Using this flag
one can skip this precaution.

The *-v* flag generates a vtk-file for visualisation with e.g. ParaView:
Since the GRASS visualisation module nviz is unable to show voxel as
(semitransparent) cubes, the Open Source visualisation program ParaView
is now commonly used for the visualisation of GRASS GIS maps and
especially for 3D visualisations. Hence, the output GRASS GIS files have
to be converted into a ParaView readable format.

The *-z* flag fits active region's z range to input DEMs: This option
does not yet work.

## SEE ALSO

*[g.region](https://grass.osgeo.org/grass-stable/manuals/g.region.html),
[r.to.rast3](https://grass.osgeo.org/grass-stable/manuals/r.to.rast3.html),
[r.to.rast3elev](https://grass.osgeo.org/grass-stable/manuals/r.to.rast3elev.html)*

[Screenhot gallery](http://undine-lieberwirth.info/?page_id=8)

## AUTHORS

Software: Benjamin Ducke  
Documentation: Undine Lieberwirth

## SOURCE CODE

Available at: [r.vol.dem source code](https://github.com/OSGeo/grass-addons/tree/grass8/src/raster/r.vol.dem)
([history](https://github.com/OSGeo/grass-addons/commits/grass8/src/raster/r.vol.dem))  
Latest change: Thursday Mar 20 21:36:57 2025 in commit [7286ecf](https://github.com/OSGeo/grass-addons/commit/7286ecf7af235bfd089fb9b1b82fb383cf95f3fc)
