---
name: r.width.funct.py
description: Calculates the Width Function of a watershed basin.
keywords: [ raster, hydrology ]
---

# r.width.funct.py

Calculates the Width Function of a watershed basin.

=== "Command line"

    **r.width.funct.py**
    **map**=*name*
    **image**=*image*
    [**--overwrite**]
    [**--verbose**]
    [**--quiet**]
    [**--qq**]
    [**--ui**]

    Example:

    ```sh
    r.width.funct.py map=name image=image
    ```

=== "Python (grass.script)"

    *grass.script.run_command*("***r.width.funct.py***",
        **map**,
        **image**,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    gs.run_command("r.width.funct.py", map="name", image="image")
    ```

=== "Python (grass.tools)"

    *grass.tools.Tools.r_width_funct_py*(**map**,
        **image**,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    tools = Tools()
    tools.r_width_funct_py(map="name", image="image")
    ```

    This grass.tools API is experimental in version 8.5 and expected to be stable in version 8.6.

## Parameters

=== "Command line"

    **map**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Distance to outlet map (from r.stream.distance)  
    **image**=*image* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output graph file (png)  
    **--overwrite**  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    **--help**  
    &nbsp;&nbsp;&nbsp;&nbsp;Print usage summary  
    **--verbose**  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    **--quiet**  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    **--qq**  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    **--ui**  
    &nbsp;&nbsp;&nbsp;&nbsp;Force launching GUI dialog

=== "Python (grass.script)"

    **map** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Distance to outlet map (from r.stream.distance)  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **image** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output graph file (png)  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, file, *image*  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

=== "Python (grass.tools)"

    **map** : str | np.ndarray, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Distance to outlet map (from r.stream.distance)  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **image** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output graph file (png)  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, file, *image*  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

    Returns:

    **result** : grass.tools.support.ToolResult | None  
    If the tool produces text as standard output, a *ToolResult* object will be returned. Otherwise, `None` will be returned.

    Raises:

    *grass.tools.ToolError*: When the tool ended with an error.

## DESCRIPTION

*r.width.funct* produces the Width Function of a basin. The Width
Function W(x) gives the number of the cells in a basin at a flow
distance x from the outlet (it is also referred as distance-area
function). It is important to underline the fact that the distance is
not the euclidean one, but it is measured along the flowpath towards the
outlet.

### Input

*Distance to outlet map:* Input map, required. It is obtained by
r.stream.distance (with the option: distance to outlet, flag -o).

*Output plot:* Path and name of the plot.

### Output

It provides the quantiles of the area - distance distribution and the
plot of the Width Function. In x axis is reported the distance and in y
axis is the area.

## EXAMPLE

North Carolina sample dataset example:

```sh
g.region raster=elevation -p

# Calculate flow direction
r.stream.extract elevation=elevation threshold=1000 \
direction=direction

# Create outlet point
echo "637304.924954,218617.100523" | v.in.ascii input=- sep=',' out=outlet

# Convert outlet point to raster
v.to.rast input=outlet type=point output=outlet use=cat

# Calculate distance to outlet map
r.stream.distance -o stream_rast=outlet \
direction=direction distance=dist2out

# Calculate width function
r.width.funct map=dist2out image=/tmp/my_basin
```

### Dependencies

- Matplotlib

## SEE ALSO

*[r.stream.distance](r.stream.distance.md),
[r.basin](https://grass.osgeo.org/grass-stable/manuals/r.basin.html),*

## REFERENCES

- *Rodriguez-Iturbe I., Rinaldo A. — Fractal River Basins, Chance and
    Self-Organization. Cambridge Press (2001)*
- *In Italian: Di Leo M., Di Stefano M., Claps P., Sole A. —
    Caratterizzazione morfometrica del bacino idrografico in GRASS GIS
    (Morphometric characterization of the catchment in GRASS GIS
    environment), [Geomatics
    Workbooks](https://www.geolab.polimi.it/volume-9/), n. 9 (2010)*

## AUTHORS

Margherita Di Leo (grass-dev AT lists DOT osgeo DOT org), Massimo Di
Stefano, Francesco Di Stefano

## SOURCE CODE

Available at: [r.width.funct source code](https://github.com/OSGeo/grass-addons/tree/grass8/src/raster/r.width.funct)
([history](https://github.com/OSGeo/grass-addons/commits/grass8/src/raster/r.width.funct))  
Latest change: Friday Feb 21 10:10:05 2025 in commit [7d78fe3](https://github.com/OSGeo/grass-addons/commit/7d78fe34868674c3b6050ba1924e1c5675d155c9)
