---
name: t.rast.import.netcdf.py
description: Import netCDF files that adhere to the CF convention as STRDS.
keywords: [ temporal, import, raster, time, netcdf ]
---

# t.rast.import.netcdf.py

Import netCDF files that adhere to the CF convention as STRDS.

=== "Command line"

    **t.rast.import.netcdf.py**
    [**-airlfeo**]
    **input**=*Input file(s) ("-" = stdin)*
    [**semantic_labels**=*Input file with configuration for semantic labels ("-" = stdin)*]
    [**output**=*name*]
    [**end_time**=*string*]
    [**start_time**=*string*]
    [**temporal_relations**=*string* [,*string*,...]]
    [**resample**=*string*]
    [**print**=*string*]
    [**color**=*style*]
    [**memory**=*memory in MB*]
    [**default_crs**=*Default CRS (EPSG code)*]
    [**nprocs**=*integer*]
    [**separator**=*character*]
    [**nodata**=*Source nodata* [,*Source nodata*,...]]
    [**--overwrite**]
    [**--verbose**]
    [**--quiet**]
    [**--qq**]
    [**--ui**]

    Example:

    ```sh
    t.rast.import.netcdf.py input=Input file(s) ("-" = stdin) print=extended
    ```

=== "Python (grass.script)"

    *grass.script.run_command*("***t.rast.import.netcdf.py***",
        **input**,
        **semantic_labels**=*None*,
        **output**=*None*,
        **end_time**=*None*,
        **start_time**=*None*,
        **temporal_relations**=*"equal,during,contains,overlaps,overlapped,starts,started,finishes,finished"*,
        **resample**=*"nearest"*,
        **print**=*None*,
        **color**=*"viridis"*,
        **memory**=*300*,
        **default_crs**=*None*,
        **nprocs**=*1*,
        **separator**=*"pipe"*,
        **nodata**=*None*,
        **flags**=*None*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    gs.run_command("t.rast.import.netcdf.py", input="Input file(s) ("-" = stdin)", print="extended")
    ```

=== "Python (grass.tools)"

    *grass.tools.Tools.t_rast_import_netcdf_py*(**input**,
        **semantic_labels**=*None*,
        **output**=*None*,
        **end_time**=*None*,
        **start_time**=*None*,
        **temporal_relations**=*"equal,during,contains,overlaps,overlapped,starts,started,finishes,finished"*,
        **resample**=*"nearest"*,
        **print**=*None*,
        **color**=*"viridis"*,
        **memory**=*300*,
        **default_crs**=*None*,
        **nprocs**=*1*,
        **separator**=*"pipe"*,
        **nodata**=*None*,
        **flags**=*None*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    tools = Tools()
    tools.t_rast_import_netcdf_py(input="Input file(s) ("-" = stdin)", print="extended")
    ```

    This grass.tools API is experimental in version 8.5 and expected to be stable in version 8.6.

## Parameters

=== "Command line"

    **input**=*Input file(s) ("-" = stdin)* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;URL or name of input netcdf-file ("-" = stdin)  
    **semantic_labels**=*Input file with configuration for semantic labels ("-" = stdin)*  
    &nbsp;&nbsp;&nbsp;&nbsp;File with mapping of variables or subdatasets to semantic labels  
    **output**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of the output space time raster dataset  
    **end_time**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;Latest timestamp of temporal extent to include in the output  
    &nbsp;&nbsp;&nbsp;&nbsp;Timestamp of format "YYYY-MM-DD HH:MM:SS"  
    **start_time**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;Earliest timestamp of temporal extent to include in the output  
    &nbsp;&nbsp;&nbsp;&nbsp;Timestamp of format "YYYY-MM-DD HH:MM:SS"  
    **temporal_relations**=*string* [,*string*,...]  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed temporal relation for temporal filtering  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed temporal relation between time dimension in the netCDF file and temporal window defined by start_time and end_time  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *equal, during, contains, overlaps, overlapped, starts, started, finishes, finished*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *equal,during,contains,overlaps,overlapped,starts,started,finishes,finished*  
    **resample**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;Resampling method when data is reprojected  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *nearest, bilinear, bicubic, cubicspline, lanczos, average, mode, max, min, med, Q1, Q3*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *nearest*  
    **print**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;Print metadata and exit  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *extended,  grass*  
    **color**=*style*  
    &nbsp;&nbsp;&nbsp;&nbsp;Color table to assign to imported datasets  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *aspect, aspectcolr, bcyr, bgyr, blues, byg, byr, celsius, corine, curvature, differences, elevation, etopo2, evi, fahrenheit, forest_cover, gdd, grass, greens, grey, grey.eq, grey.log, grey1.0, grey255, gyr, haxby, inferno, kelvin, magma, ndvi, ndwi, nlcd, oranges, plasma, population, population_dens, precipitation, precipitation_daily, precipitation_monthly, rainbow, ramp, random, reds, roygbiv, rstcurv, ryb, ryg, sepia, slope, soilmoisture, srtm, srtm_percent, srtm_plus, terrain, viridis, water, wave*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *viridis*  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![aspect](colortables/aspect.png) &nbsp;&nbsp;&nbsp;&nbsp;**aspect**: aspect oriented grey colors [range: map values]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![aspectcolr](colortables/aspectcolr.png) &nbsp;&nbsp;&nbsp;&nbsp;**aspectcolr**: aspect oriented rainbow colors [range: 0 to 360]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![bcyr](colortables/bcyr.png) &nbsp;&nbsp;&nbsp;&nbsp;**bcyr**: blue through cyan through yellow to red [range: map values]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![bgyr](colortables/bgyr.png) &nbsp;&nbsp;&nbsp;&nbsp;**bgyr**: blue through green through yellow to red [range: map values]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![blues](colortables/blues.png) &nbsp;&nbsp;&nbsp;&nbsp;**blues**: white to blue [range: map values]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![byg](colortables/byg.png) &nbsp;&nbsp;&nbsp;&nbsp;**byg**: blue through yellow to green [range: map values]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![byr](colortables/byr.png) &nbsp;&nbsp;&nbsp;&nbsp;**byr**: blue through yellow to red [range: map values]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![celsius](colortables/celsius.png) &nbsp;&nbsp;&nbsp;&nbsp;**celsius**: blue to red for degree Celsius temperature [range: -80 to 80]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![corine](colortables/corine.png) &nbsp;&nbsp;&nbsp;&nbsp;**corine**: EU Corine land cover colors [range: 111 to 995]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![curvature](colortables/curvature.png) &nbsp;&nbsp;&nbsp;&nbsp;**curvature**: for terrain curvatures (from v.surf.rst and r.slope.aspect) [range: map values]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![differences](colortables/differences.png) &nbsp;&nbsp;&nbsp;&nbsp;**differences**: differences oriented colors [range: map values]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![elevation](colortables/elevation.png) &nbsp;&nbsp;&nbsp;&nbsp;**elevation**: maps relative ranges of raster values to elevation color ramp [range: map values]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![etopo2](colortables/etopo2.png) &nbsp;&nbsp;&nbsp;&nbsp;**etopo2**: colors for ETOPO2 worldwide bathymetry/topography [range: -11000 to 8850]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![evi](colortables/evi.png) &nbsp;&nbsp;&nbsp;&nbsp;**evi**: enhanced vegetative index colors [range: -1 to 1]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![fahrenheit](colortables/fahrenheit.png) &nbsp;&nbsp;&nbsp;&nbsp;**fahrenheit**: blue to red for Fahrenheit temperature [range: -112 to 176]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![forest_cover](colortables/forest_cover.png) &nbsp;&nbsp;&nbsp;&nbsp;**forest_cover**: percentage of forest cover [range: 0 to 100]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![gdd](colortables/gdd.png) &nbsp;&nbsp;&nbsp;&nbsp;**gdd**: accumulated growing degree days [range: 0 to 6000]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![grass](colortables/grass.png) &nbsp;&nbsp;&nbsp;&nbsp;**grass**: GRASS green (perceptually uniform) [range: map values]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![greens](colortables/greens.png) &nbsp;&nbsp;&nbsp;&nbsp;**greens**: white to green [range: map values]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![grey](colortables/grey.png) &nbsp;&nbsp;&nbsp;&nbsp;**grey**: grey scale [range: map values]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![grey.eq](colortables/grey.eq.png) &nbsp;&nbsp;&nbsp;&nbsp;**grey.eq**: histogram-equalized grey scale [range: map values]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![grey.log](colortables/grey.log.png) &nbsp;&nbsp;&nbsp;&nbsp;**grey.log**: histogram logarithmic transformed grey scale [range: map values]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![grey1.0](colortables/grey1.0.png) &nbsp;&nbsp;&nbsp;&nbsp;**grey1.0**: grey scale for raster values between 0.0-1.0 [range: 0 to 1]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![grey255](colortables/grey255.png) &nbsp;&nbsp;&nbsp;&nbsp;**grey255**: grey scale for raster values between 0-255 [range: 0 to 255]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![gyr](colortables/gyr.png) &nbsp;&nbsp;&nbsp;&nbsp;**gyr**: green through yellow to red [range: map values]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![haxby](colortables/haxby.png) &nbsp;&nbsp;&nbsp;&nbsp;**haxby**: relative colors for bathymetry or topography [range: map values]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![inferno](colortables/inferno.png) &nbsp;&nbsp;&nbsp;&nbsp;**inferno**: perceptually uniform sequential color table inferno [range: map values]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![kelvin](colortables/kelvin.png) &nbsp;&nbsp;&nbsp;&nbsp;**kelvin**: blue to red for temperature in Kelvin scale [range: 193.15 to 353.15]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![magma](colortables/magma.png) &nbsp;&nbsp;&nbsp;&nbsp;**magma**: perceptually uniform sequential color table magma [range: map values]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![ndvi](colortables/ndvi.png) &nbsp;&nbsp;&nbsp;&nbsp;**ndvi**: Normalized Difference Vegetation Index colors [range: -1 to 1]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![ndwi](colortables/ndwi.png) &nbsp;&nbsp;&nbsp;&nbsp;**ndwi**: Normalized Difference Water Index colors [range: -200 to 200]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![nlcd](colortables/nlcd.png) &nbsp;&nbsp;&nbsp;&nbsp;**nlcd**: US National Land Cover Dataset colors [range: 0 to 95]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![oranges](colortables/oranges.png) &nbsp;&nbsp;&nbsp;&nbsp;**oranges**: white to orange [range: map values]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![plasma](colortables/plasma.png) &nbsp;&nbsp;&nbsp;&nbsp;**plasma**: perceptually uniform sequential color table plasma [range: map values]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![population](colortables/population.png) &nbsp;&nbsp;&nbsp;&nbsp;**population**: color table covering human population classification breaks [range: 0 to 2e+09]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![population_dens](colortables/population_dens.png) &nbsp;&nbsp;&nbsp;&nbsp;**population_dens**: color table covering human population density classification breaks [range: 0 to 1e+09]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![precipitation](colortables/precipitation.png) &nbsp;&nbsp;&nbsp;&nbsp;**precipitation**: precipitation color table (0..2000mm) [range: 0 to 7000]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![precipitation_daily](colortables/precipitation_daily.png) &nbsp;&nbsp;&nbsp;&nbsp;**precipitation_daily**: precipitation color table (0..1000mm) [range: 0 to 10000]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![precipitation_monthly](colortables/precipitation_monthly.png) &nbsp;&nbsp;&nbsp;&nbsp;**precipitation_monthly**: precipitation color table (0..1000mm) [range: 0 to 1000]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![rainbow](colortables/rainbow.png) &nbsp;&nbsp;&nbsp;&nbsp;**rainbow**: rainbow color table [range: map values]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![ramp](colortables/ramp.png) &nbsp;&nbsp;&nbsp;&nbsp;**ramp**: color ramp [range: map values]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![random](colortables/random.png) &nbsp;&nbsp;&nbsp;&nbsp;**random**: random color table [range: map values]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![reds](colortables/reds.png) &nbsp;&nbsp;&nbsp;&nbsp;**reds**: white to red [range: map values]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![roygbiv](colortables/roygbiv.png) &nbsp;&nbsp;&nbsp;&nbsp;**roygbiv**:  [range: map values]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![rstcurv](colortables/rstcurv.png) &nbsp;&nbsp;&nbsp;&nbsp;**rstcurv**: terrain curvature (from r.resamp.rst) [range: map values]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![ryb](colortables/ryb.png) &nbsp;&nbsp;&nbsp;&nbsp;**ryb**: red through yellow to blue [range: map values]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![ryg](colortables/ryg.png) &nbsp;&nbsp;&nbsp;&nbsp;**ryg**: red through yellow to green [range: map values]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![sepia](colortables/sepia.png) &nbsp;&nbsp;&nbsp;&nbsp;**sepia**: yellowish-brown through to white [range: map values]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![slope](colortables/slope.png) &nbsp;&nbsp;&nbsp;&nbsp;**slope**: r.slope.aspect-type slope colors for raster values 0-90 [range: 0 to 90]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![soilmoisture](colortables/soilmoisture.png) &nbsp;&nbsp;&nbsp;&nbsp;**soilmoisture**: soilmoisture color table (0.0-1.0) [range: 0 to 1]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![srtm](colortables/srtm.png) &nbsp;&nbsp;&nbsp;&nbsp;**srtm**: color palette for Shuttle Radar Topography Mission elevation [range: -11000 to 8850]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![srtm_percent](colortables/srtm_percent.png) &nbsp;&nbsp;&nbsp;&nbsp;**srtm_percent**: color palette for Shuttle Radar Topography Mission using relative elevation [range: map values]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![srtm_plus](colortables/srtm_plus.png) &nbsp;&nbsp;&nbsp;&nbsp;**srtm_plus**: color palette for Shuttle Radar Topography Mission elevation (with seafloor colors) [range: -11000 to 8850]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![terrain](colortables/terrain.png) &nbsp;&nbsp;&nbsp;&nbsp;**terrain**: global elevation color table covering -11000 to +8850m [range: -11000 to 8850]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![viridis](colortables/viridis.png) &nbsp;&nbsp;&nbsp;&nbsp;**viridis**: perceptually uniform sequential color table viridis [range: map values]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![water](colortables/water.png) &nbsp;&nbsp;&nbsp;&nbsp;**water**: water depth [range: map values]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![wave](colortables/wave.png) &nbsp;&nbsp;&nbsp;&nbsp;**wave**: color wave [range: map values]  
    **memory**=*memory in MB*  
    &nbsp;&nbsp;&nbsp;&nbsp;Maximum memory to be used (in MB)  
    &nbsp;&nbsp;&nbsp;&nbsp;Cache size for raster rows  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *300*  
    **default_crs**=*Default CRS (EPSG code)*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default Coordinate Reference System (EPSG code)  
    &nbsp;&nbsp;&nbsp;&nbsp;EPSG code to assume if a (sub-) dataset has no CRS defined  
    **nprocs**=*integer*  
    &nbsp;&nbsp;&nbsp;&nbsp;Number of threads for parallel computing  
    &nbsp;&nbsp;&nbsp;&nbsp;0: use OpenMP default; &gt;0: use nprocs; &lt;0: use MAX-nprocs  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1*  
    **separator**=*character*  
    &nbsp;&nbsp;&nbsp;&nbsp;Field separator  
    &nbsp;&nbsp;&nbsp;&nbsp;Special characters: pipe, comma, space, tab, newline  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *pipe*  
    **nodata**=*Source nodata* [,*Source nodata*,...]  
    &nbsp;&nbsp;&nbsp;&nbsp;Comma separated list of values representing nodata in the input dataset  
    **-a**  
    &nbsp;&nbsp;&nbsp;&nbsp;Append to STRDS  
    **-i**  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow incomplete CF-dimensions (XY instead of XYT)  
    **-r**  
    &nbsp;&nbsp;&nbsp;&nbsp;Import only within current region  
    **-l**  
    &nbsp;&nbsp;&nbsp;&nbsp;Link the raster files using r.external  
    **-f**  
    &nbsp;&nbsp;&nbsp;&nbsp;Link the raster files in a fast way, without reading metadata using r.external  
    **-e**  
    &nbsp;&nbsp;&nbsp;&nbsp;Extend location extents based on new dataset  
    **-o**  
    &nbsp;&nbsp;&nbsp;&nbsp;Override projection check (use current location's projection)  
    &nbsp;&nbsp;&nbsp;&nbsp;Assume that the dataset has same projection as the current location  
    **--overwrite**  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    **--help**  
    &nbsp;&nbsp;&nbsp;&nbsp;Print usage summary  
    **--verbose**  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    **--quiet**  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    **--qq**  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    **--ui**  
    &nbsp;&nbsp;&nbsp;&nbsp;Force launching GUI dialog

=== "Python (grass.script)"

    **input** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;URL or name of input netcdf-file ("-" = stdin)  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, file, *Input file(s) ("-" = stdin)*  
    **semantic_labels** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;File with mapping of variables or subdatasets to semantic labels  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, file, *Input file with configuration for semantic labels ("-" = stdin)*  
    **output** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of the output space time raster dataset  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, strds, *name*  
    **end_time** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Latest timestamp of temporal extent to include in the output  
    &nbsp;&nbsp;&nbsp;&nbsp;Timestamp of format "YYYY-MM-DD HH:MM:SS"  
    **start_time** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Earliest timestamp of temporal extent to include in the output  
    &nbsp;&nbsp;&nbsp;&nbsp;Timestamp of format "YYYY-MM-DD HH:MM:SS"  
    **temporal_relations** : str | list[str], *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed temporal relation for temporal filtering  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed temporal relation between time dimension in the netCDF file and temporal window defined by start_time and end_time  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *equal, during, contains, overlaps, overlapped, starts, started, finishes, finished*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *equal,during,contains,overlaps,overlapped,starts,started,finishes,finished*  
    **resample** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Resampling method when data is reprojected  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *nearest, bilinear, bicubic, cubicspline, lanczos, average, mode, max, min, med, Q1, Q3*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *nearest*  
    **print** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Print metadata and exit  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *extended,  grass*  
    **color** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Color table to assign to imported datasets  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, colortable, *style*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *aspect, aspectcolr, bcyr, bgyr, blues, byg, byr, celsius, corine, curvature, differences, elevation, etopo2, evi, fahrenheit, forest_cover, gdd, grass, greens, grey, grey.eq, grey.log, grey1.0, grey255, gyr, haxby, inferno, kelvin, magma, ndvi, ndwi, nlcd, oranges, plasma, population, population_dens, precipitation, precipitation_daily, precipitation_monthly, rainbow, ramp, random, reds, roygbiv, rstcurv, ryb, ryg, sepia, slope, soilmoisture, srtm, srtm_percent, srtm_plus, terrain, viridis, water, wave*  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![aspect](colortables/aspect.png) &nbsp;&nbsp;&nbsp;&nbsp;**aspect**: aspect oriented grey colors [range: map values]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![aspectcolr](colortables/aspectcolr.png) &nbsp;&nbsp;&nbsp;&nbsp;**aspectcolr**: aspect oriented rainbow colors [range: 0 to 360]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![bcyr](colortables/bcyr.png) &nbsp;&nbsp;&nbsp;&nbsp;**bcyr**: blue through cyan through yellow to red [range: map values]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![bgyr](colortables/bgyr.png) &nbsp;&nbsp;&nbsp;&nbsp;**bgyr**: blue through green through yellow to red [range: map values]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![blues](colortables/blues.png) &nbsp;&nbsp;&nbsp;&nbsp;**blues**: white to blue [range: map values]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![byg](colortables/byg.png) &nbsp;&nbsp;&nbsp;&nbsp;**byg**: blue through yellow to green [range: map values]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![byr](colortables/byr.png) &nbsp;&nbsp;&nbsp;&nbsp;**byr**: blue through yellow to red [range: map values]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![celsius](colortables/celsius.png) &nbsp;&nbsp;&nbsp;&nbsp;**celsius**: blue to red for degree Celsius temperature [range: -80 to 80]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![corine](colortables/corine.png) &nbsp;&nbsp;&nbsp;&nbsp;**corine**: EU Corine land cover colors [range: 111 to 995]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![curvature](colortables/curvature.png) &nbsp;&nbsp;&nbsp;&nbsp;**curvature**: for terrain curvatures (from v.surf.rst and r.slope.aspect) [range: map values]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![differences](colortables/differences.png) &nbsp;&nbsp;&nbsp;&nbsp;**differences**: differences oriented colors [range: map values]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![elevation](colortables/elevation.png) &nbsp;&nbsp;&nbsp;&nbsp;**elevation**: maps relative ranges of raster values to elevation color ramp [range: map values]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![etopo2](colortables/etopo2.png) &nbsp;&nbsp;&nbsp;&nbsp;**etopo2**: colors for ETOPO2 worldwide bathymetry/topography [range: -11000 to 8850]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![evi](colortables/evi.png) &nbsp;&nbsp;&nbsp;&nbsp;**evi**: enhanced vegetative index colors [range: -1 to 1]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![fahrenheit](colortables/fahrenheit.png) &nbsp;&nbsp;&nbsp;&nbsp;**fahrenheit**: blue to red for Fahrenheit temperature [range: -112 to 176]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![forest_cover](colortables/forest_cover.png) &nbsp;&nbsp;&nbsp;&nbsp;**forest_cover**: percentage of forest cover [range: 0 to 100]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![gdd](colortables/gdd.png) &nbsp;&nbsp;&nbsp;&nbsp;**gdd**: accumulated growing degree days [range: 0 to 6000]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![grass](colortables/grass.png) &nbsp;&nbsp;&nbsp;&nbsp;**grass**: GRASS green (perceptually uniform) [range: map values]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![greens](colortables/greens.png) &nbsp;&nbsp;&nbsp;&nbsp;**greens**: white to green [range: map values]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![grey](colortables/grey.png) &nbsp;&nbsp;&nbsp;&nbsp;**grey**: grey scale [range: map values]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![grey.eq](colortables/grey.eq.png) &nbsp;&nbsp;&nbsp;&nbsp;**grey.eq**: histogram-equalized grey scale [range: map values]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![grey.log](colortables/grey.log.png) &nbsp;&nbsp;&nbsp;&nbsp;**grey.log**: histogram logarithmic transformed grey scale [range: map values]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![grey1.0](colortables/grey1.0.png) &nbsp;&nbsp;&nbsp;&nbsp;**grey1.0**: grey scale for raster values between 0.0-1.0 [range: 0 to 1]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![grey255](colortables/grey255.png) &nbsp;&nbsp;&nbsp;&nbsp;**grey255**: grey scale for raster values between 0-255 [range: 0 to 255]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![gyr](colortables/gyr.png) &nbsp;&nbsp;&nbsp;&nbsp;**gyr**: green through yellow to red [range: map values]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![haxby](colortables/haxby.png) &nbsp;&nbsp;&nbsp;&nbsp;**haxby**: relative colors for bathymetry or topography [range: map values]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![inferno](colortables/inferno.png) &nbsp;&nbsp;&nbsp;&nbsp;**inferno**: perceptually uniform sequential color table inferno [range: map values]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![kelvin](colortables/kelvin.png) &nbsp;&nbsp;&nbsp;&nbsp;**kelvin**: blue to red for temperature in Kelvin scale [range: 193.15 to 353.15]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![magma](colortables/magma.png) &nbsp;&nbsp;&nbsp;&nbsp;**magma**: perceptually uniform sequential color table magma [range: map values]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![ndvi](colortables/ndvi.png) &nbsp;&nbsp;&nbsp;&nbsp;**ndvi**: Normalized Difference Vegetation Index colors [range: -1 to 1]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![ndwi](colortables/ndwi.png) &nbsp;&nbsp;&nbsp;&nbsp;**ndwi**: Normalized Difference Water Index colors [range: -200 to 200]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![nlcd](colortables/nlcd.png) &nbsp;&nbsp;&nbsp;&nbsp;**nlcd**: US National Land Cover Dataset colors [range: 0 to 95]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![oranges](colortables/oranges.png) &nbsp;&nbsp;&nbsp;&nbsp;**oranges**: white to orange [range: map values]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![plasma](colortables/plasma.png) &nbsp;&nbsp;&nbsp;&nbsp;**plasma**: perceptually uniform sequential color table plasma [range: map values]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![population](colortables/population.png) &nbsp;&nbsp;&nbsp;&nbsp;**population**: color table covering human population classification breaks [range: 0 to 2e+09]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![population_dens](colortables/population_dens.png) &nbsp;&nbsp;&nbsp;&nbsp;**population_dens**: color table covering human population density classification breaks [range: 0 to 1e+09]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![precipitation](colortables/precipitation.png) &nbsp;&nbsp;&nbsp;&nbsp;**precipitation**: precipitation color table (0..2000mm) [range: 0 to 7000]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![precipitation_daily](colortables/precipitation_daily.png) &nbsp;&nbsp;&nbsp;&nbsp;**precipitation_daily**: precipitation color table (0..1000mm) [range: 0 to 10000]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![precipitation_monthly](colortables/precipitation_monthly.png) &nbsp;&nbsp;&nbsp;&nbsp;**precipitation_monthly**: precipitation color table (0..1000mm) [range: 0 to 1000]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![rainbow](colortables/rainbow.png) &nbsp;&nbsp;&nbsp;&nbsp;**rainbow**: rainbow color table [range: map values]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![ramp](colortables/ramp.png) &nbsp;&nbsp;&nbsp;&nbsp;**ramp**: color ramp [range: map values]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![random](colortables/random.png) &nbsp;&nbsp;&nbsp;&nbsp;**random**: random color table [range: map values]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![reds](colortables/reds.png) &nbsp;&nbsp;&nbsp;&nbsp;**reds**: white to red [range: map values]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![roygbiv](colortables/roygbiv.png) &nbsp;&nbsp;&nbsp;&nbsp;**roygbiv**:  [range: map values]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![rstcurv](colortables/rstcurv.png) &nbsp;&nbsp;&nbsp;&nbsp;**rstcurv**: terrain curvature (from r.resamp.rst) [range: map values]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![ryb](colortables/ryb.png) &nbsp;&nbsp;&nbsp;&nbsp;**ryb**: red through yellow to blue [range: map values]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![ryg](colortables/ryg.png) &nbsp;&nbsp;&nbsp;&nbsp;**ryg**: red through yellow to green [range: map values]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![sepia](colortables/sepia.png) &nbsp;&nbsp;&nbsp;&nbsp;**sepia**: yellowish-brown through to white [range: map values]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![slope](colortables/slope.png) &nbsp;&nbsp;&nbsp;&nbsp;**slope**: r.slope.aspect-type slope colors for raster values 0-90 [range: 0 to 90]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![soilmoisture](colortables/soilmoisture.png) &nbsp;&nbsp;&nbsp;&nbsp;**soilmoisture**: soilmoisture color table (0.0-1.0) [range: 0 to 1]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![srtm](colortables/srtm.png) &nbsp;&nbsp;&nbsp;&nbsp;**srtm**: color palette for Shuttle Radar Topography Mission elevation [range: -11000 to 8850]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![srtm_percent](colortables/srtm_percent.png) &nbsp;&nbsp;&nbsp;&nbsp;**srtm_percent**: color palette for Shuttle Radar Topography Mission using relative elevation [range: map values]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![srtm_plus](colortables/srtm_plus.png) &nbsp;&nbsp;&nbsp;&nbsp;**srtm_plus**: color palette for Shuttle Radar Topography Mission elevation (with seafloor colors) [range: -11000 to 8850]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![terrain](colortables/terrain.png) &nbsp;&nbsp;&nbsp;&nbsp;**terrain**: global elevation color table covering -11000 to +8850m [range: -11000 to 8850]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![viridis](colortables/viridis.png) &nbsp;&nbsp;&nbsp;&nbsp;**viridis**: perceptually uniform sequential color table viridis [range: map values]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![water](colortables/water.png) &nbsp;&nbsp;&nbsp;&nbsp;**water**: water depth [range: map values]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![wave](colortables/wave.png) &nbsp;&nbsp;&nbsp;&nbsp;**wave**: color wave [range: map values]  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *viridis*  
    **memory** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Maximum memory to be used (in MB)  
    &nbsp;&nbsp;&nbsp;&nbsp;Cache size for raster rows  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *memory in MB*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *300*  
    **default_crs** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default Coordinate Reference System (EPSG code)  
    &nbsp;&nbsp;&nbsp;&nbsp;EPSG code to assume if a (sub-) dataset has no CRS defined  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *Default CRS (EPSG code)*  
    **nprocs** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Number of threads for parallel computing  
    &nbsp;&nbsp;&nbsp;&nbsp;0: use OpenMP default; &gt;0: use nprocs; &lt;0: use MAX-nprocs  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1*  
    **separator** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Field separator  
    &nbsp;&nbsp;&nbsp;&nbsp;Special characters: pipe, comma, space, tab, newline  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, separator, *character*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *pipe*  
    **nodata** : str | list[str], *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Comma separated list of values representing nodata in the input dataset  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *Source nodata*  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *a*, *i*, *r*, *l*, *f*, *e*, *o*  
    &nbsp;&nbsp;&nbsp;&nbsp;**a**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Append to STRDS  
    &nbsp;&nbsp;&nbsp;&nbsp;**i**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Allow incomplete CF-dimensions (XY instead of XYT)  
    &nbsp;&nbsp;&nbsp;&nbsp;**r**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Import only within current region  
    &nbsp;&nbsp;&nbsp;&nbsp;**l**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Link the raster files using r.external  
    &nbsp;&nbsp;&nbsp;&nbsp;**f**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Link the raster files in a fast way, without reading metadata using r.external  
    &nbsp;&nbsp;&nbsp;&nbsp;**e**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Extend location extents based on new dataset  
    &nbsp;&nbsp;&nbsp;&nbsp;**o**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Override projection check (use current location's projection)  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Assume that the dataset has same projection as the current location  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

=== "Python (grass.tools)"

    **input** : str | io.StringIO, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;URL or name of input netcdf-file ("-" = stdin)  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, file, *Input file(s) ("-" = stdin)*  
    **semantic_labels** : str | io.StringIO, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;File with mapping of variables or subdatasets to semantic labels  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, file, *Input file with configuration for semantic labels ("-" = stdin)*  
    **output** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of the output space time raster dataset  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, strds, *name*  
    **end_time** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Latest timestamp of temporal extent to include in the output  
    &nbsp;&nbsp;&nbsp;&nbsp;Timestamp of format "YYYY-MM-DD HH:MM:SS"  
    **start_time** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Earliest timestamp of temporal extent to include in the output  
    &nbsp;&nbsp;&nbsp;&nbsp;Timestamp of format "YYYY-MM-DD HH:MM:SS"  
    **temporal_relations** : str | list[str], *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed temporal relation for temporal filtering  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed temporal relation between time dimension in the netCDF file and temporal window defined by start_time and end_time  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *equal, during, contains, overlaps, overlapped, starts, started, finishes, finished*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *equal,during,contains,overlaps,overlapped,starts,started,finishes,finished*  
    **resample** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Resampling method when data is reprojected  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *nearest, bilinear, bicubic, cubicspline, lanczos, average, mode, max, min, med, Q1, Q3*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *nearest*  
    **print** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Print metadata and exit  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *extended,  grass*  
    **color** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Color table to assign to imported datasets  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, colortable, *style*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *aspect, aspectcolr, bcyr, bgyr, blues, byg, byr, celsius, corine, curvature, differences, elevation, etopo2, evi, fahrenheit, forest_cover, gdd, grass, greens, grey, grey.eq, grey.log, grey1.0, grey255, gyr, haxby, inferno, kelvin, magma, ndvi, ndwi, nlcd, oranges, plasma, population, population_dens, precipitation, precipitation_daily, precipitation_monthly, rainbow, ramp, random, reds, roygbiv, rstcurv, ryb, ryg, sepia, slope, soilmoisture, srtm, srtm_percent, srtm_plus, terrain, viridis, water, wave*  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![aspect](colortables/aspect.png) &nbsp;&nbsp;&nbsp;&nbsp;**aspect**: aspect oriented grey colors [range: map values]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![aspectcolr](colortables/aspectcolr.png) &nbsp;&nbsp;&nbsp;&nbsp;**aspectcolr**: aspect oriented rainbow colors [range: 0 to 360]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![bcyr](colortables/bcyr.png) &nbsp;&nbsp;&nbsp;&nbsp;**bcyr**: blue through cyan through yellow to red [range: map values]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![bgyr](colortables/bgyr.png) &nbsp;&nbsp;&nbsp;&nbsp;**bgyr**: blue through green through yellow to red [range: map values]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![blues](colortables/blues.png) &nbsp;&nbsp;&nbsp;&nbsp;**blues**: white to blue [range: map values]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![byg](colortables/byg.png) &nbsp;&nbsp;&nbsp;&nbsp;**byg**: blue through yellow to green [range: map values]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![byr](colortables/byr.png) &nbsp;&nbsp;&nbsp;&nbsp;**byr**: blue through yellow to red [range: map values]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![celsius](colortables/celsius.png) &nbsp;&nbsp;&nbsp;&nbsp;**celsius**: blue to red for degree Celsius temperature [range: -80 to 80]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![corine](colortables/corine.png) &nbsp;&nbsp;&nbsp;&nbsp;**corine**: EU Corine land cover colors [range: 111 to 995]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![curvature](colortables/curvature.png) &nbsp;&nbsp;&nbsp;&nbsp;**curvature**: for terrain curvatures (from v.surf.rst and r.slope.aspect) [range: map values]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![differences](colortables/differences.png) &nbsp;&nbsp;&nbsp;&nbsp;**differences**: differences oriented colors [range: map values]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![elevation](colortables/elevation.png) &nbsp;&nbsp;&nbsp;&nbsp;**elevation**: maps relative ranges of raster values to elevation color ramp [range: map values]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![etopo2](colortables/etopo2.png) &nbsp;&nbsp;&nbsp;&nbsp;**etopo2**: colors for ETOPO2 worldwide bathymetry/topography [range: -11000 to 8850]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![evi](colortables/evi.png) &nbsp;&nbsp;&nbsp;&nbsp;**evi**: enhanced vegetative index colors [range: -1 to 1]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![fahrenheit](colortables/fahrenheit.png) &nbsp;&nbsp;&nbsp;&nbsp;**fahrenheit**: blue to red for Fahrenheit temperature [range: -112 to 176]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![forest_cover](colortables/forest_cover.png) &nbsp;&nbsp;&nbsp;&nbsp;**forest_cover**: percentage of forest cover [range: 0 to 100]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![gdd](colortables/gdd.png) &nbsp;&nbsp;&nbsp;&nbsp;**gdd**: accumulated growing degree days [range: 0 to 6000]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![grass](colortables/grass.png) &nbsp;&nbsp;&nbsp;&nbsp;**grass**: GRASS green (perceptually uniform) [range: map values]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![greens](colortables/greens.png) &nbsp;&nbsp;&nbsp;&nbsp;**greens**: white to green [range: map values]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![grey](colortables/grey.png) &nbsp;&nbsp;&nbsp;&nbsp;**grey**: grey scale [range: map values]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![grey.eq](colortables/grey.eq.png) &nbsp;&nbsp;&nbsp;&nbsp;**grey.eq**: histogram-equalized grey scale [range: map values]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![grey.log](colortables/grey.log.png) &nbsp;&nbsp;&nbsp;&nbsp;**grey.log**: histogram logarithmic transformed grey scale [range: map values]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![grey1.0](colortables/grey1.0.png) &nbsp;&nbsp;&nbsp;&nbsp;**grey1.0**: grey scale for raster values between 0.0-1.0 [range: 0 to 1]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![grey255](colortables/grey255.png) &nbsp;&nbsp;&nbsp;&nbsp;**grey255**: grey scale for raster values between 0-255 [range: 0 to 255]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![gyr](colortables/gyr.png) &nbsp;&nbsp;&nbsp;&nbsp;**gyr**: green through yellow to red [range: map values]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![haxby](colortables/haxby.png) &nbsp;&nbsp;&nbsp;&nbsp;**haxby**: relative colors for bathymetry or topography [range: map values]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![inferno](colortables/inferno.png) &nbsp;&nbsp;&nbsp;&nbsp;**inferno**: perceptually uniform sequential color table inferno [range: map values]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![kelvin](colortables/kelvin.png) &nbsp;&nbsp;&nbsp;&nbsp;**kelvin**: blue to red for temperature in Kelvin scale [range: 193.15 to 353.15]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![magma](colortables/magma.png) &nbsp;&nbsp;&nbsp;&nbsp;**magma**: perceptually uniform sequential color table magma [range: map values]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![ndvi](colortables/ndvi.png) &nbsp;&nbsp;&nbsp;&nbsp;**ndvi**: Normalized Difference Vegetation Index colors [range: -1 to 1]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![ndwi](colortables/ndwi.png) &nbsp;&nbsp;&nbsp;&nbsp;**ndwi**: Normalized Difference Water Index colors [range: -200 to 200]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![nlcd](colortables/nlcd.png) &nbsp;&nbsp;&nbsp;&nbsp;**nlcd**: US National Land Cover Dataset colors [range: 0 to 95]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![oranges](colortables/oranges.png) &nbsp;&nbsp;&nbsp;&nbsp;**oranges**: white to orange [range: map values]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![plasma](colortables/plasma.png) &nbsp;&nbsp;&nbsp;&nbsp;**plasma**: perceptually uniform sequential color table plasma [range: map values]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![population](colortables/population.png) &nbsp;&nbsp;&nbsp;&nbsp;**population**: color table covering human population classification breaks [range: 0 to 2e+09]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![population_dens](colortables/population_dens.png) &nbsp;&nbsp;&nbsp;&nbsp;**population_dens**: color table covering human population density classification breaks [range: 0 to 1e+09]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![precipitation](colortables/precipitation.png) &nbsp;&nbsp;&nbsp;&nbsp;**precipitation**: precipitation color table (0..2000mm) [range: 0 to 7000]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![precipitation_daily](colortables/precipitation_daily.png) &nbsp;&nbsp;&nbsp;&nbsp;**precipitation_daily**: precipitation color table (0..1000mm) [range: 0 to 10000]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![precipitation_monthly](colortables/precipitation_monthly.png) &nbsp;&nbsp;&nbsp;&nbsp;**precipitation_monthly**: precipitation color table (0..1000mm) [range: 0 to 1000]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![rainbow](colortables/rainbow.png) &nbsp;&nbsp;&nbsp;&nbsp;**rainbow**: rainbow color table [range: map values]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![ramp](colortables/ramp.png) &nbsp;&nbsp;&nbsp;&nbsp;**ramp**: color ramp [range: map values]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![random](colortables/random.png) &nbsp;&nbsp;&nbsp;&nbsp;**random**: random color table [range: map values]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![reds](colortables/reds.png) &nbsp;&nbsp;&nbsp;&nbsp;**reds**: white to red [range: map values]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![roygbiv](colortables/roygbiv.png) &nbsp;&nbsp;&nbsp;&nbsp;**roygbiv**:  [range: map values]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![rstcurv](colortables/rstcurv.png) &nbsp;&nbsp;&nbsp;&nbsp;**rstcurv**: terrain curvature (from r.resamp.rst) [range: map values]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![ryb](colortables/ryb.png) &nbsp;&nbsp;&nbsp;&nbsp;**ryb**: red through yellow to blue [range: map values]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![ryg](colortables/ryg.png) &nbsp;&nbsp;&nbsp;&nbsp;**ryg**: red through yellow to green [range: map values]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![sepia](colortables/sepia.png) &nbsp;&nbsp;&nbsp;&nbsp;**sepia**: yellowish-brown through to white [range: map values]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![slope](colortables/slope.png) &nbsp;&nbsp;&nbsp;&nbsp;**slope**: r.slope.aspect-type slope colors for raster values 0-90 [range: 0 to 90]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![soilmoisture](colortables/soilmoisture.png) &nbsp;&nbsp;&nbsp;&nbsp;**soilmoisture**: soilmoisture color table (0.0-1.0) [range: 0 to 1]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![srtm](colortables/srtm.png) &nbsp;&nbsp;&nbsp;&nbsp;**srtm**: color palette for Shuttle Radar Topography Mission elevation [range: -11000 to 8850]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![srtm_percent](colortables/srtm_percent.png) &nbsp;&nbsp;&nbsp;&nbsp;**srtm_percent**: color palette for Shuttle Radar Topography Mission using relative elevation [range: map values]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![srtm_plus](colortables/srtm_plus.png) &nbsp;&nbsp;&nbsp;&nbsp;**srtm_plus**: color palette for Shuttle Radar Topography Mission elevation (with seafloor colors) [range: -11000 to 8850]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![terrain](colortables/terrain.png) &nbsp;&nbsp;&nbsp;&nbsp;**terrain**: global elevation color table covering -11000 to +8850m [range: -11000 to 8850]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![viridis](colortables/viridis.png) &nbsp;&nbsp;&nbsp;&nbsp;**viridis**: perceptually uniform sequential color table viridis [range: map values]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![water](colortables/water.png) &nbsp;&nbsp;&nbsp;&nbsp;**water**: water depth [range: map values]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![wave](colortables/wave.png) &nbsp;&nbsp;&nbsp;&nbsp;**wave**: color wave [range: map values]  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *viridis*  
    **memory** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Maximum memory to be used (in MB)  
    &nbsp;&nbsp;&nbsp;&nbsp;Cache size for raster rows  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *memory in MB*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *300*  
    **default_crs** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default Coordinate Reference System (EPSG code)  
    &nbsp;&nbsp;&nbsp;&nbsp;EPSG code to assume if a (sub-) dataset has no CRS defined  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *Default CRS (EPSG code)*  
    **nprocs** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Number of threads for parallel computing  
    &nbsp;&nbsp;&nbsp;&nbsp;0: use OpenMP default; &gt;0: use nprocs; &lt;0: use MAX-nprocs  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1*  
    **separator** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Field separator  
    &nbsp;&nbsp;&nbsp;&nbsp;Special characters: pipe, comma, space, tab, newline  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, separator, *character*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *pipe*  
    **nodata** : str | list[str], *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Comma separated list of values representing nodata in the input dataset  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *Source nodata*  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *a*, *i*, *r*, *l*, *f*, *e*, *o*  
    &nbsp;&nbsp;&nbsp;&nbsp;**a**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Append to STRDS  
    &nbsp;&nbsp;&nbsp;&nbsp;**i**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Allow incomplete CF-dimensions (XY instead of XYT)  
    &nbsp;&nbsp;&nbsp;&nbsp;**r**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Import only within current region  
    &nbsp;&nbsp;&nbsp;&nbsp;**l**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Link the raster files using r.external  
    &nbsp;&nbsp;&nbsp;&nbsp;**f**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Link the raster files in a fast way, without reading metadata using r.external  
    &nbsp;&nbsp;&nbsp;&nbsp;**e**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Extend location extents based on new dataset  
    &nbsp;&nbsp;&nbsp;&nbsp;**o**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Override projection check (use current location's projection)  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Assume that the dataset has same projection as the current location  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

    Returns:

    **result** : grass.tools.support.ToolResult | None  
    If the tool produces text as standard output, a *ToolResult* object will be returned. Otherwise, `None` will be returned.

    Raises:

    *grass.tools.ToolError*: When the tool ended with an error.

## DESCRIPTION

*t.rast.import.netcdf* imports content of one or more NetCDF files into
a GRASS GIS Space Time Raster Dataset (STRDS). NetCDF files are expected
to follow the [CF-convention](https://cfconventions.org/). Files not
adhering to those standards may fail to import.

The [Attribute Convention for Data Discovery (ACDD)](
https://wiki.esipfed.org/Attribute_Convention_for_Data_Discovery_1-3)
that is related to the CF-Convention is partly supported. Datasets
compliant with ACDD but not CF-Convention the **i-flag** may have to
be used.

Input URL(s) to NetCDF files can be provided in the **input** option as
either a file, with one URL to a dataset per line, a comma-separated
list of URLs or a single URL. "-" causes input to be taken from stdin.

The module works for both local and remote data (e.g. on a Thredds
Server). Data can be imported via *r.in.gdal* or linked with
*r.external*.

*t.rast.import.netcdf* uses GDALs Virtual Raster format (VRT) if data's
Coordinate Reference system differs from the one of the current location
where they are supposed to be imported.

Reprojection on import is done using GDAL warp if necessary. In that
case, users should be aware of the extent and resolution of the data to
import and the current computational region. Import is limited to and
aligned with the current computational region, if the **r-flag** is set.
Otherwise, extent and resolution in the target CRS is guessed by GDAL.
Import of global data to coordinate systems that do not support that
extent will thus fail.

Starting with GRASS GIS version 8.0, different variables or subdatasets
in a NetCDF file can be imported as "semantic\_label" into one STRDS. To
achieve this, a configuration file has to be provided in the
**semantic\_labels** option. That configuration file maps subdatasets in
the NetCDF file to GRASS GIS semantic\_labels. Each line in that file
must have the following format: `
input_netcdf_subdataset=grass_gis_semantic_label ` The equal sign *=* is
required. If a semantic\_labels configuration file is provided, the
import of subdatasets is limited to those subdatasets listed in the
file. Hence, it can be used to filter variables of interest.

## KNOWN ISSUES

The VRT format is also used when linking NetCDF data that contains
subdatasets, as subdatasets are currently not supported in *r.external*.

Reading NetCDF files directly via HTTP protocol (like in the examples
below) is currently not supported on MS Windows.

GDAL versions prior to 3.4.1 do not support reading NetCDF files
directly via HTTP protocol on newer Linux kernels either. Please make
sure to have at least GDAL version 3.4.1 on recent Linux systems. See
posts on the [GDAL-dev mailing
list](https://www.mail-archive.com/gdal-dev@lists.osgeo.org/msg37419.html).
for reference.

The Attribute Convention for Data Discovery (ACDD) is not yet fully
supported, depending on the structure of the datasets, import may or
may not work.

## REQUIREMENTS

Support of semantic\_labels is only available with GRASS GIS 8.0 or
later. *t.rast.import.netcdf* uses the following non-standard Python
modules:

- [numpy](https://pypi.org/project/numpy)
- [GDAL](https://pypi.org/project/GDAL) (preferably version \>= 3.4.1)
- [cf-units](https://pypi.org/project/cf-units)

## EXAMPLES

### Link Sentinel-2 scenes from the Norwegian Ground Segment

```sh
# Choose Scenes to import (see also m.crawl.thredds module)
echo "https://nbstds.met.no/thredds/fileServer/NBS/S2A/2021/02/28/S2A_MSIL1C_20210228T103021_N0202_R108_T35WPU_20210228T201033_DTERRENGDATA.nc
https://nbstds.met.no/thredds/fileServer/NBS/S2A/2021/02/28/S2A_MSIL1C_20210228T103021_N0202_R108_T32VNL_20210228T201033_DTERRENGDATA.nc" > nc.txt

# Create a semantic_label configuration file
echo "B1=S2_1
B2=S2_2" > semantic_labels.conf

# Import data (link NetCDF files without downloading them)
t.rast.import.netcdf -l input=nc.txt output=S2A semantic_labels=semantic_labels.conf \
  memory=2048 nprocs=2 nodata="-1"
```

### Import Norwegian Climate data

```sh
# Create a semantic_label configuration file
echo "tg=temperature_avg
tn=temperature_min" > semantic_labels.conf

# Import data within a selected time window
t.rast.import.netcdf output=SeNorge semantic_labels=semantic_labels.conf \
  memory=2048 nprocs=2 start_time="2020-08-01" end_time="2021-08-01" \
  input=https://thredds.met.no/thredds/fileServer/senorge/seNorge_2018/Archive/seNorge2018_2020.nc
```

### Append to STRDS from previous imports

```sh
# Choose dataset to import (see also m.crawl.thredds module)

# Create a semantic_label configuration file
echo "tg=temperature_avg
tn=temperature_min" > semantic_labels.conf

# Import data within a selected time window
t.rast.import.netcdf output=SeNorge semantic_labels=semantic_labels.conf \
  memory=2048 nprocs=2 -a start_time="2020-08-01" end_time="2021-08-01" \
  input=https://thredds.met.no/thredds/fileServer/senorge/seNorge_2018/Archive/seNorge2018_2021.nc
```

### Import ACDD but not CF-compliant dataset from SWOT

```sh
# Choose dataset to import (see also m.crawl.thredds module)

# Create a semantic_label configuration file
echo "wse=SWOT_wse
wse_ucert=SWOT_wse_uncertainty" > semantic_labels.conf

# Import data within a selected time window
t.rast.import.netcdf -i output=SWOT semantic_labels=semantic_labels.conf \
  memory=2048 nprocs=2 \
  input=./SWOT_L2_HR_Raster_100m_UTM33W_N_x_x_x_020_113_138F_20240824T163805_20240824T163826_PIC0_01.nc
```

## TODO

1. Capture and store extended metadata in a way that allows for
    filtering of relevant maps.
2. Improve printing of metadata and file structure
3. Support more options of Virtual Raster files (data type, ...)

## SEE ALSO

*[t.rast.import](https://grass.osgeo.org/grass-stable/manuals/t.rast.import.html),
[r3.out.netcdf](https://grass.osgeo.org/grass-stable/manuals/r3.out.netcdf.html),
[r.semantic\_labels](https://grass.osgeo.org/grass-stable/manuals/r.semantic_labels.html),
[i.bands\_library](https://grass.osgeo.org/grass-stable/manuals/i.bands_library.html),
[r.support](https://grass.osgeo.org/grass-stable/manuals/r.support.html),
[m.crawl.thredds](https://grass.osgeo.org/grass-stable/manuals/addons/m.crawl.thredds.html)*

## AUTHORS

Stefan Blumentrath, Oslo, Norway

## SOURCE CODE

Available at: [t.rast.import.netcdf source code](https://github.com/OSGeo/grass-addons/tree/grass8/src/temporal/t.rast.import.netcdf)
([history](https://github.com/OSGeo/grass-addons/commits/grass8/src/temporal/t.rast.import.netcdf))  
Latest change: Wednesday Nov 12 16:00:13 2025 in commit [847bebb](https://github.com/OSGeo/grass-addons/commit/847bebbdfa87edccb2d0832f14c3f7c12b33484c)
