---
name: t.stac.catalog.py
description: Get STAC API Catalog metadata
keywords: [ temporal, STAC, catalog, metadata ]
---

# t.stac.catalog.py

Get STAC API Catalog metadata

=== "Command line"

    **t.stac.catalog.py**
    [**-bp**]
    **url**=*string*
    [**request_method**=*string*]
    [**settings**=*name*]
    [**format**=*string*]
    [**--verbose**]
    [**--quiet**]
    [**--qq**]
    [**--ui**]

    Example:

    ```sh
    t.stac.catalog.py url=string
    ```

=== "Python (grass.script)"

    *grass.script.parse_command*("***t.stac.catalog.py***",
        **url**,
        **request_method**=*"POST"*,
        **settings**=*None*,
        **format**=*"json"*,
        **flags**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    gs.parse_command("t.stac.catalog.py", url="string", format="json")
    ```

=== "Python (grass.tools)"

    *grass.tools.Tools.t_stac_catalog_py*(**url**,
        **request_method**=*"POST"*,
        **settings**=*None*,
        **format**=*"json"*,
        **flags**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    tools = Tools()
    tools.t_stac_catalog_py(url="string", format="json")
    ```

    This grass.tools API is experimental in version 8.5 and expected to be stable in version 8.6.

## Parameters

=== "Command line"

    **url**=*string* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;STAC API Client URL (examples at https://stacspec.org/en/about/datasets/)  
    **request_method**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;The HTTP method to use when making a request to the service.  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *GET, POST*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *POST*  
    **settings**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Full path to settings file (user, password)  
    &nbsp;&nbsp;&nbsp;&nbsp;'-' for standard input  
    **format**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;Output format  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *json, plain*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *json*  
    **-b**  
    &nbsp;&nbsp;&nbsp;&nbsp;Return basic information only  
    **-p**  
    &nbsp;&nbsp;&nbsp;&nbsp;Pretty print the JSON output  
    **--help**  
    &nbsp;&nbsp;&nbsp;&nbsp;Print usage summary  
    **--verbose**  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    **--quiet**  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    **--qq**  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    **--ui**  
    &nbsp;&nbsp;&nbsp;&nbsp;Force launching GUI dialog

=== "Python (grass.script)"

    **url** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;STAC API Client URL (examples at https://stacspec.org/en/about/datasets/)  
    **request_method** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;The HTTP method to use when making a request to the service.  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *GET, POST*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *POST*  
    **settings** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Full path to settings file (user, password)  
    &nbsp;&nbsp;&nbsp;&nbsp;'-' for standard input  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, file, *name*  
    **format** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Output format  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *json, plain*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *json*  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *b*, *p*  
    &nbsp;&nbsp;&nbsp;&nbsp;**b**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Return basic information only  
    &nbsp;&nbsp;&nbsp;&nbsp;**p**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Pretty print the JSON output  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

=== "Python (grass.tools)"

    **url** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;STAC API Client URL (examples at https://stacspec.org/en/about/datasets/)  
    **request_method** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;The HTTP method to use when making a request to the service.  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *GET, POST*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *POST*  
    **settings** : str | io.StringIO, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Full path to settings file (user, password)  
    &nbsp;&nbsp;&nbsp;&nbsp;'-' for standard input  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, file, *name*  
    **format** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Output format  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *json, plain*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *json*  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *b*, *p*  
    &nbsp;&nbsp;&nbsp;&nbsp;**b**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Return basic information only  
    &nbsp;&nbsp;&nbsp;&nbsp;**p**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Pretty print the JSON output  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

    Returns:

    **result** : grass.tools.support.ToolResult | None  
    If the tool produces text as standard output, a *ToolResult* object will be returned. Otherwise, `None` will be returned.

    Raises:

    *grass.tools.ToolError*: When the tool ended with an error.

## DESCRIPTION

*t.stac.catalog* is a tool for exploring SpatioTemporal Asset Catalogs
metadata from a STAC API. A list of STAC API and Catalogs can be found
at <https://stacindex.org/catalogs>. The tool is based on the PySTAC
library and provides a set of modules for working with STAC APIs.

## REQUIREMENTS

- [PySTAC\_Client
    (0.8.3)](https://pystac-client.readthedocs.io/en/stable/)

## EXAMPLES

Get the catalog metadata from a STAC API.

### STAC Catalog JSON metadata

```sh
t.stac.catalog url="https://earth-search.aws.element84.com/v1/"
```

GRASS Jupyter Notebooks can be used to visualize the catalog metadata.

```python
from grass import gs
catalog = gs.parse_command("t.stac.catalog", url="https://earth-search.aws.element84.com/v1/", flags="p")
print(catalog)

    # Output
    {'conformsTo': ['https://api.stacspec.org/v1.0.0/core',
                'https://api.stacspec.org/v1.0.0/collections',
                'https://api.stacspec.org/v1.0.0/ogcapi-features',
                'https://api.stacspec.org/v1.0.0/item-search',
                'https://api.stacspec.org/v1.0.0/ogcapi-features#fields',
                'https://api.stacspec.org/v1.0.0/ogcapi-features#sort',
                'https://api.stacspec.org/v1.0.0/ogcapi-features#query',
                'https://api.stacspec.org/v1.0.0/item-search#fields',
                'https://api.stacspec.org/v1.0.0/item-search#sort',
                'https://api.stacspec.org/v1.0.0/item-search#query',
                'https://api.stacspec.org/v0.3.0/aggregation',
                'http://www.opengis.net/spec/ogcapi-features-1/1.0/conf/core',
                'http://www.opengis.net/spec/ogcapi-features-1/1.0/conf/oas30',
                'http://www.opengis.net/spec/ogcapi-features-1/1.0/conf/geojson'],
 'description': 'A STAC API of public datasets on AWS',
 'id': 'earth-search-aws',
 'stac_version': '1.0.0',
 'title': 'Earth Search by Element 84',
 'type': 'Catalog'}
```

### STAC Catalog plain text metadata

```sh
t.stac.catalog url=https://earth-search.aws.element84.com/v1/ format=plain -b

---------------------------------------------------------------------------
Catalog: Earth Search by Element 84
---------------------------------------------------------------------------
Client Id: earth-search-aws
Client Description: A STAC API of public datasets on AWS
Client STAC Extensions: []
Client catalog_type: ABSOLUTE_PUBLISHED
---------------------------------------------------------------------------
Collections: 9
---------------------------------------------------------------------------
Collection Id | Collection Title
---------------------------------------------------------------------------
sentinel-2-pre-c1-l2a: Sentinel-2 Pre-Collection 1 Level-2A
cop-dem-glo-30: Copernicus DEM GLO-30
naip: NAIP: National Agriculture Imagery Program
cop-dem-glo-90: Copernicus DEM GLO-90
landsat-c2-l2: Landsat Collection 2 Level-2
sentinel-2-l2a: Sentinel-2 Level-2A
sentinel-2-l1c: Sentinel-2 Level-1C
sentinel-2-c1-l2a: Sentinel-2 Collection 1 Level-2A
sentinel-1-grd: Sentinel-1 Level-1C Ground Range Detected (GRD)
---------------------------------------------------------------------------
```

### Basic STAC catalog metadata

```sh
t.stac.catalog url=https://earth-search.aws.element84.com/v1/ format=plain

---------------------------------------------------------------------------
Catalog: Earth Search by Element 84
---------------------------------------------------------------------------
Client Id: earth-search-aws
Client Description: A STAC API of public datasets on AWS
Client STAC Extensions: []
Client catalog_type: ABSOLUTE_PUBLISHED
---------------------------------------------------------------------------
Collections: 9
---------------------------------------------------------------------------
Collection: Sentinel-2 Pre-Collection 1 Level-2A
---------------------------------------------------------------------------
Collection Id: sentinel-2-pre-c1-l2a
Sentinel-2 Pre-Collection 1 Level-2A (baseline < 05.00), with data and metadata matching collection sentinel-2-c1-l2a
Extent: {'spatial': {'bbox': [[-180, -90, 180, 90]]}, 'temporal': {'interval': [['2015-06-27T10:25:31.456000Z', None]]}}
License: proprietary
---------------------------------------------------------------------------
---------------------------------------------------------------------------
Collection: Copernicus DEM GLO-30
---------------------------------------------------------------------------
Collection Id: cop-dem-glo-30
The Copernicus DEM is a Digital Surface Model (DSM) which represents the surface of the Earth including buildings, infrastructure and vegetation. GLO-30 Public provides limited worldwide coverage at 30 meters because a small subset of tiles covering specific countries are not yet released to the public by the Copernicus Programme.
Extent: {'spatial': {'bbox': [[-180, -90, 180, 90]]}, 'temporal': {'interval': [['2021-04-22T00:00:00Z', '2021-04-22T00:00:00Z']]}}
License: proprietary
---------------------------------------------------------------------------
...
Extent: {'spatial': {'bbox': [[-180, -90, 180, 90]]}, 'temporal': {'interval': [['2014-10-10T00:28:21Z', None]]}}
License: proprietary
---------------------------------------------------------------------------
```

## AUTHENTICATION

The *t.stac.catalog* tool supports authentication with the STAC API
using the *GDAL's* virtual fie system */vsi/*.

### Basic Authentication

```sh
t.stac.catalog url="https://earth-search.aws.element84.com/v1/" settings="user:password"
```

### AWS

[AWS
S3](https://gdal.org/user/virtual_file_systems.html#vsis3-aws-s3-files)

### Google Cloud Storage

[Google Cloud
Storage](https://gdal.org/user/virtual_file_systems.html#vsigs-google-cloud-storage-files)

### Microsoft Azure

[Microsoft
Azure](https://gdal.org/user/virtual_file_systems.html#vsiaz-microsoft-azure-blob-files)

### HTTP

[HTTP](https://gdal.org/user/virtual_file_systems.html#vsicurl-http-https-ftp-files-random-access)

## SEE ALSO

*[t.stac.collection](https://grass.osgeo.org/grass-stable/manuals/addons/t.stac.collection.html),
[t.stac.item](https://grass.osgeo.org/grass-stable/manuals/addons/t.stac.item.html)*

[GRASS GIS Wiki: temporal data
processing](https://grasswiki.osgeo.org/wiki/Temporal_data_processing)

## AUTHORS

Corey T. White

## Sponsors

- [OpenPlains Inc.](https://openplains.com)
- [NCSU GeoForAll Lab](https://geospatial.ncsu.edu/geoforall/)

Center for Geospatial Analytics at North Carolina State University

## SOURCE CODE

Available at: [t.stac.catalog source code](https://github.com/OSGeo/grass-addons/tree/grass8/temporal/t.stac/t.stac.catalog)
([history](https://github.com/OSGeo/grass-addons/commits/grass8/temporal/t.stac/t.stac.catalog))  
Latest change: Tuesday Apr 01 23:14:57 2025 in commit [814b39c](https://github.com/OSGeo/grass-addons/commit/814b39c402a9c3987ef48765eaf6f719b53570f7)
