---
name: t.topology.py
description: Lists temporal topology of a space time dataset.
keywords: [ temporal, topology, time ]
---

# t.topology.py

Lists temporal topology of a space time dataset.

=== "Command line"

    **t.topology.py**
    [**-ms**]
    **input**=*name*
    [**type**=*name*]
    [**where**=*sql_query*]
    [**--verbose**]
    [**--quiet**]
    [**--qq**]
    [**--ui**]

    Example:

    ```sh
    t.topology.py input=name
    ```

=== "Python (grass.script)"

    *grass.script.run_command*("***t.topology.py***",
        **input**,
        **type**=*"strds"*,
        **where**=*None*,
        **flags**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    gs.run_command("t.topology.py", input="name")
    ```

=== "Python (grass.tools)"

    *grass.tools.Tools.t_topology_py*(**input**,
        **type**=*"strds"*,
        **where**=*None*,
        **flags**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    tools = Tools()
    tools.t_topology_py(input="name")
    ```

    This grass.tools API is experimental in version 8.5 and expected to be stable in version 8.6.

## Parameters

=== "Command line"

    **input**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of the input space time dataset  
    **type**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Type of the input space time dataset  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *strds, stvds, str3ds*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *strds*  
    **where**=*sql_query*  
    &nbsp;&nbsp;&nbsp;&nbsp;WHERE conditions of SQL statement without 'where' keyword used in the temporal GIS framework  
    &nbsp;&nbsp;&nbsp;&nbsp;Example: start_time &gt; '2001-01-01 12:30:00'  
    **-m**  
    &nbsp;&nbsp;&nbsp;&nbsp;Print temporal topological relationships and exit  
    **-s**  
    &nbsp;&nbsp;&nbsp;&nbsp;Print spatio-temporal topological relationships and exit  
    **--help**  
    &nbsp;&nbsp;&nbsp;&nbsp;Print usage summary  
    **--verbose**  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    **--quiet**  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    **--qq**  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    **--ui**  
    &nbsp;&nbsp;&nbsp;&nbsp;Force launching GUI dialog

=== "Python (grass.script)"

    **input** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of the input space time dataset  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, stds, *name*  
    **type** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Type of the input space time dataset  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *strds, stvds, str3ds*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *strds*  
    **where** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;WHERE conditions of SQL statement without 'where' keyword used in the temporal GIS framework  
    &nbsp;&nbsp;&nbsp;&nbsp;Example: start_time &gt; '2001-01-01 12:30:00'  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *sql_query*  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *m*, *s*  
    &nbsp;&nbsp;&nbsp;&nbsp;**m**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Print temporal topological relationships and exit  
    &nbsp;&nbsp;&nbsp;&nbsp;**s**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Print spatio-temporal topological relationships and exit  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

=== "Python (grass.tools)"

    **input** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of the input space time dataset  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, stds, *name*  
    **type** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Type of the input space time dataset  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *strds, stvds, str3ds*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *strds*  
    **where** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;WHERE conditions of SQL statement without 'where' keyword used in the temporal GIS framework  
    &nbsp;&nbsp;&nbsp;&nbsp;Example: start_time &gt; '2001-01-01 12:30:00'  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *sql_query*  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *m*, *s*  
    &nbsp;&nbsp;&nbsp;&nbsp;**m**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Print temporal topological relationships and exit  
    &nbsp;&nbsp;&nbsp;&nbsp;**s**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Print spatio-temporal topological relationships and exit  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

    Returns:

    **result** : grass.tools.support.ToolResult | None  
    If the tool produces text as standard output, a *ToolResult* object will be returned. Otherwise, `None` will be returned.

    Raises:

    *grass.tools.ToolError*: When the tool ended with an error.

## DESCRIPTION

The module *t.topology* lists temporal relations of the maps in a space
time dataset.

## EXAMPLE

In order to obtain information about space time dataset topology, run:

```sh
t.topology tempmean_monthly@climate_2009_2012
 +-------------------- Basic information -------------------------------------+
 | Id: ........................ tempmean_monthly@climate_2009_2012
 | Name: ...................... tempmean_monthly
 | Mapset: .................... climate_2009_2012
 | Creator: ................... lucadelu
 | Temporal type: ............. absolute
 | Creation time: ............. 2014-11-28 10:40:55.060096
 | Modification time:.......... 2014-11-28 16:08:42.166628
 | Semantic type:.............. mean
 +-------------------- Temporal topology -------------------------------------+
 | Is subset of dataset: ...... False
 | Temporal topology is: ...... valid
 | Number of intervals: ....... 48
 | Invalid time stamps: ....... 0
 | Number of points: .......... 0
 | Number of gaps: ............ 0
 | Granularity: ............... 1 month
 +-------------------- Topological relations ---------------------------------+
 | Overlaps: .................. 0
 | Overlapped: ................ 0
 | Finishes: .................. 0
 | Started: ................... 0
 | Follows: ................... 47
 | Contains: .................. 0
 | Equal:...................... 0
 | Finished: .................. 0
 | Precedes: .................. 47
 | Starts: .................... 0
 | During: .................... 0
 +----------------------------------------------------------------------------+
```

## SEE ALSO

*[t.create](t.create.md), [t.info](t.info.md)*

## AUTHOR

Sören Gebbert, Thünen Institute of Climate-Smart Agriculture

## SOURCE CODE

Available at: [t.topology source code](https://github.com/OSGeo/grass/tree/main/temporal/t.topology)
([history](https://github.com/OSGeo/grass/commits/main/temporal/t.topology))  
Latest change: Thursday Dec 18 07:11:47 2025 in commit [cf870a5](https://github.com/OSGeo/grass/commit/cf870a5e49fd2643a55de543467edf5c2e61d640)
