---
title: Temporal tools
author: GRASS Development Team
---

# Temporal tools

To learn more about these tool in general, go to [Temporal introduction](temporalintro.md).

| Name | Description |
|--------|-------------|
| [t.connect](t.connect.md) | Prints/sets general temporal GIS database connection for current mapset. |
| [t.copy](t.copy.md) | Creates a copy of a space time raster dataset. |
| [t.create](t.create.md) | Creates a space time dataset. |
| [t.info](t.info.md) | Lists information about space time datasets and maps. |
| [t.list](t.list.md) | Lists space time datasets and maps registered in the temporal database. |
| [t.merge](t.merge.md) | Merges several space time datasets into a single space time dataset. |
| [t.rast.accdetect](t.rast.accdetect.md) | Detects accumulation patterns in temporally accumulated space time raster datasets created by t.rast.accumulate. |
| [t.rast.accumulate](t.rast.accumulate.md) | Computes cyclic accumulations of a space time raster dataset. |
| [t.rast.aggregate.ds](t.rast.aggregate.ds.md) | Aggregates data of an existing space time raster dataset using the time intervals of a second space time dataset. |
| [t.rast.aggregate](t.rast.aggregate.md) | Aggregates temporally the maps of a space time raster dataset by a user defined granularity. |
| [t.rast.algebra](t.rast.algebra.md) | Apply temporal and spatial operations on space time raster datasets using temporal raster algebra. |
| [t.rast.colors](t.rast.colors.md) | Creates/modifies the color table associated with each raster map of the space time raster dataset. |
| [t.rast.contour](t.rast.contour.md) | Produces a space time vector dataset of specified contours from a space time raster dataset. |
| [t.rast.export](t.rast.export.md) | Exports space time raster dataset. |
| [t.rast.extract](t.rast.extract.md) | Extracts a subset of a space time raster datasets. |
| [t.rast.gapfill](t.rast.gapfill.md) | Replaces gaps in a space time raster dataset with interpolated raster maps. |
| [t.rast.import](t.rast.import.md) | Imports space time raster dataset. |
| [t.rast.list](t.rast.list.md) | Lists registered maps of a space time raster dataset. |
| [t.rast.mapcalc](t.rast.mapcalc.md) | Performs spatio-temporal mapcalc expressions on temporally sampled maps of space time raster datasets. |
| [t.rast.neighbors](t.rast.neighbors.md) | Performs a neighborhood analysis for each map in a space time raster dataset. |
| [t.rast.out.vtk](t.rast.out.vtk.md) | Exports space time raster dataset as VTK time series. |
| [t.rast.series](t.rast.series.md) | Performs different aggregation algorithms from r.series on all or a subset of raster maps in a space time raster dataset. |
| [t.rast.to.rast3](t.rast.to.rast3.md) | Converts a space time raster dataset into a 3D raster map. |
| [t.rast.to.vect](t.rast.to.vect.md) | Converts a space time raster dataset into a space time vector dataset |
| [t.rast.univar](t.rast.univar.md) | Calculates univariate statistics from the non-null cells for each registered raster map of a space time raster dataset. |
| [t.rast.what](t.rast.what.md) | Sample a space time raster dataset at specific vector point coordinates and write the output to stdout using different layouts |
| [t.rast3d.algebra](t.rast3d.algebra.md) | Apply temporal and spatial operations on space time 3D raster datasets using temporal 3D raster algebra. |
| [t.rast3d.extract](t.rast3d.extract.md) | Extracts a subset of a space time 3D raster dataset. |
| [t.rast3d.list](t.rast3d.list.md) | Lists registered maps of a space time raster3d dataset. |
| [t.rast3d.mapcalc](t.rast3d.mapcalc.md) | Performs r3.mapcalc expressions on maps of sampled space time 3D raster datasets. |
| [t.rast3d.univar](t.rast3d.univar.md) | Calculates univariate statistics from the non-null cells for each registered 3D raster map of a space time 3D raster dataset. |
| [t.register](t.register.md) | Assigns timestamps and registers raster, vector and raster3d maps in a space time dataset. |
| [t.remove](t.remove.md) | Removes space time datasets from temporal database. |
| [t.rename](t.rename.md) | Renames a space time dataset |
| [t.sample](t.sample.md) | Samples the input space time dataset(s) with a sample space time dataset and print the result to stdout. |
| [t.select](t.select.md) | Select maps from space time datasets by topological relationships to other space time datasets using temporal algebra. |
| [t.shift](t.shift.md) | Shifts temporally the maps of a space time dataset. |
| [t.snap](t.snap.md) | Snaps temporally the maps of a space time dataset. |
| [t.support](t.support.md) | Modifies the metadata of a space time dataset. |
| [t.topology](t.topology.md) | Lists temporal topology of a space time dataset. |
| [t.unregister](t.unregister.md) | Unregisters raster, vector and raster3d maps from the temporal database or a specific space time dataset. |
| [t.upgrade](t.upgrade.md) | Upgrades the version of the temporal database. |
| [t.vect.algebra](t.vect.algebra.md) | Apply temporal and spatial operations on space time vector datasets using temporal vector algebra. |
| [t.vect.db.select](t.vect.db.select.md) | Prints attributes of vector maps registered in a space time vector dataset. |
| [t.vect.export](t.vect.export.md) | Exports a space time vector dataset as GRASS specific archive file. |
| [t.vect.extract](t.vect.extract.md) | Extracts a subset of a space time vector dataset. |
| [t.vect.import](t.vect.import.md) | Imports a space time vector dataset from a GRASS specific archive file. |
| [t.vect.list](t.vect.list.md) | Lists registered maps of a space time vector dataset. |
| [t.vect.observe.strds](t.vect.observe.strds.md) | Observes specific locations in a space time raster dataset over a period of time using vector points. |
| [t.vect.univar](t.vect.univar.md) | Calculates univariate statistics of attributes for each registered vector map of a space time vector dataset |
| [t.vect.what.strds](t.vect.what.strds.md) | Stores raster map values at spatial and temporal positions of vector points as vector attributes. |
