---
name: v.ellipse
description: Computes the best-fitting ellipse for given vector data.
keywords: [ vector, geometry, best-fitting ellipse ]
---

# v.ellipse

Computes the best-fitting ellipse for given vector data.

=== "Command line"

    **v.ellipse**
    **input**=*name*
    **output**=*name*
    [**step**=*float*]
    [**--overwrite**]
    [**--verbose**]
    [**--quiet**]
    [**--qq**]
    [**--ui**]

    Example:

    ```sh
    v.ellipse input=name output=name
    ```

=== "Python (grass.script)"

    *grass.script.run_command*("***v.ellipse***",
        **input**,
        **output**,
        **step**=*4*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    gs.run_command("v.ellipse", input="name", output="name")
    ```

=== "Python (grass.tools)"

    *grass.tools.Tools.v_ellipse*(**input**,
        **output**,
        **step**=*4*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    tools = Tools()
    tools.v_ellipse(input="name", output="name")
    ```

    This grass.tools API is experimental in version 8.5 and expected to be stable in version 8.6.

## Parameters

=== "Command line"

    **input**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input vector map  
    &nbsp;&nbsp;&nbsp;&nbsp;Or data source for direct OGR access  
    **output**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output vector map  
    **step**=*float*  
    &nbsp;&nbsp;&nbsp;&nbsp;Step size in degrees  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *4*  
    **--overwrite**  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    **--help**  
    &nbsp;&nbsp;&nbsp;&nbsp;Print usage summary  
    **--verbose**  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    **--quiet**  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    **--qq**  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    **--ui**  
    &nbsp;&nbsp;&nbsp;&nbsp;Force launching GUI dialog

=== "Python (grass.script)"

    **input** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input vector map  
    &nbsp;&nbsp;&nbsp;&nbsp;Or data source for direct OGR access  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, vector, *name*  
    **output** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output vector map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, vector, *name*  
    **step** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Step size in degrees  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *4*  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

=== "Python (grass.tools)"

    **input** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input vector map  
    &nbsp;&nbsp;&nbsp;&nbsp;Or data source for direct OGR access  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, vector, *name*  
    **output** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output vector map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, vector, *name*  
    **step** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Step size in degrees  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *4*  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

    Returns:

    **result** : grass.tools.support.ToolResult | None  
    If the tool produces text as standard output, a *ToolResult* object will be returned. Otherwise, `None` will be returned.

    Raises:

    *grass.tools.ToolError*: When the tool ended with an error.

## DESCRIPTION

*v.ellipse* computes the best-fitting ellipse for **input** vector map
and creates new **output** vector map with ellipse. Input vector data
might be 2D points, lines, or areas.

![image-alt](v_ellipse.png)  
*Fig: Fitting ellipse created with v.ellipse*

The parameters of ellipse are printed on output if **--verbose** flag is
given.

## EXAMPLE

Example of *v.ellipse* created around set of points (using data
*points\_of\_interest*, North Carolina sample data set). Ellipse is is
approximated by linestring with point distance 1 degree (**step**).

```sh
v.ellipse input=points_of_interest output=ellipse step=1
```

## REFERENCES

- [Charles F. Van Loan: Using the Ellipse to Fit and Enclose Data
    Points.](https://www.cs.cornell.edu/cv/OtherPdf/Ellipse.pdf)

## SEE ALSO

*[v.hull](https://grass.osgeo.org/grass-stable/manuals/v.hull.html)*

## AUTHOR

Tereza Fiedlerova, OSGeoREL, Czech Technical University in Prague, Czech
Republic

## SOURCE CODE

Available at: [v.ellipse source code](https://github.com/OSGeo/grass-addons/tree/grass8/src/vector/v.ellipse)
([history](https://github.com/OSGeo/grass-addons/commits/grass8/src/vector/v.ellipse))  
Latest change: Friday Feb 21 10:10:05 2025 in commit [7d78fe3](https://github.com/OSGeo/grass-addons/commit/7d78fe34868674c3b6050ba1924e1c5675d155c9)
