---
name: v.fixed.segmentpoints.py
description: segment points along a vector line with fixed distances
keywords: [ vector, geometry ]
---

# v.fixed.segmentpoints.py

segment points along a vector line with fixed distances

=== "Command line"

    **v.fixed.segmentpoints.py**
    **vector**=*name*
    **cat**=*integer*
    **dir**=*name*
    **prefix**=*prefix*
    [**distance**=*integer*]
    [**--verbose**]
    [**--quiet**]
    [**--qq**]
    [**--ui**]

    Example:

    ```sh
    v.fixed.segmentpoints.py vector=name cat=0 dir=name prefix=prefix
    ```

=== "Python (grass.script)"

    *grass.script.run_command*("***v.fixed.segmentpoints.py***",
        **vector**,
        **cat**,
        **dir**,
        **prefix**,
        **distance**=*100*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    gs.run_command("v.fixed.segmentpoints.py", vector="name", cat=0, dir="name", prefix="prefix")
    ```

=== "Python (grass.tools)"

    *grass.tools.Tools.v_fixed_segmentpoints_py*(**vector**,
        **cat**,
        **dir**,
        **prefix**,
        **distance**=*100*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    tools = Tools()
    tools.v_fixed_segmentpoints_py(vector="name", cat=0, dir="name", prefix="prefix")
    ```

    This grass.tools API is experimental in version 8.5 and expected to be stable in version 8.6.

## Parameters

=== "Command line"

    **vector**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input vector map  
    &nbsp;&nbsp;&nbsp;&nbsp;Or data source for direct OGR access  
    **cat**=*integer* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Category of a vector line  
    **dir**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Directory where the output will be found  
    **prefix**=*prefix* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;output prefix (must start with a letter)  
    **distance**=*integer*  
    &nbsp;&nbsp;&nbsp;&nbsp;fixed distance between segment points  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *100*  
    **--help**  
    &nbsp;&nbsp;&nbsp;&nbsp;Print usage summary  
    **--verbose**  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    **--quiet**  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    **--qq**  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    **--ui**  
    &nbsp;&nbsp;&nbsp;&nbsp;Force launching GUI dialog

=== "Python (grass.script)"

    **vector** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input vector map  
    &nbsp;&nbsp;&nbsp;&nbsp;Or data source for direct OGR access  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, vector, *name*  
    **cat** : int, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Category of a vector line  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, cats  
    **dir** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Directory where the output will be found  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, dir, *name*  
    **prefix** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;output prefix (must start with a letter)  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *prefix*  
    **distance** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;fixed distance between segment points  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *integer*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *100*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

=== "Python (grass.tools)"

    **vector** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input vector map  
    &nbsp;&nbsp;&nbsp;&nbsp;Or data source for direct OGR access  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, vector, *name*  
    **cat** : int, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Category of a vector line  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, cats  
    **dir** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Directory where the output will be found  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, dir, *name*  
    **prefix** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;output prefix (must start with a letter)  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *prefix*  
    **distance** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;fixed distance between segment points  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *integer*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *100*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

    Returns:

    **result** : grass.tools.support.ToolResult | None  
    If the tool produces text as standard output, a *ToolResult* object will be returned. Otherwise, `None` will be returned.

    Raises:

    *grass.tools.ToolError*: When the tool ended with an error.

## DESCRIPTION

*v.fixed.segmentpoints* creates segment points along a vector line with
fixed distances by using the *v.segment* module. A category of one line
has to be given. Start and end point of the line will be considered. The
distance option is limited to an integer number. As a *prefix* (starting
with a letter) has to be given, resulting vectors are
*prefix*\_singleline and *prefix*\_segmentpoints, resulting external
files are *prefix*\_segmentpoints and *prefix*\_segmentpoints.csv.

The next to last point may be closer to the last point as the given
distance. Distance information for every point is added to the vector
attribute table. The attribute is then exported as CSV file. The
*category (cat)* of the input line is stored in the column *cat\_line*
of the *prefix*\_segmentpoints attribute table.

## EXAMPLE

```sh
  # NC sample data set
  v.fixed.segmentpoints vector=streams@PERMANENT cat=40102 dir=C:\tmp distance=25
 
```

## DEPENDENCIES

- v.segment

## SEE ALSO

*[v.segment](https://grass.osgeo.org/grass-stable/manuals/v.segment.html)*

## AUTHOR

Helmut Kudrnovsky

## SOURCE CODE

Available at: [v.fixed.segmentpoints source code](https://github.com/OSGeo/grass-addons/tree/grass8/src/vector/v.fixed.segmentpoints)
([history](https://github.com/OSGeo/grass-addons/commits/grass8/src/vector/v.fixed.segmentpoints))  
Latest change: Friday Feb 21 10:10:05 2025 in commit [7d78fe3](https://github.com/OSGeo/grass-addons/commit/7d78fe34868674c3b6050ba1924e1c5675d155c9)
