---
name: v.gsflow.hruparams.py
description: Set parameters for GSFLOW Hydrologic Response Units (HRUs)
keywords: [ vector, stream network, hydrology, GSFLOW ]
---

# v.gsflow.hruparams.py

Set parameters for GSFLOW Hydrologic Response Units (HRUs)

=== "Command line"

    **v.gsflow.hruparams.py**
    **elevation**=*name*
    [**cov_type**=*name*]
    [**soil_type**=*name*]
    **input**=*name*
    **output**=*name*
    **slope**=*string*
    **aspect**=*string*
    [**--overwrite**]
    [**--verbose**]
    [**--quiet**]
    [**--qq**]
    [**--ui**]

    Example:

    ```sh
    v.gsflow.hruparams.py elevation=name input=name output=name slope=string aspect=string
    ```

=== "Python (grass.script)"

    *grass.script.run_command*("***v.gsflow.hruparams.py***",
        **elevation**,
        **cov_type**=*"0"*,
        **soil_type**=*"2"*,
        **input**,
        **output**,
        **slope**,
        **aspect**,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    gs.run_command("v.gsflow.hruparams.py", elevation="name", input="name", output="name", slope="string", aspect="string")
    ```

=== "Python (grass.tools)"

    *grass.tools.Tools.v_gsflow_hruparams_py*(**elevation**,
        **cov_type**=*"0"*,
        **soil_type**=*"2"*,
        **input**,
        **output**,
        **slope**,
        **aspect**,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    tools = Tools()
    tools.v_gsflow_hruparams_py(elevation="name", input="name", output="name", slope="string", aspect="string")
    ```

    This grass.tools API is experimental in version 8.5 and expected to be stable in version 8.6.

## Parameters

=== "Command line"

    **elevation**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Elevation raster  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input raster map  
    **cov_type**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;land cover: rast or int: 0=bare soil; 1=grass; 2=shrub; 3=tree; 4=conif  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *0*  
    **soil_type**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;soil: rast or int: 1=sand; 2=loam; 3=clay  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *2*  
    **input**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Sub-basins to become HRUs  
    &nbsp;&nbsp;&nbsp;&nbsp;Or data source for direct OGR access  
    **output**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;HRUs  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output vector map  
    **slope**=*string* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Slope [unitless]: r.slope.aspect format=percent zscale=0.01  
    **aspect**=*string* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Aspect from r.slope.aspect  
    **--overwrite**  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    **--help**  
    &nbsp;&nbsp;&nbsp;&nbsp;Print usage summary  
    **--verbose**  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    **--quiet**  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    **--qq**  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    **--ui**  
    &nbsp;&nbsp;&nbsp;&nbsp;Force launching GUI dialog

=== "Python (grass.script)"

    **elevation** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Elevation raster  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **cov_type** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;land cover: rast or int: 0=bare soil; 1=grass; 2=shrub; 3=tree; 4=conif  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *0*  
    **soil_type** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;soil: rast or int: 1=sand; 2=loam; 3=clay  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *2*  
    **input** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Sub-basins to become HRUs  
    &nbsp;&nbsp;&nbsp;&nbsp;Or data source for direct OGR access  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, vector, *name*  
    **output** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;HRUs  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output vector map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, vector, *name*  
    **slope** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Slope [unitless]: r.slope.aspect format=percent zscale=0.01  
    **aspect** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Aspect from r.slope.aspect  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

=== "Python (grass.tools)"

    **elevation** : str | np.ndarray, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Elevation raster  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **cov_type** : str | np.ndarray, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;land cover: rast or int: 0=bare soil; 1=grass; 2=shrub; 3=tree; 4=conif  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *0*  
    **soil_type** : str | np.ndarray, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;soil: rast or int: 1=sand; 2=loam; 3=clay  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *2*  
    **input** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Sub-basins to become HRUs  
    &nbsp;&nbsp;&nbsp;&nbsp;Or data source for direct OGR access  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, vector, *name*  
    **output** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;HRUs  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output vector map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, vector, *name*  
    **slope** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Slope [unitless]: r.slope.aspect format=percent zscale=0.01  
    **aspect** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Aspect from r.slope.aspect  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

    Returns:

    **result** : grass.tools.support.ToolResult | None  
    If the tool produces text as standard output, a *ToolResult* object will be returned. Otherwise, `None` will be returned.

    Raises:

    *grass.tools.ToolError*: When the tool ended with an error.

## DESCRIPTION

*v.gsflow.hruparameters* uploads required parameters to run the USGS
combined groundwater (MODFLOW) and surface-water (PRMS) model GSFLOW to
each of the hydrologic response units (HRU) in the study watershed.

## REFERENCES

Ng, G.-H. C., A. D. Wickert, R. L. McLaughlin, J. La Frenierre, S.
Liess, and L. Sabeeri (2016), Modeling the role of groundwater and
vegetation in the hydrological response of tropical glaciated watersheds
to climate change, in AGU Fall Meeting Abstracts, H13L–1590, San
Francisco, CA.

## SEE ALSO

[v.gsflow.export](v.gsflow.export.md),
[v.gsflow.gravres](v.gsflow.gravres.md),
[v.gsflow.grid](v.gsflow.grid.md),
[v.gsflow.reaches](v.gsflow.reaches.md),
[v.gsflow.segments](v.gsflow.segments.md),
[v.gsflow.mapdata](v.gsflow.mapdata.md),
[v.stream.inbasin](v.stream.inbasin.md),
[v.stream.network](v.stream.network.md)

## AUTHOR

Andrew D. Wickert

## SOURCE CODE

Available at: [v.gsflow.hruparams source code](https://github.com/OSGeo/grass-addons/tree/grass8/src/vector/v.gsflow.hruparams)
([history](https://github.com/OSGeo/grass-addons/commits/grass8/src/vector/v.gsflow.hruparams))  
Latest change: Thursday Feb 20 13:02:26 2025 in commit [53de819](https://github.com/OSGeo/grass-addons/commit/53de8196a10ba5a8a9121898ce87861d227137e3)
