---
name: v.in.gbif.py
description: importing of GBIF species distribution data
keywords: [ vector, geometry ]
---

# v.in.gbif.py

importing of GBIF species distribution data

=== "Command line"

    **v.in.gbif.py**
    [**-cr**]
    **input**=*name*
    **output**=*name*
    [**dir**=*name*]
    [**--overwrite**]
    [**--verbose**]
    [**--quiet**]
    [**--qq**]
    [**--ui**]

    Example:

    ```sh
    v.in.gbif.py input=name output=name
    ```

=== "Python (grass.script)"

    *grass.script.run_command*("***v.in.gbif.py***",
        **input**,
        **output**,
        **dir**=*None*,
        **flags**=*None*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    gs.run_command("v.in.gbif.py", input="name", output="name")
    ```

=== "Python (grass.tools)"

    *grass.tools.Tools.v_in_gbif_py*(**input**,
        **output**,
        **dir**=*None*,
        **flags**=*None*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    tools = Tools()
    tools.v_in_gbif_py(input="name", output="name")
    ```

    This grass.tools API is experimental in version 8.5 and expected to be stable in version 8.6.

## Parameters

=== "Command line"

    **input**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input file  
    **output**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;name of imported GBIF data set  
    **dir**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Directory where the output will be found  
    **-c**  
    &nbsp;&nbsp;&nbsp;&nbsp;Create GDAL VRT data set of GBIF data  
    **-r**  
    &nbsp;&nbsp;&nbsp;&nbsp;Reproject data on-the-fly if no latlon (WGS84) location  
    **--overwrite**  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    **--help**  
    &nbsp;&nbsp;&nbsp;&nbsp;Print usage summary  
    **--verbose**  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    **--quiet**  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    **--qq**  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    **--ui**  
    &nbsp;&nbsp;&nbsp;&nbsp;Force launching GUI dialog

=== "Python (grass.script)"

    **input** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input file  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, file, *name*  
    **output** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;name of imported GBIF data set  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, vector, *name*  
    **dir** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Directory where the output will be found  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, dir, *name*  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *c*, *r*  
    &nbsp;&nbsp;&nbsp;&nbsp;**c**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Create GDAL VRT data set of GBIF data  
    &nbsp;&nbsp;&nbsp;&nbsp;**r**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Reproject data on-the-fly if no latlon (WGS84) location  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

=== "Python (grass.tools)"

    **input** : str | io.StringIO, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input file  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, file, *name*  
    **output** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;name of imported GBIF data set  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, vector, *name*  
    **dir** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Directory where the output will be found  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, dir, *name*  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *c*, *r*  
    &nbsp;&nbsp;&nbsp;&nbsp;**c**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Create GDAL VRT data set of GBIF data  
    &nbsp;&nbsp;&nbsp;&nbsp;**r**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Reproject data on-the-fly if no latlon (WGS84) location  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

    Returns:

    **result** : grass.tools.support.ToolResult | None  
    If the tool produces text as standard output, a *ToolResult* object will be returned. Otherwise, `None` will be returned.

    Raises:

    *grass.tools.ToolError*: When the tool ended with an error.

## DESCRIPTION

*v.in.gbif* imports [GBIF](https://www.gbif.org/) species distribution
data. GBIF data is by definition in WGS84 geographic coordinates.

The species distribution data downloaded from
[GBIF](https://www.gbif.org/) hast to be unzipped before importing the
csv file.

*v.in.gbif* saves the data to an intermediate [GDAL](https://gdal.org)
[VRT - Virtual Datasource](https://gdal.org/drivers/vector/vrt.html)
which will be imported by
[v.in.ogr](https://grass.osgeo.org/grass-stable/manuals/v.in.ogr.html).
The VRT data set can be copied to a user defined directory by *-c* flag
and used in any GDAL aware software. As some column names in the
original data set are similar to [SQL reserverd key
words](https://www.postgresql.org/docs/devel/sql-keywords-appendix.html),
the columns will renamed with the prefix *g\_*.

By the *-r* flag an on-the-fly reprojection of the data can be invoked
using
[v.import](https://grass.osgeo.org/grass-stable/manuals/v.import.html),
if the location is not in WGS84. Quality of on-the-fly reprojection is
not garanteed. The traditional reprojection procedure in GRASS GIS can
also be used instead.

## EXAMPLE

```sh
  # import GBIF data
  v.in.gbif input=0004248-150811131857512.csv output=chondrilla

  # create GDAL VRT files based upon GBIF data in user defined directory by -c flag
  v.in.gbif -c input=0004248-150811131857512.csv /
  output=chondrilla dir=C:\data\
 
```

## SEE ALSO

*[v.import](https://grass.osgeo.org/grass-stable/manuals/v.import.html),
[v.in.ascii](https://grass.osgeo.org/grass-stable/manuals/v.in.ascii.html),
[v.in.ogr](https://grass.osgeo.org/grass-stable/manuals/v.in.ogr.html),
[v.proj](https://grass.osgeo.org/grass-stable/manuals/v.proj.html)*

## AUTHOR

Helmut Kudrnovsky

## SOURCE CODE

Available at: [v.in.gbif source code](https://github.com/OSGeo/grass-addons/tree/grass8/src/vector/v.in.gbif)
([history](https://github.com/OSGeo/grass-addons/commits/grass8/src/vector/v.in.gbif))  
Latest change: Thursday Feb 20 13:02:26 2025 in commit [53de819](https://github.com/OSGeo/grass-addons/commit/53de8196a10ba5a8a9121898ce87861d227137e3)
