---
name: v.label.sa
description: Create optimally placed labels for vector map(s)
keywords: [ vector, paint labels ]
---

# v.label.sa

Create optimally placed labels for vector map(s)

=== "Command line"

    **v.label.sa**
    **map**=*name*
    [**type**=*string* [,*string*,...]]
    [**layer**=*string*]
    **column**=*string*
    **labels**=*name*
    **font**=*string*
    [**size**=*float*]
    [**isize**=*float*]
    [**charset**=*string*]
    [**color**=*string*]
    [**hcolor**=*string*]
    [**hwidth**=*float*]
    [**background**=*string*]
    [**opaque**=*yes|no*]
    [**border**=*string*]
    [**width**=*float*]
    [**--verbose**]
    [**--quiet**]
    [**--qq**]
    [**--ui**]

    Example:

    ```sh
    v.label.sa map=name column=string labels=name font=string
    ```

=== "Python (grass.script)"

    *grass.script.run_command*("***v.label.sa***",
        **map**,
        **type**=*"point,line,area"*,
        **layer**=*"1"*,
        **column**,
        **labels**,
        **font**,
        **size**=*100*,
        **isize**=*10*,
        **charset**=*"UTF-8"*,
        **color**=*"black"*,
        **hcolor**=*"none"*,
        **hwidth**=*0*,
        **background**=*"none"*,
        **opaque**=*"yes"*,
        **border**=*"none"*,
        **width**=*0*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    gs.run_command("v.label.sa", map="name", column="string", labels="name", font="string")
    ```

=== "Python (grass.tools)"

    *grass.tools.Tools.v_label_sa*(**map**,
        **type**=*"point,line,area"*,
        **layer**=*"1"*,
        **column**,
        **labels**,
        **font**,
        **size**=*100*,
        **isize**=*10*,
        **charset**=*"UTF-8"*,
        **color**=*"black"*,
        **hcolor**=*"none"*,
        **hwidth**=*0*,
        **background**=*"none"*,
        **opaque**=*"yes"*,
        **border**=*"none"*,
        **width**=*0*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    tools = Tools()
    tools.v_label_sa(map="name", column="string", labels="name", font="string")
    ```

    This grass.tools API is experimental in version 8.5 and expected to be stable in version 8.6.

## Parameters

=== "Command line"

    **map**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of vector map  
    &nbsp;&nbsp;&nbsp;&nbsp;Or data source for direct OGR access  
    **type**=*string* [,*string*,...]  
    &nbsp;&nbsp;&nbsp;&nbsp;Input feature type  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *point, line, area*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *point,line,area*  
    **layer**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;Layer number or name  
    &nbsp;&nbsp;&nbsp;&nbsp;Vector features can have category values in different layers. This number determines which layer to use. When used with direct OGR access this is the layer name.  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1*  
    **column**=*string* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of attribute column to be used for labels  
    **labels**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for new paint-label file  
    **font**=*string* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of TrueType font (as listed in the fontcap)  
    **size**=*float*  
    &nbsp;&nbsp;&nbsp;&nbsp;Label size (in map-units)  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *100*  
    **isize**=*float*  
    &nbsp;&nbsp;&nbsp;&nbsp;Icon size of point features (in map-units)  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *10*  
    **charset**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;Character encoding (default: UTF-8)  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *UTF-8*  
    **color**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;Text color  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *aqua, black, blue, brown, cyan, gray, green, grey, indigo, magenta, orange, purple, red, violet, white, yellow*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *black*  
    **hcolor**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;Highlight color for text  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *none, aqua, black, blue, brown, cyan, gray, green, grey, indigo, magenta, orange, purple, red, violet, white, yellow*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *none*  
    **hwidth**=*float*  
    &nbsp;&nbsp;&nbsp;&nbsp;Width of highlight coloring  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *0*  
    **background**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;Background color  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *none, aqua, black, blue, brown, cyan, gray, green, grey, indigo, magenta, orange, purple, red, violet, white, yellow*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *none*  
    **opaque**=*yes|no*  
    &nbsp;&nbsp;&nbsp;&nbsp;Opaque to vector (only relevant if background color is selected)  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *yes, no*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *yes*  
    **border**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;Border color  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *none, aqua, black, blue, brown, cyan, gray, green, grey, indigo, magenta, orange, purple, red, violet, white, yellow*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *none*  
    **width**=*float*  
    &nbsp;&nbsp;&nbsp;&nbsp;Border width (only for ps.map output)  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *0*  
    **--help**  
    &nbsp;&nbsp;&nbsp;&nbsp;Print usage summary  
    **--verbose**  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    **--quiet**  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    **--qq**  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    **--ui**  
    &nbsp;&nbsp;&nbsp;&nbsp;Force launching GUI dialog

=== "Python (grass.script)"

    **map** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of vector map  
    &nbsp;&nbsp;&nbsp;&nbsp;Or data source for direct OGR access  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, vector, *name*  
    **type** : str | list[str], *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Input feature type  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *point, line, area*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *point,line,area*  
    **layer** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Layer number or name  
    &nbsp;&nbsp;&nbsp;&nbsp;Vector features can have category values in different layers. This number determines which layer to use. When used with direct OGR access this is the layer name.  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, layer  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1*  
    **column** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of attribute column to be used for labels  
    **labels** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for new paint-label file  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *name*  
    **font** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of TrueType font (as listed in the fontcap)  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as:   
    **size** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Label size (in map-units)  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *100*  
    **isize** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Icon size of point features (in map-units)  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *10*  
    **charset** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Character encoding (default: UTF-8)  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *UTF-8*  
    **color** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Text color  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *aqua, black, blue, brown, cyan, gray, green, grey, indigo, magenta, orange, purple, red, violet, white, yellow*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *black*  
    **hcolor** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Highlight color for text  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *none, aqua, black, blue, brown, cyan, gray, green, grey, indigo, magenta, orange, purple, red, violet, white, yellow*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *none*  
    **hwidth** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Width of highlight coloring  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *0*  
    **background** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Background color  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *none, aqua, black, blue, brown, cyan, gray, green, grey, indigo, magenta, orange, purple, red, violet, white, yellow*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *none*  
    **opaque** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Opaque to vector (only relevant if background color is selected)  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *yes|no*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *yes, no*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *yes*  
    **border** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Border color  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *none, aqua, black, blue, brown, cyan, gray, green, grey, indigo, magenta, orange, purple, red, violet, white, yellow*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *none*  
    **width** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Border width (only for ps.map output)  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *0*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

=== "Python (grass.tools)"

    **map** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of vector map  
    &nbsp;&nbsp;&nbsp;&nbsp;Or data source for direct OGR access  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, vector, *name*  
    **type** : str | list[str], *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Input feature type  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *point, line, area*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *point,line,area*  
    **layer** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Layer number or name  
    &nbsp;&nbsp;&nbsp;&nbsp;Vector features can have category values in different layers. This number determines which layer to use. When used with direct OGR access this is the layer name.  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, layer  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1*  
    **column** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of attribute column to be used for labels  
    **labels** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for new paint-label file  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *name*  
    **font** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of TrueType font (as listed in the fontcap)  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as:   
    **size** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Label size (in map-units)  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *100*  
    **isize** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Icon size of point features (in map-units)  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *10*  
    **charset** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Character encoding (default: UTF-8)  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *UTF-8*  
    **color** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Text color  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *aqua, black, blue, brown, cyan, gray, green, grey, indigo, magenta, orange, purple, red, violet, white, yellow*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *black*  
    **hcolor** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Highlight color for text  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *none, aqua, black, blue, brown, cyan, gray, green, grey, indigo, magenta, orange, purple, red, violet, white, yellow*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *none*  
    **hwidth** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Width of highlight coloring  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *0*  
    **background** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Background color  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *none, aqua, black, blue, brown, cyan, gray, green, grey, indigo, magenta, orange, purple, red, violet, white, yellow*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *none*  
    **opaque** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Opaque to vector (only relevant if background color is selected)  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *yes|no*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *yes, no*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *yes*  
    **border** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Border color  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *none, aqua, black, blue, brown, cyan, gray, green, grey, indigo, magenta, orange, purple, red, violet, white, yellow*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *none*  
    **width** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Border width (only for ps.map output)  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *0*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

    Returns:

    **result** : grass.tools.support.ToolResult | None  
    If the tool produces text as standard output, a *ToolResult* object will be returned. Otherwise, `None` will be returned.

    Raises:

    *grass.tools.ToolError*: When the tool ended with an error.

## DESCRIPTION

*v.label.sa* makes a label-file from a GRASS vector map with labels
created from attributes in the attached table. The labels are placed in
as optimal place as possible. The label file has the same syntax as the
one created by
[v.label](https://grass.osgeo.org/grass-stable/manuals/v.label.html)

## EXAMPLE

North Carolina example:

```sh
# get font names:
d.font -L

v.label.sa roadsmajor labels=roads_labels column=ROAD_NAME color=red \
           background=white size=250 font=Vera

# set region:
g.region raster=lsat7_2002_10 -p

# display:
d.rgb b=lsat7_2002_10 g=lsat7_2002_20 r=lsat7_2002_30
d.vect roadsmajor col=yellow
d.labels roads_labels
```

![image-alt](v_label_sa.jpg)  
*Road labeling with v.label.sa (Raleigh, North Carolina, USA, area)*

## REFERENCES

Edmondson, Christensen, Marks and Shieber: A General Cartographic
Labeling Algorithm, Cartographica, Vol. 33, No. 4, Winter 1996, pp.
13-23 The algorithm works by the principle of Simulated Annealing.

## SEE ALSO

*[d.labels](https://grass.osgeo.org/grass-stable/manuals/d.labels.html),
[v.label](https://grass.osgeo.org/grass-stable/manuals/v.label.html),
[ps.map](https://grass.osgeo.org/grass-stable/manuals/ps.map.html)  
[Wikipedia article on simulated
annealing](https://en.wikipedia.org/wiki/Simulated_Annealing)*  

## AUTHOR

Wolf Bergenheim

## SOURCE CODE

Available at: [v.label.sa source code](https://github.com/OSGeo/grass-addons/tree/grass8/src/vector/v.label.sa)
([history](https://github.com/OSGeo/grass-addons/commits/grass8/src/vector/v.label.sa))  
Latest change: Thursday Feb 20 13:02:26 2025 in commit [53de819](https://github.com/OSGeo/grass-addons/commit/53de8196a10ba5a8a9121898ce87861d227137e3)
